/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.capability.mongo;

import com.ibm.neo.asset.repository.requestoptions.CalRequestOptions;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.capability.mongo.PerTennantRolesCache;
import com.ibm.neo.security.capability.mongo.RoleAndCapabilities;
import com.ibm.neo.security.identity.CapabilityInfo;
import com.ibm.neo.security.identity.CapabilityService;
import com.ibm.neo.security.identity.DefaultRolesAndCapabilities;
import com.ibm.neo.security.identity.SecurityToken;
import com.ibm.neo.security.nodel.ACSPersistence;
import com.ibm.neo.security.nodel.Role;
import com.ibm.neo.security.nodel.User;
import com.ibm.neo.security.nodel.UserOrGroup;
import com.ibm.neo.security.persistence.GeneralPersistenceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class MongoCapabilityService
implements CapabilityService {
    protected static final PerTennantRolesCache ROLE_CACHE = new PerTennantRolesCache();
    protected AccessControlService m_accessControl;

    public MongoCapabilityService(AccessControlService _accessControl) {
        this.m_accessControl = _accessControl;
        ROLE_CACHE.setAccessControl(_accessControl);
    }

    public CapabilityInfo[] listCapabilities(SecurityToken _securityToken) throws GeneralPersistenceException {
        List<String> allRolesForUser = this.getCurrentUsersRoleIds();
        return this.listCapabilities(_securityToken, allRolesForUser);
    }

    public List<String> getCurrentUsersRoleIds() throws GeneralPersistenceException {
        try {
            User currentUser = this.m_accessControl.getCurrentUser();
            List<Role> allRolesForUser = this.m_accessControl.getAllRoles((UserOrGroup)currentUser);
            ArrayList<String> roleIds = new ArrayList<String>();
            for (Role role : allRolesForUser) {
                roleIds.add(role.getId().getIdentifier());
            }
            return roleIds;
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
    }

    public CapabilityInfo[] listCapabilities(SecurityToken _securityToken, List<String> userRoleIds) throws GeneralPersistenceException {
        if (!CalRequestOptions.permissionOption().isOn()) {
            return DefaultRolesAndCapabilities.getDefaultCapabilities().keySet().toArray(new CapabilityInfo[0]);
        }
        HashSet<CapabilityInfo> capabilityInfos = new HashSet<CapabilityInfo>();
        for (String roleId : userRoleIds) {
            RoleAndCapabilities roleAndCaps = ROLE_CACHE.getRoles(_securityToken, new IONObjectId(roleId));
            if (roleAndCaps == null) continue;
            capabilityInfos.addAll(roleAndCaps.capabilities());
        }
        return capabilityInfos.toArray(new CapabilityInfo[capabilityInfos.size()]);
    }

    public boolean hasCapability(SecurityToken _securityToken, CapabilityInfo ... _capability) throws GeneralPersistenceException {
        List<String> roleIds = this.getCurrentUsersRoleIds();
        return this.hasCapability(_securityToken, roleIds, _capability);
    }

    public boolean hasCapability(SecurityToken _securityToken, List<String> userRoleIds, CapabilityInfo ... _capability) throws GeneralPersistenceException {
        if (!CalRequestOptions.permissionOption().isOn()) {
            return true;
        }
        HashSet<CapabilityInfo> requiredCapabilitySet = new HashSet<CapabilityInfo>();
        requiredCapabilitySet.addAll(Arrays.asList(_capability));
        RoleAndCapabilities roleAndCaps = null;
        for (String roleId : userRoleIds) {
            roleAndCaps = ROLE_CACHE.getRoles(_securityToken, new IONObjectId(roleId));
            if (roleAndCaps != null) {
                requiredCapabilitySet.removeAll(roleAndCaps.capabilities());
            }
            if (!requiredCapabilitySet.isEmpty()) continue;
            return true;
        }
        return requiredCapabilitySet.isEmpty();
    }

    public boolean isCapabilityRegistered(String _capability) throws GeneralPersistenceException {
        boolean registered = false;
        try {
            registered = ACSPersistence.getCapabilitiesCollection().findOne(new QueryBuilder().equalTo("name", (Object)_capability).toDocument()) != null;
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
        return registered;
    }
}

