/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.capability.mongo;

import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.capability.mongo.MongoRoleAndCapabilityManipulator;
import com.ibm.neo.security.capability.mongo.PerTennantRolesCache;
import com.ibm.neo.security.capability.mongo.RoleAndCapabilities;
import com.ibm.neo.security.identity.CapabilityInfo;
import com.ibm.neo.security.identity.SecurityToken;
import com.ibm.neo.security.nodel.ACSPersistence;
import com.ibm.neo.security.nodel.Capability;
import com.ibm.neo.security.nodel.Role;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.security.nodel.User;
import com.ibm.neo.security.persistence.GeneralPersistenceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDevopsRoleAndCapabilityManipulator
extends MongoRoleAndCapabilityManipulator {
    private static final transient Logger LOG = LoggerFactory.getLogger(MongoDevopsRoleAndCapabilityManipulator.class);

    public MongoDevopsRoleAndCapabilityManipulator(AccessControlService _accessControl) {
        super(_accessControl);
    }

    public void registerSystemCapabilities(CapabilityInfo[] _capabilities) throws GeneralPersistenceException {
        HashMap<CapabilityInfo, Collection<CapabilityInfo>> mapOfCapabilities = new HashMap<CapabilityInfo, Collection<CapabilityInfo>>();
        for (CapabilityInfo capability : _capabilities) {
            mapOfCapabilities.put(capability, new ArrayList());
        }
        this.registerSystemCapabilities(mapOfCapabilities);
    }

    public void registerSystemCapabilities(Map<CapabilityInfo, Collection<CapabilityInfo>> _capabilities) throws GeneralPersistenceException {
        LOG.info("registering system capabilities ");
        ROLE_CACHE.clear();
        try {
            NobjectCollection capabilitiesCollection = ACSPersistence.getCapabilitiesCollection();
            this.clearCapabilitiesFromRoles();
            capabilitiesCollection.drop();
            HashMap<CapabilityInfo, Capability> savedCaps = new HashMap<CapabilityInfo, Capability>();
            for (CapabilityInfo capabilityName : _capabilities.keySet()) {
                this.buildCapability(capabilityName, _capabilities, savedCaps, (NobjectCollection<Capability>)capabilitiesCollection);
            }
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
        LOG.info("system capabilities registered");
    }

    public CapabilityInfo[] listAllCapabilities() throws GeneralPersistenceException {
        ArrayList<CapabilityInfo> capabilityInfos = null;
        try {
            NobjectCollection capabilitiesCollection = ACSPersistence.getCapabilitiesCollection();
            List capabilitiesList = capabilitiesCollection.find(new IONObject()).toListAndClose();
            capabilityInfos = new ArrayList<CapabilityInfo>();
            for (Capability capability : capabilitiesList) {
                if (capability == null) continue;
                capabilityInfos.add(new CapabilityInfo(capability.getName(), capability.getType()));
            }
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
        return capabilityInfos.toArray(new CapabilityInfo[capabilityInfos.size()]);
    }

    public String[] listAllRoles(String _tenantId) throws GeneralPersistenceException {
        ArrayList<String> roleNames = null;
        try {
            NobjectCollection rolesCollection = ACSPersistence.getRolesCollection();
            List rolesList = rolesCollection.find(new QueryBuilder().equalTo("tenant-id", (Object)new IONObjectId(_tenantId)).toDocument()).toListAndClose();
            roleNames = new ArrayList<String>();
            for (Role role : rolesList) {
                if (role == null) continue;
                roleNames.add(role.getName());
            }
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
        return roleNames.toArray(new String[roleNames.size()]);
    }

    public Role[] registerSystemRoles(String _tenantId, String[] _roles) throws GeneralPersistenceException {
        ArrayList<Role> createdRoles = new ArrayList<Role>();
        IONObjectId tennantId = new IONObjectId(_tenantId);
        ROLE_CACHE.clear();
        try {
            this.clearRolesFromUsers(tennantId);
            NobjectCollection rolesCollection = ACSPersistence.getRolesCollection();
            rolesCollection.remove(new QueryBuilder().equalTo("tenant-id", (Object)tennantId).toDocument());
            HashSet<String> roleSet = new HashSet<String>();
            roleSet.addAll(Arrays.asList(_roles));
            for (String roleName : roleSet) {
                Role role = new Role(tennantId, roleName);
                rolesCollection.save((Nobject)role);
                createdRoles.add(role);
            }
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
        return createdRoles.toArray(new Role[createdRoles.size()]);
    }

    public List<Capability> assignCapabilitiesForRole(CapabilityInfo[] _capabilities, Role _role) throws GeneralPersistenceException {
        ROLE_CACHE.clear();
        try {
            NobjectCollection rolesCollection = ACSPersistence.getRolesCollection();
            Role role = (Role)rolesCollection.get(_role.getId());
            if (role == null) {
                throw new GeneralPersistenceException(_role.getId().getIdentifier(), GeneralPersistenceException.Type.ILLEGAL_ARGUMENT);
            }
            List<Capability> capabilities = this.findCapabilities(_capabilities);
            List capabilityIds = role.getCapabilities();
            capabilityIds.clear();
            for (Capability capability : capabilities) {
                capabilityIds.add(capability.getId());
            }
            rolesCollection.save((Nobject)role);
            return capabilities;
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
    }

    public void clearCache() {
        ROLE_CACHE.clear();
    }

    public PerTennantRolesCache cache() {
        return ROLE_CACHE;
    }

    public void clearAll() throws GeneralPersistenceException {
        try {
            ROLE_CACHE.clear();
            List tenantsList = ACSPersistence.getTenantsCollection().findAll().toListAndClose();
            for (Tenant tenant : tenantsList) {
                this.registerSystemRoles(tenant.getId().getIdentifier(), new String[0]);
            }
            NobjectCollection rolesCollection = ACSPersistence.getRolesCollection();
            rolesCollection.remove(new IONObject());
            this.registerSystemCapabilities(new HashMap<CapabilityInfo, Collection<CapabilityInfo>>());
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
    }

    RoleAndCapabilities getRolesAndCapabilities(IONObjectId _tenantId, String _role) throws GeneralPersistenceException {
        return ROLE_CACHE.getRolesCache(_tenantId).getRoles(new SecurityToken(){

            public String serialize() {
                return "";
            }

            public boolean requestingSudo() {
                return false;
            }
        }, _role);
    }

    private void buildCapability(CapabilityInfo _capabilityInfo, Map<CapabilityInfo, Collection<CapabilityInfo>> _capabilities, Map<CapabilityInfo, Capability> _savedCaps, NobjectCollection<Capability> _capabilitiesCollection) throws PersistenceException {
        if (_savedCaps.containsKey(_capabilityInfo)) {
            if (_savedCaps.get(_capabilityInfo) != null) {
                return;
            }
            throw new IllegalArgumentException("loop found in capability definition");
        }
        _savedCaps.put(_capabilityInfo, null);
        Collection<CapabilityInfo> impliedCaps = _capabilities.get(_capabilityInfo);
        ArrayList<IONObjectId> impliedCapsIds = new ArrayList<IONObjectId>();
        for (CapabilityInfo impliedCap : impliedCaps) {
            this.buildCapability(impliedCap, _capabilities, _savedCaps, _capabilitiesCollection);
            impliedCapsIds.add(_savedCaps.get(impliedCap).getId());
        }
        Capability cap = new Capability(_capabilityInfo.name(), _capabilityInfo.type(), impliedCapsIds);
        _capabilitiesCollection.save((Nobject)cap);
        _savedCaps.put(_capabilityInfo, cap);
    }

    private IONObject makeQueryForCapabilityInfo(CapabilityInfo _capability) {
        QueryBuilder explicitType = new QueryBuilder();
        if (_capability.type().equals("*")) {
            explicitType.equalTo("name", (Object)_capability.name()).notEqualTo("type", (Object)"");
        } else {
            explicitType.equalTo("name", (Object)_capability.name()).equalTo("type", (Object)_capability.type());
        }
        return explicitType.toDocument();
    }

    private List<Capability> findCapabilities(CapabilityInfo[] _capabilityInfo) throws PersistenceException, GeneralPersistenceException {
        NobjectCollection capabilitiesCollection = ACSPersistence.getCapabilitiesCollection();
        ArrayList<IONObject> queries = new ArrayList<IONObject>();
        for (CapabilityInfo capability : _capabilityInfo) {
            queries.add(this.makeQueryForCapabilityInfo(capability));
        }
        List capabilities = null;
        if (_capabilityInfo.length == 0) {
            capabilities = Collections.emptyList();
        } else {
            QueryBuilder queryBuilder = new QueryBuilder();
            queryBuilder.or(queries);
            capabilities = capabilitiesCollection.find(queryBuilder.toDocument()).toListAndClose();
        }
        return capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRolesFromUsers(IONObjectId _tenantId) throws PersistenceException {
        NobjectCollection usersCollection = ACSPersistence.getUsersCollection();
        IONObject tennantUserQuery = new QueryBuilder().equalTo("tenant-id", (Object)_tenantId).toDocument();
        try (ICursor users = null;){
            users = usersCollection.find(tennantUserQuery);
            while (users.hasNext()) {
                User user = (User)users.next();
                user.getRoleIds().clear();
                usersCollection.save((Nobject)user);
            }
        }
    }

    private void clearCapabilitiesFromRoles() throws PersistenceException {
        LOG.info("clearing capabilities from roles  ");
        NobjectCollection rolesCollection = ACSPersistence.getRolesCollection();
        List roles = rolesCollection.findAll().toListAndClose();
        LOG.info("Found ({}) roles to clear ", (Object)roles.size());
        for (Role role : roles) {
            role.getCapabilities().clear();
            rolesCollection.save((Nobject)role);
        }
        LOG.info("capabilities cleared from roles");
    }
}

