/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.capability.mongo;

import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.capability.mongo.MongoCapabilityService;
import com.ibm.neo.security.capability.mongo.RoleAndCapabilities;
import com.ibm.neo.security.identity.CapabilityInfo;
import com.ibm.neo.security.identity.RoleAndCapabilityManipulator;
import com.ibm.neo.security.identity.RoleInfo;
import com.ibm.neo.security.identity.SecurityToken;
import com.ibm.neo.security.nodel.ACSPersistence;
import com.ibm.neo.security.nodel.Capability;
import com.ibm.neo.security.nodel.Role;
import com.ibm.neo.security.nodel.User;
import com.ibm.neo.security.persistence.GeneralPersistenceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MongoRoleAndCapabilityManipulator
extends MongoCapabilityService
implements RoleAndCapabilityManipulator {
    public MongoRoleAndCapabilityManipulator(AccessControlService _accessControl) {
        super(_accessControl);
    }

    public CapabilityInfo[] listAllCapabilities(SecurityToken _securityToken) throws GeneralPersistenceException {
        ArrayList<CapabilityInfo> capabilityInfos = null;
        try {
            NobjectCollection capabilitiesCollection = ACSPersistence.getCapabilitiesCollection();
            ICursor capabilitiesCursor = capabilitiesCollection.find(new IONObject());
            capabilityInfos = new ArrayList<CapabilityInfo>();
            while (capabilitiesCursor.hasNext()) {
                Capability capability = (Capability)capabilitiesCursor.next();
                if (capability == null) continue;
                capabilityInfos.add(new CapabilityInfo(capability.getName(), capability.getType()));
            }
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
        return capabilityInfos.toArray(new CapabilityInfo[capabilityInfos.size()]);
    }

    public void assignRoleToUser(SecurityToken _securityToken, Role _role, User _user) throws GeneralPersistenceException {
        this.assignRolesToUser(_securityToken, new Role[]{_role}, _user);
    }

    public void assignRolesToUser(SecurityToken _securityToken, Role[] _roles, User _user) throws GeneralPersistenceException {
        ArrayList<String> roleIds = new ArrayList<String>();
        for (Role role : _roles) {
            roleIds.add(role.getId().getIdentifier());
        }
        this.assignRolesToUser(_securityToken, roleIds.toArray(new String[roleIds.size()]), _user.getId().getIdentifier());
    }

    public void assignRolesToUser(SecurityToken _securityToken, String[] _roleIds, String _userId) throws GeneralPersistenceException {
        try {
            NobjectCollection userCollection = ACSPersistence.getUsersCollection();
            User user = (User)userCollection.get(new IONObjectId(_userId));
            if (user == null) {
                throw new GeneralPersistenceException(_userId, GeneralPersistenceException.Type.ILLEGAL_ARGUMENT);
            }
            List<Role> roles = this.findRoles(user.getTenantId(), _roleIds);
            user.getRoleIds().clear();
            for (Role role : roles) {
                user.getRoleIds().add(role.getId());
            }
            userCollection.save((Nobject)user);
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
    }

    @Deprecated
    public String[] listAllRoles(SecurityToken _securityToken) throws GeneralPersistenceException {
        ArrayList<String> roleNames = null;
        try {
            IONObjectId tenantId = ACSHelper.getCurrentTenantId();
            NobjectCollection rolesCollection = ACSPersistence.getRolesCollection();
            ICursor rolesCursor = rolesCollection.find(new QueryBuilder().equalTo("tenant-id", (Object)tenantId).toDocument());
            roleNames = new ArrayList<String>();
            while (rolesCursor.hasNext()) {
                Role role = (Role)rolesCursor.next();
                if (role == null) continue;
                roleNames.add(role.getName());
            }
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
        return roleNames.toArray(new String[roleNames.size()]);
    }

    public RoleInfo getRole(String _roleId, SecurityToken _token) throws GeneralPersistenceException {
        RoleInfo roleInfo = null;
        try {
            IONObjectId currentTenantId = ACSHelper.getCurrentTenantId();
            Role role = AccessControlService.getInstance().getRole(new IONObjectId(_roleId));
            if (role != null) {
                if (!role.getTenantId().equals((Object)currentTenantId)) {
                    throw new GeneralPersistenceException(_roleId, GeneralPersistenceException.Type.ILLEGAL_ARGUMENT);
                }
                MongoRoleAndCapabilityManipulator capabilityManipulator = new MongoRoleAndCapabilityManipulator(this.m_accessControl);
                roleInfo = new RoleInfo(role.getId().getIdentifier(), role.getName(), capabilityManipulator.listCapabilitiesForRole(_token, role));
            }
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
        return roleInfo;
    }

    public RoleInfo[] listRoles(SecurityToken _token) throws GeneralPersistenceException {
        RoleInfo[] allRolesArray = null;
        try {
            IONObjectId tenantId = ACSHelper.getCurrentTenantId();
            List roleList = ACSPersistence.getRolesCollection().find(new QueryBuilder().equalTo("tenant-id", (Object)tenantId).toDocument()).toListAndClose();
            ArrayList<RoleInfo> allRolesList = new ArrayList<RoleInfo>();
            Iterator roleIterator = roleList.iterator();
            MongoRoleAndCapabilityManipulator capabilityManipulator = new MongoRoleAndCapabilityManipulator(this.m_accessControl);
            while (roleIterator.hasNext()) {
                Role role = (Role)roleIterator.next();
                allRolesList.add(new RoleInfo(role.getId().getIdentifier(), role.getName(), capabilityManipulator.listCapabilitiesForRole(_token, role)));
            }
            allRolesArray = allRolesList.toArray(new RoleInfo[0]);
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
        return allRolesArray;
    }

    public CapabilityInfo[] listCapabilitiesForRole(SecurityToken _securityToken, Role _role) throws GeneralPersistenceException {
        return this.listCapabilitiesForRole(_securityToken, _role.getId().getIdentifier());
    }

    public CapabilityInfo[] listCapabilitiesForRole(SecurityToken _securityToken, String _roleId) throws GeneralPersistenceException {
        RoleAndCapabilities roleAndCaps = ROLE_CACHE.getRoles(_securityToken, new IONObjectId(_roleId));
        Collection<CapabilityInfo> capabilities = roleAndCaps.capabilities();
        return capabilities.toArray(new CapabilityInfo[capabilities.size()]);
    }

    private List<Role> findRoles(IONObjectId _tenant, String[] _roleIds) throws PersistenceException, GeneralPersistenceException {
        List<Role> roles = this.findRolesById(_tenant, _roleIds);
        if (_roleIds.length > roles.size()) {
            throw new GeneralPersistenceException(StringUtils.join((Object[])_roleIds), GeneralPersistenceException.Type.ILLEGAL_ARGUMENT);
        }
        return roles;
    }

    private List<Role> findRolesById(IONObjectId _tenant, String[] _roleIds) throws PersistenceException, GeneralPersistenceException {
        NobjectCollection rolesCollection = ACSPersistence.getRolesCollection();
        List roles = null;
        if (_roleIds.length == 0) {
            roles = Collections.emptyList();
        } else {
            ArrayList<IONObjectId> roleIds = new ArrayList<IONObjectId>();
            for (String roleId : _roleIds) {
                roleIds.add(new IONObjectId(roleId));
            }
            roles = rolesCollection.find(new QueryBuilder().and(new IONObject[]{new QueryBuilder().equalTo("tenant-id", (Object)_tenant).toDocument(), new QueryBuilder().in("_id", roleIds).toDocument()}).toDocument()).toListAndClose();
        }
        return roles;
    }
}

