/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.capability.mongo;

import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.capability.mongo.RoleAndCapabilities;
import com.ibm.neo.security.capability.mongo.RolesCache;
import com.ibm.neo.security.identity.SecurityToken;
import com.ibm.neo.security.persistence.GeneralPersistenceException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PerTennantRolesCache {
    private AccessControlService m_accessControl;
    private Map<String, RolesCache> m_cacheMap = new ConcurrentHashMap<String, RolesCache>();

    public void setAccessControl(AccessControlService _accessControl) {
        if (this.m_accessControl == null) {
            this.m_accessControl = _accessControl;
        }
    }

    public RoleAndCapabilities getRoles(SecurityToken _token, IONObjectId _roleId) throws GeneralPersistenceException {
        return this.getRolesCache(this.getTennantId(_token)).getRoles(_token, _roleId);
    }

    public RoleAndCapabilities getRoles(SecurityToken _token, String _name) throws GeneralPersistenceException {
        return this.getRolesCache(this.getTennantId(_token)).getRoles(_token, _name);
    }

    public int size(SecurityToken _token) throws GeneralPersistenceException {
        return this.getRolesCache(this.getTennantId(_token)).size();
    }

    public void clear() {
        this.m_cacheMap.clear();
    }

    private IONObjectId getTennantId(SecurityToken _token) throws GeneralPersistenceException {
        return ACSHelper.getCurrentTenantId();
    }

    public RolesCache getRolesCache(IONObjectId _tenantId) throws GeneralPersistenceException {
        RolesCache rolesCache = this.m_cacheMap.get(_tenantId.getIdentifier());
        if (rolesCache == null) {
            rolesCache = new RolesCache(_tenantId);
            this.m_cacheMap.put(_tenantId.getIdentifier(), rolesCache);
        }
        return rolesCache;
    }
}

