/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.capability.mongo;

import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.identity.CapabilityInfo;
import com.ibm.neo.security.identity.RoleInfo;
import com.ibm.neo.security.nodel.ACSPersistence;
import com.ibm.neo.security.nodel.Capability;
import com.ibm.neo.security.nodel.Role;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;

public class RoleAndCapabilities {
    private Role m_role;
    private Map<CapabilityInfo, Capability> m_capabilities = new HashMap<CapabilityInfo, Capability>();

    public RoleAndCapabilities(Role _role, List<Capability> _capabilities) {
        for (Capability capability : _capabilities) {
            this.m_capabilities.put(new CapabilityInfo(capability.getName(), capability.getType()), capability);
        }
        this.m_role = _role;
    }

    public RoleAndCapabilities(Role _role, Capability[] _capabilities) {
        this(_role, Arrays.asList(_capabilities));
    }

    public String roleName() {
        return this.m_role.getName();
    }

    public Role role() {
        return this.m_role;
    }

    public RoleInfo roleInfo() {
        return new RoleInfo(this.m_role.getId().getIdentifier(), this.m_role.getName(), this.capabilities().toArray(new CapabilityInfo[this.m_capabilities.size()]));
    }

    public Collection<CapabilityInfo> capabilities() {
        return this.m_capabilities.keySet();
    }

    public boolean hasCapability(CapabilityInfo _name) {
        return this.m_capabilities.containsKey(_name);
    }

    public RoleAndCapabilities calculateAllCaps() throws PersistenceException {
        return new RoleAndCapabilities(this.m_role, this.calculateCapabilities());
    }

    public RoleAndCapabilities rolesAndExplicitCaps() {
        return new RoleAndCapabilities(this.m_role, this.capabilitySubset(true));
    }

    public RoleAndCapabilities rolesAndImplicitCaps() {
        return new RoleAndCapabilities(this.m_role, this.capabilitySubset(false));
    }

    public boolean matches(RoleAndCapabilities _other) {
        if (_other == null) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.m_role.getName(), (Object)_other.m_role.getName()).append(this.capabilities(), _other.capabilities()).isEquals();
    }

    public boolean equals(Object _another) {
        if (this == _another) {
            return true;
        }
        if (!(_another instanceof RoleAndCapabilities)) {
            return false;
        }
        RoleAndCapabilities otherRandC = (RoleAndCapabilities)_another;
        return new EqualsBuilder().appendSuper(super.equals(_another)).append((Object)this.m_role, (Object)otherRandC.m_role).append(this.m_capabilities, otherRandC.m_capabilities).isEquals();
    }

    private List<Capability> capabilitySubset(boolean _explicit) {
        HashSet implicitIds = new HashSet();
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        for (Map.Entry<CapabilityInfo, Capability> capEntry : this.m_capabilities.entrySet()) {
            implicitIds.addAll(capEntry.getValue().getImpliedCapabilities());
        }
        for (Map.Entry<CapabilityInfo, Capability> capEntry : this.m_capabilities.entrySet()) {
            if ((!_explicit || implicitIds.contains(capEntry.getValue().getId())) && (_explicit || !implicitIds.contains(capEntry.getValue().getId()))) continue;
            capabilities.add(capEntry.getValue());
        }
        return capabilities;
    }

    private List<Capability> calculateCapabilities() throws PersistenceException {
        NobjectCollection capabilitiesCollection = ACSPersistence.getCapabilitiesCollection();
        HashSet<IONObjectId> exploredCaps = new HashSet<IONObjectId>();
        LinkedList yetToExploreCaps = new LinkedList();
        ArrayList<Capability> foundRoleCaps = new ArrayList<Capability>();
        for (Map.Entry<CapabilityInfo, Capability> capEntry : this.m_capabilities.entrySet()) {
            exploredCaps.add(capEntry.getValue().getId());
            foundRoleCaps.add(capEntry.getValue());
            yetToExploreCaps.addAll(capEntry.getValue().getImpliedCapabilities());
        }
        while (!yetToExploreCaps.isEmpty()) {
            QueryBuilder queryBuilder = new QueryBuilder();
            ArrayList<IONObject> queries = new ArrayList<IONObject>();
            for (IONObjectId capabilityId : yetToExploreCaps) {
                if (exploredCaps.contains(capabilityId)) continue;
                exploredCaps.add(capabilityId);
                queries.add(new QueryBuilder().equalTo("_id", (Object)capabilityId).toDocument());
            }
            yetToExploreCaps.clear();
            if (queries.isEmpty()) continue;
            queryBuilder.or(queries);
            List foundCaps = capabilitiesCollection.find(queryBuilder.toDocument()).toListAndClose();
            HashSet newImpliedCaps = new HashSet();
            for (Capability foundCap : foundCaps) {
                foundRoleCaps.add(foundCap);
                newImpliedCaps.addAll(foundCap.getImpliedCapabilities());
            }
            yetToExploreCaps.addAll(newImpliedCaps);
        }
        return foundRoleCaps;
    }
}

