/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.capability.mongo;

import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.security.capability.mongo.RoleAndCapabilities;
import com.ibm.neo.security.identity.SecurityToken;
import com.ibm.neo.security.nodel.ACSPersistence;
import com.ibm.neo.security.nodel.Role;
import com.ibm.neo.security.persistence.GeneralPersistenceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RolesCache {
    private Map<IONObjectId, RoleAndCapabilities> m_rolesCacheById = new ConcurrentHashMap<IONObjectId, RoleAndCapabilities>();
    private Map<String, RoleAndCapabilities> m_rolesCacheByName = new ConcurrentHashMap<String, RoleAndCapabilities>();
    private final IONObjectId m_tenantId;

    RolesCache(IONObjectId _tenantId) {
        this.m_tenantId = _tenantId;
    }

    public RoleAndCapabilities getRoles(SecurityToken _token, IONObjectId _roleId) throws GeneralPersistenceException {
        try {
            if (_roleId == null) {
                return null;
            }
            if (!this.m_rolesCacheById.containsKey(_roleId)) {
                this.addRoleToCache(_roleId);
            }
            return this.m_rolesCacheById.get(_roleId);
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
    }

    public RoleAndCapabilities getRoles(SecurityToken _token, String _name) throws GeneralPersistenceException {
        try {
            if (_name == null) {
                return null;
            }
            if (!this.m_rolesCacheByName.containsKey(_name)) {
                this.addRoleToCache(_token, _name);
            }
            return this.m_rolesCacheByName.get(_name);
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
    }

    int size() {
        return this.m_rolesCacheById.size();
    }

    void clear() {
        this.m_rolesCacheById.clear();
        this.m_rolesCacheByName.clear();
    }

    private void addRoleToCache(SecurityToken _token, String _name) throws PersistenceException {
        Role role = (Role)ACSPersistence.getRolesCollection().findOne(new QueryBuilder().equalTo("name", (Object)_name).equalTo("tenant-id", (Object)this.m_tenantId).toDocument());
        this.addRoleToCache(role);
    }

    private void addRoleToCache(IONObjectId _roleId) throws PersistenceException {
        Role role = (Role)ACSPersistence.getRolesCollection().get(_roleId);
        if (this.m_tenantId != null && this.m_tenantId.equals((Object)role.getTenantId())) {
            this.addRoleToCache(role);
        }
    }

    private void addRoleToCache(Role _role) throws PersistenceException {
        if (_role == null) {
            return;
        }
        QueryBuilder queryBuilder = new QueryBuilder();
        ArrayList<IONObject> queries = new ArrayList<IONObject>();
        for (IONObjectId capabilityId : _role.getCapabilities()) {
            queries.add(new QueryBuilder().equalTo("_id", (Object)capabilityId).toDocument());
        }
        queryBuilder.or(queries);
        List capabilities = null;
        capabilities = queries.size() > 0 ? ACSPersistence.getCapabilitiesCollection().find(queryBuilder.toDocument()).toListAndClose() : Collections.emptyList();
        RoleAndCapabilities roleAndCapabilities = new RoleAndCapabilities(_role, capabilities);
        roleAndCapabilities = roleAndCapabilities.calculateAllCaps();
        this.m_rolesCacheById.put(_role.getId(), roleAndCapabilities);
        this.m_rolesCacheByName.put(_role.getName(), roleAndCapabilities);
    }
}

