/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.capability.mongo;

import com.ibm.neo.security.identity.CapabilityInfo;
import com.ibm.neo.security.identity.GroupInfo;
import com.ibm.neo.security.identity.RoleInfo;
import com.ibm.neo.security.identity.UserInfo;
import com.ibm.neo.security.identity.UserOrGroupInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TeamRoleCapabilityResolver {
    Map<String, List<String>> m_userOrGroupId2GroupIdListMap = new HashMap<String, List<String>>();
    Map<String, RoleInfo> m_roleId2RoleMap = new HashMap<String, RoleInfo>();
    Map<String, UserOrGroupInfo> m_userOrGroupId2UserOrGroupMap = new HashMap<String, UserOrGroupInfo>();

    public TeamRoleCapabilityResolver(UserInfo[] _users, GroupInfo[] _groups, RoleInfo[] _roles) {
        for (UserInfo userInfo : _users) {
            if (userInfo == null) continue;
            this.m_userOrGroupId2UserOrGroupMap.put(userInfo.id(), (UserOrGroupInfo)userInfo);
        }
        for (UserInfo userInfo : _groups) {
            if (userInfo == null) continue;
            this.m_userOrGroupId2UserOrGroupMap.put(userInfo.id(), (UserOrGroupInfo)userInfo);
            if (userInfo.groupMemberIds() != null) {
                for (GroupInfo groupInfo : userInfo.groupMemberIds()) {
                    this.append(this.m_userOrGroupId2GroupIdListMap, groupInfo.id(), userInfo.id());
                }
            }
            if (userInfo.memberIds() == null) continue;
            for (GroupInfo groupInfo : userInfo.memberIds()) {
                this.append(this.m_userOrGroupId2GroupIdListMap, groupInfo.id(), userInfo.id());
            }
        }
        for (UserInfo userInfo : _roles) {
            if (userInfo == null) continue;
            this.m_roleId2RoleMap.put(userInfo.id(), (RoleInfo)userInfo);
        }
    }

    private void append(Map<String, List<String>> _map, String _key, String _value) {
        if (!_map.containsKey(_key)) {
            _map.put(_key, new ArrayList());
        }
        _map.get(_key).add(_value);
    }

    private GroupInfo[] calculateTeams(UserOrGroupInfo _userOrGroup, boolean _all) {
        if (_userOrGroup == null) {
            return new GroupInfo[0];
        }
        ArrayList<String> foundGroups = new ArrayList<String>();
        if (_all) {
            ArrayList<String> groupsToExpand = new ArrayList<String>();
            ArrayList<String> collectedParents = new ArrayList<String>();
            if (this.m_userOrGroupId2GroupIdListMap.containsKey(_userOrGroup.id())) {
                groupsToExpand.add(_userOrGroup.id());
            }
            while (groupsToExpand.size() > 0) {
                for (String groupId : groupsToExpand) {
                    foundGroups.add(groupId);
                    List<String> parentGroups = this.m_userOrGroupId2GroupIdListMap.get(groupId);
                    if (parentGroups == null) continue;
                    collectedParents.addAll(parentGroups);
                }
                groupsToExpand.clear();
                for (String groupId : collectedParents) {
                    if (foundGroups.contains(groupId)) continue;
                    groupsToExpand.add(groupId);
                }
                collectedParents.clear();
            }
            foundGroups.remove(_userOrGroup.id());
        } else if (this.m_userOrGroupId2GroupIdListMap.containsKey(_userOrGroup.id())) {
            foundGroups.addAll((Collection)this.m_userOrGroupId2GroupIdListMap.get(_userOrGroup.id()));
        }
        ArrayList<GroupInfo> teams = new ArrayList<GroupInfo>();
        for (int i = 0; i < foundGroups.size(); ++i) {
            UserOrGroupInfo foundUserOrGroup = this.m_userOrGroupId2UserOrGroupMap.get(foundGroups.get(i));
            if (!(foundUserOrGroup instanceof GroupInfo)) continue;
            teams.add((GroupInfo)foundUserOrGroup);
        }
        return teams.toArray(new GroupInfo[teams.size()]);
    }

    public GroupInfo[] getImmediateTeams(UserOrGroupInfo _userOrGroup) {
        return this.calculateTeams(_userOrGroup, false);
    }

    public GroupInfo[] getTeams(UserOrGroupInfo _userOrGroup) {
        return this.calculateTeams(_userOrGroup, true);
    }

    public RoleInfo[] getRoles(UserOrGroupInfo _userOrGroup) {
        if (_userOrGroup == null) {
            return new RoleInfo[0];
        }
        ArrayList<String> roleIds = new ArrayList<String>();
        RoleInfo[] roles = null;
        GroupInfo[] allTeams = this.calculateTeams(_userOrGroup, true);
        UserOrGroupInfo userOrGroup = this.m_userOrGroupId2UserOrGroupMap.get(_userOrGroup.id());
        if (userOrGroup.roles() != null) {
            for (GroupInfo groupInfo : userOrGroup.roles()) {
                if (roleIds.contains(groupInfo.id())) continue;
                roleIds.add(groupInfo.id());
            }
        }
        for (GroupInfo groupInfo : allTeams) {
            if (groupInfo.roles() == null) continue;
            for (RoleInfo info : groupInfo.roles()) {
                if (roleIds.contains(info.id())) continue;
                roleIds.add(info.id());
            }
        }
        roles = new RoleInfo[roleIds.size()];
        for (int i = 0; i < roleIds.size(); ++i) {
            roles[i] = this.m_roleId2RoleMap.get(roleIds.get(i));
        }
        return roles;
    }

    public CapabilityInfo[] getCapabilities(UserOrGroupInfo _userOrGroup) {
        RoleInfo[] allRoles;
        ArrayList<CapabilityInfo> caps = new ArrayList<CapabilityInfo>();
        for (RoleInfo role : allRoles = this.getRoles(_userOrGroup)) {
            if (role.memberInfos() == null) continue;
            for (CapabilityInfo cap : role.memberInfos()) {
                if (caps.contains(cap)) continue;
                caps.add(cap);
            }
        }
        return caps.toArray(new CapabilityInfo[caps.size()]);
    }
}

