/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.shiro;

import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.nodel.Account;
import com.ibm.neo.security.nodel.User;
import com.ibm.neo.security.shiro.AnonymousToken;
import com.ibm.neo.security.shiro.MappingACSRealm;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountCheckedMappingACSRealm
extends MappingACSRealm {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountCheckedMappingACSRealm.class);

    public AccountCheckedMappingACSRealm() {
        this.setAuthenticationTokenClass(AuthenticationToken.class);
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken _authToken) throws AuthenticationException {
        AccessControlService acs = AccessControlService.getInstance();
        AuthenticationInfo authInfo = super.doGetAuthenticationInfo(_authToken);
        if (_authToken instanceof AnonymousToken) {
            return authInfo;
        }
        String credentialStr = (String)authInfo.getCredentials();
        String accountName = AccountCheckedMappingACSRealm.extractAccountName(credentialStr);
        String userId = (String)authInfo.getPrincipals().getPrimaryPrincipal();
        try {
            User user = acs.getUser(new IONObjectId(userId));
            if (null == user) {
                LOGGER.error("Authentication failed: Could not resolve user (_id={})", (Object)userId);
                throw new UnknownAccountException("Could not resolve user: " + userId);
            }
            List<Account> accounts = acs.findAccounts(new QueryBuilder().equalTo("name", (Object)accountName).equalTo("_id", (Object)user.getAccountId()).toDocument());
            if (accounts.size() == 0) {
                LOGGER.error("Authentication failed: User '{}' was not associated with account '{}'");
                throw new IncorrectCredentialsException(String.format("The user's actual account does not match the expected account (%s).", accountName));
            }
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Internal error during authentication.", ex);
        }
        LOGGER.info("Validated user '{}' with account '{}'", (Object)userId, (Object)accountName);
        return authInfo;
    }

    private static String extractAccountName(String credentialStr) throws AuthenticationException {
        if (null == credentialStr) {
            throw new IncorrectCredentialsException("Invalid credentials.");
        }
        int colonPos = credentialStr.indexOf(58);
        if (colonPos == -1) {
            throw new IncorrectCredentialsException("Account name was missing from credentials.");
        }
        String accountName = credentialStr.substring(0, colonPos);
        if (accountName.isEmpty()) {
            throw new IncorrectCredentialsException("Account name was missing from credentials.");
        }
        return accountName;
    }
}

