/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.shiro;

import com.ibm.neo.security.AccessControlService;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.concurrent.SubjectAwareScheduledExecutorService;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

public class ForkingSubjectAwareScheduledExecutorService
extends SubjectAwareScheduledExecutorService {
    public ForkingSubjectAwareScheduledExecutorService() {
    }

    public ForkingSubjectAwareScheduledExecutorService(ScheduledExecutorService target) {
        super(target);
    }

    protected Subject getSubject() {
        throw new UnsupportedOperationException();
    }

    protected Subject forkSubject() {
        AccessControlService acs = AccessControlService.getInstance();
        Subject currentSubject = SecurityUtils.getSubject();
        Subject forkedSubject = acs.forkSubject(currentSubject);
        Session forkedSession = forkedSubject.getSession(true);
        forkedSession.setTimeout(-1L);
        return forkedSubject;
    }

    protected Runnable associateWithSubject(Runnable r) {
        Subject forkedSubject = this.forkSubject();
        return new LogoutRunnable(forkedSubject, forkedSubject.associateWith(r));
    }

    protected <T> Callable<T> associateWithSubject(Callable<T> task) {
        Subject forkedSubject = this.forkSubject();
        return new LogoutCallable(forkedSubject, forkedSubject.associateWith(task));
    }

    private static final class LogoutCallable<T>
    implements Callable<T> {
        private final Subject subject;
        private final Callable<T> target;

        public LogoutCallable(Subject _subject, Callable<T> _target) {
            this.subject = _subject;
            this.target = _target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            try {
                T t = this.target.call();
                return t;
            }
            finally {
                this.subject.logout();
            }
        }
    }

    private static final class LogoutRunnable
    implements Runnable {
        private final Subject subject;
        private final Runnable target;

        public LogoutRunnable(Subject _subject, Runnable _target) {
            this.subject = _subject;
            this.target = _target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.target.run();
            }
            finally {
                this.subject.logout();
            }
        }
    }
}

