/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.shiro;

import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.shiro.ACSRealm;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingACSRealm
extends ACSRealm {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingACSRealm.class);

    public MappingACSRealm() {
        this.setAuthenticationTokenClass(AuthenticationToken.class);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken _authToken) throws AuthenticationException {
        AccessControlService acs = AccessControlService.getInstance();
        String externalUserId = _authToken.getPrincipal().toString();
        if (StringUtils.isEmpty((String)externalUserId)) {
            LOGGER.error("Rejected authentication: Principal was empty");
            throw new IncorrectCredentialsException("Principal was empty");
        }
        if (acs.isAnonymousExternalUser(externalUserId) && !acs.isAnonymousAllowed()) {
            LOGGER.error("Rejected anonymous authentication");
            throw new IncorrectCredentialsException("Anonymous is not allowed");
        }
        String internalUserId = acs.mapExternalUserId(externalUserId);
        if (null == internalUserId) {
            LOGGER.error("Rejected authentication: Failed to resolve principal ({}) to a user", (Object)externalUserId);
            throw new UnknownAccountException("Failed to resolve principal to a user: " + externalUserId);
        }
        LOGGER.info("Accepted authentication: Resolved principal ({}) to user (_id={})", (Object)externalUserId, (Object)internalUserId);
        SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((Object)internalUserId, _authToken.getCredentials(), this.getName());
        return info;
    }
}

