/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.shiro;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionKeepAliveHelper {
    private static final long WAKEUP_SECONDS = 300L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionKeepAliveHelper.class);
    private static final SessionKeepAliveHelper INSTANCE = new SessionKeepAliveHelper();
    private final ScheduledExecutorService mExecutor;
    private final ConcurrentLinkedQueue<Session> mSessions = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Subject> mSubjects = new ConcurrentLinkedQueue();

    public static SessionKeepAliveHelper getInstance() {
        return INSTANCE;
    }

    private SessionKeepAliveHelper() {
        this.mExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("SessionKeepAlive");
                return t;
            }
        });
        this.mExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SessionKeepAliveHelper.this.touchSessions();
            }
        }, 300L, 300L, TimeUnit.SECONDS);
    }

    public void startKeepAlive(Session session) {
        this.mSessions.add(session);
    }

    public void stopKeepAlive(Session session) {
        this.mSessions.remove(session);
    }

    public void startKeepAlive(Subject subject) {
        this.mSubjects.add(subject);
    }

    public void stopKeepAlive(Subject subject) {
        this.mSubjects.remove(subject);
    }

    private void touchSessions() {
        for (Session session : this.mSessions) {
            LOGGER.debug("Renewing session id {}", (Object)session.getId());
            try {
                session.touch();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to renew session", (Throwable)ex);
                this.mSessions.remove(session);
            }
        }
        for (Subject subject : this.mSubjects) {
            try {
                Session session = subject.getSession(false);
                if (null != session) {
                    LOGGER.debug("Renewing session id {}", (Object)session.getId());
                    session.touch();
                    continue;
                }
                this.mSubjects.remove(subject);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to renew session", (Throwable)ex);
                this.mSubjects.remove(subject);
            }
        }
    }
}

