/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.shiro;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.shiro.authc.RememberMeAuthenticationToken;

public class TrustedExternalToken
implements RememberMeAuthenticationToken {
    private static final long serialVersionUID = 1L;
    private final String m_externalUserId;
    private final String m_accountName;

    public TrustedExternalToken(String _externalUserId) {
        this.m_externalUserId = _externalUserId;
        this.m_accountName = null;
    }

    public TrustedExternalToken(String _externalUserId, String _accountName) {
        this.m_externalUserId = _externalUserId;
        this.m_accountName = _accountName;
    }

    public String getExternalUserId() {
        return this.m_externalUserId;
    }

    public String getAccountName() {
        return this.m_accountName;
    }

    public Object getPrincipal() {
        return this.m_externalUserId;
    }

    public Object getCredentials() {
        if (null != this.m_accountName) {
            return this.m_accountName + ":" + this.m_externalUserId;
        }
        return this.m_externalUserId;
    }

    public boolean isRememberMe() {
        return true;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.m_accountName).append((Object)this.m_externalUserId).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrustedExternalToken)) {
            return false;
        }
        TrustedExternalToken other = (TrustedExternalToken)o;
        return new EqualsBuilder().append((Object)this.m_accountName, (Object)other.m_accountName).append((Object)this.m_externalUserId, (Object)other.m_externalUserId).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("externalUserId", (Object)this.m_externalUserId).append("accountName", (Object)this.m_accountName).toString();
    }
}

