/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.shiro;

import com.ibm.neo.security.shiro.WASubject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DelegatingSubject;

public class WADelegatingSubject
extends DelegatingSubject
implements WASubject {
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public WADelegatingSubject(PrincipalCollection principals, boolean authenticated, String host, Session session, boolean sessionEnabled, SecurityManager securityManager) {
        super(principals, authenticated, host, session, sessionEnabled, securityManager);
    }

    @Override
    public Set<String> getAttributeKeys() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public <T> T getTypedAttribute(String key, Class<T> type) {
        return type.cast(this.attributes.get(key));
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
    }

    @Override
    public Map<String, Object> getAttributesMap() {
        return new HashMap<String, Object>(this.attributes);
    }

    public void logout() {
        super.logout();
        this.clearAttributes();
    }
}

