/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.shiro;

import java.util.Map;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;

public interface WASubject
extends Subject {
    public static final String ATTRIBUTE_BA_HEADERS = "BA.Headers";
    public static final String ATTRIBUTE_KEY_PREFIX = "WASubject.Attribute.";

    public Set<String> getAttributeKeys();

    public <T> T getTypedAttribute(String var1, Class<T> var2);

    public Object getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public void removeAttribute(String var1);

    public void clearAttributes();

    public Map<String, Object> getAttributesMap();

    public static class Builder
    extends Subject.Builder {
        public Builder() {
            this(SecurityUtils.getSecurityManager());
        }

        public Builder(SecurityManager securityManager) {
            super(securityManager);
        }

        public Builder attribute(String key, Object value) {
            this.contextAttribute(WASubject.ATTRIBUTE_KEY_PREFIX + key, value);
            return this;
        }

        public WASubject buildWASubject() {
            Subject subject = super.buildSubject();
            if (!(subject instanceof WASubject)) {
                String msg = "Subject implementation returned from the SecurityManager was not a " + WASubject.class.getName() + " implementation.  Please ensure a WASecurityManager " + "has been configured and made available to this builder.";
                throw new IllegalStateException(msg);
            }
            return (WASubject)subject;
        }
    }
}

