/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.user;

import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.capability.mongo.DefaultRoleSetup;
import com.ibm.neo.security.capability.mongo.MongoRoleAndCapabilityManipulator;
import com.ibm.neo.security.nodel.ACSPersistence;
import com.ibm.neo.security.nodel.Account;
import com.ibm.neo.security.nodel.Role;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.security.nodel.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HarvesterBase {
    public void createUser(AccessControlService _acs, Tenant _tenant, String _externalUserId, String _fullName, String _email, String _role) throws Exception {
        User user;
        List<User> users = _acs.findUsers(new QueryBuilder().equalTo("external-user-id", (Object)_externalUserId).toDocument());
        boolean newUser = false;
        if (users.size() > 1) {
            this.exit(-7, "There is more than one existing user record with the external-user-id " + _externalUserId + ".");
        } else if (users.size() == 1) {
            user = users.get(0);
            if (!user.getTenantId().equals((Object)_tenant.getId())) {
                this.exit(-8, "Existing user " + user.getId().getIdentifier() + " refers to tenant " + user.getTenantId().getIdentifier() + ". Cannot reassign to tenant " + _tenant.getId().getIdentifier() + ".");
            } else {
                user.setEmail(_email);
                user.setFullName(_fullName);
                ACSPersistence.getUsersCollection().save((Nobject)user);
                this.ensureUserRole(_acs, _tenant, user, _role);
            }
        } else {
            user = _acs.createUser(_tenant.getAccountId(), _tenant.getId(), _externalUserId, _fullName, _email, new ArrayList<IONObjectId>());
            users.add(user);
            this.ensureUserRole(_acs, _tenant, user, _role);
            newUser = true;
        }
        user = users.get(0);
        this.out((newUser ? "Creating" : "Updating") + " user record " + user.getId().getIdentifier() + " for user " + user.getExternalUserId() + ".");
    }

    public Account ensureAccount(AccessControlService _acs, String _accountName) throws Exception {
        List<Account> accounts = _acs.findAccounts(new QueryBuilder().equalTo("name", (Object)_accountName).toDocument());
        boolean newAccount = false;
        if (accounts.size() > 1) {
            this.exit(-4, "There is more than one existing account record with the name '" + _accountName + "'.");
        } else if (accounts.isEmpty()) {
            accounts.add(_acs.createAccount(_accountName));
            newAccount = true;
        }
        Account account = accounts.get(0);
        this.out((newAccount ? "Creating" : "Reusing") + " account record " + account.getId().getIdentifier() + " for account " + account.getName() + ".");
        return account;
    }

    public Tenant ensureTenant(AccessControlService _acs, Account _account, String _tenantName) throws Exception {
        Tenant tenant;
        List<Tenant> tenants = _acs.findTenants(new QueryBuilder().equalTo("name", (Object)_tenantName).equalTo("account-id", (Object)_account.getId()).toDocument());
        boolean newTenant = false;
        if (tenants.size() > 1) {
            this.exit(-5, "There is more than one existing tenant record with the name '" + _tenantName + "' under account " + _account.getId().getIdentifier() + ".");
        } else if (tenants.isEmpty()) {
            tenant = _acs.createTenant(_account.getId(), _tenantName);
            tenants.add(tenant);
            new DefaultRoleSetup(tenant.getId(), AccessControlService.getInstance()).ensureDefaults();
            newTenant = true;
        }
        tenant = tenants.get(0);
        this.out((newTenant ? "Creating" : "Reusing") + " tenant record " + tenant.getId().getIdentifier() + " for tenant " + tenant.getName() + ".");
        return tenant;
    }

    public void removeEntries(AccessControlService _acs, String _accountName, String _tenantName, String _externalUserId) throws PersistenceException {
        IDocumentCollection accountsCollection = ACSPersistence.getAccountsCollection().getDocumentCollection();
        List accountIds = accountsCollection.findAndProject(new QueryBuilder().equalTo("name", (Object)_accountName).toDocument(), "_id", IONObjectId.class).toListAndClose();
        if (accountIds.isEmpty()) {
            this.out("No accounts match the given account name.");
            return;
        }
        if (_tenantName != null) {
            IDocumentCollection tenantsCollection = ACSPersistence.getTenantsCollection().getDocumentCollection();
            List tenantIds = tenantsCollection.findAndProject(new QueryBuilder().in("account-id", (Collection)accountIds).equalTo("name", (Object)_tenantName).toDocument(), "_id", IONObjectId.class).toListAndClose();
            if (tenantIds.isEmpty()) {
                this.out("No tenants match the given account/tenant values.");
                return;
            }
            if (_externalUserId != null) {
                IDocumentCollection usersCollection = ACSPersistence.getUsersCollection().getDocumentCollection();
                List userIds = usersCollection.findAndProject(new QueryBuilder().equalTo("external-user-id", (Object)_externalUserId).in("tenant-id", (Collection)tenantIds).in("account-id", (Collection)accountIds).toDocument(), "_id", IONObjectId.class).toListAndClose();
                if (userIds.isEmpty()) {
                    System.out.println("No users match the given account/tenant/external user id values.");
                } else {
                    for (IONObjectId userId : userIds) {
                        this.out("Deleting user record '" + userId.getIdentifier() + "' with external user id '" + _externalUserId + "'.");
                        _acs.deleteUser(userId);
                    }
                }
            } else {
                for (IONObjectId tenantId : tenantIds) {
                    this.out("Deleting tenant record '" + tenantId.getIdentifier() + "' with tenant name '" + _tenantName + "'.");
                    _acs.deleteTenant(tenantId);
                }
            }
        } else {
            for (IONObjectId accountId : accountIds) {
                this.out("Deleting account record '" + accountId.getIdentifier() + "' with account name '" + _accountName + "'.");
                _acs.deleteAccount(accountId);
            }
        }
    }

    private void ensureUserRole(AccessControlService _acs, Tenant _tenant, User _user, String _role) throws Exception {
        MongoRoleAndCapabilityManipulator capabilityManipulator = new MongoRoleAndCapabilityManipulator(_acs);
        String roleToFind = _role;
        if (roleToFind == null) {
            roleToFind = "creator";
        }
        if (!"".equals(roleToFind) && !"none".equalsIgnoreCase(roleToFind)) {
            List<Role> foundRoles = _acs.findRoles(new QueryBuilder().equalTo("tenant-id", (Object)_tenant.getId()).equalTo("name", (Object)roleToFind).toDocument());
            if (foundRoles != null && foundRoles.size() > 0) {
                capabilityManipulator.assignRoleToUser(null, foundRoles.get(0), _user);
            }
        } else {
            capabilityManipulator.assignRolesToUser(null, new Role[0], _user);
        }
    }

    protected void err(String _message) {
        System.err.println(_message);
    }

    protected void out(String _message) {
        System.out.println(_message);
    }

    protected void exit(int _code, String _message) throws Exception {
        throw new Exception(_message);
    }
}

