/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.user;

import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.capability.mongo.DefaultRoleSetup;
import com.ibm.neo.security.capability.mongo.MongoRoleAndCapabilityManipulator;
import com.ibm.neo.security.nodel.ACSPersistence;
import com.ibm.neo.security.nodel.Account;
import com.ibm.neo.security.nodel.Role;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.security.nodel.User;
import com.ibm.neo.security.nodel.wa.WATenant;
import com.ibm.neo.security.nodel.wa.WAUser;
import com.ibm.neo.security.persistence.GeneralPersistenceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SetupDemoUsersBase {
    public static final String COKE_ACCOUNT = "coke";
    public static final String COKE_TENNANT = "Coke-Sales";
    public static final String PEPSI_ACCOUNT = "Pepsi";
    public static final String PEPSI_TENNANT = "Pepsi-Marketing";

    public void dropAllUserInfo() throws PersistenceException {
        ACSPersistence.getAccountsCollection().drop();
        ACSPersistence.getTenantsCollection().drop();
        ACSPersistence.getGroupsCollection().drop();
        ACSPersistence.getUsersCollection().drop();
    }

    public Tenant ensureTenant(AccessControlService _acs, String _accountName, String _name) throws GeneralPersistenceException {
        Tenant tenant;
        try {
            tenant = (Tenant)ACSPersistence.getTenantsCollection().findOne(new QueryBuilder().equalTo("name", (Object)_accountName).toDocument());
            if (tenant != null) {
                System.out.println(_accountName + " account artifacts already exist.");
                return tenant;
            }
            Account account = _acs.createAccount(_accountName);
            System.out.println("Created account: " + _accountName);
            tenant = _acs.createTenant(account.getId(), _name);
            WATenant waTenant = new WATenant(tenant);
            waTenant.setWaTenantId("watenant." + tenant.getName());
            ACSPersistence.getTenantsCollection().save((Nobject)waTenant);
        }
        catch (PersistenceException e) {
            throw new GeneralPersistenceException((Throwable)e, GeneralPersistenceException.Type.UNKNOWN);
        }
        new DefaultRoleSetup(tenant.getId(), _acs).ensureDefaults();
        return tenant;
    }

    public void create(AccessControlService _acs) throws Exception {
        Tenant cokeTenant = this.ensureTenant(_acs, COKE_ACCOUNT, COKE_TENNANT);
        User cokeadmin = this.createUser(_acs, cokeTenant, "cokeadmin", "CokeAdmin", "admin@coke.com", "administrator");
        User alice = this.createUser(_acs, cokeTenant, "alice", "Alice Applebee", "alice@coke.com", "contributor");
        this.createUser(_acs, cokeTenant, "alan", "Alan Consumer", "alan@coke.com", "consumer");
        User alex = this.createUser(_acs, cokeTenant, "alex", "Alex Ankle", "alex@coke.com", "creator");
        User norolecoke = this.createUser(_acs, cokeTenant, "norolecoke", "No Role Coke", "norole@coke.com", null);
        this.createGroup(_acs, cokeTenant, "Normal Coke Users", Arrays.asList(alice.getId(), alex.getId()));
        this.createGroup(_acs, cokeTenant, "Admin Coke Users", Arrays.asList(cokeadmin.getId()));
        this.createGroup(_acs, cokeTenant, "No Role Coke Users", Arrays.asList(norolecoke.getId()));
        Tenant pepsiTenant = this.ensureTenant(_acs, PEPSI_ACCOUNT, PEPSI_TENNANT);
        User pepsiadmin = this.createUser(_acs, pepsiTenant, "pepsiadmin", "Pepsi admin", "admin@pepsi.com", "administrator");
        User bob = this.createUser(_acs, pepsiTenant, "bob", "Bob Berrington", "bob@pepsi.com", "contributor");
        User barry = this.createUser(_acs, pepsiTenant, "barry", "Barry Bankit", "barry@pepsi.com", "creator");
        this.createUser(_acs, pepsiTenant, "bollo", "Bollo Consumption", "bollo@pepsi.com", "consumer");
        User norolepepsi = this.createUser(_acs, pepsiTenant, "norolepepsi", "No Role Pepsi", "norole@pepsi.com", null);
        this.createGroup(_acs, pepsiTenant, "Normal Pepsi Users", Arrays.asList(bob.getId(), barry.getId()));
        this.createGroup(_acs, pepsiTenant, "Admin Pepsi Users", Arrays.asList(pepsiadmin.getId()));
        this.createGroup(_acs, pepsiTenant, "No Role Pepsi Users", Arrays.asList(norolepepsi.getId()));
    }

    public User createUser(AccessControlService _acs, Tenant _tenant, String _name, String _fullName, String _email, String _role) throws Exception {
        User user = _acs.createUser(_tenant.getAccountId(), _tenant.getId(), _name, _fullName, _email, new ArrayList<IONObjectId>());
        WAUser waUser = new WAUser(user);
        waUser.setWaUserId("wauser." + _email);
        ACSPersistence.getUsersCollection().save((Nobject)waUser);
        System.out.print("Created user: " + _name);
        if (_role != null) {
            this.ensureUserRole(_acs, user, _role);
            System.out.println(" with no roles defined ");
        } else {
            System.out.println(" in role " + _role);
        }
        return user;
    }

    public void createGroup(AccessControlService _acs, Tenant _tenant, String _name, List<IONObjectId> _members) throws Exception {
        _acs.createGroup(_tenant.getAccountId(), _tenant.getId(), _name, _members, new ArrayList<IONObjectId>(0), new ArrayList<IONObjectId>(0));
        System.out.print("Created group: " + _name);
        if (_members != null && _members.size() > 0) {
            System.out.println(" with " + _members.size() + " member(s)");
        } else {
            System.out.println(" with no members");
        }
    }

    public void ensureUserRole(AccessControlService _acs, User _user, String _role) throws Exception {
        MongoRoleAndCapabilityManipulator capabilityManipulator = new MongoRoleAndCapabilityManipulator(_acs);
        NobjectCollection roleCol = ACSPersistence.getRolesCollection();
        Role role = (Role)roleCol.findOne(new QueryBuilder().equalTo("tenant-id", (Object)_user.getTenantId()).equalTo("name", (Object)_role).toDocument());
        capabilityManipulator.assignRoleToUser(null, role, _user);
    }
}

