/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.client.queryFlow;

import com.ibm.bi.platform.moser.client.queryFlow.Operator;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.QsClassifierType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubjectUsage;
import com.ibm.bi.platform.moser.common.generated.metadata.SetOperation;
import java.util.ArrayList;
import java.util.List;

public class QueryFlowUtil {
    private QsClassifierType getClassifier(QuerySubject querysubject) {
        if (querysubject.getClassifier() != null) {
            return querysubject.getClassifier();
        }
        return QsClassifierType.QUERY_SUBJECT;
    }

    public Operator getQuerySubjectType(QuerySubject querysubject) {
        if (querysubject == null) {
            return null;
        }
        switch (this.getClassifier(querysubject)) {
            case JOIN_QUERY_SUBJECT: {
                return Operator.JOIN;
            }
            case OPERATION_QUERY_SUBJECT: {
                SetOperation operation = querysubject.getQueryOperation().getSetOperation();
                switch (operation) {
                    case EXCEPT: {
                        return Operator.EXCEPT;
                    }
                    case INTERSECT: {
                        return Operator.INTERSECT;
                    }
                    case UNION: {
                        return Operator.UNION;
                    }
                }
            }
            case SQL_QUERY_SUBJECT: {
                return Operator.SQL;
            }
        }
        return this.getPrecursors(querysubject).isEmpty() ? Operator.PLAIN : Operator.VIEW;
    }

    public List<Filter> getSelectableFilters(QuerySubject querysubject) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        this.appendFilters(querysubject.getItem(), filters);
        return filters;
    }

    private void appendFilters(List<ItemType> items, List<Filter> filters) {
        for (ItemType item : items) {
            if (item.getFilter() != null) {
                filters.add(item.getFilter());
                continue;
            }
            if (item.getFolder() == null) continue;
            this.appendFilters(item.getFolder().getItem(), filters);
        }
    }

    public List<Filter>[] extractFilters(QuerySubject querysubject) {
        ArrayList<Filter> preAggregate = new ArrayList<Filter>();
        ArrayList<Filter> postAggregate = new ArrayList<Filter>();
        if (querysubject.basicGetFilter() != null) {
            for (Filter filter : querysubject.getFilter()) {
                if (filter.isPostAutoAggregation() != null && filter.isPostAutoAggregation().booleanValue()) {
                    postAggregate.add(filter);
                    continue;
                }
                preAggregate.add(filter);
            }
        }
        ArrayList[] result = new ArrayList[]{preAggregate, postAggregate};
        return result;
    }

    public boolean hasAggregate(QuerySubject querysubject) {
        return querysubject.getQuerySubjectUsage() == QuerySubjectUsage.SUMMARY_QUERY;
    }

    public List<QuerySubject> getPrecursors(QuerySubject querysubject) {
        Module module = MoserObject.getModuleObject((MoserObject)querysubject);
        if (module == null) {
            return new ArrayList<QuerySubject>();
        }
        switch (this.getClassifier(querysubject)) {
            case JOIN_QUERY_SUBJECT: {
                return this.fromReference(querysubject.getJoinOperation().getQueryRef(), module);
            }
            case OPERATION_QUERY_SUBJECT: {
                return this.fromReference(querysubject.getQueryOperation().getQueryRef(), module);
            }
        }
        InstanceType instanceType = this.getInstanceType(querysubject);
        switch (instanceType) {
            case MISSING: 
            case REFERENCE: {
                return new ArrayList<QuerySubject>();
            }
        }
        return this.fromReference(querysubject.getRef(), module);
    }

    private InstanceType getInstanceType(QuerySubject querysubject) {
        if (querysubject.getInstanceType() == null) {
            return InstanceType.COPY;
        }
        return querysubject.getInstanceType();
    }

    private List<QuerySubject> fromReference(List<String> references, Module module) {
        ArrayList<QuerySubject> tables = new ArrayList<QuerySubject>();
        for (String ref : references) {
            if (ref.split("\\.").length != 1) continue;
            QuerySubject qs = this.getQuerySubjectById(ref, module);
            if (qs == null) {
                qs = new QuerySubject();
                qs.setInstanceType(InstanceType.MISSING);
                qs.setIdentifier(ref);
            }
            tables.add(qs);
        }
        return tables;
    }

    private QuerySubject getQuerySubjectById(String id, Module module) {
        QuerySubject querySubject = null;
        List qsList = module.basicGetQuerySubject();
        if (qsList != null) {
            for (QuerySubject qs : qsList) {
                if (!qs.getIdentifier().equals(id)) continue;
                querySubject = qs;
                break;
            }
        }
        return querySubject;
    }
}

