/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.client.relink;

import com.ibm.bi.platform.moser.client.relink.ModuleRelinker;
import com.ibm.bi.platform.moser.common.generated.metadata.DrillGroup;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmbeddedModuleRelinker
extends ModuleRelinker {
    private List<String> qsIds;
    private List<String> newQsIds;
    private Map<String, List<String>> qsAndQiIds;
    private Map<String, List<String>> newQsAndQiIds;
    private Map<String, String> qsIdRemap;

    public EmbeddedModuleRelinker(Module module, Module newSrcModule) {
        super(module, newSrcModule);
    }

    @Override
    public Module.UseSpec relinkSource(Module.UseSpec useSpec, UseSpecType newSrcType, String newSrcStoreId, List<Module.UseSpec.Ancestors> newSrcAncestors, ObjectFactory objectFactory) {
        Module.UseSpec newUseSpec = this.doRelinkSource(useSpec, newSrcType, newSrcStoreId, newSrcAncestors, objectFactory);
        newUseSpec.setImports("*");
        return newUseSpec;
    }

    @Override
    public void relinkIdentifiers(Module.UseSpec useSpec) {
        this.qsIds = new ArrayList<String>();
        this.newQsIds = new ArrayList<String>();
        this.qsAndQiIds = new HashMap<String, List<String>>();
        this.newQsAndQiIds = new HashMap<String, List<String>>();
        if (!this.containsDrillGroups()) {
            return;
        }
        EmbeddedModuleRelinker.collectQsAndQiIds(this.module, this.qsIds, this.qsAndQiIds);
        EmbeddedModuleRelinker.collectQsAndQiIds(this.newSrcModule, this.newQsIds, this.newQsAndQiIds);
        if (!this.collectIdsFromDrillGroups()) {
            return;
        }
        this.buildQsRemap();
        this.relinkDrillGroups();
    }

    public List<String> relinkIdForExpressions(List<String> expressions) {
        this.qsIds = new ArrayList<String>();
        this.newQsIds = new ArrayList<String>();
        this.qsAndQiIds = new HashMap<String, List<String>>();
        this.newQsAndQiIds = new HashMap<String, List<String>>();
        if (expressions == null || expressions.isEmpty()) {
            return new ArrayList<String>();
        }
        EmbeddedModuleRelinker.collectQsAndQiIds(this.module, this.qsIds, this.qsAndQiIds);
        EmbeddedModuleRelinker.collectQsAndQiIds(this.newSrcModule, this.newQsIds, this.newQsAndQiIds);
        if (!this.collectIdsFromExpressions(expressions)) {
            return expressions;
        }
        this.buildQsRemap();
        ArrayList<String> result = new ArrayList<String>();
        for (String expression : expressions) {
            result.add(this.relinkExpression(expression));
        }
        return result;
    }

    private static void collectQsAndQiIds(Module m, List<String> querySubjectIDs, Map<String, List<String>> querySubjectQueryItemIDs) {
        if (m == null) {
            return;
        }
        List querySubjects = m.basicGetQuerySubject();
        if (querySubjects != null) {
            for (QuerySubject qs : querySubjects) {
                String id = qs.getIdentifier();
                String idLower = id.toLowerCase();
                querySubjectIDs.add(id);
                List<String> qiIds = EmbeddedModuleRelinker.collectItemsIdentifiers(qs.basicGetItem());
                List<String> existingIds = querySubjectQueryItemIDs.get(idLower);
                if (existingIds != null) {
                    existingIds.addAll(qiIds);
                    continue;
                }
                querySubjectQueryItemIDs.put(idLower, qiIds);
            }
        }
    }

    private boolean collectIdsFromExpressions(List<String> expressions) {
        boolean found = false;
        for (String expression : expressions) {
            String[] splits;
            if (expression.charAt(0) == '[' || (splits = expression.split("\\.")).length < 2) continue;
            found = true;
            String qsId = splits[0];
            String qsIdLower = qsId.toLowerCase();
            String qiId = splits[1];
            List<String> existingIds = this.qsAndQiIds.get(qsIdLower);
            if (existingIds == null) {
                this.qsIds.add(qsId);
                existingIds = new ArrayList<String>();
                this.qsAndQiIds.put(qsIdLower, existingIds);
            }
            if (existingIds.contains(qiId)) continue;
            existingIds.add(qiId);
        }
        return found;
    }

    private boolean containsDrillGroups() {
        List drillGroups = this.module.basicGetDrillGroup();
        if (drillGroups == null) {
            return false;
        }
        for (DrillGroup drillGroup : drillGroups) {
            List segments = drillGroup.basicGetSegment();
            if (drillGroup.isImported() || segments == null) continue;
            for (DrillGroup.Segment segment : segments) {
                String ref = segment.getRef();
                String[] splits = ref.split("\\.");
                if (splits.length != 2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean collectIdsFromDrillGroups() {
        List drillGroups = this.module.basicGetDrillGroup();
        if (drillGroups == null) {
            return false;
        }
        boolean found = false;
        for (DrillGroup drillGroup : drillGroups) {
            List segments = drillGroup.basicGetSegment();
            if (drillGroup.isImported() || segments == null) continue;
            for (DrillGroup.Segment segment : segments) {
                String ref = segment.getRef();
                String[] splits = ref.split("\\.");
                if (splits.length != 2) continue;
                found = true;
                String qsId = splits[0];
                String qsIdLower = qsId.toLowerCase();
                String qiId = splits[1];
                List<String> existingIds = this.qsAndQiIds.get(qsIdLower);
                if (existingIds == null) {
                    this.qsIds.add(qsId);
                    existingIds = new ArrayList<String>();
                    this.qsAndQiIds.put(qsIdLower, existingIds);
                }
                if (existingIds.contains(qiId)) continue;
                existingIds.add(qiId);
            }
        }
        return found;
    }

    private void buildQsRemap() {
        this.qsIdRemap = new HashMap<String, String>();
        for (String qsId : this.qsIds) {
            this.qsIdRemap.put(qsId, this.bestMatch(qsId));
        }
    }

    private String bestMatch(String qsId) {
        if (this.newQsIds.isEmpty()) {
            return qsId;
        }
        if (this.newQsIds.size() == 1) {
            return this.newQsIds.get(0);
        }
        int bestScore = 0;
        String bestCandidate = null;
        String qsIdLower = qsId.toLowerCase();
        List<String> identifiers = this.qsAndQiIds.get(qsIdLower);
        for (String candidate : this.newQsIds) {
            String candidateLower = candidate.toLowerCase();
            if (qsIdLower.equals(candidateLower)) {
                return candidate;
            }
            int score = EmbeddedModuleRelinker.scoreCandidate(identifiers, this.newQsAndQiIds.get(candidateLower));
            if (score <= bestScore) continue;
            bestCandidate = candidate;
            bestScore = score;
        }
        return bestCandidate;
    }

    private String relinkExpression(String expression) {
        if (expression == null || expression.isEmpty()) {
            return null;
        }
        String[] splits = expression.split("\\.");
        if (splits.length < 2) {
            return null;
        }
        String qsId = splits[0];
        String newQsId = this.qsIdRemap.get(qsId);
        if (newQsId == null) {
            return null;
        }
        return newQsId + expression.substring(qsId.length());
    }

    private void relinkDrillGroups() {
        List drillGroups = this.module.basicGetDrillGroup();
        if (drillGroups == null) {
            return;
        }
        for (DrillGroup drillGroup : drillGroups) {
            List segments = drillGroup.basicGetSegment();
            if (drillGroup.isImported() || segments == null) continue;
            for (DrillGroup.Segment segment : segments) {
                String relinkedRef = this.relinkExpression(segment.getRef());
                if (relinkedRef == null) continue;
                segment.setRef(relinkedRef);
            }
        }
    }
}

