/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.client.relink;

import com.ibm.bi.platform.moser.client.utils.ModuleUtils;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.ReferenceResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModuleRelinker {
    protected final Module module;
    protected final Module newSrcModule;

    public ModuleRelinker(Module module, Module newSrcModule) {
        this.module = module;
        this.newSrcModule = newSrcModule;
    }

    public Module.UseSpec relinkSource(Module.UseSpec useSpec, UseSpecType newSrcType, String newSrcStoreId, List<Module.UseSpec.Ancestors> newSrcAncestors, ObjectFactory objectFactory) {
        return this.doRelinkSource(useSpec, newSrcType, newSrcStoreId, newSrcAncestors, objectFactory);
    }

    protected Module.UseSpec doRelinkSource(Module.UseSpec useSpec, UseSpecType newSrcType, String newSrcStoreId, List<Module.UseSpec.Ancestors> newSrcAncestors, ObjectFactory objectFactory) {
        Module.UseSpec newUseSpec = objectFactory.createModuleUseSpec();
        newUseSpec.setIdentifier(useSpec.getIdentifier());
        newUseSpec.setType(newSrcType);
        newUseSpec.setStoreID(newSrcStoreId);
        newUseSpec.setSearchPath(null);
        if (newSrcAncestors != null && !newSrcAncestors.isEmpty()) {
            newUseSpec.getAncestors().addAll(newSrcAncestors);
        }
        newUseSpec.setDataCacheExpiry(useSpec.getDataCacheExpiry());
        int position = this.module.getUseSpec().indexOf(useSpec);
        this.module.removeUseSpecAt(position);
        this.module.addUseSpecAt(position, newUseSpec);
        return newUseSpec;
    }

    public void relinkIdentifiers(Module.UseSpec useSpec) {
        List<ObjectType> refsToUseSpec = ModuleUtils.getUseSpecRefs(useSpec, this.module);
        this.relinkIdentifierRefs(refsToUseSpec, useSpec);
    }

    private void relinkIdentifierRefs(List<ObjectType> refs, Module.UseSpec newUseSpec) {
        if (refs == null || refs.isEmpty()) {
            return;
        }
        ArrayList<String> identifiers = new ArrayList<String>();
        Map<String, ObjectType> identifierToObjectType = ModuleRelinker.identifierToObjectType(this.newSrcModule, identifiers);
        for (ObjectType obj : refs) {
            String objType = obj.getObjectType();
            if ("QuerySubject".equals(objType)) {
                ModuleRelinker.relinkQuerySubject((QuerySubject)obj, newUseSpec, identifierToObjectType, identifiers);
                continue;
            }
            if ("Relationship".equals(objType)) {
                ModuleRelinker.relinkRelationship((Relationship)obj, newUseSpec, identifierToObjectType, identifiers);
                continue;
            }
            if ("Calculation".equals(objType)) {
                ModuleRelinker.relinkCalculation((Calculation)obj, newUseSpec, identifierToObjectType, identifiers);
                continue;
            }
            if (!"Filter".equals(objType)) continue;
            ModuleRelinker.relinkFilter((Filter)obj, newUseSpec, identifierToObjectType, identifiers);
        }
    }

    private static Map<String, ObjectType> identifierToObjectType(Module module, List<String> identifiers) {
        List filters;
        List calculations;
        List relationships;
        HashMap<String, ObjectType> identifierToObjectType = new HashMap<String, ObjectType>();
        List querySubjects = module.basicGetQuerySubject();
        if (querySubjects != null && !querySubjects.isEmpty()) {
            for (QuerySubject qs : querySubjects) {
                identifierToObjectType.put(qs.getIdentifier(), (ObjectType)qs);
                identifiers.add(qs.getIdentifier());
            }
        }
        if ((relationships = module.basicGetRelationship()) != null && !relationships.isEmpty()) {
            for (Relationship rel : relationships) {
                identifierToObjectType.put(rel.getIdentifier(), (ObjectType)rel);
                identifiers.add(rel.getIdentifier());
            }
        }
        if ((calculations = module.basicGetCalculation()) != null && !calculations.isEmpty()) {
            for (Calculation calc : calculations) {
                identifierToObjectType.put(calc.getIdentifier(), (ObjectType)calc);
                identifiers.add(calc.getIdentifier());
            }
        }
        if ((filters = module.basicGetFilter()) != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                identifierToObjectType.put(filter.getIdentifier(), (ObjectType)filter);
                identifiers.add(filter.getIdentifier());
            }
        }
        return identifierToObjectType;
    }

    private static void relinkQuerySubject(QuerySubject qs, Module.UseSpec newUseSpec, Map<String, ObjectType> identifierToObjectType, List<String> identifiers) {
        String ref;
        ObjectType matchingObject = null;
        List<String> allRefs = ModuleRelinker.buildQSRefList(qs);
        Iterator<String> iterator = allRefs.iterator();
        while (iterator.hasNext() && (matchingObject = identifierToObjectType.get(ref = iterator.next())) == null && (matchingObject = identifierToObjectType.get(ref.toLowerCase())) == null) {
        }
        if (InstanceType.MISSING.equals((Object)qs.getInstanceType())) {
            int index;
            qs.setInstanceType(null);
            List props = qs.basicGetPropertyOverride();
            if (props != null && !props.isEmpty() && (index = props.indexOf("instanceType")) >= 0) {
                props.remove(index);
            }
        }
        if (matchingObject == null || !"QuerySubject".equals(matchingObject.getObjectType())) {
            matchingObject = ModuleRelinker.bestMatch((ObjectType)qs, identifierToObjectType, identifiers);
        }
        if (matchingObject == null) {
            return;
        }
        while (!qs.getRef().isEmpty()) {
            qs.removeRefAt(0);
        }
        qs.addRef(newUseSpec.getIdentifier() + "." + matchingObject.getIdentifier());
    }

    private static List<String> buildQSRefList(QuerySubject qs) {
        List refs = qs.basicGetRef();
        List originalRefs = qs.basicGetOriginalRef();
        ArrayList<String> result = new ArrayList<String>();
        if (refs != null && !refs.isEmpty()) {
            for (String ref : refs) {
                ModuleRelinker.addSecondPartIdentifier(result, ref);
            }
        }
        if (originalRefs != null && !originalRefs.isEmpty()) {
            for (String ref : originalRefs) {
                ModuleRelinker.addSecondPartIdentifier(result, ref);
            }
        }
        ModuleRelinker.addSecondPartIdentifier(result, qs.getIdentifier());
        return result;
    }

    protected static void addSecondPartIdentifier(List<String> result, String ref) {
        String identifier = ReferenceResolver.getSecondPart((String)ref);
        if (identifier != null && !identifier.isEmpty()) {
            result.add(identifier);
        }
    }

    private static ObjectType bestMatch(ObjectType obj, Map<String, ObjectType> identifierToObjectType, List<String> identifiers) {
        ArrayList<ObjectType> candidates = new ArrayList<ObjectType>();
        String type = obj.getObjectType();
        for (String id : identifiers) {
            ObjectType candidate = identifierToObjectType.get(id);
            if (!type.equals(candidate.getObjectType())) continue;
            candidates.add(candidate);
        }
        return candidates.isEmpty() ? null : (candidates.size() == 1 ? (ObjectType)candidates.get(0) : ModuleRelinker.bestCandidate(obj, candidates));
    }

    private static ObjectType bestCandidate(ObjectType obj, List<ObjectType> candidates) {
        if (!"QuerySubject".equals(obj.getObjectType())) {
            return null;
        }
        int bestScore = 1;
        QuerySubject querySubject = (QuerySubject)obj;
        QuerySubject bestCandidate = null;
        List<String> identifiers = ModuleRelinker.collectItemsIdentifiers(querySubject.basicGetItem());
        for (ObjectType c : candidates) {
            int score;
            QuerySubject candidate = (QuerySubject)c;
            int n = score = querySubject.getLabel().equals(candidate.getLabel()) ? 1 : 0;
            if ((score += ModuleRelinker.scoreCandidate(identifiers, ModuleRelinker.collectItemsIdentifiers(candidate.basicGetItem()))) <= bestScore) continue;
            bestCandidate = candidate;
            bestScore = score;
        }
        return bestCandidate;
    }

    protected static List<String> collectItemsIdentifiers(List<ItemType> items) {
        ArrayList<String> identifiers = new ArrayList<String>();
        if (items == null || items.isEmpty()) {
            return identifiers;
        }
        for (ItemType item : items) {
            if (item.getQueryItem() != null) {
                identifiers.add(item.getQueryItem().getIdentifier());
                continue;
            }
            if (item.getFilter() != null) {
                identifiers.add(item.getFilter().getIdentifier());
                continue;
            }
            if (item.getItemHierarchy() != null) {
                identifiers.add(item.getItemHierarchy().getIdentifier());
                continue;
            }
            if (item.getNamedSet() != null) {
                identifiers.add(item.getNamedSet().getIdentifier());
                continue;
            }
            if (item.getFolder() == null) continue;
            identifiers.addAll(ModuleRelinker.collectItemsIdentifiers(item.getFolder().basicGetItem()));
        }
        return identifiers;
    }

    protected static int scoreCandidate(List<String> identifiers, List<String> newIdentifiers) {
        if (newIdentifiers == null || newIdentifiers.isEmpty()) {
            return 0;
        }
        int score = 0;
        for (String identifier : identifiers) {
            score += newIdentifiers.contains(identifier) ? 1 : 0;
        }
        return score;
    }

    private static void relinkRelationship(Relationship rel, Module.UseSpec newUseSpec, Map<String, ObjectType> identifierToObjectType, List<String> identifiers) {
        String originalRef = rel.getRef();
        String ref = ReferenceResolver.getSecondPart((String)originalRef);
        ObjectType matchingObject = identifierToObjectType.get(ref);
        if (InstanceType.MISSING.equals((Object)rel.getInstanceType())) {
            int index;
            rel.setInstanceType(null);
            List props = rel.basicGetPropertyOverride();
            if (props != null && !props.isEmpty() && (index = props.indexOf("instanceType")) >= 0) {
                props.remove(index);
            }
        }
        if (matchingObject == null || !"Relationship".equals(matchingObject.getObjectType())) {
            matchingObject = ModuleRelinker.bestMatch((ObjectType)rel, identifierToObjectType, identifiers);
        }
        if (matchingObject == null) {
            return;
        }
        rel.setRef(newUseSpec.getIdentifier() + "." + matchingObject.getIdentifier());
    }

    private static void relinkCalculation(Calculation calc, Module.UseSpec newUseSpec, Map<String, ObjectType> identifierToObjectType, List<String> identifiers) {
        String originaRef = calc.getRef();
        String ref = ReferenceResolver.getSecondPart((String)originaRef);
        ObjectType matchingObject = identifierToObjectType.get(ref);
        if (matchingObject == null || !"Calculation".equals(matchingObject.getObjectType())) {
            matchingObject = ModuleRelinker.bestMatch((ObjectType)calc, identifierToObjectType, identifiers);
        }
        if (matchingObject == null) {
            return;
        }
        calc.setRef(newUseSpec.getIdentifier() + "." + matchingObject.getIdentifier());
    }

    private static void relinkFilter(Filter filter, Module.UseSpec newUseSpec, Map<String, ObjectType> identifierToObjectType, List<String> identifiers) {
        String originaRef = filter.getRef();
        String ref = ReferenceResolver.getSecondPart((String)originaRef);
        ObjectType matchingObject = identifierToObjectType.get(ref);
        if (matchingObject == null || !"Filter".equals(matchingObject.getObjectType())) {
            matchingObject = ModuleRelinker.bestMatch((ObjectType)filter, identifierToObjectType, identifiers);
        }
        if (matchingObject == null) {
            return;
        }
        filter.setIdentifier(newUseSpec.getIdentifier() + "." + matchingObject.getIdentifier());
    }
}

