/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.client.utils;

import com.ibm.bi.platform.moser.client.utils.QuerySubjectUtils;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.bi.platform.moser.common.utils.ItemScanner;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import java.util.List;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class IdGenerator {
    private CaseInsensitiveMap _ids = new CaseInsensitiveMap();
    private String _scopeId;

    public IdGenerator(ObjectType scope) {
        if (scope != null) {
            ObjectType actualScope = IdGenerator.adjustScope(scope);
            if ("QuerySubject".equals(actualScope.getObjectType())) {
                this._scopeId = actualScope.getIdentifier();
            }
            this.collectScopeIds(actualScope);
        }
    }

    private static ObjectType adjustScope(ObjectType scope) {
        String objectType = scope.getObjectType();
        if ("QueryItem".equals(objectType) || "Folder".equals(objectType)) {
            return QuerySubjectUtils.getParentQuerySubject((MoserObject)scope);
        }
        if ("FolderType".equals(objectType)) {
            return QuerySubjectUtils.getParentModule((MoserObject)scope);
        }
        return scope;
    }

    public void generateId(ObjectType obj) {
        String prefix = obj.getIdentifier();
        if (prefix == null || prefix.isEmpty()) {
            prefix = obj.getLabel();
            if (prefix == null || prefix.isEmpty()) {
                prefix = "_id";
            } else if ("Module".equals(obj.getObjectType()) && ((Module)obj).getContainer() != null) {
                prefix = ((Module)obj).getContainer() + "." + prefix;
            }
        }
        String id = IdentifierUtil.makeUniqueAndValidIdentifier((String)prefix, (CaseInsensitiveMap)this._ids);
        obj.setIdentifier(id);
        if (!("Module".equals(obj.getObjectType()) || "QuerySubject".equals(obj.getObjectType()) || "Folder".equals(obj.getObjectType()) || "FolderType".equals(obj.getObjectType()))) {
            if (this._scopeId == null || this._scopeId.isEmpty()) {
                obj.setIdForExpression(id);
            } else {
                obj.setIdForExpression(this._scopeId + "." + id);
            }
        }
        this._ids.put((Object)id, (Object)Boolean.TRUE);
    }

    public static String generateNewUseSpecId(Module module) {
        return IdGenerator.generateNewUseSpecIdWithPrefix(module, "M");
    }

    public static String generateNewUseSpecIdWithPrefix(Module module, String prefix) {
        List useSpecList = module.basicGetUseSpec();
        int nextId = 0;
        if (useSpecList != null) {
            for (Module.UseSpec spec : useSpecList) {
                int id;
                if (spec.getIdentifier().indexOf(prefix) != 0 || (id = Integer.parseInt(spec.getIdentifier().substring(prefix.length()))) <= nextId) continue;
                nextId = id;
            }
        }
        return prefix + ++nextId;
    }

    private void collectScopeIds(ObjectType scope) {
        if ("Module".equals(scope.getObjectType())) {
            this.collectIds(((Module)scope).basicGetQuerySubject());
            this.collectIds(((Module)scope).basicGetCalculation());
            this.collectIds(((Module)scope).basicGetDrillGroup());
            this.collectIds(((Module)scope).basicGetFilter());
            this.collectIds(((Module)scope).basicGetParameterMap());
            this.collectIds(((Module)scope).basicGetRelationship());
            this.collectIds(((Module)scope).basicGetNamedSet());
            this.collectIds(MoserObjectUtils.getFolderTypes((Module)((Module)scope)));
        } else if ("QuerySubject".equals(scope.getObjectType())) {
            this.collectIds(MoserObjectUtils.getItems((ObjectType)scope));
            this.collectIds(((QuerySubject)scope).basicGetFilter());
            this.collectIds(((QuerySubject)scope).basicGetSecurityFilter());
            this.collectIds(MoserObjectUtils.getItemNormalizationGroups((QuerySubject)((QuerySubject)scope)));
        } else if ("QueryItem".equals(scope.getObjectType())) {
            this.collectIds(MoserObjectUtils.getItems((ObjectType)scope));
        }
    }

    private void collectIds(List<? extends ObjectType> itemList) {
        if (itemList != null) {
            for (ObjectType objectType : itemList) {
                String id = objectType.getIdentifier();
                if (id == null || id.isEmpty()) continue;
                this._ids.put((Object)id, (Object)Boolean.TRUE);
            }
        }
    }

    public static boolean idIsAllowedToBeChanged(ObjectType obj) {
        if (obj == null) {
            return true;
        }
        if ("QueryItem".equals(obj.getObjectType())) {
            String expr = ((QueryItem)obj).getExpression();
            String id = obj.getIdentifier();
            if (id != null && !id.isEmpty() && expr != null && !expr.isEmpty()) {
                List ids = ItemScanner.collectIdentifiers((String)expr);
                for (String[] parts : ids) {
                    if (parts.length != 1 || !id.equals(parts[0])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isIdUnique(ObjectType obj, String idToCheck) {
        if (obj == null) {
            return true;
        }
        MoserObject scopeObj = null;
        for (MoserObject parent = obj.getParent(); parent != null; parent = parent.getParent()) {
            String objType = parent.getObjectType();
            if (!"Module".equals(objType) && !"QuerySubject".equals(objType)) continue;
            scopeObj = parent;
            break;
        }
        if (scopeObj == null) {
            return true;
        }
        IdGenerator gen = new IdGenerator(null);
        gen.collectScopeIds((ObjectType)scopeObj);
        return !gen._ids.containsKey((Object)idToCheck);
    }

    public static boolean isIdValid(String idToCheck) {
        return IdentifierUtil.isIdValid((String)idToCheck);
    }

    public static String makeIdentifier(MoserObject parentObj, String id) {
        if (parentObj == null) {
            return null;
        }
        MoserObject scopeObj = null;
        for (MoserObject parent = parentObj; parent != null; parent = parent.getParent()) {
            String objType = parent.getObjectType();
            if (!"Module".equals(objType) && !"QuerySubject".equals(objType)) continue;
            scopeObj = parent;
            break;
        }
        if (scopeObj == null) {
            return null;
        }
        IdGenerator gen = new IdGenerator(null);
        gen.collectScopeIds((ObjectType)scopeObj);
        return IdentifierUtil.makeUniqueAndValidIdentifier((String)id, (CaseInsensitiveMap)gen._ids);
    }
}

