/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.client.utils;

import com.ibm.bi.platform.moser.client.relink.EmbeddedModuleRelinker;
import com.ibm.bi.platform.moser.client.relink.ModuleRelinker;
import com.ibm.bi.platform.moser.client.utils.CopyMode;
import com.ibm.bi.platform.moser.client.utils.IdGenerator;
import com.ibm.bi.platform.moser.client.utils.QuerySubjectUtils;
import com.ibm.bi.platform.moser.client.utils.RelationshipUtils;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityType;
import com.ibm.bi.platform.moser.common.generated.metadata.DefLinkType;
import com.ibm.bi.platform.moser.common.generated.metadata.DrillGroup;
import com.ibm.bi.platform.moser.common.generated.metadata.FacetType;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemHierarchy;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemNormalizationGroupType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemNormalizationType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.LocalRefType;
import com.ibm.bi.platform.moser.common.generated.metadata.MemberType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.NamedSet;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertySetter;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.SecurityFilter;
import com.ibm.bi.platform.moser.common.generated.metadata.SortListType;
import com.ibm.bi.platform.moser.common.generated.metadata.SplitType;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.common.utils.ReferenceResolver;
import com.ibm.bi.platform.moser.core.metadata.util.CommonResolverUtil;
import com.ibm.bi.platform.moser.core.module.util.DataModuleExtractor;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ModuleUtils {
    private ModuleUtils() {
    }

    public static Module createModule(ObjectFactory objectFactory, String label, String expressionLocale) {
        Module module = objectFactory.createModule();
        module.setLabel(label);
        module.setContainer("C");
        new IdGenerator(null).generateId((ObjectType)module);
        module.setVersion("11.1");
        module.setExpressionLocale(expressionLocale);
        module.setDataRetrievalMode("liveConnection");
        FolderType f = objectFactory.createFolderType();
        module.addMetadataTreeView(f);
        return module;
    }

    public static Module.UseSpec addSource(Module module, UseSpecType srcModuleType, String srcModuleStoreId, @Deprecated String srcModuleSearchPath, ObjectFactory objectFactory, boolean addMDTVPlaceHolder, List<Module.UseSpec.Ancestors> ancestors) {
        Module.UseSpec useSpec = objectFactory.createModuleUseSpec();
        useSpec.setIdentifier(IdGenerator.generateNewUseSpecId(module));
        useSpec.setType(srcModuleType);
        useSpec.setStoreID(srcModuleStoreId);
        if (ancestors != null && !ancestors.isEmpty()) {
            useSpec.getAncestors().addAll(ancestors);
        }
        module.addUseSpec(useSpec);
        if (addMDTVPlaceHolder && (UseSpecType.PACKAGE.equals((Object)srcModuleType) || UseSpecType.LW_OLAP.equals((Object)srcModuleType))) {
            ModuleUtils.addPlaceHolder(module, useSpec.getIdentifier(), objectFactory);
        }
        if (UseSpecType.DATABASE.equals((Object)srcModuleType)) {
            useSpec.setDataCacheExpiry("3600");
        }
        return useSpec;
    }

    public static Module.UseSpec relinkDataModuleSource(Module module, Module.UseSpec useSpec, UseSpecType newSrcType, String newSrcStoreId, List<Module.UseSpec.Ancestors> newSrcAncestors, ObjectFactory objectFactory) {
        ModuleRelinker relinker = new ModuleRelinker(module, null);
        return relinker.relinkSource(useSpec, newSrcType, newSrcStoreId, newSrcAncestors, objectFactory);
    }

    public static void relinkDataModule(Module module, Module.UseSpec useSpec, Module newSrcModule) {
        ModuleRelinker relinker = new ModuleRelinker(module, newSrcModule);
        relinker.relinkIdentifiers(useSpec);
    }

    public static Module.UseSpec relinkEmbeddedModuleSource(Module module, Module.UseSpec useSpec, UseSpecType newSrcType, String newSrcStoreId, List<Module.UseSpec.Ancestors> newSrcAncestors, ObjectFactory objectFactory) {
        EmbeddedModuleRelinker relinker = new EmbeddedModuleRelinker(module, null);
        return relinker.relinkSource(useSpec, newSrcType, newSrcStoreId, newSrcAncestors, objectFactory);
    }

    public static void relinkEmbeddedModule(Module module, Module.UseSpec useSpec, Module newSrcModule) {
        EmbeddedModuleRelinker relinker = new EmbeddedModuleRelinker(module, newSrcModule);
        relinker.relinkIdentifiers(useSpec);
    }

    public static List<String> relinkIdForExpressions(Module module, List<String> expressions, Module newSrcModule) {
        EmbeddedModuleRelinker relinker = new EmbeddedModuleRelinker(module, newSrcModule);
        return relinker.relinkIdForExpressions(expressions);
    }

    public static void removeMembers(QuerySubject qs) {
        DataModuleExtractor.removeMembersFromQS((QuerySubject)qs);
    }

    protected static void addPlaceHolder(Module module, String srcId, ObjectFactory objectFactory) {
        FolderType f;
        FolderType placeHolder = objectFactory.createFolderType();
        placeHolder.setIdentifier(srcId);
        FolderItemType fi = objectFactory.createFolderItemType();
        fi.setFolder(placeHolder);
        List mdtv = module.getMetadataTreeView();
        if (mdtv.isEmpty()) {
            f = objectFactory.createFolderType();
            module.addMetadataTreeView(f);
        } else {
            f = (FolderType)mdtv.get(0);
        }
        f.addFolderItem(fi);
    }

    public static JSONObject prepareModuleForSave(Module module) throws CloneNotSupportedException {
        JSONObject moduleJSON = null;
        Module clonedModule = (Module)module.clone();
        if (clonedModule != null) {
            DataModuleExtractor.removeModuleMetadata((Module)clonedModule);
            moduleJSON = clonedModule.toJSON();
        }
        return moduleJSON;
    }

    public static void generateObjectId(ObjectType scope, ObjectType obj) {
        new IdGenerator(scope).generateId(obj);
    }

    public static IdGenerator getIdGenerator(ObjectType scope) {
        return new IdGenerator(scope);
    }

    public static String getNewUseSpecId(Module module) {
        return IdGenerator.generateNewUseSpecId(module);
    }

    public static void convertReferenceQuerySubjectToCopy(QuerySubject qs, Module module) throws CloneNotSupportedException {
        QuerySubjectUtils.convertReferenceQuerySubjectToCopy(qs, module);
    }

    public static void insertQuerySubject(Module module, List<QuerySubject> qsList, FolderType mdtvFolder, int inserAtIndex, ObjectFactory objectFactory) {
        int mdtvIndex = inserAtIndex;
        for (QuerySubject qs : qsList) {
            module.addQuerySubject(qs);
            ModuleUtils.insertFolderItem(mdtvFolder, (ObjectType)qs, mdtvIndex++, objectFactory);
        }
    }

    public static Module.UseSpec getSourceModuleUseSpecInParentModule(MoserObject srcObj, Module module) {
        if (srcObj == null || module == null) {
            return null;
        }
        List useSpecs = module.basicGetUseSpec();
        if (useSpecs == null || useSpecs.isEmpty()) {
            return null;
        }
        Module srcModule = QuerySubjectUtils.getParentModule(srcObj);
        if (srcModule == null) {
            return null;
        }
        List useLst = srcModule.basicGetUse();
        if (useLst == null || useLst.size() != 1) {
            return null;
        }
        String srcModuleStoreId = (String)useLst.get(0);
        for (Module.UseSpec useSp : useSpecs) {
            if (!srcModuleStoreId.equals(useSp.getStoreID())) continue;
            return useSp;
        }
        return null;
    }

    public static String getSourceModuleAliasIfNotDefined(String srcModuleId, Module module, MoserObject srcObj) {
        if (srcModuleId != null) {
            return srcModuleId;
        }
        Module.UseSpec useSpec = ModuleUtils.getSourceModuleUseSpecInParentModule(srcObj, module);
        if (useSpec != null) {
            return useSpec.getIdentifier();
        }
        return null;
    }

    public static void insert(ObjectType destParent, List<MoserObject> objList, String srcModuleId, Module srcModule, boolean asReference, FolderType mdtvFolder, int insertAtIndex, ObjectFactory objectFactory, HashMap<String, String> idMap) throws CloneNotSupportedException {
        IdGenerator idGenerator = ModuleUtils.getIdGenerator(destParent);
        HashMap<String, String> oldIdToNewIdMap = idMap;
        if (oldIdToNewIdMap == null) {
            oldIdToNewIdMap = new HashMap();
        }
        int mdtvIndex = insertAtIndex;
        String destParentObjectType = destParent.getObjectType();
        for (MoserObject obj : objList) {
            QueryItem qi2;
            String idForExprPrefix;
            Module module;
            String objectType = obj.getObjectType();
            if ("QuerySubject".equals(objectType) && "Module".equals(destParentObjectType)) {
                QuerySubject qs;
                module = (Module)destParent;
                String qsRef = ModuleUtils.getSourceModuleAliasIfNotDefined(srcModuleId, module, obj) + "." + ((QuerySubject)obj).getIdentifier();
                QuerySubject existingQS = ModuleUtils.findQuerySubjectByOriginalRefThenRef(module, qsRef);
                if (existingQS == null) {
                    qs = (QuerySubject)obj.clone();
                    if (qs.basicGetSecurityFilter() != null) {
                        qs.getSecurityFilter().clear();
                    }
                    qs.setInstanceType((InstanceType)(asReference ? InstanceType.REFERENCE : null));
                    QuerySubjectUtils.clearPropertyOerride(qs);
                    String oldId = qs.getIdentifier();
                    ModuleUtils.updateQuerySubjectRef(module, qs, ModuleUtils.getSourceModuleAliasIfNotDefined(srcModuleId, module, obj), srcModule, asReference);
                    idGenerator.generateId((ObjectType)qs);
                    oldIdToNewIdMap.put(oldId, qs.getIdentifier());
                    idForExprPrefix = qs.getIdentifier() + ".";
                    for (QueryItem qi2 : MoserObjectUtils.getQueryItems((QuerySubject)qs)) {
                        if (!asReference) {
                            qi2.setExpression(qi2.getIdentifier());
                        }
                        qi2.setIdForExpression(idForExprPrefix + qi2.getIdentifier());
                    }
                    module.addQuerySubject(qs);
                    ModuleUtils.insertFolderItem(mdtvFolder, (ObjectType)qs, mdtvIndex++, objectFactory);
                    continue;
                }
                if (asReference) continue;
                qs = (QuerySubject)obj;
                ModuleUtils.updateExistingQuerySubject(existingQS, qs, objectFactory);
                continue;
            }
            if ("Relationship".equals(objectType) && "Module".equals(destParentObjectType)) {
                module = (Module)destParent;
                Relationship rel = (Relationship)obj.clone();
                String qsId = oldIdToNewIdMap.get(rel.getLeft().getRef());
                if (qsId != null) {
                    rel.getLeft().setRef(qsId);
                }
                if ((qsId = oldIdToNewIdMap.get(rel.getRight().getRef())) != null) {
                    rel.getRight().setRef(qsId);
                }
                if (null == ModuleUtils.findRelationshipMatch(module, rel)) {
                    QuerySubject qsLeft = ModuleUtils.getQuerySubjectById(rel.getLeft().getRef(), module);
                    QuerySubject qsRight = ModuleUtils.getQuerySubjectById(rel.getRight().getRef(), module);
                    if (qsLeft != null && qsLeft.getInstanceType() == InstanceType.REFERENCE && qsRight != null && qsRight.getInstanceType() == InstanceType.REFERENCE) {
                        rel.setInstanceType(InstanceType.REFERENCE);
                        rel.setRef(ModuleUtils.getSourceModuleAliasIfNotDefined(srcModuleId, module, obj) + "." + rel.getIdentifier());
                    } else {
                        rel.setInstanceType(null);
                        rel.setRef(null);
                    }
                    idGenerator.generateId((ObjectType)rel);
                    module.addRelationship(rel);
                }
                ReferenceResolver.resolveRelationship((Relationship)rel, (Module)module);
                continue;
            }
            if ("Calculation".equals(objectType) && "Module".equals(destParentObjectType)) {
                module = (Module)destParent;
                Calculation calc = (Calculation)obj.clone();
                idGenerator.generateId((ObjectType)calc);
                module.addCalculation(calc);
                ModuleUtils.insertFolderItem(mdtvFolder, (ObjectType)calc, mdtvIndex++, objectFactory);
                continue;
            }
            if ("Filter".equals(objectType) && "Module".equals(destParentObjectType)) {
                module = (Module)destParent;
                Filter filter = (Filter)obj.clone();
                idGenerator.generateId((ObjectType)filter);
                module.addFilter(filter);
                ModuleUtils.insertFolderItem(mdtvFolder, (ObjectType)filter, mdtvIndex++, objectFactory);
                continue;
            }
            if ("FolderItemType".equals(objectType) && "Module".equals(destParentObjectType)) {
                module = (Module)destParent;
                FolderItemType folderItem = (FolderItemType)obj.clone();
                FolderType folder = folderItem.getFolder();
                MoserObject o = folderItem.getReferencedObject();
                if (folder != null) {
                    ArrayList<MoserObject> folders = new ArrayList<MoserObject>();
                    folders.add((MoserObject)folder);
                    ModuleUtils.insert((ObjectType)module, folders, ModuleUtils.getSourceModuleAliasIfNotDefined(srcModuleId, module, obj), srcModule, asReference, mdtvFolder, mdtvIndex++, objectFactory, oldIdToNewIdMap);
                    continue;
                }
                if (o == null) continue;
                ArrayList<MoserObject> objects = new ArrayList<MoserObject>();
                objects.add(o);
                ModuleUtils.insert((ObjectType)module, objects, ModuleUtils.getSourceModuleAliasIfNotDefined(srcModuleId, module, obj), srcModule, asReference, mdtvFolder, mdtvIndex++, objectFactory, oldIdToNewIdMap);
                continue;
            }
            if ("FolderType".equals(objectType) && "Module".equals(destParentObjectType)) {
                module = (Module)destParent;
                FolderType folder = (FolderType)obj.clone();
                idGenerator.generateId((ObjectType)folder);
                List items = folder.basicGetFolderItem();
                if (items != null && !items.isEmpty()) {
                    ArrayList<MoserObject> folderItems = new ArrayList<MoserObject>();
                    folderItems.addAll(items);
                    folder.basicGetFolderItem().clear();
                    ModuleUtils.insert((ObjectType)module, folderItems, ModuleUtils.getSourceModuleAliasIfNotDefined(srcModuleId, module, obj), srcModule, asReference, folder, 0, objectFactory, oldIdToNewIdMap);
                }
                ModuleUtils.insertFolder(mdtvFolder, folder, mdtvIndex++, objectFactory);
                continue;
            }
            if (!"QueryItem".equals(objectType) || !"Module".equals(destParentObjectType)) continue;
            module = (Module)destParent;
            String[] ancestor = new String[]{"QuerySubject"};
            QuerySubject srcQs = (QuerySubject)ModuleUtils.getTreeAncestor(obj, ancestor, null);
            String qsRef = ModuleUtils.getSourceModuleAliasIfNotDefined(srcModuleId, module, obj) + "." + srcQs.getIdentifier();
            QuerySubject existingQS = ModuleUtils.findQuerySubjectByOriginalRefThenRef(module, qsRef);
            if (existingQS == null) {
                existingQS = (QuerySubject)srcQs.clone();
                if (existingQS.basicGetSecurityFilter() != null) {
                    existingQS.getSecurityFilter().clear();
                }
                existingQS.setInstanceType((InstanceType)(asReference ? InstanceType.REFERENCE : null));
                QuerySubjectUtils.clearPropertyOerride(existingQS);
                String oldId = existingQS.getIdentifier();
                ModuleUtils.updateQuerySubjectRef(module, existingQS, ModuleUtils.getSourceModuleAliasIfNotDefined(srcModuleId, module, obj), srcModule, asReference);
                idGenerator.generateId((ObjectType)existingQS);
                oldIdToNewIdMap.put(oldId, existingQS.getIdentifier());
                module.addQuerySubject(existingQS);
                ModuleUtils.insertFolderItem(mdtvFolder, (ObjectType)existingQS, mdtvIndex++, objectFactory);
                for (QueryItem qi2 : MoserObjectUtils.getQueryItems((QuerySubject)existingQS)) {
                    ModuleUtils.removeObjectFromQuerySubject((MoserObject)qi2, true);
                }
            }
            idForExprPrefix = existingQS.getIdentifier() + ".";
            Map<String, QueryItem> qiMap = ModuleUtils.createQIMap(existingQS);
            if (qiMap.get((qi2 = (QueryItem)obj).getIdentifier()) != null) continue;
            QueryItem newQI = (QueryItem)obj.clone();
            newQI.setExpression(newQI.getIdentifier());
            newQI.setIdForExpression(idForExprPrefix + newQI.getIdentifier());
            ItemType newItem = objectFactory.createItemType();
            newItem.setQueryItem(newQI);
            existingQS.addItemAt(insertAtIndex, newItem);
        }
    }

    public static List<MoserObject> copy(Module module, List<MoserObject> objList, FolderType mdtvFolder, int insertAtIndex, CopyMode mode, ObjectFactory objectFactory) throws CloneNotSupportedException {
        IdGenerator idGenerator = ModuleUtils.getIdGenerator((ObjectType)module);
        HashMap<String, String> oldIdToNewIdMap = new HashMap<String, String>();
        int mdtvIndex = insertAtIndex;
        ArrayList<MoserObject> copiedObj = new ArrayList<MoserObject>();
        for (MoserObject obj : objList) {
            copiedObj.add(ModuleUtils.copyMoserObject(module, obj, mdtvFolder, mdtvIndex++, idGenerator, oldIdToNewIdMap, objectFactory));
        }
        List<Relationship> relationships = ModuleUtils.collectRelationshipsToCopy(module, oldIdToNewIdMap, mode);
        for (Relationship relationship : relationships) {
            ModuleUtils.copyRelationship(module, relationship, idGenerator, oldIdToNewIdMap);
        }
        return copiedObj;
    }

    private static MoserObject copyMoserObject(Module module, MoserObject obj, FolderType mdtvFolder, int mdtvIndex, IdGenerator idGenerator, HashMap<String, String> oldIdToNewIdMap, ObjectFactory objectFactory) throws CloneNotSupportedException {
        String objectType = obj.getObjectType();
        if ("QuerySubject".equals(objectType)) {
            return ModuleUtils.copyQuerySubject(module, (QuerySubject)obj, mdtvFolder, mdtvIndex, idGenerator, oldIdToNewIdMap, objectFactory);
        }
        if ("Relationship".equals(objectType)) {
            return ModuleUtils.copyRelationship(module, (Relationship)obj, idGenerator, oldIdToNewIdMap);
        }
        if ("Calculation".equals(objectType)) {
            return ModuleUtils.copyCalculation(module, (Calculation)obj, mdtvFolder, mdtvIndex, idGenerator, objectFactory);
        }
        if ("Filter".equals(objectType)) {
            return ModuleUtils.copyFilter(module, (Filter)obj, mdtvFolder, mdtvIndex, idGenerator, objectFactory);
        }
        if ("FolderItemType".equals(objectType)) {
            ModuleUtils.copyFolderItemType(module, (FolderItemType)obj, mdtvFolder, mdtvIndex, idGenerator, oldIdToNewIdMap, objectFactory);
        } else if ("FolderType".equals(objectType)) {
            return ModuleUtils.copyFolderType(module, (FolderType)obj, mdtvFolder, mdtvIndex, idGenerator, oldIdToNewIdMap, objectFactory);
        }
        return null;
    }

    private static QuerySubject copyQuerySubject(Module module, QuerySubject obj, FolderType mdtvFolder, int mdtvIndex, IdGenerator idGenerator, HashMap<String, String> oldIdToNewIdMap, ObjectFactory objectFactory) throws CloneNotSupportedException {
        QuerySubject qs = (QuerySubject)obj.clone();
        String oldId = qs.getIdentifier();
        idGenerator.generateId((ObjectType)qs);
        oldIdToNewIdMap.put(oldId, qs.getIdentifier());
        PropertySetter.updateIdForExpression((List)qs.basicGetItem(), (String)qs.getIdentifier());
        module.addQuerySubject(qs);
        ModuleUtils.insertFolderItem(mdtvFolder, (ObjectType)qs, mdtvIndex, objectFactory);
        return qs;
    }

    private static Relationship copyRelationship(Module module, Relationship obj, IdGenerator idGenerator, HashMap<String, String> oldIdToNewIdMap) throws CloneNotSupportedException {
        Relationship rel = (Relationship)obj.clone();
        String qsId = oldIdToNewIdMap.get(rel.getLeft().getRef());
        if (qsId != null) {
            rel.getLeft().setRef(qsId);
        }
        if ((qsId = oldIdToNewIdMap.get(rel.getRight().getRef())) != null) {
            rel.getRight().setRef(qsId);
        }
        idGenerator.generateId((ObjectType)rel);
        module.addRelationship(rel);
        ReferenceResolver.resolveRelationship((Relationship)rel, (Module)module);
        return rel;
    }

    private static Calculation copyCalculation(Module module, Calculation obj, FolderType mdtvFolder, int mdtvIndex, IdGenerator idGenerator, ObjectFactory objectFactory) throws CloneNotSupportedException {
        Calculation calc = (Calculation)obj.clone();
        idGenerator.generateId((ObjectType)calc);
        module.addCalculation(calc);
        ModuleUtils.insertFolderItem(mdtvFolder, (ObjectType)calc, mdtvIndex, objectFactory);
        return calc;
    }

    private static Filter copyFilter(Module module, Filter obj, FolderType mdtvFolder, int mdtvIndex, IdGenerator idGenerator, ObjectFactory objectFactory) throws CloneNotSupportedException {
        Filter filter = (Filter)obj.clone();
        idGenerator.generateId((ObjectType)filter);
        module.addFilter(filter);
        ModuleUtils.insertFolderItem(mdtvFolder, (ObjectType)filter, mdtvIndex, objectFactory);
        return filter;
    }

    private static MoserObject copyFolderItemType(Module module, FolderItemType obj, FolderType mdtvFolder, int mdtvIndex, IdGenerator idGenerator, HashMap<String, String> oldIdToNewIdMap, ObjectFactory objectFactory) throws CloneNotSupportedException {
        FolderType folder = obj.getFolder();
        MoserObject o = obj.getReferencedObject();
        if (folder != null) {
            return ModuleUtils.copyMoserObject(module, (MoserObject)folder, mdtvFolder, mdtvIndex, idGenerator, oldIdToNewIdMap, objectFactory);
        }
        if (o != null) {
            return ModuleUtils.copyMoserObject(module, o, mdtvFolder, mdtvIndex, idGenerator, oldIdToNewIdMap, objectFactory);
        }
        return null;
    }

    private static FolderType copyFolderType(Module module, FolderType obj, FolderType mdtvFolder, int mdtvIndex, IdGenerator idGenerator, HashMap<String, String> oldIdToNewIdMap, ObjectFactory objectFactory) throws CloneNotSupportedException {
        FolderType folder = (FolderType)obj.clone();
        idGenerator.generateId((ObjectType)folder);
        List items = folder.basicGetFolderItem();
        if (items != null && !items.isEmpty()) {
            ArrayList folderItems = new ArrayList();
            folderItems.addAll(items);
            items.clear();
            int folderIndex = 0;
            for (FolderItemType item : folderItems) {
                ModuleUtils.copyMoserObject(module, (MoserObject)item, folder, folderIndex++, idGenerator, oldIdToNewIdMap, objectFactory);
            }
        }
        ModuleUtils.insertFolder(mdtvFolder, folder, mdtvIndex, objectFactory);
        return folder;
    }

    private static List<Relationship> collectRelationshipsToCopy(Module module, Map<String, String> oldIdToNewIdMap, CopyMode mode) {
        ArrayList<Relationship> relationshipsToCopy = new ArrayList<Relationship>();
        List relationships = module.basicGetRelationship();
        if (CopyMode.SELECTION_ONLY.equals((Object)mode) || relationships == null || relationships.isEmpty()) {
            return relationshipsToCopy;
        }
        for (Relationship relationship : relationships) {
            boolean isRight;
            boolean isLeft = oldIdToNewIdMap.get(relationship.getLeft().getRef()) != null;
            boolean bl = isRight = oldIdToNewIdMap.get(relationship.getRight().getRef()) != null;
            if (CopyMode.COMMON_RELATIONSHIPS.equals((Object)mode) && isLeft && isRight) {
                relationshipsToCopy.add(relationship);
                continue;
            }
            if (!CopyMode.ALL_RELATIONSHIPS.equals((Object)mode) || !isLeft && !isRight) continue;
            relationshipsToCopy.add(relationship);
        }
        return relationshipsToCopy;
    }

    private static QuerySubject findQuerySubjectByOriginalRefThenRef(Module module, String ref) {
        List qsList = MoserObjectUtils.getList((List)module.basicGetQuerySubject());
        for (QuerySubject qs : qsList) {
            List refList = qs.basicGetOriginalRef();
            if (refList == null || refList.isEmpty()) {
                refList = qs.basicGetRef();
            }
            if (!ModuleUtils.findString(refList, ref)) continue;
            return qs;
        }
        return null;
    }

    private static void updateExistingQuerySubject(QuerySubject existingQS, QuerySubject srcQS, ObjectFactory objectFactory) throws CloneNotSupportedException {
        if (srcQS.basicGetItem() != null) {
            Map<String, QueryItem> qiMap = ModuleUtils.createQIMap(existingQS);
            String idForExprPrefix = existingQS.getIdentifier() + ".";
            for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)srcQS)) {
                if (qiMap.get(qi.getIdentifier()) != null) continue;
                QueryItem newQI = (QueryItem)qi.clone();
                newQI.setExpression(newQI.getIdentifier());
                newQI.setIdForExpression(idForExprPrefix + newQI.getIdentifier());
                ItemType newItem = objectFactory.createItemType();
                newItem.setQueryItem(newQI);
                existingQS.addItem(newItem);
            }
        }
    }

    private static Map<String, QueryItem> createQIMap(QuerySubject qs) {
        HashMap<String, QueryItem> qiMap = new HashMap<String, QueryItem>();
        if (qs.basicGetItem() != null) {
            for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)qs)) {
                qiMap.put(qi.getIdentifier(), qi);
            }
        }
        return qiMap;
    }

    public static void insertPackage(ObjectFactory objectFactory, Module module, String srcModuleId, Module srcModule, FolderType mdtvFolder, int insertAtIndex) throws CloneNotSupportedException {
        if (CommonResolverUtil.getFMPlaceHolderInMDTV((Module)module, (String)srcModuleId) != null) {
            return;
        }
        List qsList = MoserObjectUtils.getList((List)srcModule.basicGetQuerySubject());
        for (Object qs : qsList) {
            QuerySubject qsCopy = (QuerySubject)ModuleUtils.cloneAndUpdateId((ObjectType)qs, srcModuleId);
            module.addQuerySubject(qsCopy);
            for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)qsCopy)) {
                qi.setIdForExpression(null);
            }
        }
        List calcList = MoserObjectUtils.getList((List)srcModule.basicGetCalculation());
        for (Object calc : calcList) {
            Calculation calcCopy = (Calculation)ModuleUtils.cloneAndUpdateId((ObjectType)calc, srcModuleId);
            module.addCalculation(calcCopy);
        }
        List filterList = MoserObjectUtils.getList((List)srcModule.basicGetFilter());
        for (Object filter : filterList) {
            Filter filterCopy = (Filter)ModuleUtils.cloneAndUpdateId((ObjectType)filter, srcModuleId);
            module.addFilter(filterCopy);
        }
        List namedSetList = MoserObjectUtils.getList((List)srcModule.basicGetNamedSet());
        for (NamedSet namedSet : namedSetList) {
            NamedSet namedSetCopy = (NamedSet)ModuleUtils.cloneAndUpdateId((ObjectType)namedSet, srcModuleId);
            module.addNamedSet(namedSetCopy);
        }
        FolderType placeHolder = objectFactory.createFolderType();
        placeHolder.setIdentifier(srcModuleId);
        placeHolder.setLabel(srcModule.getLabel());
        FolderItemType fi = objectFactory.createFolderItemType();
        fi.setFolder((FolderType)srcModule.getMetadataTreeView().get(0));
        placeHolder.addFolderItem(fi);
        FolderItemType packageFolderItem = objectFactory.createFolderItemType();
        packageFolderItem.setFolder(placeHolder);
        mdtvFolder.addFolderItemAt(insertAtIndex, packageFolderItem);
        ModuleUtils.updateFolderTypeReferences(placeHolder, srcModuleId);
        ReferenceResolver.resolve((Module)module);
    }

    private static ObjectType cloneAndUpdateId(ObjectType obj, String idPrefix) throws CloneNotSupportedException {
        String id = idPrefix + "." + obj.getIdentifier();
        ObjectType objCopy = (ObjectType)obj.clone();
        objCopy.setIdentifier(id);
        objCopy.setIdForExpression(null);
        return objCopy;
    }

    private static void updateFolderTypeReferences(FolderType folderType, String idPrefix) {
        List folderItemTypes = folderType.basicGetFolderItem();
        if (folderItemTypes != null) {
            for (FolderItemType folderItemType : folderItemTypes) {
                DefLinkType defLinkType;
                FolderType nestedFolder = folderItemType.getFolder();
                if (nestedFolder != null) {
                    ModuleUtils.updateFolderTypeReferences(nestedFolder, idPrefix);
                }
                if ((defLinkType = folderItemType.getDefLink()) == null || defLinkType.getIdentifier() == null) continue;
                String ref = idPrefix + "." + defLinkType.getIdentifier();
                defLinkType.setRef(ref);
            }
        }
    }

    private static void insertFolderItem(FolderType folder, ObjectType obj, int index, ObjectFactory objectFactory) {
        FolderItemType item = objectFactory.createFolderItemType();
        item.setRef(obj.getIdentifier());
        item.setReferencedObject((MoserObject)obj);
        folder.addFolderItemAt(index, item);
    }

    private static void insertFolder(FolderType folder, FolderType obj, int index, ObjectFactory objectFactory) {
        FolderItemType item = objectFactory.createFolderItemType();
        item.setFolder(obj);
        item.setReferencedObject((MoserObject)obj);
        folder.addFolderItemAt(index, item);
    }

    private static void updateQuerySubjectRef(Module module, QuerySubject qs, String srcModuleId, Module srcModule, boolean isReference) throws CloneNotSupportedException {
        if (isReference) {
            List refs = qs.getOriginalRef();
            refs.clear();
            String ref = srcModuleId + "." + qs.getIdentifier();
            refs.add(ref);
            refs = qs.getRef();
            for (int i = 0; i < refs.size(); ++i) {
                String newModuleId;
                ref = (String)refs.get(i);
                String srcModuleUseSpecId = ReferenceResolver.getFirstPart((String)ref);
                Module.UseSpec oldUseSpec = QuerySubjectUtils.getUseSpecById(srcModule, srcModuleUseSpecId);
                if (oldUseSpec == null) continue;
                Module.UseSpec useSpec = ModuleUtils.getUseSpecByStoreId(module, oldUseSpec.getStoreID());
                if (useSpec == null) {
                    useSpec = (Module.UseSpec)oldUseSpec.clone();
                    newModuleId = IdGenerator.generateNewUseSpecIdWithPrefix(module, "__Base");
                    useSpec.setIdentifier(newModuleId);
                    module.addUseSpec(useSpec);
                } else {
                    newModuleId = useSpec.getIdentifier();
                }
                int sepIndex = ref.indexOf(".");
                ref = newModuleId + "." + ref.substring(sepIndex + 1);
                refs.set(i, ref);
            }
        } else {
            List refs = qs.basicGetOriginalRef();
            if (refs != null) {
                refs.clear();
            }
            refs = qs.getRef();
            refs.clear();
            refs.add(srcModuleId + "." + qs.getIdentifier());
        }
    }

    private static Module.UseSpec getUseSpecByStoreId(Module module, String storeId) {
        List uSpecs = MoserObjectUtils.getList((List)module.basicGetUseSpec());
        for (Module.UseSpec useSpec : uSpecs) {
            if (!storeId.equals(useSpec.getStoreID())) continue;
            return useSpec;
        }
        return null;
    }

    private static Relationship findRelationshipMatch(Module module, Relationship rel) {
        List relationShips = MoserObjectUtils.getList((List)module.basicGetRelationship());
        for (Relationship relshp : relationShips) {
            if (!RelationshipUtils.isEqual(rel, relshp)) continue;
            return relshp;
        }
        return null;
    }

    private static QuerySubject findQuerySubjectByRef(Module module, String qsRef) {
        List qsList = MoserObjectUtils.getList((List)module.basicGetQuerySubject());
        for (QuerySubject qs : qsList) {
            if (!ModuleUtils.findString(qs.basicGetRef(), qsRef) && !ModuleUtils.findString(qs.basicGetOriginalRef(), qsRef)) continue;
            return qs;
        }
        return null;
    }

    private static boolean findString(List<String> strList, String strValue) {
        if (strList == null) {
            return false;
        }
        for (String str : strList) {
            if (!str.equals(strValue)) continue;
            return true;
        }
        return false;
    }

    protected static void deleteRelationshipsForQuerySubject(Module module, List<Relationship> rels, String qsId) {
        for (int i = rels.size() - 1; i >= 0; --i) {
            Relationship rel = rels.get(i);
            if (!qsId.equals(rel.getLeft().getRef()) && !qsId.equals(rel.getRight().getRef())) continue;
            module.removeRelationshipAt(i);
        }
    }

    public static void deleteQuerySubject(Module module, QuerySubject qs) {
        ModuleUtils.deleteQuerySubjectImp(module, qs, true);
    }

    protected static void deleteQuerySubjectRelatedObjects(Module module, QuerySubject qs, String qsId) {
        List rels = MoserObjectUtils.getList((List)module.basicGetRelationship());
        ModuleUtils.deleteRelationshipsForQuerySubject(module, rels, qsId);
        List querySubjects = MoserObjectUtils.getList((List)module.basicGetQuerySubject());
        for (QuerySubject aQS : querySubjects) {
            QuerySubject.JoinOperation join;
            if (aQS.equals(qs) || (join = aQS.getJoinOperation()) == null) continue;
            List relsJoin = MoserObjectUtils.getList((List)join.basicGetRelationship());
            ModuleUtils.deleteRelationshipsForQuerySubject(module, relsJoin, qsId);
        }
        List dgs = MoserObjectUtils.getList((List)module.basicGetDrillGroup());
        String qsFirstPart = qsId + ".";
        for (int i = dgs.size() - 1; i >= 0; --i) {
            DrillGroup dg = (DrillGroup)dgs.get(i);
            List segs = dg.basicGetSegment();
            if (segs == null) continue;
            for (int j = segs.size() - 1; j >= 0; --j) {
                if (((DrillGroup.Segment)segs.get(j)).getRef().indexOf(qsFirstPart) != 0) continue;
                dg.removeSegmentAt(j);
            }
        }
    }

    protected static MoserObject deleteQuerySubjectImp(Module module, QuerySubject qs, boolean bClean) {
        String qsId = qs.getIdentifier();
        if (bClean) {
            ModuleUtils.deleteQuerySubjectRelatedObjects(module, qs, qsId);
        }
        List mdtvs = MoserObjectUtils.getList((List)module.basicGetMetadataTreeView());
        for (FolderType folder : mdtvs) {
            MoserObject del = ModuleUtils.removeQuerySubjectFromMDTVFolder(qsId, folder, bClean);
            if (bClean || del == null) continue;
            return del;
        }
        module.removeQuerySubject(qs);
        return qs;
    }

    private static MoserObject removeQuerySubjectFromMDTVFolder(String qsId, FolderType folder, boolean bClean) {
        if (folder == null) {
            return null;
        }
        List itemList = MoserObjectUtils.getList((List)folder.basicGetFolderItem());
        for (int j = itemList.size() - 1; j >= 0; --j) {
            FolderItemType r;
            if (qsId.equals(((FolderItemType)itemList.get(j)).getRef())) {
                r = (FolderItemType)itemList.get(j);
                if (bClean) {
                    folder.removeFolderItemAt(j);
                    continue;
                }
                return r;
            }
            r = ModuleUtils.removeQuerySubjectFromMDTVFolder(qsId, ((FolderItemType)itemList.get(j)).getFolder(), bClean);
            if (r == null || bClean) continue;
            return r;
        }
        return null;
    }

    public static List<Relationship> suggestRelationships(Module srcModule, String srcModuleId, List<QuerySubject> qsList, Module dstModule) {
        String ref;
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        HashSet<String> qsIds = new HashSet<String>();
        for (QuerySubject qs : qsList) {
            qsIds.add(qs.getIdentifier());
        }
        HashSet<Object> qsRefs = new HashSet<Object>();
        List dstQSList = MoserObjectUtils.getList((List)dstModule.basicGetQuerySubject());
        for (QuerySubject qs : dstQSList) {
            Object ref22;
            String prefix = srcModuleId + ".";
            List qsRefList = MoserObjectUtils.getList((List)qs.basicGetRef());
            for (Object ref22 : qsRefList) {
                if (((String)ref22).indexOf(prefix) != 0) continue;
                qsRefs.add(ref22);
            }
            List qsOrgRefList = MoserObjectUtils.getList((List)qs.basicGetOriginalRef());
            ref22 = qsOrgRefList.iterator();
            while (ref22.hasNext()) {
                ref = (String)ref22.next();
                if (ref.indexOf(prefix) != 0) continue;
                qsRefs.add(ref);
            }
        }
        List srcRelList = MoserObjectUtils.getList((List)srcModule.basicGetRelationship());
        block4: for (Relationship rel : srcRelList) {
            String otherQSId;
            if (qsIds.contains(rel.getLeft().getRef())) {
                otherQSId = rel.getRight().getRef();
            } else {
                if (!qsIds.contains(rel.getRight().getRef())) continue;
                otherQSId = rel.getLeft().getRef();
            }
            if (qsIds.contains(otherQSId)) {
                result.add(rel);
                continue;
            }
            String otherRef = srcModuleId + "." + otherQSId;
            if (qsRefs.contains(otherRef)) {
                result.add(rel);
                continue;
            }
            QuerySubject qs = ModuleUtils.getQuerySubjectById(otherQSId, srcModule);
            if (qs == null || (ref = (String)qs.getRef().get(0)) == null || ref.isEmpty()) continue;
            Module.UseSpec useSpec = DataModuleExtractor.getUseSpecByRef((Module)srcModule, (String)ref, (boolean)true);
            String storeId = null;
            if (useSpec != null) {
                storeId = useSpec.getStoreID();
            }
            if (storeId == null) continue;
            List dstModuleUSpecs = MoserObjectUtils.getList((List)dstModule.basicGetUseSpec());
            for (Module.UseSpec us : dstModuleUSpecs) {
                String id = us.getIdentifier();
                if (!us.getStoreID().equals(storeId) || id.indexOf("__Base") == 0) continue;
                String dstRef = us.getIdentifier() + "." + ReferenceResolver.getSecondPart((String)ref);
                QuerySubject qsDst = ModuleUtils.findQuerySubjectByRef(dstModule, dstRef);
                if (qsDst == null) continue block4;
                result.add(rel);
                continue block4;
            }
        }
        return result;
    }

    public static QuerySubject getQuerySubjectById(String id, Module module) {
        QuerySubject querySubject = null;
        List qsList = MoserObjectUtils.getList((List)module.basicGetQuerySubject());
        for (QuerySubject qs : qsList) {
            if (!qs.getIdentifier().equals(id)) continue;
            querySubject = qs;
            break;
        }
        return querySubject;
    }

    public static Calculation getCalculationById(String id, Module module) {
        Calculation calculation = null;
        List calculations = MoserObjectUtils.getList((List)module.basicGetCalculation());
        for (Calculation calc : calculations) {
            if (!calc.getIdentifier().equals(id)) continue;
            calculation = calc;
            break;
        }
        return calculation;
    }

    public static BaseQueryItemType getQueryItemById(String qualifiedID, Module module) {
        BaseQueryItemType queryItem = null;
        String qsId = ReferenceResolver.getFirstPart((String)qualifiedID);
        if (qsId != null && qsId.length() > 0) {
            QuerySubject qs = ModuleUtils.getQuerySubjectById(qsId, module);
            String qiId = ReferenceResolver.getSecondPart((String)qualifiedID);
            if (qs != null && qiId != null && qiId.length() > 0) {
                queryItem = QuerySubjectUtils.getQueryItemById(qiId, qs);
            }
        }
        return queryItem;
    }

    public static Filter getFilterById(String id, Module module) {
        Filter filter = null;
        List filterList = MoserObjectUtils.getList((List)module.basicGetFilter());
        for (Filter fltr : filterList) {
            if (!fltr.getIdentifier().equals(id)) continue;
            filter = fltr;
            break;
        }
        return filter;
    }

    public static MoserObject getMoserObjectByIdForExpression(String idForExprn, Module module) {
        String alias;
        MoserObject obj = ReferenceResolver.getMoserObjectByIdForExpression((String)idForExprn, (Module)module);
        if (obj == null && (alias = ReferenceResolver.strBetween((String)idForExprn, (String)"[", (String)"].")) != null) {
            for (Module.UseSpec useSpec : module.getUseSpec()) {
                if (!alias.equals(useSpec.getIdentifier())) continue;
                String newID = alias + "." + ReferenceResolver.strAfter((String)idForExprn, (String)"].");
                return ReferenceResolver.getMoserObjectByIdForExpression((String)newID, (Module)module);
            }
        }
        return obj;
    }

    private static Module getModule(MoserObject o) {
        for (MoserObject obj = o.getParent(); obj != null; obj = obj.getParent()) {
            if (!"Module".equals(obj.getObjectType())) continue;
            return (Module)obj;
        }
        return null;
    }

    public static Module.UseSpec getObjectUseSpec(ObjectType obj, Module m) {
        Module module = m;
        if (module == null && (module = ModuleUtils.getModule((MoserObject)obj)) == null) {
            throw new IllegalArgumentException("Can't find the module!");
        }
        return DataModuleExtractor.getUseSpec((ObjectType)obj, (Module)module, (boolean)false);
    }

    public static List<ObjectType> getUseSpecRefs(Module.UseSpec useSpec, Module m) {
        Module module = m;
        if (module == null && (module = ModuleUtils.getModule((MoserObject)useSpec)) == null) {
            throw new IllegalArgumentException("Can't find the module!");
        }
        return DataModuleExtractor.getUseSpecRefs((Module.UseSpec)useSpec, (Module)module);
    }

    public static List<Module.UseSpec.Ancestors> createAncestors(JSONArray ancestorsResp, String myFoldersLabel, String teamContentLabel) {
        return MoserCommonUtils.createAncestors((JSONArray)ancestorsResp, (String)myFoldersLabel, (String)teamContentLabel);
    }

    public static List<MoserObject> createMembers(ObjectFactory factory, MoserObject parent, JSONObject membersResponse) {
        if (factory == null || parent == null || membersResponse == null) {
            return null;
        }
        JSONArray dataItems = (JSONArray)membersResponse.get((Object)"dataItems");
        if (dataItems == null || dataItems.isEmpty()) {
            return null;
        }
        if (!(parent instanceof QueryItem) && !(parent instanceof MemberType)) {
            return null;
        }
        JSONArray items = (JSONArray)((JSONObject)dataItems.get(0)).get((Object)"items");
        if (items == null) {
            return null;
        }
        ArrayList<MoserObject> members = new ArrayList<MoserObject>();
        for (Object item : items) {
            MemberType member = ModuleUtils.addMember(factory, ModuleUtils.getData((JSONObject)item), parent);
            if (member == null) continue;
            members.add((MoserObject)member);
            ModuleUtils.setMemberHidden(member, false);
        }
        return members;
    }

    private static JSONObject getData(JSONObject item) {
        JSONArray t = (JSONArray)item.get((Object)"t");
        if (t == null || t.size() != 1) {
            return null;
        }
        return (JSONObject)t.get(0);
    }

    private static MemberType addMember(ObjectFactory factory, JSONObject data, MoserObject parent) {
        if (data == null || parent == null) {
            return null;
        }
        String mun = (String)data.get((Object)"u");
        MemberType member = ModuleUtils.getMember(parent, mun);
        if (member != null) {
            if (parent instanceof QueryItem) {
                ((QueryItem)parent).removeMembers(member);
                ((QueryItem)parent).addMembers(member);
            } else {
                ((MemberType)parent).removeMembers(member);
                ((MemberType)parent).addMembers(member);
            }
            return member;
        }
        member = factory.createMemberType();
        ModuleUtils.setMemberHidden(member, true);
        member.setIdentifier(mun);
        member.setIdForExpression(mun);
        member.setLabel((String)data.get((Object)"d"));
        member.setMemberCaption((String)data.get((Object)"d"));
        JSONObject jparent = (JSONObject)data.get((Object)"p");
        if (jparent != null) {
            member.setParentUniqueName((String)jparent.get((Object)"u"));
        }
        member.setDimensionUniqueName((String)data.get((Object)"du"));
        member.setLevelNumber((Long)data.get((Object)"ln"));
        member.setLevelLabel((String)data.get((Object)"ll"));
        member.setLevelUniqueName((String)data.get((Object)"lu"));
        member.setHierarchyUniqueName((String)data.get((Object)"hu"));
        member.setParentLevel((Long)data.get((Object)"pn"));
        if (parent instanceof QueryItem) {
            ((QueryItem)parent).addMembers(member);
        } else {
            ((MemberType)parent).addMembers(member);
        }
        return member;
    }

    private static MemberType getMember(MoserObject parent, String mun) {
        if (mun == null) {
            return null;
        }
        List members = null;
        members = parent instanceof QueryItem ? ((QueryItem)parent).basicGetMembers() : ((MemberType)parent).basicGetMembers();
        if (members == null || members.isEmpty()) {
            return null;
        }
        for (MemberType member : members) {
            if (!mun.equals(member.getIdForExpression())) continue;
            return member;
        }
        return null;
    }

    public static List<MoserObject> createMembersForSearch(ObjectFactory factory, Module module, JSONObject membersResponse) {
        if (factory == null || module == null || membersResponse == null) {
            return null;
        }
        JSONArray dataItems = (JSONArray)membersResponse.get((Object)"dataItems");
        if (dataItems == null || dataItems.size() != 1) {
            return null;
        }
        JSONArray items = (JSONArray)((JSONObject)dataItems.get(0)).get((Object)"items");
        if (items == null || items.isEmpty()) {
            return null;
        }
        ArrayList<MoserObject> members = new ArrayList<MoserObject>();
        for (Object item : items) {
            MemberType member;
            JSONObject data = ModuleUtils.getData((JSONObject)item);
            MoserObject parent = ModuleUtils.getMemberParent(module, data);
            if (parent == null || (member = ModuleUtils.addMember(factory, data, parent)) == null) continue;
            members.add((MoserObject)member);
            member.setParent(parent);
        }
        return members;
    }

    private static MoserObject getMemberParent(Module module, JSONObject item) {
        if (module == null || item == null) {
            return null;
        }
        String mun = (String)item.get((Object)"u");
        if (mun == null) {
            return null;
        }
        String itemId = ModuleUtils.extractItemID(mun);
        return ReferenceResolver.bindMoserObject((Module)module, (String)itemId);
    }

    private static String extractItemID(String startAtPath) {
        String itemId = startAtPath;
        int idx = startAtPath.indexOf("->");
        if (idx != -1) {
            itemId = startAtPath.substring(0, idx);
        }
        return itemId;
    }

    public static long taskPercentage(JSONObject taskStatus) {
        String state = (String)taskStatus.get((Object)"state");
        if ("SUCCESS".equals(state) || "CANCELLED".equals(state) || "ERROR".equals(state) || "NOT_AVAILABLE".equals(state)) {
            return 100L;
        }
        if ("PENDING".equals(state)) {
            return 0L;
        }
        return ModuleUtils.taskStepPercentage((JSONObject)taskStatus.get((Object)"taskStep"));
    }

    private static long taskStepPercentage(JSONObject taskStep) {
        long numTotalSteps = (Long)taskStep.get((Object)"numTotalSteps");
        long numCompleted = taskStep.containsKey((Object)"numCompleted") ? (Long)taskStep.get((Object)"numCompleted") : 0L;
        long currentStepNum = (Long)taskStep.get((Object)"currentStepNum");
        double percentagePerStep = 100.0 / (double)numTotalSteps;
        long stepNum = currentStepNum < 1L ? 1L : currentStepNum;
        double percentageCompleted = percentagePerStep * (double)((stepNum += numCompleted) - 1L);
        JSONObject currentSubTask = (JSONObject)taskStep.get((Object)"currentSubTask");
        if (currentSubTask != null) {
            percentageCompleted += percentagePerStep * (double)ModuleUtils.taskStepPercentage(currentSubTask) / 100.0;
        }
        return percentageCompleted > 100.0 ? 100L : (percentageCompleted < 0.0 ? 0L : Math.round(percentageCompleted));
    }

    public static ObjectType findObjectTypeByIdForExpression(Module module, String idForExprn) {
        if (idForExprn == null || idForExprn.isEmpty()) {
            return null;
        }
        String[] parts = idForExprn.split("\\.");
        if (parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            QuerySubject qs = ModuleUtils.getQuerySubjectById(parts[0], module);
            if (qs != null) {
                return qs;
            }
            Calculation calc = ModuleUtils.getCalculationById(parts[0], module);
            if (calc != null) {
                return calc;
            }
            return ModuleUtils.getFilterById(parts[0], module);
        }
        QuerySubject qs = ModuleUtils.getQuerySubjectById(parts[0], module);
        if (qs == null) {
            return null;
        }
        List items = qs.basicGetItem();
        ObjectType rt = null;
        for (int currentPos = 1; currentPos < parts.length && (rt = ModuleUtils.findObjectTypeByIdInItems(items, parts[currentPos])) != null; ++currentPos) {
            items = rt.getObjectType() == "QueryItem" ? ((QueryItem)rt).basicGetItem() : null;
        }
        return rt;
    }

    private static ObjectType findObjectTypeByIdInItems(List<ItemType> items, String id) {
        if (items == null) {
            return null;
        }
        for (ItemType itm : items) {
            ObjectType rt;
            QueryItem qi = itm.getQueryItem();
            if (qi != null) {
                if (!id.equals(qi.getIdentifier())) continue;
                return qi;
            }
            Filter flt = itm.getFilter();
            if (flt != null) {
                if (!id.equals(flt.getIdentifier())) continue;
                return flt;
            }
            ItemType.Folder folder = itm.getFolder();
            if (folder == null || (rt = ModuleUtils.findObjectTypeByIdInItems(folder.basicGetItem(), id)) == null) continue;
            return rt;
        }
        return null;
    }

    public static boolean areCompatibleDataTypes(String lDataType, String rDataType) {
        return MoserCommonUtils.areCompatibleDataTypes((String)lDataType, (String)rDataType);
    }

    public static Integer getPrecision(String dataType) {
        return MoserCommonUtils.getPrecision((String)dataType);
    }

    public static Integer getScale(String dataType) {
        return MoserCommonUtils.getScale((String)dataType);
    }

    protected static boolean checkValidContainer(MoserObject obj, MoserObject parentObj, boolean bEmbeddedFilter) {
        if (obj == null || parentObj == null) {
            return false;
        }
        String objTp = obj.getObjectType();
        HashSet<String> allowed = new HashSet<String>();
        HashSet<String> skipped = new HashSet<String>();
        if ("QuerySubject".equals(objTp)) {
            allowed.add("Module");
            allowed.add("FolderType");
            skipped.add("FolderItemType");
            return ModuleUtils.checkContainer(parentObj, allowed, skipped);
        }
        if ("FolderType".equals(objTp)) {
            allowed.add("Module");
            allowed.add("FolderType");
            skipped.add("FolderItemType");
            return ModuleUtils.checkContainer(parentObj, allowed, skipped);
        }
        if ("QueryItem".equals(objTp)) {
            allowed.add("QuerySubject");
            allowed.add("QueryItem");
            skipped.add("Folder");
            skipped.add("ItemType");
            return ModuleUtils.checkContainer(parentObj, allowed, skipped);
        }
        if ("NamedSet".equals(objTp)) {
            allowed.add("QuerySubject");
            skipped.add("Folder");
            skipped.add("ItemType");
            return ModuleUtils.checkContainer(parentObj, allowed, skipped);
        }
        if ("Filter".equals(objTp)) {
            if (bEmbeddedFilter) {
                allowed.add("QuerySubject");
                return ModuleUtils.checkContainer(parentObj, allowed, skipped);
            }
            QuerySubject qs = ModuleUtils.getParentQuerySubject(parentObj);
            if (qs != null) {
                allowed.add("QuerySubject");
                allowed.add("QueryItem");
                skipped.add("Folder");
                skipped.add("ItemType");
                return ModuleUtils.checkContainer(parentObj, allowed, skipped);
            }
            allowed.add("Module");
            allowed.add("FolderType");
            skipped.add("FolderItemType");
            return ModuleUtils.checkContainer(parentObj, allowed, skipped);
        }
        if ("Folder".equals(objTp)) {
            allowed.add("QuerySubject");
            allowed.add("QueryItem");
            allowed.add("Folder");
            allowed.add("Calculation");
            skipped.add("ItemType");
            return ModuleUtils.checkContainer(parentObj, allowed, skipped);
        }
        if ("Calculation".equals(objTp)) {
            allowed.add("Module");
            allowed.add("FolderType");
            allowed.add("Calculation");
            skipped.add("Folder");
            skipped.add("ItemType");
            skipped.add("FolderItemType");
            return ModuleUtils.checkContainer(parentObj, allowed, skipped);
        }
        if ("SecurityFilter".equals(objTp)) {
            allowed.add("QuerySubject");
            return ModuleUtils.checkContainer(parentObj, allowed, skipped);
        }
        return false;
    }

    protected static boolean checkContainer(MoserObject parentObj, HashSet<String> allowed, HashSet<String> skipped) {
        for (MoserObject parent = parentObj; parent != null; parent = parent.getParent()) {
            String parentTp = parent.getObjectType();
            if (allowed.contains(parentTp)) {
                return true;
            }
            if (skipped.contains(parentTp)) continue;
            return false;
        }
        return false;
    }

    public static boolean add(MoserObject obj, MoserObject parentObj, int index, ObjectFactory objectFactory, boolean bEmbeddedFilter) {
        if (!ModuleUtils.checkValidContainer(obj, parentObj, bEmbeddedFilter)) {
            return false;
        }
        String objTp = obj.getObjectType();
        if ("QueryItem".equals(objTp) || "SecurityFilter".equals(objTp) || "NamedSet".equals(objTp)) {
            return ModuleUtils.addObjectToQuerySubject(obj, parentObj, index, objectFactory, false);
        }
        if ("Folder".equals(objTp)) {
            QuerySubject qs = ModuleUtils.getParentQuerySubject(parentObj);
            if (qs != null) {
                return ModuleUtils.addObjectToQuerySubject(obj, parentObj, index, objectFactory, false);
            }
            return ModuleUtils.addObjectToCalculation(obj, parentObj, index, objectFactory);
        }
        if ("Filter".equals(objTp)) {
            QuerySubject qs = ModuleUtils.getParentQuerySubject(parentObj);
            if (qs != null) {
                return ModuleUtils.addObjectToQuerySubject(obj, parentObj, index, objectFactory, bEmbeddedFilter);
            }
            return ModuleUtils.addObjectToModule(obj, parentObj, index, objectFactory);
        }
        if ("QuerySubject".equals(objTp)) {
            return ModuleUtils.addObjectToModule(obj, parentObj, index, objectFactory);
        }
        if ("Calculation".equals(objTp)) {
            Calculation c = ModuleUtils.getParentCalculation(parentObj);
            if (c != null) {
                Module module = MoserObject.getModuleObject((MoserObject)c);
                if (module == null) {
                    return false;
                }
                ModuleUtils.setIdentifierInModuleScope(obj, module);
                return ModuleUtils.addObjectToCalculation(obj, parentObj, index, objectFactory);
            }
            return ModuleUtils.addObjectToModule(obj, parentObj, index, objectFactory);
        }
        if ("FolderType".equals(objTp)) {
            return ModuleUtils.addFolderTypeToMDTV((FolderType)obj, parentObj, index, objectFactory);
        }
        return false;
    }

    protected static Calculation getParentCalculation(MoserObject parentObj) {
        for (MoserObject obj = parentObj; obj != null; obj = obj.getParent()) {
            String tp = obj.getObjectType();
            if ("Calculation".equals(tp)) {
                return (Calculation)obj;
            }
            if (!"Module".equals(tp)) continue;
            return null;
        }
        return null;
    }

    protected static QuerySubject getParentQuerySubject(MoserObject parentObj) {
        String parentTp = parentObj.getObjectType();
        if ("QuerySubject".equals(parentTp)) {
            return (QuerySubject)parentObj;
        }
        return PropertySetter.getParentQuerySubject((MoserObject)parentObj);
    }

    protected static boolean invalidIndex(List<?> list, int index) {
        return list == null || index < 0 || index >= list.size();
    }

    protected static void addItemToParent(ItemType item, MoserObject parentObj, int index) {
        String parentTp = parentObj.getObjectType();
        if ("QuerySubject".equals(parentTp)) {
            if (ModuleUtils.invalidIndex(((QuerySubject)parentObj).basicGetItem(), index)) {
                ((QuerySubject)parentObj).addItem(item);
            } else {
                ((QuerySubject)parentObj).addItemAt(index, item);
            }
            return;
        }
        if ("QueryItem".equals(parentTp)) {
            if (ModuleUtils.invalidIndex(((QueryItem)parentObj).basicGetItem(), index)) {
                ((QueryItem)parentObj).addItem(item);
            } else {
                ((QueryItem)parentObj).addItemAt(index, item);
            }
            return;
        }
        if ("Folder".equals(parentTp)) {
            if (ModuleUtils.invalidIndex(((ItemType.Folder)parentObj).basicGetItem(), index)) {
                ((ItemType.Folder)parentObj).addItem(item);
            } else {
                ((ItemType.Folder)parentObj).addItemAt(index, item);
            }
            return;
        }
        if ("Calculation".equals(parentTp)) {
            if (ModuleUtils.invalidIndex(((Calculation)parentObj).basicGetItem(), index)) {
                ((Calculation)parentObj).addItem(item);
            } else {
                ((Calculation)parentObj).addItemAt(index, item);
            }
            return;
        }
    }

    protected static void getIdChain(List<String> idChain, MoserObject parentObj, MoserObject anchor) {
        for (MoserObject parent = parentObj; parent != null; parent = parent.getParent()) {
            String objType = parent.getObjectType();
            if ("QuerySubject".equals(objType) || "QueryItem".equals(objType)) {
                idChain.add(((ObjectType)parent).getIdentifier());
            }
            if (parent.equals(anchor)) break;
        }
    }

    protected static boolean addObjectToQuerySubject(MoserObject obj, MoserObject parentObj, int index, ObjectFactory objectFactory, boolean bEmbeddedFilter) {
        ItemType item;
        QuerySubject qs = ModuleUtils.getParentQuerySubject(parentObj);
        if (qs == null) {
            return false;
        }
        String tp = obj.getObjectType();
        if (!"Folder".equals(tp)) {
            String id;
            String label = ((ObjectType)obj).getLabel();
            if (label == null || label.isEmpty()) {
                label = "new" + tp;
            }
            if ((id = ((ObjectType)obj).getIdentifier()) == null || id.isEmpty()) {
                id = IdGenerator.makeIdentifier(parentObj, label);
                ((ObjectType)obj).setIdentifier(id);
                ArrayList<String> idChain = new ArrayList<String>();
                ModuleUtils.getIdChain(idChain, parentObj, (MoserObject)qs);
                String idforexpr = "";
                for (int i = idChain.size() - 1; i >= 0; --i) {
                    idforexpr = idforexpr + (String)idChain.get(i) + ".";
                }
                idforexpr = idforexpr + id;
                ((ObjectType)obj).setIdForExpression(idforexpr);
            }
        }
        if ("QueryItem".equals(tp)) {
            ((QueryItem)obj).setHighlevelDatatype(MoserCommonUtils.generateHighlevelDatatype((String)((QueryItem)obj).getDatatype()));
            item = objectFactory.createItemType();
            item.setQueryItem((QueryItem)obj);
            ModuleUtils.addItemToParent(item, parentObj, index);
            PropertySetter.addQueryItemToItemNormalization((QuerySubject)qs, (QueryItem)((QueryItem)obj), (ObjectFactory)objectFactory);
            return true;
        }
        if ("NamedSet".equals(tp)) {
            item = objectFactory.createItemType();
            item.setNamedSet((NamedSet)obj);
            ModuleUtils.addItemToParent(item, parentObj, index);
            return true;
        }
        if ("Folder".equals(tp)) {
            item = objectFactory.createItemType();
            item.setFolder((ItemType.Folder)obj);
            ModuleUtils.addItemToParent(item, parentObj, index);
            return true;
        }
        if ("Filter".equals(tp)) {
            if (bEmbeddedFilter) {
                if (ModuleUtils.invalidIndex(((QuerySubject)parentObj).basicGetFilter(), index)) {
                    ((QuerySubject)parentObj).addFilter((Filter)obj);
                } else {
                    ((QuerySubject)parentObj).addFilterAt(index, (Filter)obj);
                }
            } else {
                item = objectFactory.createItemType();
                item.setFilter((Filter)obj);
                ModuleUtils.addItemToParent(item, parentObj, index);
            }
            return true;
        }
        if (ModuleUtils.invalidIndex(((QuerySubject)parentObj).basicGetSecurityFilter(), index)) {
            ((QuerySubject)parentObj).addSecurityFilter((SecurityFilter)obj);
        } else {
            ((QuerySubject)parentObj).addSecurityFilterAt(index, (SecurityFilter)obj);
        }
        return true;
    }

    protected static boolean addObjectToCalculation(MoserObject obj, MoserObject parentObj, int index, ObjectFactory objectFactory) {
        String tp = obj.getObjectType();
        if ("Calculation".equals(tp)) {
            ItemType item = objectFactory.createItemType();
            item.setCalculation((Calculation)obj);
            ModuleUtils.addItemToParent(item, parentObj, index);
            return true;
        }
        if ("Folder".equals(tp)) {
            ItemType item = objectFactory.createItemType();
            item.setFolder((ItemType.Folder)obj);
            ModuleUtils.addItemToParent(item, parentObj, index);
            return true;
        }
        return false;
    }

    protected static FolderType getParentFolderType(MoserObject parentObj) {
        for (MoserObject parent = parentObj; parent != null; parent = parent.getParent()) {
            String parentTp = parent.getObjectType();
            if ("FolderType".equals(parentTp)) {
                return (FolderType)parent;
            }
            if (!"Module".equals(parentTp)) continue;
            Module module = (Module)parent;
            List mdtv = module.basicGetMetadataTreeView();
            if (mdtv != null && !mdtv.isEmpty()) {
                return (FolderType)mdtv.get(0);
            }
            return null;
        }
        return null;
    }

    protected static boolean addFolderTypeToMDTV(FolderType obj, MoserObject parentObj, int index, ObjectFactory objectFactory) {
        FolderType parentFolderType = ModuleUtils.getParentFolderType(parentObj);
        if (parentFolderType == null) {
            return false;
        }
        FolderItemType folderItem = objectFactory.createFolderItemType();
        folderItem.setFolder(obj);
        if (ModuleUtils.invalidIndex(parentFolderType.basicGetFolderItem(), index)) {
            parentFolderType.addFolderItem(folderItem);
        } else {
            parentFolderType.addFolderItemAt(index, folderItem);
        }
        return true;
    }

    protected static String setIdentifierInModuleScope(MoserObject obj, Module module) {
        String id;
        String label = ((ObjectType)obj).getLabel();
        if (label == null || label.isEmpty()) {
            label = "new" + obj.getObjectType();
        }
        if ((id = ((ObjectType)obj).getIdentifier()) == null || id.isEmpty()) {
            id = IdGenerator.makeIdentifier((MoserObject)module, label);
            ((ObjectType)obj).setIdentifier(id);
            ((ObjectType)obj).setIdForExpression(id);
        }
        return id;
    }

    protected static boolean addObjectToModule(MoserObject obj, MoserObject parentObj, int index, ObjectFactory objectFactory) {
        FolderType parentFolderType = ModuleUtils.getParentFolderType(parentObj);
        if (parentFolderType == null) {
            return false;
        }
        Module module = MoserObject.getModuleObject((MoserObject)parentFolderType);
        if (module == null) {
            return false;
        }
        String id = ModuleUtils.setIdentifierInModuleScope(obj, module);
        String tp = obj.getObjectType();
        FolderItemType folderItem = objectFactory.createFolderItemType();
        folderItem.setRef(id);
        folderItem.setReferencedObject(obj);
        if (ModuleUtils.invalidIndex(parentFolderType.basicGetFolderItem(), index)) {
            parentFolderType.addFolderItem(folderItem);
        } else {
            parentFolderType.addFolderItemAt(index, folderItem);
        }
        if ("QuerySubject".equals(tp)) {
            module.addQuerySubject((QuerySubject)obj);
        } else if ("Calculation".equals(tp)) {
            module.addCalculation((Calculation)obj);
        } else {
            module.addFilter((Filter)obj);
        }
        return true;
    }

    public static MoserObject remove(MoserObject obj) {
        return ModuleUtils.removeImp(obj, true);
    }

    protected static MoserObject removeImp(MoserObject obj, boolean bClean) {
        if (obj == null) {
            return null;
        }
        String objTp = obj.getObjectType();
        if ("QueryItem".equals(objTp) || "SecurityFilter".equals(objTp) || "Folder".equals(objTp)) {
            return ModuleUtils.removeObjectFromQuerySubject(obj, bClean);
        }
        if ("Filter".equals(objTp)) {
            QuerySubject qs = ModuleUtils.getParentQuerySubject(obj);
            if (qs != null) {
                return ModuleUtils.removeObjectFromQuerySubject(obj, bClean);
            }
            return ModuleUtils.removeObjectFromModule(obj, bClean);
        }
        if ("Calculation".equals(objTp) || "QuerySubject".equals(objTp)) {
            return ModuleUtils.removeObjectFromModule(obj, bClean);
        }
        if ("FolderType".equals(objTp)) {
            return ModuleUtils.removeFolderTypeFromMDTV((FolderType)obj, bClean);
        }
        return null;
    }

    protected static MoserObject removeObjectFromQuerySubject(MoserObject obj, boolean bClean) {
        String objTp = obj.getObjectType();
        if ("Folder".equals(objTp) || "QueryItem".equals(objTp)) {
            return ModuleUtils.removeParentItem(obj, bClean);
        }
        if ("SecurityFilter".equals(objTp)) {
            String parentTp = ModuleUtils.getParentObjectType(obj);
            if ("QuerySubject".equals(parentTp)) {
                QuerySubject qs = (QuerySubject)obj.getParent();
                if (bClean) {
                    qs.removeSecurityFilter((SecurityFilter)obj);
                }
                return obj;
            }
            return null;
        }
        if ("Filter".equals(objTp)) {
            String parentTp = ModuleUtils.getParentObjectType(obj);
            if ("QuerySubject".equals(parentTp)) {
                QuerySubject qs = (QuerySubject)obj.getParent();
                if (bClean) {
                    qs.removeFilter((Filter)obj);
                }
                return obj;
            }
            return ModuleUtils.removeParentItem(obj, bClean);
        }
        return null;
    }

    protected static String getParentObjectType(MoserObject obj) {
        MoserObject parent = obj.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getObjectType();
    }

    protected static MoserObject removeParentItem(MoserObject obj, boolean bclean) {
        String parentTp = ModuleUtils.getParentObjectType(obj);
        if (!"ItemType".equals(parentTp)) {
            return null;
        }
        ItemType item = (ItemType)obj.getParent();
        MoserObject parentParent = item.getParent();
        if (parentParent == null) {
            return null;
        }
        String parentParentTp = parentParent.getObjectType();
        ArrayList<String> qiIds = null;
        ArrayList<String> qiIdForExpressions = null;
        String qsId = null;
        Module module = null;
        QuerySubject qs = null;
        if (bclean) {
            qiIds = new ArrayList<String>();
            qiIdForExpressions = new ArrayList<String>();
            ModuleUtils.collectQIIdsInItem(item, qiIds, qiIdForExpressions);
            if (!qiIds.isEmpty() && (module = MoserObject.getModuleObject((MoserObject)(qs = ModuleUtils.getParentQuerySubject((MoserObject)item)))) != null && qs != null) {
                qsId = qs.getIdentifier();
            }
            if (qsId != null) {
                ModuleUtils.cleanSplitDefinition(module, obj);
            }
        }
        if ("QuerySubject".equals(parentParentTp)) {
            if (bclean) {
                ((QuerySubject)parentParent).removeItem(item);
            }
        } else if ("QueryItem".equals(parentParentTp)) {
            if (bclean) {
                ((QueryItem)parentParent).removeItem(item);
            }
        } else if ("Folder".equals(parentParentTp)) {
            if (bclean) {
                ((ItemType.Folder)parentParent).removeItem(item);
            }
        } else {
            return null;
        }
        if (qsId != null) {
            for (int i = 0; i < qiIds.size(); ++i) {
                String qiId = qiIds.get(i);
                PropertySetter.resetReferencedObject((Module)module, (String)qiId, (String)qiIdForExpressions.get(i), qsId);
                ModuleUtils.cleanItemNormalization(qs, qiId);
            }
        }
        if (bclean) {
            return obj;
        }
        return item;
    }

    protected static void cleanSplitDefinition(Module module, MoserObject obj) {
        if (obj == null) {
            return;
        }
        if (!"QueryItem".equals(obj.getObjectType())) {
            return;
        }
        List sp = ((QueryItem)obj).basicGetSplitDefinition();
        if (sp == null || sp.isEmpty() || PropertySetter.isEmptyRef((String)((SplitType)sp.get(0)).getRef())) {
            return;
        }
        String idForExpr = ((QueryItem)obj).getIdForExpression();
        List qss = module.basicGetQuerySubject();
        if (qss == null) {
            return;
        }
        for (QuerySubject aQS : qss) {
            for (QueryItem aQI : PropertySetter.getAllQueryItemsInQuerySubject((QuerySubject)aQS)) {
                List sp1;
                if (aQI.equals(obj) || (sp1 = aQI.basicGetSplitDefinition()) == null || sp1.isEmpty() || !idForExpr.equals(((SplitType)sp1.get(0)).getRef())) continue;
                ((SplitType)sp1.get(0)).setRef("None");
            }
        }
    }

    protected static void cleanItemNormalization(QuerySubject qs, String qiId) {
        ItemNormalizationType itemNorm = qs.getItemNormalization();
        if (itemNorm == null) {
            return;
        }
        List grps = itemNorm.basicGetItemNormalizationGroup();
        if (grps == null || grps.isEmpty()) {
            return;
        }
        ItemNormalizationGroupType grpToDelete = null;
        for (ItemNormalizationGroupType g : grps) {
            List attrs = g.basicGetAttribute();
            ItemNormalizationGroupType.Key k = g.getKey();
            if (attrs != null && !attrs.isEmpty()) {
                int sz = attrs.size();
                for (ItemNormalizationGroupType.Attribute a : attrs) {
                    if (!qiId.equals(a.getItemRef())) continue;
                    if (sz == 1 && k == null) {
                        grpToDelete = g;
                        break;
                    }
                    g.removeAttribute(a);
                    return;
                }
            }
            if (grpToDelete != null) break;
            if (k == null || !qiId.equals(k.getItemRef())) continue;
            grpToDelete = g;
            break;
        }
        if (grpToDelete != null) {
            String gpId = grpToDelete.getIdentifier();
            List paranetGrps = grpToDelete.basicGetParentGroupRef();
            itemNorm.removeItemNormalizationGroup(grpToDelete);
            for (ItemNormalizationGroupType otherGrp : grps) {
                List otherParanetGrps = otherGrp.basicGetParentGroupRef();
                if (otherParanetGrps == null || otherParanetGrps.isEmpty() || !otherParanetGrps.contains(gpId)) continue;
                otherGrp.removeParentGroupRef(gpId);
                if (paranetGrps == null) continue;
                for (String sg : paranetGrps) {
                    if (otherParanetGrps.contains(sg)) continue;
                    otherGrp.addParentGroupRef(sg);
                }
            }
        }
        if (grps.isEmpty()) {
            qs.setItemNormalization(null);
        }
    }

    protected static void collectQIIdsInItem(ItemType itm, ArrayList<String> qiIds, ArrayList<String> qiIdForExpressions) {
        QueryItem qi = itm.getQueryItem();
        if (qi != null) {
            String id = qi.getIdentifier();
            String qiIdForExpression = qi.getIdForExpression();
            if (id != null && qiIdForExpression != null) {
                qiIds.add(id);
                qiIdForExpressions.add(qiIdForExpression);
            }
        } else {
            ItemType.Folder fld = itm.getFolder();
            if (fld != null) {
                ModuleUtils.collectQIIdsInFolder(fld, qiIds, qiIdForExpressions);
            }
        }
    }

    private static void collectQIIdsInFolder(ItemType.Folder theFolder, ArrayList<String> qiIds, ArrayList<String> qiIdForExpressions) {
        List items = theFolder.basicGetItem();
        if (items == null || items.isEmpty()) {
            return;
        }
        for (ItemType itm : items) {
            ModuleUtils.collectQIIdsInItem(itm, qiIds, qiIdForExpressions);
        }
    }

    protected static boolean checkFolderType(FolderType obj) {
        MoserObject parent = obj.getParent();
        String parentTp = parent.getObjectType();
        if (!"Module".equals(parentTp) && !"FolderItemType".equals(parentTp)) {
            return false;
        }
        if ("Module".equals(parentTp)) {
            return true;
        }
        FolderItemType folderItem = (FolderItemType)parent;
        String parentParentTp = ModuleUtils.getParentObjectType((MoserObject)folderItem);
        return "FolderType".equals(parentParentTp);
    }

    protected static void collectIdsInFolderType(FolderType obj, List<String> ids) {
        if (obj == null) {
            return;
        }
        List folderItems = obj.basicGetFolderItem();
        if (folderItems == null) {
            return;
        }
        for (FolderItemType folderItem : folderItems) {
            String ref = folderItem.getRef();
            if (ref != null) {
                ids.add(ref);
            }
            ModuleUtils.collectIdsInFolderType(folderItem.getFolder(), ids);
        }
    }

    protected static void removeObjectsInMDTVFolderType(FolderType obj) {
        List filters;
        List calcs;
        Module module = MoserObject.getModuleObject((MoserObject)obj);
        if (module == null) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ModuleUtils.collectIdsInFolderType(obj, ids);
        if (ids.isEmpty()) {
            return;
        }
        HashMap<String, QuerySubject> idToQS = new HashMap<String, QuerySubject>();
        HashMap<String, Calculation> idToCalc = new HashMap<String, Calculation>();
        HashMap<String, Filter> idToFilter = new HashMap<String, Filter>();
        List qss = module.basicGetQuerySubject();
        if (qss != null) {
            for (QuerySubject qs : qss) {
                idToQS.put(qs.getIdentifier(), qs);
            }
        }
        if ((calcs = module.basicGetCalculation()) != null) {
            for (Calculation c : calcs) {
                idToCalc.put(c.getIdentifier(), c);
            }
        }
        if ((filters = module.basicGetFilter()) != null) {
            for (Filter f : filters) {
                idToFilter.put(f.getIdentifier(), f);
            }
        }
        HashSet<String> seen = new HashSet<String>();
        for (String id : ids) {
            if (seen.contains(id)) continue;
            seen.add(id);
            QuerySubject q = (QuerySubject)idToQS.get(id);
            if (q != null) {
                ModuleUtils.deleteQuerySubjectRelatedObjects(module, q, id);
                module.removeQuerySubject(q);
                continue;
            }
            Calculation c = (Calculation)idToCalc.get(id);
            if (c != null) {
                module.removeCalculation(c);
                continue;
            }
            Filter f = (Filter)idToFilter.get(id);
            if (f == null) continue;
            module.removeFilter(f);
        }
    }

    protected static MoserObject removeFolderTypeFromMDTV(FolderType obj, boolean bClean) {
        if (!ModuleUtils.checkFolderType(obj)) {
            return null;
        }
        MoserObject parent = obj.getParent();
        String parentTp = parent.getObjectType();
        if (!bClean) {
            if ("FolderItemType".equals(parentTp)) {
                return parent;
            }
            return null;
        }
        ModuleUtils.removeObjectsInMDTVFolderType(obj);
        if ("Module".equals(parentTp)) {
            ((Module)parent).removeMetadataTreeView(obj);
            return obj;
        }
        FolderItemType folderItem = (FolderItemType)parent;
        ((FolderType)folderItem.getParent()).removeFolderItem(folderItem);
        return obj;
    }

    protected static MoserObject removeObjectFromModule(MoserObject obj, boolean bClean) {
        Module module = MoserObject.getModuleObject((MoserObject)obj);
        if (module == null) {
            return null;
        }
        String objectTp = obj.getObjectType();
        if ("QuerySubject".equals(objectTp)) {
            return ModuleUtils.deleteQuerySubjectImp(module, (QuerySubject)obj, bClean);
        }
        List mdtvs = MoserObjectUtils.getList((List)module.basicGetMetadataTreeView());
        if ("Calculation".equals(objectTp)) {
            Calculation calc = (Calculation)obj;
            for (FolderType folder : mdtvs) {
                MoserObject r = ModuleUtils.removeQuerySubjectFromMDTVFolder(calc.getIdentifier(), folder, bClean);
                if (bClean || r == null) continue;
                return r;
            }
            module.removeCalculation(calc);
            return obj;
        }
        if ("Filter".equals(objectTp)) {
            Filter filter = (Filter)obj;
            for (FolderType folder : mdtvs) {
                MoserObject r = ModuleUtils.removeQuerySubjectFromMDTVFolder(filter.getIdentifier(), folder, bClean);
                if (bClean || r == null) continue;
                return r;
            }
            module.removeFilter(filter);
            return obj;
        }
        return null;
    }

    public static MoserObject move(MoserObject obj, MoserObject parentObj, int index) {
        MoserObject removed = ModuleUtils.removeImp(obj, false);
        if (removed == null) {
            return null;
        }
        MoserObject p1 = ModuleUtils.getParentContainer(parentObj);
        MoserObject p2 = ModuleUtils.getParentContainer(removed);
        if (p1 == null || p2 == null || !p1.equals(p2)) {
            return null;
        }
        MoserObject[] oldParentObj = new MoserObject[]{null};
        int oldIdx = ModuleUtils.detachFromParent(removed, oldParentObj);
        if (oldIdx == -1) {
            return null;
        }
        ModuleUtils.insertToParent(removed, parentObj, index, oldParentObj[0], oldIdx);
        return obj;
    }

    private static MoserObject getParentContainer(MoserObject obj) {
        if (obj == null) {
            return null;
        }
        String objType = obj.getObjectType();
        if ("QueryItem".equals(objType) || "QuerySubject".equals(objType) || "Module".equals(objType)) {
            return obj;
        }
        return ModuleUtils.getParentContainer(obj.getParent());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int detachFromParent(MoserObject removed, MoserObject[] oldParent) {
        int oldIdx;
        MoserObject parent = removed.getParent();
        String parentObjType = parent.getObjectType();
        String objType = removed.getObjectType();
        if ("QuerySubject".equals(parentObjType)) {
            QuerySubject qs = (QuerySubject)parent;
            if ("ItemType".equals(objType)) {
                oldIdx = qs.getItem().indexOf(removed);
                if (oldIdx >= 0) {
                    qs.removeItemAt(oldIdx);
                    oldParent[0] = qs;
                }
            } else if ("Filter".equals(objType)) {
                oldIdx = qs.getFilter().indexOf(removed);
                if (oldIdx >= 0) {
                    qs.removeFilterAt(oldIdx);
                    oldParent[0] = qs;
                }
            } else {
                if (!"SecurityFilter".equals(objType)) return -1;
                oldIdx = qs.getSecurityFilter().indexOf(removed);
                if (oldIdx >= 0) {
                    qs.removeSecurityFilterAt(oldIdx);
                    oldParent[0] = qs;
                }
            }
        } else if ("Folder".equals(parentObjType)) {
            if (!"ItemType".equals(objType)) return -1;
            oldIdx = ((ItemType.Folder)parent).getItem().indexOf(removed);
            if (oldIdx >= 0) {
                ((ItemType.Folder)parent).removeItemAt(oldIdx);
                oldParent[0] = parent;
            }
        } else if ("QueryItem".equals(parentObjType)) {
            if (!"ItemType".equals(objType)) return -1;
            oldIdx = ((QueryItem)parent).getItem().indexOf(removed);
            if (oldIdx >= 0) {
                ((QueryItem)parent).removeItemAt(oldIdx);
                oldParent[0] = parent;
            }
        } else {
            if (!"FolderType".equals(parentObjType)) return -1;
            if (!"FolderItemType".equals(objType)) return -1;
            oldIdx = ((FolderType)parent).getFolderItem().indexOf(removed);
            if (oldIdx >= 0) {
                ((FolderType)parent).removeFolderItemAt(oldIdx);
                oldParent[0] = parent;
            }
        }
        removed.setParent(null);
        return oldIdx;
    }

    private static int adjustIndex(int i, MoserObject parent, int oldIdx, MoserObject oldParent) {
        int index = i;
        if (oldParent != null && parent != null && parent.equals(oldParent) && index > oldIdx) {
            --index;
        }
        return index;
    }

    private static void insertToParent(MoserObject removed, MoserObject parentObj, int index, MoserObject oldParent, int oldIdx) {
        String objType = removed.getObjectType();
        if ("FolderItemType".equals(objType)) {
            FolderType parentFolderType = ModuleUtils.getParentFolderType(parentObj);
            if (parentFolderType == null) {
                return;
            }
            int idx = ModuleUtils.adjustIndex(index, (MoserObject)parentFolderType, oldIdx, oldParent);
            if (ModuleUtils.invalidIndex(parentFolderType.basicGetFolderItem(), idx)) {
                parentFolderType.addFolderItem((FolderItemType)removed);
            } else {
                parentFolderType.addFolderItemAt(idx, (FolderItemType)removed);
            }
        } else if ("ItemType".equals(objType)) {
            int idx = ModuleUtils.adjustIndex(index, parentObj, oldIdx, oldParent);
            ModuleUtils.addItemToParent((ItemType)removed, parentObj, idx);
        } else if ("Filter".equals(objType)) {
            int idx = ModuleUtils.adjustIndex(index, parentObj, oldIdx, oldParent);
            if (ModuleUtils.invalidIndex(((QuerySubject)parentObj).basicGetFilter(), idx)) {
                ((QuerySubject)parentObj).addFilter((Filter)removed);
            } else {
                ((QuerySubject)parentObj).addFilterAt(idx, (Filter)removed);
            }
        } else if ("SecurityFilter".equals(objType)) {
            int idx = ModuleUtils.adjustIndex(index, parentObj, oldIdx, oldParent);
            if (ModuleUtils.invalidIndex(((QuerySubject)parentObj).basicGetSecurityFilter(), idx)) {
                ((QuerySubject)parentObj).addSecurityFilter((SecurityFilter)removed);
            } else {
                ((QuerySubject)parentObj).addSecurityFilterAt(idx, (SecurityFilter)removed);
            }
        }
    }

    public static String getExtractIdentifiersSpec(ObjectType obj, String value) {
        return PropertySetter.getExtractIdentifiersSpec((ObjectType)obj, (String)value);
    }

    public static void setIdentifier(ObjectType obj, String value, JSONObject response) {
        JSONArray feedBack;
        HashMap<String, String> idforExprToNewExpr = null;
        if (response != null && (feedBack = (JSONArray)response.get((Object)"feedback")) != null && !feedBack.isEmpty()) {
            idforExprToNewExpr = new HashMap<String, String>();
            for (Object f : feedBack) {
                JSONObject jobj = (JSONObject)f;
                idforExprToNewExpr.put((String)jobj.get((Object)"idForExpression"), (String)jobj.get((Object)"expression"));
            }
        }
        PropertySetter.setIdentifier((ObjectType)obj, (String)value, idforExprToNewExpr);
    }

    public static boolean isVisible(ObjectType object, Module module) {
        boolean visible;
        boolean hidden = object.isHidden() == null ? false : object.isHidden();
        boolean bl = visible = !hidden;
        if (hidden) {
            return visible;
        }
        ObjectType parent = (ObjectType)ModuleUtils.getTreeAncestor((MoserObject)object, null, module);
        if (parent != null) {
            return visible && ModuleUtils.isVisible(parent, module);
        }
        return visible;
    }

    public static MoserObject getTreeAncestor(MoserObject obj, String[] anestorType, Module module) {
        String objTp = obj.getObjectType();
        if (!ModuleUtils.isMDTVObjectType(objTp, false)) {
            return null;
        }
        if (module == null) {
            module = MoserObject.getModuleObject((MoserObject)obj);
        }
        HashSet<String> ancestorSet = null;
        if (anestorType != null && anestorType.length > 0) {
            ancestorSet = new HashSet<String>();
            for (String element : anestorType) {
                ancestorSet.add(element);
            }
        }
        if ("QuerySubject".equals(objTp) || "Calculation".equals(objTp)) {
            FolderItemType folderItemType = ModuleUtils.getFolderItemType(module, ((ObjectType)obj).getIdentifier());
            if (folderItemType == null) {
                if ("Calculation".equals(objTp)) {
                    return obj.getParent() != null && obj.getParent().getParent() != null ? obj.getParent().getParent() : null;
                }
                return null;
            }
            return ModuleUtils.getTreeAncestorMDTV(module, folderItemType.getParent(), ancestorSet);
        }
        if ("FolderType".equals(objTp)) {
            return ModuleUtils.getTreeAncestorMDTV(module, obj.getParent(), ancestorSet);
        }
        if ("Filter".equals(objTp) || "NamedSet".equals(objTp)) {
            QuerySubject qs = ModuleUtils.getParentQuerySubject(obj);
            if (qs == null) {
                FolderItemType folderItemType = ModuleUtils.getFolderItemType(module, ((ObjectType)obj).getIdentifier());
                if (folderItemType == null) {
                    return null;
                }
                return ModuleUtils.getTreeAncestorMDTV(module, folderItemType.getParent(), ancestorSet);
            }
            return ModuleUtils.getTreeAncestorQuerySubject(module, obj.getParent(), ancestorSet);
        }
        return ModuleUtils.getTreeAncestorQuerySubject(module, obj.getParent(), ancestorSet);
    }

    private static boolean isMDTVObjectType(String objectType, boolean incModule) {
        if ("QueryItem".equals(objectType) || "Folder".equals(objectType) || "Filter".equals(objectType) || "QuerySubject".equals(objectType) || "Calculation".equals(objectType) || "FolderType".equals(objectType) || "NamedSet".equals(objectType) || "MemberType".equals(objectType)) {
            return true;
        }
        return incModule && "Module".equals(objectType);
    }

    private static MoserObject getTreeAncestorQuerySubject(Module module, MoserObject parentObj, HashSet<String> ancestorSet) {
        if (parentObj == null) {
            return null;
        }
        String objType = parentObj.getObjectType();
        if ("QuerySubject".equals(objType)) {
            if (ancestorSet == null || ancestorSet.contains(objType)) {
                return parentObj;
            }
            FolderItemType folderItemType = ModuleUtils.getFolderItemType(module, ((ObjectType)parentObj).getIdentifier());
            if (folderItemType == null) {
                return null;
            }
            return ModuleUtils.getTreeAncestorMDTV(module, folderItemType.getParent(), ancestorSet);
        }
        if (ModuleUtils.isMDTVObjectType(objType, false) && (ancestorSet == null || ancestorSet.contains(objType))) {
            return parentObj;
        }
        return ModuleUtils.getTreeAncestorQuerySubject(module, parentObj.getParent(), ancestorSet);
    }

    private static MoserObject getTreeAncestorMDTV(Module module, MoserObject parent, HashSet<String> ancestorSet) {
        if (parent == null) {
            return null;
        }
        String objType = parent.getObjectType();
        if (ModuleUtils.isMDTVObjectType(objType, true) && (ancestorSet == null || ancestorSet.contains(objType))) {
            if (parent.getParent() == module) {
                return module;
            }
            return parent;
        }
        return ModuleUtils.getTreeAncestorMDTV(module, parent.getParent(), ancestorSet);
    }

    private static FolderItemType getFolderItemType(Module module, String id) {
        if (module == null) {
            return null;
        }
        List mdtvs = MoserObjectUtils.getList((List)module.basicGetMetadataTreeView());
        for (FolderType folder : mdtvs) {
            FolderItemType r = ModuleUtils.getFolderItemTypeInMDTVFolder(id, folder);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static FolderItemType getFolderItemTypeInMDTVFolder(String id, FolderType folder) {
        if (folder == null) {
            return null;
        }
        List itemList = MoserObjectUtils.getList((List)folder.basicGetFolderItem());
        for (int j = itemList.size() - 1; j >= 0; --j) {
            FolderItemType r = (FolderItemType)itemList.get(j);
            if (id.equals(r.getRef()) || r.getDefLink() != null && id.equals(r.getDefLink().getRef())) {
                return r;
            }
            if ((r = ModuleUtils.getFolderItemTypeInMDTVFolder(id, r.getFolder())) == null) continue;
            return r;
        }
        return null;
    }

    public static MoserObject findTreeObjectByIdForExpression(String idForExpression, MoserObject treeObject, boolean forceMDTVSearch) {
        if (idForExpression == null || idForExpression.isEmpty() || treeObject == null) {
            return null;
        }
        if (!forceMDTVSearch) {
            return ModuleUtils.findObjectByIdforExprInObject(treeObject, idForExpression);
        }
        Module module = MoserObject.getModuleObject((MoserObject)treeObject);
        if (module == null) {
            return null;
        }
        List mdtvs = MoserObjectUtils.getList((List)module.basicGetMetadataTreeView());
        for (FolderType folder : mdtvs) {
            MoserObject r = ModuleUtils.findObjectByIdforExprInObject((MoserObject)folder, idForExpression);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static MoserObject findObjectByIdforExprInObject(MoserObject obj, String idForExpression) {
        if (obj == null) {
            return null;
        }
        String objType = obj.getObjectType();
        if ("FolderType".equals(objType)) {
            return ModuleUtils.findObjectByIdforExprInFolderType((FolderType)obj, idForExpression);
        }
        if ("FolderItemType".equals(objType)) {
            return ModuleUtils.findObjectByIdforExprInFolderItemType((FolderItemType)obj, idForExpression);
        }
        if ("QuerySubject".equals(objType)) {
            return ModuleUtils.findObjectByIdforExprInQuerySubject((QuerySubject)obj, idForExpression);
        }
        if ("ItemType".equals(objType)) {
            return ModuleUtils.findObjectByIdforExprInItemType((ItemType)obj, idForExpression);
        }
        if ("QueryItem".equals(objType)) {
            return ModuleUtils.findObjectByIdforExprInQueryItem((QueryItem)obj, idForExpression);
        }
        if ("Folder".equals(objType)) {
            return ModuleUtils.findObjectByIdforExprInFolder((ItemType.Folder)obj, idForExpression);
        }
        if ("Calculation".equals(objType) || "Filter".equals(objType) || "NamedSet".equals(objType)) {
            String idforexpr = ((ObjectType)obj).getIdForExpression();
            if (idForExpression.equals(idforexpr)) {
                return obj;
            }
            return null;
        }
        return null;
    }

    private static MoserObject findObjectByIdforExprInFolderType(FolderType obj, String idForExpression) {
        List items = MoserObjectUtils.getList((List)obj.basicGetFolderItem());
        for (FolderItemType itm : items) {
            MoserObject r = ModuleUtils.findObjectByIdforExprInObject((MoserObject)itm, idForExpression);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static MoserObject findObjectByIdforExprInFolderItemType(FolderItemType obj, String idForExpression) {
        String rf;
        FolderType folder = obj.getFolder();
        if (folder != null) {
            return ModuleUtils.findObjectByIdforExprInObject((MoserObject)folder, idForExpression);
        }
        String ref = obj.getRef();
        if (ref != null && !ref.isEmpty()) {
            return ModuleUtils.findObjectByIdforExprInObject(obj.getReferencedObject(), idForExpression);
        }
        DefLinkType dlink = obj.getDefLink();
        if (dlink != null && (rf = dlink.getRef()) != null && !rf.isEmpty()) {
            return ModuleUtils.findObjectByIdforExprInObject(dlink.getReferencedObject(), idForExpression);
        }
        return null;
    }

    private static MoserObject findObjectByIdforExprInQuerySubject(QuerySubject obj, String idForExpression) {
        String idforexpr = obj.getIdForExpression();
        if (idForExpression.equals(idforexpr)) {
            return obj;
        }
        List items = MoserObjectUtils.getList((List)obj.basicGetItem());
        for (ItemType itm : items) {
            MoserObject r = ModuleUtils.findObjectByIdforExprInObject((MoserObject)itm, idForExpression);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static MoserObject findObjectByIdforExprInItemType(ItemType obj, String idForExpression) {
        QueryItem queryItem = obj.getQueryItem();
        if (queryItem != null) {
            return ModuleUtils.findObjectByIdforExprInObject((MoserObject)queryItem, idForExpression);
        }
        NamedSet nameSet = obj.getNamedSet();
        if (nameSet != null) {
            return ModuleUtils.findObjectByIdforExprInObject((MoserObject)nameSet, idForExpression);
        }
        Filter filter = obj.getFilter();
        if (filter != null) {
            return ModuleUtils.findObjectByIdforExprInObject((MoserObject)filter, idForExpression);
        }
        ItemType.Folder folder = obj.getFolder();
        if (folder != null) {
            return ModuleUtils.findObjectByIdforExprInObject((MoserObject)folder, idForExpression);
        }
        return null;
    }

    private static MoserObject findObjectByIdforExprInFolder(ItemType.Folder obj, String idForExpression) {
        List items = MoserObjectUtils.getList((List)obj.basicGetItem());
        for (ItemType itm : items) {
            MoserObject r = ModuleUtils.findObjectByIdforExprInObject((MoserObject)itm, idForExpression);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static MoserObject findObjectByIdforExprInQueryItem(QueryItem obj, String idForExpression) {
        String idforexpr = obj.getIdForExpression();
        if (idForExpression.equals(idforexpr)) {
            return obj;
        }
        List items = MoserObjectUtils.getList((List)obj.basicGetItem());
        for (ItemType itm : items) {
            MoserObject r = ModuleUtils.findObjectByIdforExprInObject((MoserObject)itm, idForExpression);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public static List<MoserObject> getTreeChildren(MoserObject obj, int depth, String[] childrenType) {
        if (obj == null || depth < 0) {
            return null;
        }
        String objTp = obj.getObjectType();
        if (!ModuleUtils.isMDTVObjectType(objTp, true)) {
            return null;
        }
        HashSet<String> childrenSet = null;
        if (childrenType != null && childrenType.length > 0) {
            childrenSet = new HashSet<String>();
            for (String element : childrenType) {
                childrenSet.add(element);
            }
        }
        ArrayList<MoserObject> rt = new ArrayList<MoserObject>();
        if ("Module".equals(objTp)) {
            List mdtv = ((Module)obj).basicGetMetadataTreeView();
            if (mdtv == null) {
                return rt;
            }
            for (FolderType folder : mdtv) {
                ModuleUtils.getTreeChildrenObjects((MoserObject)folder, depth, 1, childrenSet, rt);
            }
            return rt;
        }
        ModuleUtils.getTreeChildrenObjects(obj, depth, 1, childrenSet, rt);
        return rt;
    }

    protected static void getTreeChildrenObjects(MoserObject parent, int depth, int d, HashSet<String> childrenSet, List<MoserObject> rt) {
        if (depth != 0 && d > depth) {
            return;
        }
        List<MoserObject> children = ModuleUtils.getVisibleChildren(parent);
        for (MoserObject c : children) {
            String cType = c.getObjectType();
            if (childrenSet == null || childrenSet.contains(cType)) {
                rt.add(c);
            }
            ModuleUtils.getTreeChildrenObjects(c, depth, d + 1, childrenSet, rt);
        }
    }

    protected static List<MoserObject> getVisibleChildren(MoserObject parent) {
        List members;
        ArrayList<MoserObject> children = new ArrayList<MoserObject>();
        String parentType = parent.getObjectType();
        if ("FolderType".equals(parentType)) {
            List itms = ((FolderType)parent).basicGetFolderItem();
            if (itms != null) {
                for (FolderItemType itm : itms) {
                    MoserObject refobj;
                    FolderType fldType = itm.getFolder();
                    if (fldType != null) {
                        children.add((MoserObject)fldType);
                        continue;
                    }
                    MoserObject o = itm.getReferencedObject();
                    if (o != null) {
                        children.add(o);
                        continue;
                    }
                    DefLinkType dlink = itm.getDefLink();
                    if (dlink == null || (refobj = dlink.getReferencedObject()) == null) continue;
                    children.add(refobj);
                }
            }
        } else if ("QueryItem".equals(parentType) || "Folder".equals(parentType) || "QuerySubject".equals(parentType)) {
            List items = null;
            List members2 = null;
            if ("QueryItem".equals(parentType)) {
                items = ((QueryItem)parent).basicGetItem();
                members2 = ((QueryItem)parent).basicGetMembers();
            } else {
                items = "Folder".equals(parentType) ? ((ItemType.Folder)parent).basicGetItem() : ((QuerySubject)parent).basicGetItem();
            }
            if (items != null) {
                for (ItemType item : items) {
                    QueryItem qi = item.getQueryItem();
                    if (qi != null) {
                        children.add((MoserObject)qi);
                        continue;
                    }
                    ItemType.Folder fld = item.getFolder();
                    if (fld != null) {
                        children.add((MoserObject)fld);
                        continue;
                    }
                    Filter flt = item.getFilter();
                    if (flt != null) {
                        children.add((MoserObject)flt);
                        continue;
                    }
                    NamedSet nmSet = item.getNamedSet();
                    if (nmSet == null) continue;
                    children.add((MoserObject)nmSet);
                }
            }
            if (members2 != null) {
                children.addAll(members2);
            }
        } else if ("MemberType".equals(parentType) && (members = ((MemberType)parent).basicGetMembers()) != null) {
            children.addAll(members);
        }
        return children;
    }

    public static Module copyModule(Module srcModule) throws CloneNotSupportedException {
        Module clonedModule = (Module)srcModule.clone();
        ModuleUtils.resetRefObject(clonedModule);
        ReferenceResolver.resolve((Module)clonedModule);
        return clonedModule;
    }

    protected static void resetRefObject(Module module) {
        if (module == null) {
            return;
        }
        boolean overrideMode = module.isOverrideMode();
        module.setOverrideMode(false);
        ModuleUtils.resetItemHierarchyLocalRef(module);
        List mdtv = module.basicGetMetadataTreeView();
        if (mdtv != null) {
            for (FolderType folderType : mdtv) {
                ModuleUtils.resetFolderTypeReferences(folderType);
            }
        }
        ModuleUtils.resetSegmentReferences(module);
        ModuleUtils.resetRelationships(module);
        ModuleUtils.resetFacetDef(module);
        module.setOverrideMode(overrideMode);
    }

    protected static void resetItemHierarchyLocalRef(Module module) {
        List querySubjectList = module.basicGetQuerySubject();
        if (querySubjectList == null) {
            return;
        }
        for (QuerySubject querySubject : querySubjectList) {
            List queryItemTypeList = querySubject.basicGetItem();
            if (queryItemTypeList == null) continue;
            for (ItemType queryItemType : queryItemTypeList) {
                List localRefList;
                ItemHierarchy hierarchy = queryItemType.getItemHierarchy();
                if (hierarchy == null || (localRefList = hierarchy.basicGetLocalRef()) == null) continue;
                for (LocalRefType localRef : localRefList) {
                    String ref = localRef.getRef();
                    if (ref == null) continue;
                    localRef.setReferencedObject(null);
                }
            }
        }
    }

    private static void resetFolderTypeReferences(FolderType folderType) {
        List folderItemTypes = folderType.basicGetFolderItem();
        if (folderItemTypes == null) {
            return;
        }
        for (FolderItemType folderItemType : folderItemTypes) {
            FolderType nestedFolder;
            String ref = folderItemType.getRef();
            if (ref != null) {
                folderItemType.setReferencedObject(null);
            } else {
                DefLinkType defLinkType = folderItemType.getDefLink();
                if (defLinkType != null) {
                    defLinkType.setReferencedObject(null);
                }
            }
            if ((nestedFolder = folderItemType.getFolder()) == null) continue;
            ModuleUtils.resetFolderTypeReferences(nestedFolder);
        }
    }

    private static void resetSegmentReferences(Module module) {
        List drillGroups = module.basicGetDrillGroup();
        if (drillGroups == null) {
            return;
        }
        for (DrillGroup drillGroup : drillGroups) {
            List segments = drillGroup.basicGetSegment();
            if (segments == null) continue;
            for (DrillGroup.Segment segment : segments) {
                segment.setReferencedObject(null);
            }
        }
    }

    private static void resetRelationships(Module module) {
        List relationships = module.basicGetRelationship();
        if (relationships == null) {
            return;
        }
        for (Relationship relationship : relationships) {
            List links;
            CardinalityType rightcard;
            CardinalityType leftcard = relationship.getLeft();
            if (leftcard != null) {
                leftcard.setReferencedObject(null);
            }
            if ((rightcard = relationship.getRight()) != null) {
                rightcard.setReferencedObject(null);
            }
            if ((links = relationship.basicGetLink()) == null) continue;
            for (Relationship.Link link : links) {
                link.setReferencedObjectLeft(null);
                link.setReferencedObjectRight(null);
            }
        }
    }

    private static void resetFacetDef(Module module) {
        List querySubjects = module.basicGetQuerySubject();
        if (querySubjects == null) {
            return;
        }
        for (QuerySubject querySubject : querySubjects) {
            List itemTypeList = querySubject.basicGetItem();
            ModuleUtils.resetFacetDefFromItems(itemTypeList);
        }
    }

    protected static void resetFacetDefFromItems(List<ItemType> itemTypeList) {
        if (itemTypeList == null) {
            return;
        }
        for (ItemType itemType : itemTypeList) {
            List nested = null;
            QueryItem queryItem = itemType.getQueryItem();
            if (queryItem != null) {
                ModuleUtils.resetFacetDefFromQueryItem(queryItem);
                nested = queryItem.basicGetItem();
            } else {
                ItemType.Folder nestedFolder = itemType.getFolder();
                if (nestedFolder != null) {
                    nested = nestedFolder.basicGetItem();
                }
            }
            ModuleUtils.resetFacetDefFromItems(nested);
        }
    }

    private static void resetFacetDefFromQueryItem(QueryItem item) {
        FacetType.Context context;
        List sortItems;
        FacetType ft = item.getFacetDefinition();
        if (ft == null) {
            return;
        }
        SortListType sl = ft.getSortList();
        if (sl != null && (sortItems = sl.basicGetSortItem()) != null) {
            for (SortListType.SortItem sortItem : sortItems) {
                sortItem.setReferencedObject(null);
            }
        }
        if ((context = ft.getContext()) != null) {
            context.setReferencedObject(null);
        }
    }

    public static boolean isForData(MoserObject mo) {
        return mo instanceof MemberType;
    }

    public static void setMemberHidden(MemberType member, boolean hidden) {
        PropertyType prop = ModuleUtils.getMemberHiddenProperty(member);
        if (prop == null) {
            prop = new PropertyType();
            prop.setName("memberHidden");
            member.addProperty(prop);
        }
        if (hidden) {
            prop.setValue("true");
        } else {
            prop.setValue("false");
        }
    }

    public static PropertyType getMemberHiddenProperty(MemberType member) {
        for (PropertyType p : member.getProperty()) {
            if (!"memberHidden".equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public static boolean getMemberHidden(MemberType member) {
        PropertyType p = ModuleUtils.getMemberHiddenProperty(member);
        if (p != null) {
            return "true".equals(p.getValue());
        }
        return false;
    }

    public static boolean cleanObject(MoserObject obj, List<String> objTypes) {
        String objectType = obj.getObjectType();
        if ("QuerySubject".equals(objectType)) {
            return ModuleUtils.cleanQuerySubject((QuerySubject)obj, objTypes);
        }
        return false;
    }

    protected static boolean cleanQuerySubject(QuerySubject qs, List<String> objTypes) {
        return ModuleUtils.cleanQuerySubjectItemNormalization(qs, objTypes);
    }

    protected static boolean cleanQuerySubjectItemNormalization(QuerySubject qs, List<String> objTypes) {
        ItemNormalizationType itemNorm = qs.getItemNormalization();
        if (itemNorm == null) {
            return false;
        }
        List grps = itemNorm.basicGetItemNormalizationGroup();
        if (grps == null || grps.isEmpty()) {
            return false;
        }
        if (objTypes != null && !objTypes.isEmpty() && !objTypes.contains("ItemNormalizationType")) {
            return false;
        }
        ArrayList<String> existingQIs = new ArrayList<String>();
        for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)qs)) {
            existingQIs.add(qi.getIdentifier());
        }
        return PropertySetter.cleanQuerySubjectItemNormalization((QuerySubject)qs, existingQIs);
    }
}

