/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.client.utils;

import com.ibm.bi.platform.moser.client.utils.ModuleUtils;
import com.ibm.bi.platform.moser.client.utils.QuerySubjectUtils;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.utils.ReferenceResolver;
import com.ibm.bi.platform.moser.core.module.util.DataModuleExtractor;
import java.util.List;
import java.util.Map;

public class ObjectNavigator {
    protected Module module;
    protected Map<String, Module> catalog;

    public ObjectNavigator(Module module, Map<String, Module> catalog) {
        this.module = module;
        this.catalog = catalog;
    }

    public MoserObject findModuleObjectUsingBaseObject(ObjectType baseModuleObject, String baseModuleUseSpecID) {
        block6: {
            QuerySubject querySubject;
            block5: {
                if (baseModuleObject == null || !this.catalog.containsKey(baseModuleUseSpecID)) {
                    return null;
                }
                if (!"QuerySubject".equals(baseModuleObject.getObjectType())) break block5;
                String ref = baseModuleUseSpecID + "." + baseModuleObject.getIdentifier();
                for (QuerySubject qs : this.module.getQuerySubject()) {
                    if (!(!qs.getOriginalRef().isEmpty() ? ref.equals(qs.getOriginalRef().get(0)) : !qs.getRef().isEmpty() && ref.equals(qs.getRef().get(0)))) continue;
                    return qs;
                }
                break block6;
            }
            if ("Relationship".equals(baseModuleObject.getObjectType())) {
                return null;
            }
            if (!"Filter".equals(baseModuleObject.getObjectType()) && !"Calculation".equals(baseModuleObject.getObjectType()) && !"QueryItem".equals(baseModuleObject.getObjectType()) || (querySubject = (QuerySubject)QuerySubjectUtils.getParentOfType("QuerySubject", (MoserObject)baseModuleObject)) == null) break block6;
            String idForExpression = baseModuleUseSpecID + "." + querySubject.getIdentifier();
            for (QuerySubject qs : this.module.getQuerySubject()) {
                String ref;
                String origRef;
                if (!qs.getOriginalRef().isEmpty() && idForExpression.equals(origRef = (String)qs.getOriginalRef().get(0))) {
                    return this.locateModuleItemUsingBase(baseModuleObject, qs.getItem());
                }
                if (qs.getRef().isEmpty() || !idForExpression.equals(ref = (String)qs.getRef().get(0))) continue;
                return this.locateModuleItemUsingBase(baseModuleObject, qs.getItem());
            }
        }
        return null;
    }

    private MoserObject locateModuleItemUsingBase(ObjectType baseItem, List<ItemType> items) {
        for (ItemType item : items) {
            MoserObject object;
            if (item.getFolder() != null && (object = this.locateModuleItemUsingBase(baseItem, item.getFolder().getItem())) != null) {
                return object;
            }
            if ("Filter".equals(baseItem.getObjectType())) {
                if (item.getFilter() == null || !item.getFilter().getIdentifier().equals(baseItem.getIdentifier())) continue;
                return item.getFilter();
            }
            if ("Calculation".equals(baseItem.getObjectType())) {
                if (item.getCalculation() == null || !item.getCalculation().getIdentifier().equals(baseItem.getIdentifier())) continue;
                return item.getCalculation();
            }
            if (!"QueryItem".equals(baseItem.getObjectType()) || item.getQueryItem() == null || !item.getQueryItem().getIdentifier().equals(baseItem.getIdentifier())) continue;
            return item.getQueryItem();
        }
        return null;
    }

    public MoserObject findBaseObjectUsingModuleObject(ObjectType moduleObject) {
        QuerySubject querySubject;
        if (moduleObject == null) {
            return null;
        }
        if ("QuerySubject".equals(moduleObject.getObjectType())) {
            Module.UseSpec useSpec = DataModuleExtractor.getUseSpec((ObjectType)moduleObject, (Module)this.module, (boolean)true);
            if (useSpec == null) {
                return null;
            }
            Module base = this.catalog.get(useSpec.getIdentifier());
            return ModuleUtils.findObjectTypeByIdForExpression(base, ObjectNavigator.getSecondPart((QuerySubject)moduleObject));
        }
        if ("Relationship".equals(moduleObject.getObjectType())) {
            return null;
        }
        if (("Filter".equals(moduleObject.getObjectType()) || "Calculation".equals(moduleObject.getObjectType()) || "QueryItem".equals(moduleObject.getObjectType())) && (querySubject = (QuerySubject)QuerySubjectUtils.getParentOfType("QuerySubject", (MoserObject)moduleObject)) != null) {
            return this.locateBaseItemUsing(moduleObject, querySubject);
        }
        return null;
    }

    private MoserObject locateBaseItemUsing(ObjectType moduleItem, QuerySubject moduleQuerySubject) {
        Module.UseSpec useSpec = this.getUseSpec((ObjectType)moduleQuerySubject);
        if (useSpec == null) {
            return null;
        }
        Module base = this.catalog.get(useSpec.getIdentifier());
        String qsRef = ObjectNavigator.getSecondPart(moduleQuerySubject);
        String qiRef = ReferenceResolver.getSecondPart((String)moduleItem.getIdForExpression());
        String idForExpression = qsRef + "." + qiRef;
        return ModuleUtils.findObjectTypeByIdForExpression(base, idForExpression);
    }

    private Module.UseSpec getUseSpec(ObjectType object) {
        return DataModuleExtractor.getUseSpec((ObjectType)object, (Module)this.module, (boolean)true);
    }

    private static String getSecondPart(QuerySubject querySubject) {
        if (!querySubject.getOriginalRef().isEmpty()) {
            return ReferenceResolver.getSecondPart((String)((String)querySubject.getOriginalRef().get(0)));
        }
        return ReferenceResolver.getSecondPart((String)((String)querySubject.getRef().get(0)));
    }
}

