/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.client.utils;

import com.ibm.bi.platform.moser.client.utils.IdGenerator;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemHierarchy;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.ProjectedItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.QsClassifierType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.SqlQueryType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.common.utils.ItemScanner;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.common.utils.ReferenceResolver;
import com.ibm.bi.platform.moser.core.module.util.DataModuleExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class QuerySubjectUtils {
    private QuerySubjectUtils() {
    }

    public static void convertReferenceQuerySubjectToCopy(QuerySubject qs, Module module) throws CloneNotSupportedException {
        if (qs.getInstanceType() != InstanceType.REFERENCE) {
            throw new IllegalArgumentException("The query subject instance type is not reference.");
        }
        QsClassifierType qsCls = qs.getClassifier();
        if (qsCls == QsClassifierType.QUERY_SUBJECT || qsCls == null) {
            String qsRef = (String)qs.getRef().get(0);
            String baseModuleUseSpecId = ReferenceResolver.getFirstPart((String)qsRef);
            Module.UseSpec baseModuleuseSpec = QuerySubjectUtils.getUseSpecById(module, baseModuleUseSpecId);
            if (baseModuleuseSpec != null) {
                String newBaseModuleId;
                Module.UseSpec newBaseModuleUseSpec = QuerySubjectUtils.getMUseSpecByStoreId(module, baseModuleuseSpec.getStoreID());
                if (newBaseModuleUseSpec == null) {
                    newBaseModuleUseSpec = (Module.UseSpec)baseModuleuseSpec.clone();
                    newBaseModuleId = IdGenerator.generateNewUseSpecId(module);
                    newBaseModuleUseSpec.setIdentifier(newBaseModuleId);
                    module.addUseSpec(newBaseModuleUseSpec);
                } else {
                    newBaseModuleId = newBaseModuleUseSpec.getIdentifier();
                }
                qs.removeOriginalRefAt(0);
                String origRef = newBaseModuleId + "." + ReferenceResolver.getSecondPart((String)qsRef);
                qs.removeRefAt(0);
                qs.addRefAt(0, origRef);
            }
        } else {
            qs.getOriginalRef().clear();
        }
        qs.setInstanceType(null);
        QuerySubjectUtils.clearPropertyOerride(qs);
        String qsId = qs.getIdentifier();
        if (qsId != null && !qsId.isEmpty()) {
            for (Relationship rel : module.getRelationship()) {
                if (!qsId.equals(rel.getLeft().getRef()) && !qsId.equals(rel.getRight().getRef())) continue;
                rel.setInstanceType(null);
                rel.setRef(null);
                QuerySubjectUtils.clearPropertyOverrideList((ObjectType)rel);
                if (qsId.equals(rel.getLeft().getRef())) {
                    rel.getLeft().setReferencedObject((MoserObject)qs);
                }
                if (!qsId.equals(rel.getRight().getRef())) continue;
                rel.getRight().setReferencedObject((MoserObject)qs);
            }
        }
    }

    public static void clearPropertyOerride(QuerySubject qs) {
        QuerySubjectUtils.clearPropertyOverrideList((ObjectType)qs);
        List items = MoserObjectUtils.getList((List)qs.basicGetItem());
        for (ItemType item : items) {
            ItemHierarchy choice = item.getItemHierarchy();
            if (choice == null) continue;
            QuerySubjectUtils.clearPropertyOverrideList((ObjectType)choice);
        }
        for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)qs)) {
            QuerySubjectUtils.clearPropertyOverrideList((ObjectType)qi);
        }
    }

    private static void clearPropertyOverrideList(ObjectType obj) {
        List list = MoserObjectUtils.getList((List)obj.basicGetPropertyOverride());
        for (int i = list.size() - 1; i >= 0; --i) {
            obj.removePropertyOverrideAt(i);
        }
    }

    private static Module.UseSpec getMUseSpecByStoreId(Module module, String storeId) {
        List uSpecs = MoserObjectUtils.getList((List)module.basicGetUseSpec());
        for (Module.UseSpec useSpec : uSpecs) {
            if (!storeId.equals(useSpec.getStoreID()) || useSpec.getIdentifier().indexOf("M") != 0) continue;
            return useSpec;
        }
        return null;
    }

    public static Module.UseSpec getUseSpecById(Module module, String useSpecId) {
        return DataModuleExtractor.getUseSpecById((Module)module, (String)useSpecId);
    }

    public static BaseQueryItemType getQueryItemById(String id, QuerySubject qs) {
        return ReferenceResolver.getQueryItemByIdAndQuerySubject((String)id, (QuerySubject)qs, (boolean)false);
    }

    public static MoserObject getParentOfType(String objType, MoserObject obj) {
        if (obj == null) {
            return null;
        }
        if (objType.equals(obj.getObjectType())) {
            return obj;
        }
        return QuerySubjectUtils.getParentOfType(objType, obj.getParent());
    }

    public static QuerySubject getParentQuerySubject(MoserObject obj) {
        return (QuerySubject)QuerySubjectUtils.getParentOfType("QuerySubject", obj);
    }

    public static Module getParentModule(MoserObject obj) {
        return (Module)QuerySubjectUtils.getParentOfType("Module", obj);
    }

    public static boolean updateSQLQueryQuerySubject(QuerySubject qs, QuerySubject newQS) throws CloneNotSupportedException {
        String label = newQS.getLabel();
        if (label != null) {
            qs.setLabel(label);
        }
        SqlQueryType sqlQuery = qs.getSqlQuery();
        SqlQueryType newSQLQuery = newQS.getSqlQuery();
        boolean existingEmpty = QuerySubjectUtils.isEmptySQLQuery(sqlQuery);
        boolean newEmpty = QuerySubjectUtils.isEmptySQLQuery(newSQLQuery);
        if (existingEmpty && newEmpty) {
            if (newSQLQuery != null) {
                qs.setSqlQuery((SqlQueryType)newSQLQuery.clone());
            } else {
                qs.setSqlQuery(null);
            }
            return false;
        }
        boolean[] bDel = new boolean[]{false, false};
        if (newEmpty) {
            ArrayList<String> removedId = new ArrayList<String>();
            List projItems = MoserObjectUtils.getList((List)sqlQuery.basicGetProjectedItem());
            for (ProjectedItemType pItm : projItems) {
                removedId.add(pItm.getIdentifier());
            }
            if (newSQLQuery != null) {
                qs.setSqlQuery((SqlQueryType)newSQLQuery.clone());
            } else {
                qs.setSqlQuery(null);
            }
            QuerySubjectUtils.deleteItemsInQS(qs, removedId, bDel);
            return bDel[0] && (bDel[1] || qs.basicGetFilter() != null && !qs.basicGetFilter().isEmpty());
        }
        if (existingEmpty) {
            SqlQueryType clonedSQL = (SqlQueryType)newSQLQuery.clone();
            qs.setSqlQuery(clonedSQL);
            ArrayList<String> addedByExternalName = new ArrayList<String>();
            List projItems = MoserObjectUtils.getList((List)clonedSQL.basicGetProjectedItem());
            for (ProjectedItemType pItm : projItems) {
                addedByExternalName.add(pItm.getExternalName());
            }
            QuerySubjectUtils.addQueryItems(qs, addedByExternalName, newQS);
            return false;
        }
        ArrayList<String> existingExtNames = QuerySubjectUtils.getExternalNamesFromProjItems(sqlQuery);
        ArrayList<String> newExtNames = QuerySubjectUtils.getExternalNamesFromProjItems(newSQLQuery);
        ArrayList<String> intersectExtName = QuerySubjectUtils.getIntersect(existingExtNames, newExtNames);
        ArrayList<String> delExtName = QuerySubjectUtils.getExcept(existingExtNames, intersectExtName);
        ArrayList<String> addedByExternalName = QuerySubjectUtils.getExcept(newExtNames, intersectExtName);
        ArrayList<String> removedId = QuerySubjectUtils.getIdByExternalName(sqlQuery, delExtName);
        HashMap<String, ProjectedItemType> updatedId = QuerySubjectUtils.getUpdateItemIds(intersectExtName, sqlQuery, newSQLQuery);
        SqlQueryType clonedSQL = (SqlQueryType)newSQLQuery.clone();
        qs.setSqlQuery(clonedSQL);
        if (removedId != null && !removedId.isEmpty()) {
            QuerySubjectUtils.deleteItemsInQS(qs, removedId, bDel);
        }
        if (updatedId != null) {
            QuerySubjectUtils.updateItemsInQS(qs, updatedId);
        }
        if (addedByExternalName != null && !addedByExternalName.isEmpty()) {
            QuerySubjectUtils.addQueryItems(qs, addedByExternalName, newQS);
        }
        return bDel[0] && (bDel[1] || qs.basicGetFilter() != null && !qs.basicGetFilter().isEmpty());
    }

    private static boolean isEmptySQLQuery(SqlQueryType sqlQuery) {
        if (sqlQuery == null) {
            return true;
        }
        List projItems = sqlQuery.basicGetProjectedItem();
        return projItems == null || projItems.isEmpty();
    }

    private static ArrayList<String> getExternalNamesFromProjItems(SqlQueryType sqlQuery) {
        ArrayList<String> r = new ArrayList<String>();
        List projs = MoserObjectUtils.getList((List)sqlQuery.basicGetProjectedItem());
        for (ProjectedItemType projItem : projs) {
            r.add(projItem.getExternalName());
        }
        return r;
    }

    private static ArrayList<String> getIdByExternalName(SqlQueryType sqlQuery, ArrayList<String> extName) {
        ArrayList<String> r = new ArrayList<String>();
        if (extName.isEmpty()) {
            return r;
        }
        List projs = MoserObjectUtils.getList((List)sqlQuery.basicGetProjectedItem());
        for (ProjectedItemType projItem : projs) {
            String ex = projItem.getExternalName();
            if (!extName.contains(ex)) continue;
            r.add(projItem.getIdentifier());
        }
        return r;
    }

    private static ProjectedItemType getProjectedItemTypeByExtName(SqlQueryType sqlQuery, String s) {
        List projs = MoserObjectUtils.getList((List)sqlQuery.basicGetProjectedItem());
        for (ProjectedItemType projItem : projs) {
            String ex = projItem.getExternalName();
            if (!s.equals(ex)) continue;
            return projItem;
        }
        return null;
    }

    private static ArrayList<String> getIntersect(ArrayList<String> s1, ArrayList<String> s2) {
        ArrayList<String> r = new ArrayList<String>();
        for (String v : s1) {
            if (!s2.contains(v)) continue;
            r.add(v);
        }
        return r;
    }

    private static ArrayList<String> getExcept(ArrayList<String> s1, ArrayList<String> s2) {
        ArrayList<String> r = new ArrayList<String>();
        for (String v : s1) {
            if (s2.contains(v)) continue;
            r.add(v);
        }
        return r;
    }

    private static HashMap<String, ProjectedItemType> getUpdateItemIds(ArrayList<String> extName, SqlQueryType sqlQuery, SqlQueryType newSQLQuery) {
        if (extName.isEmpty()) {
            return null;
        }
        HashMap<String, ProjectedItemType> r = null;
        for (String s : extName) {
            ProjectedItemType proj = QuerySubjectUtils.getProjectedItemTypeByExtName(sqlQuery, s);
            ProjectedItemType newProj = QuerySubjectUtils.getProjectedItemTypeByExtName(newSQLQuery, s);
            if (r == null) {
                r = new HashMap<String, ProjectedItemType>();
            }
            r.put(proj.getIdentifier(), newProj);
        }
        return r;
    }

    private static void deleteItemsInQS(QuerySubject qs, ArrayList<String> removedId, boolean[] bDel) {
        List items = qs.basicGetItem();
        if (items == null || items.isEmpty()) {
            return;
        }
        ArrayList<ItemType> delList = new ArrayList<ItemType>();
        for (ItemType itm : items) {
            QuerySubjectUtils.deleteItemType(itm, delList, removedId, bDel);
        }
        for (ItemType delItm : delList) {
            bDel[0] = true;
            qs.removeItem(delItm);
        }
    }

    private static void deleteItemType(ItemType itm, List<ItemType> delList, ArrayList<String> removedId, boolean[] bDel) {
        QueryItem qi = itm.getQueryItem();
        if (qi != null) {
            String id = qi.getIdentifier();
            if (id.equals(qi.getExpression())) {
                if (removedId.contains(id)) {
                    delList.add(itm);
                }
            } else {
                bDel[1] = true;
            }
        } else {
            ItemType.Folder fld = itm.getFolder();
            if (fld != null) {
                QuerySubjectUtils.deleteItemsInFolder(fld, removedId, bDel);
            }
        }
    }

    private static void deleteItemsInFolder(ItemType.Folder theFolder, ArrayList<String> removedId, boolean[] bDel) {
        List items = theFolder.basicGetItem();
        if (items == null || items.isEmpty()) {
            return;
        }
        ArrayList<ItemType> delList = new ArrayList<ItemType>();
        for (ItemType itm : items) {
            QuerySubjectUtils.deleteItemType(itm, delList, removedId, bDel);
        }
        for (ItemType delItm : delList) {
            bDel[0] = true;
            theFolder.removeItem(delItm);
        }
    }

    private static void updateItemsInQS(QuerySubject qs, HashMap<String, ProjectedItemType> updatedId) {
        List items = qs.basicGetItem();
        if (items == null || items.isEmpty()) {
            return;
        }
        for (ItemType itm : items) {
            QuerySubjectUtils.updateItemType(itm, updatedId);
        }
    }

    private static void updateItemType(ItemType itm, HashMap<String, ProjectedItemType> updatedId) {
        QueryItem qi = itm.getQueryItem();
        if (qi != null) {
            ProjectedItemType proj;
            String id = qi.getIdentifier();
            if (id.equals(qi.getExpression()) && (proj = updatedId.get(id)) != null) {
                qi.setNullable(proj.isNullable());
                qi.setDatatype(proj.getDatatype());
                qi.setHighlevelDatatype(proj.getHighlevelDatatype());
            }
        } else {
            ItemType.Folder fld = itm.getFolder();
            if (fld != null) {
                QuerySubjectUtils.updateItemsInFolder(fld, updatedId);
            }
        }
    }

    private static void updateItemsInFolder(ItemType.Folder theFolder, HashMap<String, ProjectedItemType> updatedId) {
        List items = theFolder.basicGetItem();
        if (items == null || items.isEmpty()) {
            return;
        }
        for (ItemType itm : items) {
            QuerySubjectUtils.updateItemType(itm, updatedId);
        }
    }

    private static void collectObjectIdsInQS(QuerySubject qs, HashSet<String> existIds) {
        List items = qs.basicGetItem();
        if (items == null || items.isEmpty()) {
            return;
        }
        for (ItemType itm : items) {
            QuerySubjectUtils.collectObjectIdsInItem(itm, existIds);
        }
    }

    private static void collectObjectIdsInItem(ItemType itm, HashSet<String> existIds) {
        QueryItem qi = itm.getQueryItem();
        if (qi != null) {
            String id = qi.getIdentifier();
            existIds.add(id);
        } else {
            ItemType.Folder fld = itm.getFolder();
            if (fld != null) {
                QuerySubjectUtils.collectObjectIdsInFolder(fld, existIds);
            }
        }
    }

    private static void collectObjectIdsInFolder(ItemType.Folder theFolder, HashSet<String> existIds) {
        List items = theFolder.basicGetItem();
        if (items == null || items.isEmpty()) {
            return;
        }
        for (ItemType itm : items) {
            QuerySubjectUtils.collectObjectIdsInItem(itm, existIds);
        }
    }

    private static void addQueryItems(QuerySubject qs, ArrayList<String> addedByExternalName, QuerySubject newQS) throws CloneNotSupportedException {
        HashSet<String> existIds = new HashSet<String>();
        QuerySubjectUtils.collectObjectIdsInQS(qs, existIds);
        SqlQueryType sqlQuery = qs.getSqlQuery();
        for (String s : addedByExternalName) {
            ProjectedItemType proj = QuerySubjectUtils.getProjectedItemTypeByExtName(sqlQuery, s);
            String id = proj.getIdentifier();
            String newId = QuerySubjectUtils.makeUnique(existIds, id);
            ItemType aItem = QuerySubjectUtils.getItemTypeByIdAndQuerySubject(id, newQS);
            ItemType cloned = (ItemType)aItem.clone();
            if (!newId.equals(id)) {
                existIds.add(newId);
                QueryItem qi = cloned.getQueryItem();
                qi.setIdentifier(newId);
                qi.setIdForExpression(qs.getIdentifier() + "." + newId);
                qi.setExpression(newId);
                proj.setIdentifier(newId);
                proj.setIdForExpression(sqlQuery.getIdentifier() + "." + newId);
            }
            qs.addItem(cloned);
        }
    }

    private static String makeUnique(HashSet<String> existIds, String validId) {
        String identifier = validId;
        int iSuffix = 0;
        while (existIds.contains(identifier)) {
            identifier = validId + '_' + ++iSuffix;
        }
        return iSuffix > 0 ? validId + '_' + iSuffix : validId;
    }

    public static ItemType getItemTypeByIdAndQuerySubject(String id, QuerySubject qs) {
        if (qs == null) {
            return null;
        }
        List items = qs.basicGetItem();
        if (items == null || items.isEmpty()) {
            return null;
        }
        for (ItemType itm : items) {
            String qiId;
            QueryItem qi = itm.getQueryItem();
            if (qi == null || !id.equals(qiId = qi.getIdentifier())) continue;
            return itm;
        }
        return null;
    }

    private static void collectFilterInFolder(ItemType.Folder theFolder, ArrayList<Filter> itemFilters) {
        List items = theFolder.basicGetItem();
        if (items == null || items.isEmpty()) {
            return;
        }
        for (ItemType itm : items) {
            Filter f = itm.getFilter();
            if (f != null) {
                itemFilters.add(f);
                continue;
            }
            ItemType.Folder fld = itm.getFolder();
            if (fld == null) continue;
            QuerySubjectUtils.collectFilterInFolder(fld, itemFilters);
        }
    }

    public static List<QueryItem> listComparableQueryItems(Module module, QueryItem exclQI) {
        ArrayList<QueryItem> rt = new ArrayList<QueryItem>();
        List qsList = MoserObjectUtils.getList((List)module.basicGetQuerySubject());
        for (QuerySubject qs : qsList) {
            for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)qs)) {
                List items;
                List sp;
                if (qi == exclQI || (sp = qi.basicGetSplitDefinition()) == null || sp.isEmpty() || (items = qi.basicGetItem()) == null || items.isEmpty()) continue;
                ArrayList<Filter> itemFilters = new ArrayList<Filter>();
                for (ItemType itm : items) {
                    Filter f = itm.getFilter();
                    if (f != null) {
                        itemFilters.add(f);
                        continue;
                    }
                    ItemType.Folder fld = itm.getFolder();
                    if (fld == null) continue;
                    QuerySubjectUtils.collectFilterInFolder(fld, itemFilters);
                }
                if (itemFilters.isEmpty()) continue;
                rt.add(qi);
            }
        }
        return rt;
    }

    public static boolean queryItemAllowPostAggregate(QueryItem qi) {
        UsageType usage = qi.getUsage();
        QuerySubject qs = QuerySubjectUtils.getParentQuerySubject((MoserObject)qi);
        String expr = qi.getExpression();
        return QuerySubjectUtils.allowPostAggregate(expr, qs, usage, qi);
    }

    public static boolean expressionAllowPostAggregate(String expr, QuerySubject qs, UsageType usage) {
        return QuerySubjectUtils.allowPostAggregate(expr, qs, usage, null);
    }

    private static boolean allowPostAggregate(String expr, QuerySubject qs, UsageType usage, QueryItem qi) {
        if (!UsageType.FACT.equals((Object)usage)) {
            return false;
        }
        if (qs == null) {
            return false;
        }
        String qsId = qs.getIdentifier();
        List ids = ItemScanner.collectIdentifiers((String)expr);
        if (ids.isEmpty()) {
            return true;
        }
        HashSet<String> allQIs = new HashSet<String>();
        List qis = MoserObjectUtils.getQueryItems((QuerySubject)qs);
        for (QueryItem aQI : qis) {
            if (aQI.equals(qi)) continue;
            allQIs.add(aQI.getIdForExpression());
        }
        for (String[] id : ids) {
            String fullId = QuerySubjectUtils.getNormalized(id, qsId);
            if (allQIs.contains(fullId)) continue;
            return false;
        }
        return true;
    }

    private static String getNormalized(String[] id, String qsId) {
        boolean bDot = false;
        String p = QuerySubjectUtils.skipBracket(id[0]);
        StringBuilder sb = new StringBuilder();
        if (!qsId.equals(p)) {
            sb.append(qsId);
            bDot = true;
        }
        for (String s : id) {
            if (bDot) {
                sb.append(".");
            } else {
                bDot = true;
            }
            sb.append(QuerySubjectUtils.skipBracket(s));
        }
        return sb.toString();
    }

    private static String skipBracket(String value) {
        String s = value;
        if (s.startsWith("[") && s.endsWith("]")) {
            s = s.substring(1, s.length() - 1);
            return s.replaceAll("]]", "]");
        }
        return s;
    }
}

