/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.client.validation;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.DrillGroup;
import com.ibm.bi.platform.moser.common.generated.metadata.FacetType;
import com.ibm.bi.platform.moser.common.generated.metadata.Feedback;
import com.ibm.bi.platform.moser.common.generated.metadata.JSONObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.SortListType;
import com.ibm.bi.platform.moser.common.generated.metadata.ValidationMessage;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.common.validation.Diagnostic;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class ValidationUtils {
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    private static final String RELATIONSHIP_LOOKUP = "/relationship[";
    private static final String DRILLGROUP_LOOKUP = "/drillGroup[";

    private ValidationUtils() {
    }

    public static List<Diagnostic> validateModule(JSONObject json, ObjectFactory objectFactory, Module module) {
        if (json == null || objectFactory == null || module == null) {
            return new ArrayList<Diagnostic>();
        }
        module.removeDiagnostics();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        JSONObjectFactory factory = new JSONObjectFactory(objectFactory);
        JSONObject feedbackValue = (JSONObject)json.get((Object)"feedback");
        Feedback feedback = feedbackValue == null ? factory.createFeedback(json) : factory.createFeedback(feedbackValue);
        Feedback.Data data = feedback.getData();
        if (data != null) {
            List vMsgs = data.getValidationMessage();
            for (ValidationMessage msg : vMsgs) {
                Diagnostic diagnostic = ValidationUtils.resolveByPath(ValidationUtils.convertLocationToList(msg.getLocation()), (MoserObject)module, msg, module.getLabel());
                if (diagnostic != null) {
                    diagnostics.add(diagnostic);
                }
                ValidationUtils.resolveAndTagRelationship(module, msg);
                ValidationUtils.resolveAndTagDrillGroup(module, msg);
            }
        }
        return diagnostics;
    }

    public static List<Diagnostic> validateExpression(JSONObject json) {
        ArrayList<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();
        if (json == null || json.get((Object)"messages") == null) {
            return diagnosticList;
        }
        JSONArray messages = (JSONArray)json.get((Object)"messages");
        if (messages != null) {
            for (Object message : messages) {
                Diagnostic diagnostic = new Diagnostic();
                ValidationMessage msg = new ValidationMessage();
                JSONObject child = (JSONObject)message;
                if (child != null) {
                    msg.setSeverity((String)child.get((Object)"severity"));
                    msg.setMsg((String)child.get((Object)"message"));
                }
                diagnostic.setValidationMessage(msg);
                diagnosticList.add(diagnostic);
            }
        }
        return diagnosticList;
    }

    private static List<String> convertLocationToList(String location) {
        if (location == null || location.isEmpty()) {
            return new ArrayList<String>();
        }
        int start = location.indexOf("/") + 1;
        String segments = location.substring(start, location.length());
        String[] parts = segments.split("/");
        ArrayList<String> list = new ArrayList<String>();
        for (String part : parts) {
            if (part.length() <= 0) continue;
            list.add(part);
        }
        return list;
    }

    private static Diagnostic resolveByPath(List<String> path, MoserObject module, ValidationMessage message, String label) {
        Diagnostic diagnostic;
        int featureId;
        String node;
        if (path.isEmpty() || module == null || path.get(0).length() == 0) {
            return null;
        }
        String featureName = node = path.get(0);
        int arrayIdx = 0;
        int idx = node.indexOf("[");
        if (idx != -1) {
            featureName = node.substring(0, idx);
            String element = node.substring(idx + 1, node.length() - 1);
            arrayIdx = Integer.parseInt(element) - 1;
        }
        if ((featureId = module.getFeatureID(featureName)) > 0) {
            Object moduleProperty = module.get(featureId);
            Object modulePropElement = moduleProperty instanceof List ? ((List)moduleProperty).get(arrayIdx) : moduleProperty;
            if (modulePropElement instanceof MoserObject) {
                path.remove(0);
                MoserObject moserObj = (MoserObject)modulePropElement;
                String labelObjType = ValidationUtils.checkLabel(moserObj);
                String newLabel = label;
                if (labelObjType != null) {
                    newLabel = labelObjType;
                }
                if (!path.isEmpty() && path.get(0).length() != 0) {
                    diagnostic = ValidationUtils.resolveByPath(path, moserObj, message, newLabel);
                } else {
                    diagnostic = ValidationUtils.setDiagnoticProperties(moserObj, newLabel, message, featureId);
                    moserObj.addDiagnostic(diagnostic);
                }
            } else {
                diagnostic = ValidationUtils.setDiagnoticProperties(module, label, message, featureId);
            }
            module.addDiagnostic(diagnostic);
        } else if ("sortItem".equals(featureName) && module instanceof BaseQueryItemType) {
            BaseQueryItemType qi = (BaseQueryItemType)module;
            diagnostic = ValidationUtils.setDiagnoticProperties((MoserObject)qi, label, message, 249);
            qi.addDiagnostic(diagnostic);
            FacetType facetDef = qi.getFacetDefinition();
            if (facetDef != null) {
                diagnostic = ValidationUtils.setDiagnoticProperties((MoserObject)facetDef, label, message, 18);
                facetDef.addDiagnostic(diagnostic);
                SortListType sortList = facetDef.getSortList();
                if (sortList != null) {
                    diagnostic = ValidationUtils.setDiagnoticProperties((MoserObject)sortList, label, message, 184);
                    sortList.addDiagnostic(diagnostic);
                    List sortItemList = sortList.basicGetSortItem();
                    if (sortItemList != null && !sortItemList.isEmpty()) {
                        SortListType.SortItem sorItem = (SortListType.SortItem)sortItemList.get(0);
                        diagnostic = ValidationUtils.setDiagnoticProperties((MoserObject)sorItem, label, message, 36);
                        sorItem.addDiagnostic(diagnostic);
                    }
                }
            }
        } else {
            diagnostic = ValidationUtils.setDiagnoticProperties(module, label, message, featureId);
            module.addDiagnostic(diagnostic);
        }
        return diagnostic;
    }

    private static Diagnostic setDiagnoticProperties(MoserObject object, String label, ValidationMessage message, int featureId) {
        Diagnostic diagnostic = new Diagnostic();
        diagnostic.setProperties(object, label, message, featureId);
        return diagnostic;
    }

    private static String checkLabel(MoserObject obj) {
        String labelObjType;
        String label = null;
        if (obj instanceof ObjectType && (labelObjType = ((ObjectType)obj).getLabel()) != null) {
            label = labelObjType;
        }
        return label;
    }

    private static Object getObjectByLocationPath(MoserObject module, String path) {
        int featureId;
        Object moduleProperty;
        String featureName = path;
        int arrayIdx = 0;
        int idx = path.indexOf("[");
        if (idx != -1) {
            featureName = path.substring(0, idx);
            String element = path.substring(idx + 1, path.length() - 1);
            arrayIdx = Integer.parseInt(element) - 1;
        }
        Object modulePropElement = (moduleProperty = module.get(featureId = module.getFeatureID(featureName))) instanceof List ? ((List)moduleProperty).get(arrayIdx) : moduleProperty;
        return modulePropElement;
    }

    private static void resolveAndTagDrillGroup(Module module, ValidationMessage message) {
        Object segment;
        String location = message.getLocation();
        if (location == null || location.indexOf(DRILLGROUP_LOOKUP) == -1) {
            return;
        }
        List<String> locationList = ValidationUtils.convertLocationToList(location);
        if (locationList.size() <= 1) {
            return;
        }
        Object drillGroup = ValidationUtils.getObjectByLocationPath((MoserObject)module, locationList.get(0));
        if (drillGroup instanceof MoserObject && (segment = ValidationUtils.getObjectByLocationPath((MoserObject)drillGroup, locationList.get(1))) instanceof DrillGroup.Segment) {
            DrillGroup.Segment seg = (DrillGroup.Segment)segment;
            String identifier = seg.getRef();
            int index = identifier.indexOf(".");
            String qsId = identifier.substring(0, index);
            String qiId = identifier.substring(index + 1, identifier.length() - 1);
            QuerySubject querySubject = ValidationUtils.getQuerySubjectFromModuleByIdentifier(module, qsId);
            if (querySubject != null) {
                Diagnostic diagnostic = ValidationUtils.setDiagnoticProperties((MoserObject)querySubject, querySubject.getLabel(), message, 0);
                querySubject.addDiagnostic(diagnostic);
                QueryItem queryItem = ValidationUtils.getQueryItemFromQuerySubjectByIdentifier(querySubject, qiId);
                if (queryItem != null) {
                    diagnostic = ValidationUtils.setDiagnoticProperties((MoserObject)queryItem, queryItem.getLabel(), message, 0);
                    queryItem.addDiagnostic(diagnostic);
                }
            }
        }
    }

    private static void resolveAndTagRelationship(Module module, ValidationMessage message) {
        String location = message.getLocation();
        if (location == null || location.indexOf(RELATIONSHIP_LOOKUP) == -1) {
            return;
        }
        List<String> locationList = ValidationUtils.convertLocationToList(location);
        Object obj = ValidationUtils.getObjectByLocationPath((MoserObject)module, locationList.get(0));
        if (obj instanceof Relationship) {
            Diagnostic diagnostic;
            QuerySubject querySubject;
            Relationship relationship = (Relationship)obj;
            if (relationship.getLeft() != null) {
                querySubject = ValidationUtils.getQuerySubjectFromModuleByIdentifier(module, relationship.getLeft().getRef());
                diagnostic = ValidationUtils.setDiagnoticProperties((MoserObject)relationship, relationship.getLabel(), message, querySubject.getFeatureID("relationship"));
                querySubject.addDiagnostic(diagnostic);
            }
            if (relationship.getRight() != null) {
                querySubject = ValidationUtils.getQuerySubjectFromModuleByIdentifier(module, relationship.getRight().getRef());
                diagnostic = ValidationUtils.setDiagnoticProperties((MoserObject)relationship, relationship.getLabel(), message, querySubject.getFeatureID("relationship"));
                querySubject.addDiagnostic(diagnostic);
            }
        }
    }

    private static QuerySubject getQuerySubjectFromModuleByIdentifier(Module module, String identifier) {
        if (module == null) {
            return null;
        }
        List qsList = module.getQuerySubject();
        QuerySubject querySubject = null;
        for (QuerySubject qs : qsList) {
            if (!qs.getIdentifier().equals(identifier)) continue;
            querySubject = qs;
            break;
        }
        return querySubject;
    }

    private static QueryItem getQueryItemFromQuerySubjectByIdentifier(QuerySubject querySubject, String identifier) {
        if (querySubject == null) {
            return null;
        }
        for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)querySubject)) {
            if (!qi.getIdentifier().equals(identifier)) continue;
            return qi;
        }
        return null;
    }
}

