/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.indications.ILogAuditIndication;
import com.cognos.indications.LogAuditRenderer;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogIndication;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LogAuditIndication
extends LogIndication
implements ILogAuditIndication {
    public static final String defaultRequestID = " ";
    public static final String ADD = "Add";
    public static final String QUERY = "Query";
    public static final String UPDATE = "Update";
    public static final String DELETE = "Delete";
    public static final String MOVE = "Move";
    public static final String COPY = "Copy";
    public static final String EXPORT = "Export";
    public static final String IMPORT = "Import";
    public static final String EDIT = "Edit";
    public static final String EXECUTE = "Execute";
    public static final String VIEW = "View";
    public static final String EDITPARAMETERS = "EditParameters";
    public static final String STARTSERVICE = "StartService";
    public static final String STOPSERVICE = "StopService";
    public static final String UPGRADE = "Upgrade";
    public static final String UPGRADEINFO = "UpgradeDetails";
    public static final String LISTARCHIVES = "ListArchives";
    public static final String NOTIFY = "Notify";
    public static final String PING = "Ping";
    public static final String EDITQUERY = "EditQuery";
    public static final String NEWQUERY = "NewQuery";
    public static final String GETMETADATA = "GetMetadata";
    public static final String GETARCHIVEOPTIONS = "GetArchiveOptions";
    public static final String CALL = "Call";
    public static final String CALLSTART = "CallStart";
    public static final String CALLEND = "CallEnd";
    public static final String SUBMITJOB = "Submit";
    public static final String REQUEST = "Request";
    public static final String RESPONSE = "Response";
    public static final String LOGON = "Logon";
    public static final String LOGOFF = "Logoff";
    public static final String LOGONEXPIRED = "LogonExpired";
    public static final String FORCEDLOGOFF = "ForcedLogoff";
    public static final String SELECTTENANTS = "SelectTenants";
    public static final String NATIVEQUERY = "NativeQuery";
    public static final String RUN = "Run";
    public static final String RUNAT = "RunAt";
    public static final String CANCEL = "Cancel";
    public static final String WAIT = "Wait";
    public static final String RELEASE = "Release";
    public static final String BACKGROUND = "Background";
    public static final String CREATE = "Create";
    public static final String EDITANALYSIS = "EditAnalysis";
    public static final String COLLECTPARAMETER = "CollectParameter";
    public static final String VALIDATE = "Validate";
    public static final String GETPARAMETER = "GetParameter";
    public static final String REPORTQUERY = "ReportQuery";
    public static final String DRILLTHROUGH = "DrillThrough";
    public static final String FIRSTPAGE = "FirstPage";
    public static final String NEXTPAGE = "NextPage";
    public static final String PREVIOUSPAGE = "PreviousPage";
    public static final String LASTPAGE = "LastPage";
    public static final String CURRENTPAGE = "CurrentPage";
    public static final String SAVE = "Save";
    public static final String SAVEAS = "SaveAs";
    public static final String PRINT = "Print";
    public static final String EMAIL = "Email";
    public static final String REPORTADD = "ReportAdd";
    public static final String REPORTUPDATE = "ReportUpdate";
    public static final String RENDER = "Render";
    public static final String PROMPTFORWARD = "PromptForward";
    public static final String PROMPTBACK = "PromptBack";
    public static final String DRILLUPDOWN = "DrillUpDown";
    public static final String THRESHOLDVIOLATION = "ThresholdViolation";
    public static final String MIGRATIONADD = "MigrationAdd";
    public static final String MIGRATIONCREATE = "MigrationCreate";
    public static final String MIGRATIONVALIDATE = "MigrationValidate";
    public static final String MIGRATIONEXECUTE = "MigrationExecute";
    public static final String MIGRATIONUPDATE = "MigrationUpdate";
    public static final String MIGRATIONQUERY = "MigrationQuery";
    public static final String START = "Start";
    public static final String STOP = "Stop";
    public static final String CONNECT = "Connect";
    public static final String COMPLETE = "Complete";
    public static final String DETERMINE = "Determine";
    public static final String VERIFY = "Verify";
    public static final String DECORATE = "Decorate";
    public static final String REMOVE = "Remove";
    public static final String GENERATE = "Generate";
    public static final String FIXUP = "Fixup";
    public static final String TERMINATE = "Terminate";
    public static final String TRUSTED_CREDENTIAL = "Trusted Credential";
    public static final String LINEAGE = "Lineage";
    public static final String DELIVER = "Deliver";
    public static final String SUCCESS = "Success";
    public static final String FAILURE = "Failure";
    public static final String WARNING = "Warning";
    public static final String INFO = "Info";
    public static final String STATUS_SUCCESS = "Success";
    public static final String STATUS_ERR = "Failure";
    public static final int LogAuditService = 50000;
    public static final int LogAuditSession = 40000;
    public static final int LogAuditRequest = 30000;
    public static final int LogAuditTrace = 20000;
    public static final int LogAuditDebug = 10000;
    private static final long serialVersionUID = -8979431039231304264L;
    protected String m_operation;
    protected String m_logData;

    @Override
    public void setOperation(String op) {
        if (null == op) {
            op = "";
        }
        this.m_operation = op;
    }

    @Override
    public String getOperation() {
        return this.m_operation;
    }

    @Override
    public void setLogData(String data) {
        if (null == data) {
            data = "";
        }
        if (data.indexOf("\n") >= 0) {
            data = data.replaceAll("\n", defaultRequestID);
        }
        if (data.indexOf("\r") >= 0) {
            data = data.replaceAll("\r", defaultRequestID);
        }
        this.m_logData = data;
    }

    @Override
    public String getLogData() {
        return this.m_logData;
    }

    public LogAuditIndication(String component, int buildnum) {
        super(component, buildnum);
        this.m_group = 1;
        this.m_logData = "";
        this.m_operation = "";
    }

    public LogAuditIndication() {
        this("", 0);
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        try {
            out.writeUTF(this.m_operation);
            int logDataUTF8ByteSize = this.getUTF8ByteSize(this.m_logData);
            if (65535 >= logDataUTF8ByteSize) {
                out.writeInt(1);
                out.writeUTF(this.m_logData);
            } else {
                int logDataChunks = this.m_logData.length() / 40000 + 1;
                out.writeInt(logDataChunks);
                int ii = 0;
                for (ii = 0; ii < logDataChunks - 1; ++ii) {
                    out.writeUTF(this.m_logData.substring(ii * 40000, (ii + 1) * 40000));
                }
                out.writeUTF(this.m_logData.substring(ii * 40000));
            }
            super.writeExternal(out);
        }
        catch (Exception e) {
            LogIPFLog.warn("LogAuditIndication could not be sent to the log server.", e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) {
        try {
            this.m_operation = in.readUTF();
            int logDataChunks = in.readInt();
            if (1 == logDataChunks) {
                this.m_logData = in.readUTF();
            } else {
                StringBuffer tmpLogData = new StringBuffer(65535);
                for (int ii = 0; ii < logDataChunks; ++ii) {
                    tmpLogData.append(in.readUTF());
                }
                this.m_logData = tmpLogData.toString();
            }
            super.readExternal(in);
        }
        catch (Exception e) {
            LogIPFLog.warn("Received a corrupted indication.", e);
        }
    }

    public String toString() {
        LogAuditRenderer renderer = new LogAuditRenderer();
        return renderer.doRender(this);
    }
}

