/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogIPFUtils;
import java.io.File;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class LogFileWatchdog
extends Thread {
    public static final long DEFAULT_DELAY = 60000L;
    protected String filename;
    protected long delay = 60000L;
    File file;
    protected long m_lastModif = 0L;
    protected static boolean m_ipfConfigFileExists = false;
    protected boolean m_interrupted = false;

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setInterrupted(boolean interrupted) {
        this.m_interrupted = interrupted;
    }

    LogFileWatchdog(String filename) {
        this.filename = filename;
        this.file = new File(filename);
        this.checkAndConfigure();
    }

    public void doOnChange() {
        LogIPFLog.debug("LogFileWatchdog::doOnChange() - calling DOMConfigurator.configure('" + this.filename + "') to reconfigure IPF.");
        try {
            Document w3cDoc = LogIPFUtils.loadIPFConfigFile(this.file);
            if (w3cDoc != null) {
                LogIPFUtils.updateDocWithResolvedPath(w3cDoc);
                DOMConfigurator.configure((Element)w3cDoc.getDocumentElement());
            }
        }
        catch (Exception e) {
            LogIPFLog.error("LogFileWatchdog::doOnChange() - could not load ipf client config file '" + this.filename + "', exception: ", e);
        }
        Logger tmpLog = LogManager.exists((String)"Audit");
        if (null != tmpLog) {
            tmpLog.setAdditivity(false);
        }
        if (null != (tmpLog = LogManager.exists((String)"Perf"))) {
            tmpLog.setAdditivity(false);
        }
        if (null != (tmpLog = LogManager.exists((String)"Trace"))) {
            tmpLog.setAdditivity(false);
        }
    }

    protected void checkAndConfigure() {
        try {
            m_ipfConfigFileExists = this.file.exists();
        }
        catch (SecurityException e) {
            LogIPFLog.warn("LogFileWatchdog::checkAndConfigure() - Was not allowed to read check file existance, file:[" + this.filename + "].", e);
            this.m_interrupted = true;
            return;
        }
        if (m_ipfConfigFileExists) {
            long l = this.file.lastModified();
            if (l > this.m_lastModif) {
                LogIPFLog.debug("LogFileWatchdog::checkAndConfigure() - IPF configure file changed, reconfigure IPF");
                if (0L == this.m_lastModif) {
                    LogIPFLog.debug("LogFileWatchdog::checkAndConfigure() -- first time configure from ipfclientconfig.xml file.");
                    this.shutDownHierarchy();
                }
                this.m_lastModif = l;
                this.doOnChange();
                LogIPFControl.notifyConfigObservers();
            } else {
                LogIPFLog.debug("LogFileWatchdog::checkAndConfigure() - no changes to IPF configure file since last check");
            }
        } else if (0L != this.m_lastModif) {
            LogIPFLog.debug("LogFileWatchdog::checkAndConfigure() - IPF configure file deleted, re-configure IPF with runtime parameters");
            this.m_lastModif = 0L;
            this.shutDownHierarchy();
            try {
                LogIPFConfigure.resumeRNConfig();
                LogIPFControl.notifyConfigObservers();
            }
            catch (Exception meEx) {
                LogIPFLog.warn("LogFileWatchdog::checkAndConfigure() - Exception while resuming to IPF runtime parameters ", meEx);
            }
        }
    }

    @Override
    public void run() {
        LogIPFLog.debug("LogFileWatchdog::run() - watch dog thread started.");
        while (!this.m_interrupted) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                this.m_interrupted = true;
            }
            if (this.m_interrupted) continue;
            this.checkAndConfigure();
        }
        LogIPFLog.debug("LogFileWatchdog::run() - watch dog thread stopped.");
    }

    private synchronized void shutDownHierarchy() {
        Enumeration loggers = LogManager.getCurrentLoggers();
        LogIPFLog.debug("LogFileWatchdog::shutDownHierarchy()");
        while (loggers.hasMoreElements()) {
            Logger tmpLog = (Logger)loggers.nextElement();
            String logName = tmpLog.getName();
            if (!logName.startsWith("Audit") && !logName.startsWith("Perf") && !logName.startsWith("Trace")) continue;
            LogIPFLog.debug("LogFileWatchdog::shutDownHierarchy() - shutting down logger " + logName);
            this.closeNestedAppenders(tmpLog);
            tmpLog.removeAllAppenders();
            tmpLog.setLevel(null);
        }
    }

    private void closeNestedAppenders(Logger tmpLog) {
        Enumeration appList = tmpLog.getAllAppenders();
        if (appList != null) {
            while (appList.hasMoreElements()) {
                Appender a = (Appender)appList.nextElement();
                if (!(a instanceof AppenderAttachable)) continue;
                a.close();
            }
        }
    }
}

