/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.indications.LogIPFLog;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.Consumer;

public class LogFileWatcher
extends Thread {
    private String filePathToWatch;
    Consumer<WatchEvent<Path>> fileChangeListener;

    LogFileWatcher(String pathName, Consumer<WatchEvent<Path>> changeListener) {
        this.filePathToWatch = pathName;
        this.fileChangeListener = changeListener;
    }

    @Override
    public void run() {
        LogIPFLog.debug("LogFileWatcher::run() - file watcher thread started.");
        try {
            WatchKey key;
            boolean valid;
            WatchService watcher = FileSystems.getDefault().newWatchService();
            Path dir = Paths.get(this.filePathToWatch, new String[0]);
            dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            do {
                try {
                    key = watcher.take();
                }
                catch (InterruptedException ex) {
                    LogIPFLog.debug("LogFileWatcher::run() - InterruptedException happend, exit. - " + ex.toString());
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent<?> ev = event;
                    LogIPFLog.debug("LogFileWatcher::run() - The file '" + ev.context() + "' is triggered by event: " + kind.name());
                    this.fileChangeListener.accept(ev);
                }
            } while (valid = key.reset());
            LogIPFLog.debug("LogFileWatcher::run() - the file watcher thread is stopped.");
        }
        catch (IOException e) {
            LogIPFLog.debug("LogFileWatcher::run() - IOException happend, exit file watcher thread. - " + e.toString());
        }
    }
}

