/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogFileWatchdog;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogIPFUtils;
import com.cognos.indications.LogTypedLoggerLegacy;
import com.cognos.indications.dbstore.LogDbStoreFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LogIPFConfigure {
    private static final String APPENDER_REF_TAG = "appender-ref";
    private static final String APPENDER_TAG = "appender";
    private static final String APPENDER_VALUE = "appender";
    private static final String LOGGER_VALUE = "logger";
    private static final String AUDITLEVEL = "logLevel";
    private static final String CLASS_ATTR = "class";
    private static final String CONFIGURATION_TAG = "log4j:configuration";
    private static final String PARAMETER_TAG = "parameter";
    private static final String IPF_TAG = "IPF";
    private static final String LABEL_ATTR = "label";
    private static final String LEVEL_TAG = "level";
    private static final String LAYOUT_TAG = "layout";
    private static final String LOGGER_TAG = "logger";
    private static final String CATEGORY_TAG = "category";
    private static final String LOGSERVERPORT = "logServerPort";
    private static final String NAME_ATTR = "name";
    private static final String PARAM_TAG = "param";
    private static final String FILTER_TAG = "filter";
    private static final String REF_ATTR = "ref";
    private static final String RENDERED_CLASS_ATTR = "renderedClass";
    private static final String RENDERER_TAG = "renderer";
    private static final String RENDERING_CLASS_ATTR = "renderingClass";
    private static final String VALUE_ATTR = "value";
    private static final String VALUE_TAG = "value";
    private static final String UTF8ENCODING_VALUE = "useUTF8Encoding";
    private static final String ENABLE_TCP_VALUE = "enableTCPConnection";
    private static final String ENABLE_SSL_VALUE = "enableServerSSL";
    private static final String WORKER_THREADS_VALUE = "workerThreads";
    private static final String ENABLE_VALUE = "enable";
    private static final String CRN_DBMS_APPENDER_CLASS = "ipf_database";
    private static final String CRN_FILE_APPENDER_CLASS = "file";
    private static final String CRN_NTEVENT_APPENDER_CLASS = "eventLog";
    private static final String CRN_REMOTE_APPENDER_CLASS = "consolidator";
    private static final String CRN_SYSLOG_APPENDER_CLASS = "sysLog";
    private static final String CRN_ZOS_CONSOLE_APPENDER_CLASS = "zosConsoleLog";
    private static final String CRN_ZOS_CONSOLE_APPENDER_NAME = "zosConsoleAppender";
    private static final String CRN_INSTANCE_TAG = "instance";
    private static final String CRN_INSTANCES_TAG = "instances";
    private static final String CRN_PARAMETER_TAG = "parameter";
    private static final String CRN_VALUE_TAG = "value";
    protected static final String FEEDBACK_APPENDER = "FeedbackAppender";
    protected static final Namespace nsCRN = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
    protected static final QName qnParameter = new QName("parameter", nsCRN);
    protected static final QName qnInstances = new QName("instances", nsCRN);
    protected static final QName qnInstance = new QName("instance", nsCRN);
    protected static final QName qnValue = new QName("value", nsCRN);
    private static int m_logServerPort = 9362;
    private static int m_logFeedbackPort = 9363;
    protected static int m_dispatcherPort = 9300;
    private static int m_serverWorkerThreads = 10;
    protected static boolean useEncryption = true;
    private static String auditLevel = "5";
    private static String auditRTUsageLevel = "";
    private static String auditAdminLevel = "";
    private static String auditOtherLevel = "";
    private static boolean m_useUTF8Encoding;
    private static boolean m_useTCPProtocol;
    private static boolean m_useSSL;
    private static boolean m_nativeQuery;
    private static boolean firstRuntimeInit;
    private static boolean m_firstRuntimeInit;
    public static Properties IPFPropRead;
    protected static int DispatcherID;
    private static String m_dbInitializationStatus;
    private static String m_dbURL;
    private static String m_dbUser;
    private static String m_dbErrMessage;
    private static boolean m_serverFileAppenderExists;
    private static boolean m_serverDBAppenderExists;
    private static boolean m_serverDBAppenderDefined;
    private static boolean m_serverRemoteAppenderExists;
    private static boolean m_serverZosConsoleAppenderExists;
    private static boolean m_serverNTAppenderExists;
    private static boolean m_serverSyslogAppenderExists;
    private static int m_numberOfServerAppenders;
    private static Map m_compServiceMap;
    private static Map m_serviceLevelMap;

    protected static native int getDispatcherPID();

    private static String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static boolean useUTF8encoding() {
        return m_useUTF8Encoding;
    }

    public static boolean isNativeQueryEnabled() {
        return m_nativeQuery;
    }

    public static boolean enableTCP() {
        return m_useTCPProtocol;
    }

    public static boolean enableSSL() {
        return m_useSSL;
    }

    public static int getServerPort() {
        return m_logServerPort;
    }

    protected static int getDispatcherPort() {
        return m_dispatcherPort;
    }

    protected static int getFeedbackPort() {
        return m_logFeedbackPort;
    }

    public static int getServerWorkerThreads() {
        return m_serverWorkerThreads;
    }

    public static void setProcessID(int procID) {
        DispatcherID = procID;
    }

    private static boolean iniRuntimeBering(ICCLConfiguration cclConfig) throws CCLConfigurationException {
        LogIPFLog.debug("LogIPFConfiguration::iniRuntimeBering(cclConfig) - begin.");
        if (m_firstRuntimeInit) {
            try {
                LogIPFConfigure.initializeIPFBootstrapParams(cclConfig, null);
            }
            catch (CCLConfigurationException e) {
                LogIPFLog.warn("LogIPFConfiguration::iniRuntimeBering(cclConfig) - Failed to get AUDIT LEVEL(S) from ICCLConfiguration; error ", e);
                throw e;
            }
        }
        Set services = m_serviceLevelMap.keySet();
        Iterator servIter = services.iterator();
        String auditLevel = "";
        while (servIter.hasNext()) {
            try {
                String servName = (String)servIter.next();
                auditLevel = cclConfig.getValue(servName + "AuditLevel", true);
                LogIPFLog.debug("LogIPFConfiguration::iniRuntimeBering(cclConfig) - For service [" + servName + "] level is [" + auditLevel + "]");
                if (null == auditLevel || auditLevel.length() == 0) continue;
                m_serviceLevelMap.put(servName, auditLevel);
            }
            catch (CCLConfigurationException e) {
                LogIPFLog.error("LogIPFConfiguration::iniRuntimeBering(cclConfig) - Failed to get AUDIT LEVEL(S) from ICCLConfiguration; error ", e);
                throw e;
            }
        }
        if (!m_firstRuntimeInit) {
            LogIPFLog.debug("LogIPFConfiguration::iniRuntimeBering(cclConfig) - NOT firstRuntimeInit, update loggers and return false.");
            LogIPFConfigure.updateServiceLoggers();
            LogIPFConfigure.update3rdpartyLoggers();
            LogIPFControl.notifyConfigObservers();
            return false;
        }
        LogIPFLog.debug("LogIPFConfiguration::iniRuntimeBering(cclConfig) - end.");
        return true;
    }

    public static synchronized void serverInit(ICCLConfiguration cclConfig) throws CCLConfigurationException {
        LogIPFLog.debug("LogIPFConfiguration::serverInit(cclConfig) - begin");
        if (cclConfig == null) {
            LogIPFLog.debug("LogIPFConfiguration::serverInit(cclConfig) - called with a NULL ICCLConfiguration, return");
            return;
        }
        LinkedList instanceElementList = new LinkedList();
        try {
            LogIPFConfigure.initializeIPFBootstrapParams(cclConfig, instanceElementList);
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogIPFConfiguration::serverInit(cclConfig) - exception while calling initializeIPFBootstrapParams(): ", e);
            throw e;
        }
        Document doc = DocumentHelper.createDocument();
        LogIPFConfigure.generateServerDOM(doc, instanceElementList);
        DOMConfigurator.configure((Element)LogIPFConfigure.getDocAsW3C(doc).getDocumentElement());
        LogManager.getLogger((String)"server").setAdditivity(false);
        LogIPFLog.debug("LogIPFConfiguration::serverInit(cclConfig) - end.");
    }

    protected static void clientIniBering(ICCLConfiguration cclConfig) throws CCLConfigurationException {
        LogIPFLog.debug("LogIPFConfiguration::clientIniBering(cclConfig) - begin.");
        if (LogFileWatchdog.m_ipfConfigFileExists || LogIPFControl.isInitUsingConfigFile()) {
            LogIPFLog.debug("LogIPFConfiguration::clientIniBering(cclConfig) - ipfConfigFileExists, or IPF is initialized by an specified config file, return.");
            return;
        }
        Document doc = DocumentHelper.createDocument();
        if (cclConfig == null) {
            LogIPFLog.debug("LogIPFConfiguration::clientIniBering(cclConfig) - Initializing IPF client with default configuration ");
            LogIPFConfigure.generateDefaultClientDOM(doc);
        } else {
            try {
                boolean initStat = LogIPFConfigure.iniRuntimeBering(cclConfig);
                if (!initStat) {
                    LogIPFLog.debug("LogIPFConfiguration::clientIniBering(cclConfig) - calling iniRuntimeBering(cclConfig) and return false, return ");
                    return;
                }
                if (m_firstRuntimeInit) {
                    m_firstRuntimeInit = false;
                }
                LogIPFConfigure.generateClientDOMBe(doc);
            }
            catch (CCLConfigurationException e) {
                LogIPFLog.error("LogIPFConfiguration::clientIniBering(cclConfig) - exception: ", e);
                throw e;
            }
        }
        DOMConfigurator.configure((Element)LogIPFConfigure.getDocAsW3C(doc).getDocumentElement());
        Logger tmpLog = LogManager.exists((String)"Audit");
        if (null != tmpLog) {
            tmpLog.setAdditivity(false);
        }
        if (null != (tmpLog = LogManager.exists((String)"Perf"))) {
            tmpLog.setLevel(Level.OFF);
            tmpLog.setAdditivity(false);
        }
        if (null != (tmpLog = LogManager.exists((String)"Trace"))) {
            tmpLog.setLevel(Level.OFF);
            tmpLog.setAdditivity(false);
        }
        if (cclConfig != null) {
            LogIPFConfigure.updateServiceLoggers();
            LogIPFConfigure.update3rdpartyLoggers();
            LogIPFControl.notifyConfigObservers();
        }
        LogIPFLog.debug("LogIPFConfiguration::clientIniBering(cclConfig) - end.");
    }

    protected static synchronized void resumeRNConfig() throws CCLConfigurationException {
        LogIPFLog.debug("LogIPFConfiguration::resumeRNConfig() - begin.");
        Document doc = DocumentHelper.createDocument();
        ICCLConfiguration myConf = CCLConfigurationFactory.getInstance();
        m_firstRuntimeInit = true;
        try {
            boolean initStat = LogIPFConfigure.iniRuntimeBering(myConf);
            if (!initStat) {
                LogIPFLog.debug("LogIPFConfiguration::resumeRNConfig() - calling initWithRuntime(cclconfig) return false, return.");
                return;
            }
            m_firstRuntimeInit = false;
            LogIPFConfigure.generateClientDOMBe(doc);
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogIPFConfiguration::resumeRNConfig() - exception: ", e);
            throw e;
        }
        DOMConfigurator.configure((Element)LogIPFConfigure.getDocAsW3C(doc).getDocumentElement());
        Logger tmpLog = LogManager.exists((String)"Audit");
        if (null != tmpLog) {
            tmpLog.setAdditivity(false);
        }
        if (null != (tmpLog = LogManager.exists((String)"Perf"))) {
            tmpLog.setLevel(Level.OFF);
            tmpLog.setAdditivity(false);
        }
        if (null != (tmpLog = LogManager.exists((String)"Trace"))) {
            tmpLog.setLevel(Level.OFF);
            tmpLog.setAdditivity(false);
        }
        LogIPFConfigure.update3rdpartyLoggers();
        LogIPFConfigure.updateServiceLoggers();
        LogIPFLog.debug("LogIPFConfiguration::resumeRNConfig() - end.");
    }

    protected static org.w3c.dom.Document getDocAsW3C(Document doc) {
        int XML_DOC_SIZE = 8192;
        org.w3c.dom.Document w3cDoc = null;
        try {
            StringWriter sw = new StringWriter(8192);
            XMLWriter writer = new XMLWriter((Writer)sw);
            writer.write(doc);
            writer.close();
            String sResultXML = sw.toString();
            StringReader read = new StringReader(sResultXML);
            DocumentBuilderFactory build = DocumentBuilderFactory.newInstance();
            DocumentBuilder docbuilder = build.newDocumentBuilder();
            InputSource input = new InputSource(read);
            w3cDoc = docbuilder.parse(input);
        }
        catch (Exception e) {
            LogIPFLog.debug("LogIPFConfiguration::getDocAsW3C - Exception encountered while trying to convert configuration document into W3C Document: ", e);
        }
        return w3cDoc;
    }

    private static void generateServerDOM(Document doc, List instanceElementList) {
        LogIPFLog.debug("LogIPFConfiguration::generateServerDOM() - begin.");
        LogIPFConfigure.createRootElement(doc);
        LogIPFConfigure.createAllRenderers(doc);
        if (null == instanceElementList) {
            LogIPFLog.warn("LogIPFConfiguration::generateServerDOM() - Logserver initialization: No appenders added");
            return;
        }
        LinkedList<String> appenderNameList = new LinkedList<String>();
        LogIPFConfigure.addAppenders(instanceElementList, doc, appenderNameList);
        LogIPFConfigure.addZOSAppender(doc, appenderNameList);
        LogIPFConfigure.addCNFGFeedbackAppender(doc, appenderNameList);
        LogIPFConfigure.addCustomizedAppenders(doc, appenderNameList);
        if (0 == m_numberOfServerAppenders) {
            LogIPFLog.debug("LogIPFConfiguration::generateServerDOM() - No server appenders are added. ");
        }
        LogIPFConfigure.createLoggerInstance(doc, "server", "5", appenderNameList);
        appenderNameList.clear();
        appenderNameList = null;
        LogIPFLog.debug("LogIPFConfiguration::generateServerDOM() - end.");
    }

    private static void addAppenders(List instanceElementList, Document doc, LinkedList<String> appenderNameList) {
        int length = instanceElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            org.dom4j.Element instanceElement = (org.dom4j.Element)instanceElementList.get(loop);
            if (null == instanceElement) continue;
            String classAttr = instanceElement.attribute(CLASS_ATTR).getValue();
            String nameAttr = instanceElement.attribute(NAME_ATTR).getValue();
            if (null == classAttr || null == nameAttr) continue;
            boolean appenderSuccessfullyCreated = false;
            if (classAttr.equalsIgnoreCase(CRN_DBMS_APPENDER_CLASS)) {
                org.dom4j.Element databaseInstancesElement = instanceElement.element(qnInstances);
                org.dom4j.Element databaseInstanceElement = databaseInstancesElement.element(qnInstance);
                m_serverDBAppenderDefined = true;
                appenderSuccessfullyCreated = LogIPFConfigure.createJDBCAppender(doc, nameAttr, databaseInstanceElement);
                if (!appenderSuccessfullyCreated) continue;
                appenderNameList.add(nameAttr);
                ++m_numberOfServerAppenders;
                m_serverDBAppenderExists = true;
                continue;
            }
            List instanceParameterElementList = instanceElement.elements(qnParameter);
            if (classAttr.equalsIgnoreCase(CRN_FILE_APPENDER_CLASS)) {
                appenderSuccessfullyCreated = LogIPFConfigure.createFileAppender(doc, nameAttr, instanceParameterElementList);
                if (!appenderSuccessfullyCreated) continue;
                appenderNameList.add(nameAttr);
                ++m_numberOfServerAppenders;
                m_serverFileAppenderExists = true;
                continue;
            }
            if (classAttr.equalsIgnoreCase(CRN_NTEVENT_APPENDER_CLASS)) {
                appenderSuccessfullyCreated = LogIPFConfigure.createNTEventLogAppender(doc, nameAttr, instanceParameterElementList);
                if (!appenderSuccessfullyCreated) continue;
                appenderNameList.add(nameAttr);
                ++m_numberOfServerAppenders;
                m_serverNTAppenderExists = true;
                continue;
            }
            if (classAttr.equalsIgnoreCase(CRN_SYSLOG_APPENDER_CLASS)) {
                appenderSuccessfullyCreated = LogIPFConfigure.createSyslogAppender(doc, nameAttr, instanceParameterElementList);
                if (!appenderSuccessfullyCreated) continue;
                appenderNameList.add(nameAttr);
                ++m_numberOfServerAppenders;
                m_serverSyslogAppenderExists = true;
                continue;
            }
            if (!classAttr.equalsIgnoreCase(CRN_REMOTE_APPENDER_CLASS) || !(appenderSuccessfullyCreated = LogIPFConfigure.createTcpAppender(doc, nameAttr, instanceParameterElementList))) continue;
            appenderNameList.add(nameAttr);
            ++m_numberOfServerAppenders;
            m_serverRemoteAppenderExists = true;
        }
    }

    private static void addZOSAppender(Document doc, LinkedList<String> appenderNameList) {
        boolean appenderSuccessfullyCreated;
        String platform = System.getProperty("os.name");
        if (platform.equals("z/OS") && (appenderSuccessfullyCreated = LogIPFConfigure.createZosConsoleAppender(doc, CRN_ZOS_CONSOLE_APPENDER_NAME))) {
            appenderNameList.add(CRN_ZOS_CONSOLE_APPENDER_NAME);
            ++m_numberOfServerAppenders;
            m_serverZosConsoleAppenderExists = true;
        }
    }

    private static void addCNFGFeedbackAppender(Document doc, LinkedList<String> appenderNameList) {
        org.dom4j.Element cnfgAppenderElement = DocumentHelper.createElement((String)"appender");
        LogIPFConfigure.createAppenderElement(FEEDBACK_APPENDER, "com.cognos.indications.LogLocalUDPAppender", cnfgAppenderElement);
        LogIPFConfigure.addParameterNameStringValue("Port", String.valueOf(m_logFeedbackPort), cnfgAppenderElement);
        LogIPFConfigure.addParameterNameStringValue("Threshold", "fatal", cnfgAppenderElement);
        LogIPFConfigure.addFilterParamsNameValue(cnfgAppenderElement, "org.apache.log4j.varia.StringMatchFilter", "StringToMatch", "UpgradeDetails", "AcceptOnMatch", "false");
        doc.getRootElement().add(cnfgAppenderElement);
        appenderNameList.add(FEEDBACK_APPENDER);
    }

    private static void addCustomizedAppenders(Document doc, LinkedList<String> appenderNameList) {
        String pathName = CCLConfigurationFactory.getInstance().resolveEffectivePath("../configuration/logging/plugins");
        File loggingPluginPath = new File(pathName);
        if (!loggingPluginPath.exists()) {
            LogIPFLog.debug("LogIPFConfigure:addCustomizedAppenders - The logging plugin path 'configuration/logging/plugins' doesn't exist. Skip loading cusomized apppenders.");
            return;
        }
        ArrayList<File> pluginFiles = LogIPFUtils.getXmlFiles(loggingPluginPath);
        for (int i = 0; i < pluginFiles.size(); ++i) {
            File fPluginFile = pluginFiles.get(i);
            if (fPluginFile == null) continue;
            LogIPFConfigure.parseCustomizedAppender(doc, appenderNameList, fPluginFile);
        }
    }

    private static void parseCustomizedAppender(Document doc, LinkedList<String> appenderNameList, File pluginFile) {
        if (pluginFile == null || !pluginFile.exists()) {
            return;
        }
        Namespace log4jns = new Namespace("log4j", "http://jakarta.apache.org/log4j/");
        EntityResolver resolver = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId.endsWith("log4j.dtd")) {
                    Class<?> clazz = this.getClass();
                    InputStream in = clazz.getResourceAsStream("/com/cognos/indications/log4j.dtd");
                    return new InputSource(in);
                }
                return null;
            }
        };
        try {
            SAXReader reader = new SAXReader();
            reader.setEntityResolver(resolver);
            Document dom = reader.read(pluginFile);
            org.dom4j.Element rootElement = dom.getRootElement();
            if (null != rootElement && rootElement.getName().equals("configuration") && rootElement.getNamespace().equals((Object)log4jns)) {
                List appenderList = rootElement.elements("appender");
                for (org.dom4j.Element appenderElement : appenderList) {
                    String appenderName;
                    if (appenderElement == null || (appenderName = appenderElement.attributeValue(NAME_ATTR)) == null || appenderName.length() <= 0) continue;
                    appenderElement.detach();
                    doc.getRootElement().add(appenderElement);
                    appenderNameList.add(appenderName);
                    LogIPFLog.debug("LogIPFConfiguration::parseCustomizedAppender() - Added customized appender '" + appenderName + "' from '" + pluginFile.getAbsolutePath() + "'.");
                }
            }
        }
        catch (Exception e) {
            LogIPFLog.error("LogIPFConfiguration::parseCustomizedAppender() - Failed to add customized appender from '" + pluginFile.getAbsolutePath() + "'.", e);
        }
    }

    private static void generateClientDOMBe(Document doc) {
        LogIPFLog.debug("LogIPFConfiguration::generateClientDOMBe() - begin.");
        try {
            LogIPFConfigure.createRootElement(doc);
            LogIPFConfigure.createAllRenderers(doc);
            org.dom4j.Element appenderElement = DocumentHelper.createElement((String)"appender");
            if (!m_useTCPProtocol) {
                LogIPFConfigure.createAppenderElement("clientRemote", "com.cognos.indications.LogLocalUDPAppender", appenderElement);
                LogIPFConfigure.addParameterNameStringValue("Port", String.valueOf(m_logServerPort), appenderElement);
            } else {
                LogIPFConfigure.createAppenderElement("clientRemote", "com.cognos.indications.LogTCPSocketAppender", appenderElement);
                String ipaddrStr = new String();
                try {
                    ipaddrStr = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception e) {
                    LogIPFLog.warn("LogIPFConfiguration::generateClientDOMBe() - exception while get IP address: ", e);
                }
                LogIPFConfigure.addParameterNameStringValue("remoteHost", ipaddrStr, appenderElement);
                LogIPFConfigure.addParameterNameStringValue("Port", String.valueOf(m_logServerPort), appenderElement);
                if (m_useSSL) {
                    LogIPFConfigure.addParameterNameStringValue("Secure", "true", appenderElement);
                } else {
                    LogIPFConfigure.addParameterNameStringValue("Secure", "false", appenderElement);
                }
            }
            doc.getRootElement().add(appenderElement);
            appenderElement = null;
            LinkedList<String> clientAppenderList = new LinkedList<String>();
            clientAppenderList.add("clientRemote");
            LogIPFConfigure.createLoggerInstance(doc, "Audit", "1", clientAppenderList);
            Object var2_3 = null;
        }
        catch (Exception ex) {
            LogIPFLog.error("LogIPFConfiguration::generateClientDOMBe() - exception while generate client dom: ", ex);
        }
        LogIPFLog.debug("LogIPFConfiguration::generateClientDOMBe() - end.");
    }

    private static void generateDefaultClientDOM(Document doc) {
        LogIPFLog.debug("LogIPFConfiguration::generateDefaultClientDOM() - begin.");
        try {
            String appenderFilename;
            LogIPFConfigure.createRootElement(doc);
            LogIPFConfigure.createAllRenderers(doc);
            org.dom4j.Element fileAppenderElement = DocumentHelper.createElement((String)"appender");
            LogIPFConfigure.createAppenderElement("clientFile", "org.apache.log4j.RollingFileAppender", fileAppenderElement);
            ICCLConfiguration myConf = CCLConfigurationFactory.createConfiguration();
            try {
                myConf.init();
                appenderFilename = myConf.resolveEffectivePath("../logs/cogaudit_default.log");
            }
            catch (CCLConfigurationException e) {
                LogIPFLog.error("LogIPFConfiguration::generateDefaultClientDOM() - ICCLConfiguration.init() call failed - cogaudit_default.log has a relative path", e);
                appenderFilename = "../logs/cogaudit_default.log";
            }
            LogIPFConfigure.addParameterNameStringValue("File", LogIPFConfigure.convertToUnixStyleSep(appenderFilename), fileAppenderElement);
            LogIPFConfigure.addParameterNameStringValue("MaximumFileSize", "10485760", fileAppenderElement);
            LogIPFConfigure.addParameterNameStringValue("MaxBackupIndex", "1", fileAppenderElement);
            LogIPFConfigure.addLayoutTag("%m%n", fileAppenderElement);
            doc.getRootElement().add(fileAppenderElement);
            org.dom4j.Element cnfgAppenderElement = DocumentHelper.createElement((String)"appender");
            LogIPFConfigure.createAppenderElement(FEEDBACK_APPENDER, "com.cognos.indications.LogLocalUDPAppender", cnfgAppenderElement);
            LogIPFConfigure.addParameterNameStringValue("Port", String.valueOf(m_logFeedbackPort), cnfgAppenderElement);
            LogIPFConfigure.addParameterNameStringValue("Threshold", "fatal", cnfgAppenderElement);
            doc.getRootElement().add(cnfgAppenderElement);
            LinkedList<String> clientAppenderList = new LinkedList<String>();
            clientAppenderList.add("clientFile");
            clientAppenderList.add(FEEDBACK_APPENDER);
            LogIPFConfigure.createLoggerInstance(doc, "Audit", "1", clientAppenderList);
            LogIPFConfigure.createLoggerInstance(doc, "Perf", "0", clientAppenderList);
            LogIPFConfigure.createLoggerInstance(doc, "Trace", "0", clientAppenderList);
            clientAppenderList = null;
        }
        catch (Exception ex) {
            LogIPFLog.error("LogIPFConfiguration::generateDefaultClientDOM() - exception while generate default client dom: ", ex);
        }
        LogIPFLog.debug("LogIPFConfiguration::generateDefaultClientDOM() - end.");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static HashMap<String, String> parseDBParameters(org.dom4j.Element dbInstanceElement) {
        int dbType;
        String dbConnectionStringUpd;
        String dbsslencryptionenabled;
        HashMap<String, String> dbParameterMap;
        block30: {
            int noOfTokens;
            StringTokenizer st;
            String databaseSpecifier;
            String databaseName;
            String serverHost;
            String databaseType;
            block34: {
                boolean isDB2Type2;
                block33: {
                    block32: {
                        block31: {
                            dbParameterMap = new HashMap<String, String>();
                            databaseType = dbInstanceElement.attributeValue(CLASS_ATTR);
                            List dbInstanceParameterElementList = dbInstanceElement.elements(qnParameter);
                            int length = dbInstanceParameterElementList.size();
                            serverHost = "";
                            databaseName = "";
                            databaseSpecifier = "";
                            dbsslencryptionenabled = "";
                            dbParameterMap.put("username", "");
                            dbParameterMap.put("password", "");
                            dbParameterMap.put("server", serverHost);
                            dbParameterMap.put(NAME_ATTR, databaseName);
                            dbParameterMap.put("specifier", databaseSpecifier);
                            dbParameterMap.put("sslencryptionenabled", dbsslencryptionenabled);
                            for (int loop = 0; loop < length; ++loop) {
                                org.dom4j.Element dbInstanceParameterElement = (org.dom4j.Element)dbInstanceParameterElementList.get(loop);
                                String nameAttr = dbInstanceParameterElement.attributeValue(NAME_ATTR);
                                if (null == nameAttr) continue;
                                org.dom4j.Element valueElement = dbInstanceParameterElement.element(qnValue);
                                if (nameAttr.equalsIgnoreCase("user")) {
                                    org.dom4j.Element credentialElement = valueElement.element("credential");
                                    String dbUser = credentialElement.elementText("username");
                                    m_dbUser = dbUser != null ? dbUser : "";
                                    String dbPassword = credentialElement.elementText("password");
                                    dbParameterMap.put("username", dbUser != null ? dbUser : "");
                                    dbParameterMap.put("password", dbPassword != null ? dbPassword : "");
                                    continue;
                                }
                                if (nameAttr.equalsIgnoreCase("server")) {
                                    serverHost = valueElement.getText();
                                    dbParameterMap.put("server", serverHost != null ? serverHost : "");
                                    continue;
                                }
                                if (nameAttr.equalsIgnoreCase(NAME_ATTR)) {
                                    databaseName = valueElement.getText();
                                    dbParameterMap.put(NAME_ATTR, databaseName != null ? databaseName : "");
                                    continue;
                                }
                                if (nameAttr.equalsIgnoreCase("specifier")) {
                                    databaseSpecifier = valueElement.getText();
                                    dbParameterMap.put("specifier", databaseSpecifier != null ? databaseSpecifier : "");
                                    continue;
                                }
                                if (nameAttr.equalsIgnoreCase("servicename")) {
                                    databaseName = valueElement.getText();
                                    dbParameterMap.put(NAME_ATTR, databaseName != null ? databaseName : "");
                                    continue;
                                }
                                if (!nameAttr.equalsIgnoreCase("SSLencryptionEnabled")) continue;
                                dbsslencryptionenabled = valueElement.getText();
                                dbParameterMap.put("sslencryptionenabled", dbsslencryptionenabled != null ? dbsslencryptionenabled : "");
                            }
                            String driverString = IPFPropRead.getProperty("IPFDbDriver" + databaseType);
                            dbParameterMap.put("driver", driverString);
                            if (null == driverString) {
                                LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - IPFInternal.properties file is missing the " + databaseType + " driver");
                                LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - Available properties are:");
                                Enumeration<?> e = IPFPropRead.propertyNames();
                                while (true) {
                                    if (!e.hasMoreElements()) {
                                        return dbParameterMap;
                                    }
                                    LogIPFLog.debug(e.nextElement().toString());
                                }
                            }
                            String dbConnectionString = "";
                            isDB2Type2 = false;
                            if (databaseType.equalsIgnoreCase("db2") && serverHost.length() == 0) {
                                dbConnectionString = IPFPropRead.getProperty("IPFDatabase" + databaseType + "Type2");
                                isDB2Type2 = true;
                            } else {
                                dbConnectionString = IPFPropRead.getProperty("IPFDatabase" + databaseType);
                            }
                            if (null == dbConnectionString) {
                                LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - IPFInternal.properties file is missing the " + databaseType + " connection string");
                                dbParameterMap.put("connection_string", null);
                                return dbParameterMap;
                            }
                            st = new StringTokenizer(dbConnectionString, "{}", false);
                            noOfTokens = st.countTokens();
                            dbConnectionStringUpd = st.nextToken();
                            st.nextToken();
                            dbType = 0;
                            if (!databaseType.equalsIgnoreCase("microsoft") || noOfTokens != 4) break block31;
                            dbType = 2;
                            if (serverHost.length() == 0) {
                                LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - failed to read the MSSQLDB database server and port from CFGAPI");
                                dbParameterMap.put("connection_string", null);
                                return dbParameterMap;
                            }
                            dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                            LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - MSSQL db connection string : " + dbConnectionStringUpd);
                            break block30;
                        }
                        if (!databaseType.equalsIgnoreCase("microsoftwinauth") || noOfTokens != 5) break block32;
                        dbType = 7;
                        if (serverHost.length() == 0) {
                            LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - failed to read the SSQLWinAuthDB database server and port from CFGAPI");
                            dbParameterMap.put("connection_string", null);
                            return dbParameterMap;
                        }
                        dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                        st.nextToken();
                        dbConnectionStringUpd = dbConnectionStringUpd + st.nextToken();
                        LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - MSSQL WinAuth connection string : " + dbConnectionStringUpd);
                        break block30;
                    }
                    if (!databaseType.equalsIgnoreCase("oracle") || noOfTokens != 4) break block33;
                    dbType = 1;
                    dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                    LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - Oracle db connection string : " + dbConnectionStringUpd);
                    break block30;
                }
                if (!databaseType.equalsIgnoreCase("db2")) break block34;
                dbType = 3;
                if (isDB2Type2 && noOfTokens == 3) {
                    dbConnectionStringUpd = dbConnectionStringUpd + databaseName + st.nextToken();
                    LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - DB2 db connection string with no sever(Type 2): " + dbConnectionStringUpd);
                    break block30;
                } else if (!isDB2Type2 && noOfTokens == 5) {
                    dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                    st.nextToken();
                    dbConnectionStringUpd = dbConnectionStringUpd + st.nextToken();
                    LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - DB2 db connection string with sever(Type 4): " + dbConnectionStringUpd);
                    break block30;
                } else {
                    LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - DB2 database connection string is wrong:" + dbConnectionStringUpd);
                    dbParameterMap.put("connection_string", null);
                    return dbParameterMap;
                }
            }
            if (databaseType.equalsIgnoreCase("informix") && noOfTokens == 5) {
                dbType = 8;
                dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                st.nextToken();
                dbConnectionStringUpd = dbConnectionStringUpd + st.nextToken();
                LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - Informix db connection string : " + dbConnectionStringUpd);
            } else if (databaseType.equalsIgnoreCase("oracleadvanced") && noOfTokens == 2) {
                dbType = 4;
                dbConnectionStringUpd = dbConnectionStringUpd + databaseSpecifier;
                LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - Oracle Advanced db connection string : " + dbConnectionStringUpd);
            } else if (databaseType.equalsIgnoreCase("sybase") && noOfTokens == 4) {
                dbType = 5;
                if (serverHost.length() == 0) {
                    LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - failed to read the SybaseDB database server and port from CFGAPI");
                    dbParameterMap.put("connection_string", null);
                    return dbParameterMap;
                }
                dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - Sybase db connection string : " + dbConnectionStringUpd);
            } else if (databaseType.equalsIgnoreCase("derby") && noOfTokens == 4) {
                dbType = 6;
                if (serverHost.length() == 0) {
                    LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - failed to read the DerbyDB database server and port from CFGAPI");
                    dbParameterMap.put("connection_string", null);
                    return dbParameterMap;
                }
                dbConnectionStringUpd = dbConnectionStringUpd + serverHost + st.nextToken() + databaseName;
                LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - Derby db connection string : " + dbConnectionStringUpd);
            } else {
                LogIPFLog.warn("LogIPFConfiguration::parseDBParameters() - IPFInternal.properties file has corrupted entry for " + databaseType + " connection string");
                dbParameterMap.put("connection_string", null);
                return dbParameterMap;
            }
        }
        if (dbsslencryptionenabled != null && dbsslencryptionenabled.equalsIgnoreCase("true")) {
            dbConnectionStringUpd = LogIPFConfigure.enableDBSSLEncryption(dbConnectionStringUpd, dbType);
            LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - enable db ssl encryption: " + dbConnectionStringUpd);
        } else {
            LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - do not enable db ssl encryption:" + dbConnectionStringUpd);
        }
        dbParameterMap.put("type", String.valueOf(dbType));
        dbParameterMap.put("connection_string", dbConnectionStringUpd);
        return dbParameterMap;
    }

    protected static boolean createJDBCAppender(Document doc, String appenderName, org.dom4j.Element dbInstanceElement) {
        LogDbStoreFactory newFactory = new LogDbStoreFactory();
        return LogIPFConfigure.createJDBCAppender(doc, appenderName, dbInstanceElement, newFactory);
    }

    protected static boolean createJDBCAppender(Document doc, String appenderName, org.dom4j.Element dbInstanceElement, LogDbStoreFactory newFactory) {
        LogIPFLog.debug("LogIPFConfiguration::createJDBCAppender() - begin.");
        org.dom4j.Element appenderElement = doc.getRootElement().addElement("appender");
        LogIPFConfigure.createAppenderElement(appenderName, "com.cognos.indications.LogJDBCAppender", appenderElement);
        m_dbInitializationStatus = "FAILED";
        HashMap<String, String> dbParameterMap = LogIPFConfigure.parseDBParameters(dbInstanceElement);
        String serverHost = dbParameterMap.get("server");
        String databaseName = dbParameterMap.get(NAME_ATTR);
        String dbUser = dbParameterMap.get("username");
        String dbPassword = dbParameterMap.get("password");
        String dbType = dbParameterMap.get("type");
        LogIPFConfigure.addParameterNameStringValue("User", dbUser, appenderElement);
        newFactory.setUser(dbUser);
        LogIPFConfigure.addParameterNameStringValue("Password", dbPassword, appenderElement);
        newFactory.setPassword(dbPassword);
        newFactory.setType(Integer.parseInt(dbType));
        String driverString = dbParameterMap.get("driver");
        if (null == driverString) {
            m_dbURL = serverHost + " " + databaseName;
            LogIPFLog.debug("LogIPFConfiguration::createJDBCAppender() - DB driver is invalid. Set m_dbURL to '" + m_dbURL + "', return false");
            return false;
        }
        LogIPFConfigure.addParameterNameStringValue("Driver", driverString, appenderElement);
        newFactory.setDriver(driverString);
        LogIPFLog.debug("LogIPFConfiguration::createJDBCAppender() - Setting DB Driver to: " + driverString);
        String dbConnectionString = dbParameterMap.get("connection_string");
        if (null == dbConnectionString) {
            m_dbURL = serverHost + " " + databaseName;
            LogIPFLog.debug("LogIPFConfiguration::createJDBCAppender() - DB connection string is invalid. Set m_dbURL to '" + m_dbURL + "', return false");
            return false;
        }
        LogIPFLog.debug("LogIPFConfiguration::createJDBCAppender() - Setting DB Connection to: " + dbConnectionString);
        if (dbConnectionString.indexOf(92) >= 0) {
            String from = new String("\\");
            String to = new String("\\\\");
            String tDbString = LogIPFConfigure.replace(dbConnectionString, from, to);
            LogIPFLog.debug("LogIPFConfiguration::parseDBParameters() - Replaced DB string [" + dbConnectionString + "] with [" + tDbString + "]");
            LogIPFConfigure.addParameterNameStringValue("URL", tDbString, appenderElement);
        } else {
            LogIPFConfigure.addParameterNameStringValue("URL", dbConnectionString, appenderElement);
        }
        newFactory.setURL(dbConnectionString);
        m_dbURL = dbConnectionString;
        LogIPFConfigure.addParameterNameStringValue("DBType", dbType, appenderElement);
        try {
            newFactory.init();
        }
        catch (Exception e) {
            m_dbErrMessage = e.getMessage();
            LogIPFLog.error("LogIPFConfiguration::createJDBCAppender() - Call to LogDBStoreFactory.init() failed for database: " + databaseName, e);
            return false;
        }
        LogIPFConfigure.addFilterParamsNameValue(appenderElement, "org.apache.log4j.varia.StringMatchFilter", "StringToMatch", "server.Audit.IPF", "AcceptOnMatch", "false");
        m_dbInitializationStatus = "SUCCESS";
        LogIPFLog.debug("LogIPFConfiguration::createJDBCAppender() - end.");
        return true;
    }

    private static String enableDBSSLEncryption(String dbURL, int dbType) {
        StringBuffer tmp = new StringBuffer(dbURL);
        if (dbType == 2 || dbType == 7) {
            String ssl = IPFPropRead.getProperty("IPFDatabaseMicrosoftSSL");
            tmp.append(ssl);
        } else if (dbType == 3 || dbType == 8) {
            String ssl = IPFPropRead.getProperty("IPFDatabaseDB2SSL");
            tmp.append(ssl);
        } else if (dbType == 5) {
            tmp.append("?SYBSOCKET_FACTORY=com.cognos.indications.utils.SybaseSSLSocketFactory");
        } else if (dbType == 4) {
            LogIPFConfigure.addOraclePKIProvider();
        }
        return tmp.toString();
    }

    private static void addOraclePKIProvider() {
        try {
            String oraclePKIProviderClassPath = IPFPropRead.getProperty("OraclePKIProvider");
            Security.addProvider((Provider)Class.forName(oraclePKIProviderClassPath).newInstance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void setUseEncryptonForTesting(boolean useEnc) {
        useEncryption = useEnc;
    }

    public static org.dom4j.Element parseIPFStartupParams(ICCLConfiguration cclConfig, List instanceElementList) throws CCLConfigurationException {
        org.dom4j.Element configElement;
        LogIPFLog.debug("LogIPFConfiguration::parseIPFStartupParams() - start.");
        if (cclConfig == null) {
            LogIPFLog.error("LogIPFConfiguration::parseIPFStartupParams() - ICCLConfiguration is null.");
            throw new CCLConfigurationException(9);
        }
        try {
            configElement = cclConfig.getValueElement(IPF_TAG, useEncryption);
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogIPFConfiguration::parseIPFStartupParams() - Failed to read IPF startup parameters from ICCLConfiguration; error ", e);
            throw e;
        }
        if (null == configElement) {
            LogIPFLog.error("LogIPFConfiguration::parseIPFStartupParams() - ICCLConfiguration returned no IPF startup parameters");
            throw new CCLConfigurationException(9);
        }
        if (null != instanceElementList) {
            List instancesElementList = configElement.elements(qnInstances);
            int length = instancesElementList.size();
            for (int loop = 0; loop < length; ++loop) {
                org.dom4j.Element instancesElement = (org.dom4j.Element)instancesElementList.get(loop);
                String nameAttr = instancesElement.attributeValue(NAME_ATTR);
                if (null == nameAttr || !nameAttr.equals("appender")) continue;
                instanceElementList.addAll(instancesElement.elements(qnInstance));
                break;
            }
        }
        LogIPFLog.debug("LogIPFConfiguration::parseIPFStartupParams() - end.");
        return configElement;
    }

    private static void verifyPath(String pathStr) {
        File parentPath = new File(pathStr).getParentFile();
        if (!parentPath.exists()) {
            parentPath.mkdirs();
        }
    }

    private static boolean createFileAppender(Document doc, String appenderName, List parameterElementList) {
        LogIPFLog.debug("LogIPFConfiguration::createFileAppender() - begin.");
        org.dom4j.Element appenderElement = doc.getRootElement().addElement("appender");
        LogIPFConfigure.createAppenderElement(appenderName, "org.apache.log4j.RollingFileAppender", appenderElement);
        int length = parameterElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            org.dom4j.Element parameterElement = (org.dom4j.Element)parameterElementList.get(loop);
            String nameAttr = parameterElement.attributeValue(NAME_ATTR);
            if (null == nameAttr) continue;
            String parameterValue = parameterElement.elementText(qnValue);
            if (nameAttr.equalsIgnoreCase("appenderName")) {
                LogIPFLog.debug("LogIPFConfiguration::createFileAppender() - Relative file path set to: " + parameterValue);
                ICCLConfiguration myConf = CCLConfigurationFactory.createConfiguration();
                String appenderFilename = "";
                try {
                    myConf.init();
                    appenderFilename = myConf.resolveEffectivePath(parameterValue);
                }
                catch (CCLConfigurationException e) {
                    LogIPFLog.warn("LogIPFConfiguration::createFileAppender() - ICCLConfiguration.init() call failed: ", e);
                }
                LogIPFConfigure.verifyPath(appenderFilename);
                LogIPFConfigure.addParameterNameStringValue("File", LogIPFConfigure.convertToUnixStyleSep(appenderFilename), appenderElement);
                LogIPFLog.debug("LogIPFConfiguration::createFileAppender() - Resolved file path : " + LogIPFConfigure.convertToUnixStyleSep(appenderFilename));
                continue;
            }
            if (nameAttr.equalsIgnoreCase("appenderMaxSize")) {
                int fileSize = 10;
                try {
                    fileSize = Integer.parseInt(parameterValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                LogIPFConfigure.addParameterNameStringValue("MaximumFileSize", String.valueOf(fileSize *= 0x100000), appenderElement);
                continue;
            }
            if (nameAttr.equalsIgnoreCase("appenderRollOver")) {
                LogIPFConfigure.addParameterNameStringValue("MaxBackupIndex", parameterValue, appenderElement);
                continue;
            }
            if (!nameAttr.equals(UTF8ENCODING_VALUE)) continue;
            m_useUTF8Encoding = parameterValue.equalsIgnoreCase("true");
            LogIPFLog.debug("LogIPFConfiguration::createFileAppender() - UTF8 encoding set to: " + m_useUTF8Encoding);
        }
        if (m_useUTF8Encoding) {
            LogIPFConfigure.addParameterNameStringValue("Encoding", "UTF-8", appenderElement);
        }
        LogIPFConfigure.addLayoutTag("%m%n", appenderElement);
        LogIPFLog.debug("LogIPFConfiguration::createFileAppender() - end.");
        return true;
    }

    private static boolean createSyslogAppender(Document doc, String appenderName, List parameterElementList) {
        LogIPFLog.debug("LogIPFConfiguration::createSyslogAppender() - begin.");
        org.dom4j.Element appenderElement = doc.getRootElement().addElement("appender");
        LogIPFConfigure.createAppenderElement(appenderName, "org.apache.log4j.net.SyslogAppender", appenderElement);
        int length = parameterElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            org.dom4j.Element parameterElement = (org.dom4j.Element)parameterElementList.get(loop);
            String nameAttr = parameterElement.attributeValue(NAME_ATTR);
            if (null == nameAttr) continue;
            String parameterValue = parameterElement.elementText(qnValue);
            if (nameAttr.equalsIgnoreCase("host")) {
                LogIPFConfigure.addParameterNameStringValue("SyslogHost", parameterValue, appenderElement);
                continue;
            }
            if (nameAttr.equalsIgnoreCase("facility")) {
                LogIPFConfigure.addParameterNameStringValue("Facility", parameterValue, appenderElement);
                continue;
            }
            if (!nameAttr.equalsIgnoreCase("facilityPrinting")) continue;
            LogIPFConfigure.addParameterNameStringValue("FacilityPrinting", parameterValue, appenderElement);
        }
        LogIPFConfigure.addLayoutTag("%m%n", appenderElement);
        LogIPFLog.debug("LogIPFConfiguration::createSyslogAppender() - end.");
        return true;
    }

    private static boolean createZosConsoleAppender(Document doc, String appenderName) {
        LogIPFLog.debug("LogIPFConfiguration::createZosConsoleAppender() - begin.");
        org.dom4j.Element appenderElement = doc.getRootElement().addElement("appender");
        LogIPFConfigure.createAppenderElement(appenderName, "com.cognos.indications.LogZosConsoleAppender", appenderElement);
        LogIPFConfigure.addLayoutTag("%m%n", appenderElement);
        LogIPFLog.debug("LogIPFConfiguration::createZosConsoleAppender() - end.");
        return true;
    }

    private static boolean createNTEventLogAppender(Document doc, String appenderName, List parameterElementList) {
        LogIPFLog.debug("LogIPFConfiguration::createNTEventLogAppender() - begin.");
        org.dom4j.Element appenderElement = doc.getRootElement().addElement("appender");
        LogIPFConfigure.createAppenderElement(appenderName, "com.cognos.indications.LogNTEventLogAppender", appenderElement);
        int length = parameterElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            org.dom4j.Element parameterElement = (org.dom4j.Element)parameterElementList.get(loop);
            String nameAttr = parameterElement.attributeValue(NAME_ATTR);
            if (null == nameAttr || !nameAttr.equals("logSource")) continue;
            String parameterValue = parameterElement.elementText(qnValue);
            LogIPFConfigure.addParameterNameStringValue("Source", parameterValue, appenderElement);
        }
        LogIPFConfigure.addLayoutTag("%m%n", appenderElement);
        LogIPFLog.debug("LogIPFConfiguration::createNTEventLogAppender() - end.");
        return true;
    }

    private static boolean createTcpAppender(Document doc, String appenderName, List parameterElementList) {
        LogIPFLog.debug("LogIPFConfiguration::createTcpAppender() - begin.");
        org.dom4j.Element appenderElement = doc.getRootElement().addElement("appender");
        LogIPFConfigure.createAppenderElement(appenderName, "com.cognos.indications.LogTCPSocketConsolidatorAppender", appenderElement);
        int length = parameterElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            org.dom4j.Element parameterElement = (org.dom4j.Element)parameterElementList.get(loop);
            String nameAttr = parameterElement.attributeValue(NAME_ATTR);
            if (null == nameAttr) continue;
            String parameterValue = parameterElement.elementText(qnValue);
            if (nameAttr.equalsIgnoreCase("consolidatorConnection")) {
                int delPos = parameterValue.lastIndexOf(":");
                String hostStr = parameterValue.substring(0, delPos);
                if (hostStr.startsWith("[") && hostStr.endsWith("]")) {
                    hostStr = hostStr.substring(1, hostStr.length() - 1);
                }
                LogIPFConfigure.addParameterNameStringValue("RemoteHost", hostStr, appenderElement);
                String portStr = parameterValue.substring(delPos + 1);
                LogIPFConfigure.addParameterNameStringValue("Port", portStr, appenderElement);
                continue;
            }
            if (nameAttr.equalsIgnoreCase("consolidatorReconnectionDelay")) {
                int reconnDelay = 30;
                try {
                    reconnDelay = Integer.parseInt(parameterValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                LogIPFConfigure.addParameterNameStringValue("ReconnectionDelay", String.valueOf(reconnDelay *= 1000), appenderElement);
                continue;
            }
            if (!nameAttr.equalsIgnoreCase("enableConsolidatorSSL")) continue;
            LogIPFConfigure.addParameterNameStringValue("Secure", parameterValue, appenderElement);
        }
        LogIPFLog.debug("LogIPFConfiguration::createTcpAppender() - end.");
        return true;
    }

    private static void addParameterNameStringValue(String paramName, String paramValue, org.dom4j.Element item) {
        org.dom4j.Element item1 = DocumentHelper.createElement((String)PARAM_TAG);
        item1.addAttribute(NAME_ATTR, paramName);
        item1.addAttribute("value", paramValue);
        item.add(item1);
    }

    private static void addFilterParamsNameValue(org.dom4j.Element item, String filterName, String param1Name, String param1Value, String param2Name, String param2Value) {
        org.dom4j.Element item1 = DocumentHelper.createElement((String)FILTER_TAG);
        item1.addAttribute(CLASS_ATTR, filterName);
        LogIPFConfigure.addParameterNameStringValue(param1Name, param1Value, item1);
        LogIPFConfigure.addParameterNameStringValue(param2Name, param2Value, item1);
        item.add(item1);
    }

    private static void addLayoutTag(String strPattern, org.dom4j.Element item) {
        org.dom4j.Element item1 = DocumentHelper.createElement((String)LAYOUT_TAG);
        Attribute attrib = DocumentHelper.createAttribute((org.dom4j.Element)item1, (String)CLASS_ATTR, (String)"org.apache.log4j.PatternLayout");
        item1.add(attrib);
        org.dom4j.Element item2 = DocumentHelper.createElement((String)PARAM_TAG);
        attrib = DocumentHelper.createAttribute((org.dom4j.Element)item2, (String)NAME_ATTR, (String)"ConversionPattern");
        item2.add(attrib);
        attrib = DocumentHelper.createAttribute((org.dom4j.Element)item2, (String)"value", (String)strPattern);
        item2.add(attrib);
        item1.add(item2);
        item.add(item1);
    }

    private static void createAppenderElement(String appName, String appClass, org.dom4j.Element appenderElement) {
        appenderElement.addAttribute(NAME_ATTR, appName);
        appenderElement.addAttribute(CLASS_ATTR, appClass);
    }

    private static void createRendererElement(Document doc, String indicationName, String rendererName) {
        org.dom4j.Element rendererElement = DocumentHelper.createElement((String)RENDERER_TAG);
        rendererElement.addAttribute(RENDERED_CLASS_ATTR, indicationName);
        rendererElement.addAttribute(RENDERING_CLASS_ATTR, rendererName);
        doc.getRootElement().add(rendererElement);
    }

    private static void createRootElement(Document doc) {
        org.dom4j.Element root = doc.addElement(CONFIGURATION_TAG);
        root.addAttribute("xmlns:log4j", "http://jakarta.apache.org/log4j/");
    }

    private static void createAllRenderers(Document doc) {
        LogIPFConfigure.createRendererElement(doc, "com.cognos.indications.LogAuditIndication", "com.cognos.indications.LogAuditRenderer");
        LogIPFConfigure.createRendererElement(doc, "com.cognos.indications.LogAuditAccessIndication", "com.cognos.indications.LogAuditAccessRenderer");
        LogIPFConfigure.createRendererElement(doc, "com.cognos.indications.LogIndication", "com.cognos.indications.LogIndicationRenderer");
        LogIPFConfigure.createRendererElement(doc, "com.cognos.indications.LogPerfIndication", "com.cognos.indications.LogPerfRenderer");
        LogIPFConfigure.createRendererElement(doc, "com.cognos.indications.LogTraceIndication", "com.cognos.indications.LogTraceRenderer");
        LogIPFConfigure.createRendererElement(doc, "com.cognos.indications.LogValueTraceIndication", "com.cognos.indications.LogValueTraceRenderer");
    }

    private static void initializeIPFBootstrapParams(ICCLConfiguration cclConfig, List instanceElementList) throws CCLConfigurationException {
        LogIPFLog.debug("LogIPFConfiguration::initializeIPFBootstrapParams() - begin.");
        String feedbackPortStr = null;
        try {
            feedbackPortStr = cclConfig.getValue("feedbackPort", false);
            if (null != feedbackPortStr && feedbackPortStr.length() != 0) {
                m_logFeedbackPort = Integer.parseInt(feedbackPortStr);
            }
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogIPFConfiguration::initializeIPFBootstrapParams() - Failed to read feedbackPort from ICCLConfiguration; error ", e);
            throw e;
        }
        org.dom4j.Element configElement = LogIPFConfigure.parseIPFStartupParams(cclConfig, instanceElementList);
        List parameterElementList = configElement.elements(qnParameter);
        int length = parameterElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            org.dom4j.Element parameterElement = (org.dom4j.Element)parameterElementList.get(loop);
            String nameAttr = parameterElement.attributeValue(NAME_ATTR);
            if (null == nameAttr) continue;
            if (nameAttr.equals(LOGSERVERPORT)) {
                String logServerPortString = parameterElement.elementText(qnValue);
                m_logServerPort = Integer.parseInt(logServerPortString);
                LogIPFLog.debug("LogIPFConfiguration::initializeIPFBootstrapParams() - Log Server Port is: " + logServerPortString);
                continue;
            }
            if (nameAttr.equals(ENABLE_TCP_VALUE)) {
                String useTCPS = parameterElement.elementText(qnValue);
                m_useTCPProtocol = useTCPS.equalsIgnoreCase("true");
                LogIPFLog.debug("LogIPFConfiguration::initializeIPFBootstrapParams() - Using TCP protocol: " + m_useTCPProtocol);
                continue;
            }
            if (!nameAttr.equals(WORKER_THREADS_VALUE)) continue;
            String workerThreadsString = parameterElement.elementText(qnValue);
            m_serverWorkerThreads = Integer.parseInt(workerThreadsString);
            LogIPFLog.debug("LogIPFConfiguration::initializeIPFBootstrapParams() - Number of Server Worker Threads is: " + workerThreadsString);
        }
        m_useSSL = cclConfig.isInternalSSL();
        LogIPFLog.debug("LogIPFConfiguration::initializeIPFBootstrapParams() - end.");
    }

    private static void createLoggerInstance(Document doc, String loggerName, String auditLevel, List appenderList) {
        LogTypedLoggerLegacy tmpLog = (LogTypedLoggerLegacy)Logger.getLogger((String)loggerName, (LoggerFactory)LogTypedLoggerLegacy.factory);
        if (auditLevel.length() == 0) {
            tmpLog.setLevel(null);
            return;
        }
        org.dom4j.Element categoryElement = DocumentHelper.createElement((String)CATEGORY_TAG);
        categoryElement.addAttribute(NAME_ATTR, loggerName);
        categoryElement.addAttribute(CLASS_ATTR, "com.cognos.indications.LogTypedLoggerLegacy");
        org.dom4j.Element levelElement = categoryElement.addElement(LEVEL_TAG);
        if (auditLevel.equals("0")) {
            levelElement.addAttribute("value", "off");
        } else if (auditLevel.equals("1")) {
            levelElement.addAttribute("value", "fatal");
        } else if (auditLevel.equals("2")) {
            levelElement.addAttribute("value", "error");
        } else if (auditLevel.equals("3")) {
            levelElement.addAttribute("value", "warn");
        } else if (auditLevel.equals("4")) {
            levelElement.addAttribute("value", "info");
        } else {
            levelElement.addAttribute("value", "debug");
        }
        levelElement = null;
        if (null != appenderList) {
            int length = appenderList.size();
            for (int loop = 0; loop < length; ++loop) {
                org.dom4j.Element appenderRefElement = categoryElement.addElement(APPENDER_REF_TAG);
                appenderRefElement.addAttribute(REF_ATTR, appenderList.get(loop).toString());
            }
        }
        doc.getRootElement().add(categoryElement);
    }

    public static void showDoc(Document doc) {
        if (doc != null) {
            try {
                System.out.println(doc.asXML());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static String dumpAsXML(org.dom4j.Element theElement) {
        String sResultXML = "";
        int XML_DOC_SIZE = 8192;
        StringWriter sw = new StringWriter(XML_DOC_SIZE);
        OutputFormat prettyformat = OutputFormat.createPrettyPrint();
        prettyformat.setSuppressDeclaration(false);
        XMLWriter writer = new XMLWriter((Writer)sw, prettyformat);
        boolean bSuccess = true;
        try {
            writer.write(theElement);
            writer.close();
        }
        catch (IOException e) {
            bSuccess = false;
        }
        if (bSuccess) {
            sResultXML = sw.toString();
        }
        return sResultXML;
    }

    private static String convertToUnixStyleSep(String winStyleStr) {
        StringTokenizer st = new StringTokenizer(winStyleStr, "\\", false);
        int noOfTokens = st.countTokens();
        String unixStyleStr = st.nextToken();
        for (int ii = 0; ii < noOfTokens - 1; ++ii) {
            unixStyleStr = unixStyleStr + "/" + st.nextToken();
        }
        return unixStyleStr;
    }

    protected static Level convertIPFBeLevelToLog4jLevel(String ipfLevel) {
        if (ipfLevel.equalsIgnoreCase("minimal")) {
            return Level.FATAL;
        }
        if (ipfLevel.equalsIgnoreCase("basic")) {
            return Level.WARN;
        }
        if (ipfLevel.equalsIgnoreCase("request")) {
            return Level.INFO;
        }
        if (ipfLevel.equalsIgnoreCase("trace")) {
            return Level.DEBUG;
        }
        if (ipfLevel.equalsIgnoreCase("full")) {
            return Level.DEBUG;
        }
        return Level.FATAL;
    }

    protected static void setIPFLevel(Logger ipfLogger, String ipfLevel) {
        ipfLogger.setLevel(LogIPFConfigure.convertIPFBeLevelToLog4jLevel(ipfLevel));
    }

    private static void shutdownLogger(String loggerName, Class base) {
        LogIPFLog.debug("LogIPFConfiguration::shutdownLogger() - Logger name: " + loggerName);
        Logger aLogger = LogManager.exists((String)loggerName);
        if (null == aLogger) {
            LogIPFLog.debug("LogIPFConfiguration::shutdownLogger() - Logger (" + loggerName + ") does not exist");
            return;
        }
        Enumeration enum1 = aLogger.getAllAppenders();
        if (enum1 != null) {
            while (enum1.hasMoreElements()) {
                Appender a = (Appender)enum1.nextElement();
                if (!(a instanceof AppenderAttachable)) continue;
                a.close();
            }
        }
        aLogger.removeAllAppenders();
    }

    public static String getDBURL() {
        return m_dbURL;
    }

    public static String getDBUser() {
        return m_dbUser;
    }

    public static String getDBInitializationStatus() {
        return m_dbInitializationStatus;
    }

    public static String getDBErrorMessage() {
        return m_dbErrMessage;
    }

    public static boolean isDBAppenderDefined() {
        return m_serverDBAppenderDefined;
    }

    private static void update3rdpartyLoggers() {
        Enumeration allLoggers = LogManager.getCurrentLoggers();
        if (allLoggers != null) {
            while (allLoggers.hasMoreElements()) {
                LogTypedLoggerLegacy aLogger;
                Object o = allLoggers.nextElement();
                if (!(o instanceof LogTypedLoggerLegacy) || (aLogger = (LogTypedLoggerLegacy)((Object)o)).getName().indexOf("3rdparty") <= 0) continue;
                if (m_nativeQuery) {
                    LogIPFLog.debug("LogIPFConfiguration::update3rdpartyLoggers() - Set level DEBUG for Logger " + aLogger.getName());
                    aLogger.setLevel(Level.DEBUG);
                    continue;
                }
                LogIPFLog.debug("LogIPFConfiguration::update3rdpartyLoggers() - Set level OFF for Logger " + aLogger.getName());
                aLogger.setLevel(Level.OFF);
            }
            return;
        }
    }

    private static void updateLoggers(String compStr, Level someLevel) {
        Enumeration allLoggers = LogManager.getCurrentLoggers();
        if (allLoggers != null) {
            while (allLoggers.hasMoreElements()) {
                LogTypedLoggerLegacy aLogger;
                String loggerName;
                Object o = allLoggers.nextElement();
                if (!(o instanceof LogTypedLoggerLegacy) || (loggerName = (aLogger = (LogTypedLoggerLegacy)((Object)o)).getName()).indexOf("." + compStr + ".") <= 0 && !loggerName.endsWith("." + compStr) || !loggerName.startsWith("Audit")) continue;
                LogIPFLog.debug("LogIPFConfiguration::updateLoggers() - Set level to " + someLevel.toString() + " for Logger " + aLogger.getName());
                aLogger.setLevel(someLevel);
            }
            return;
        }
    }

    private static void updateRequestLoggers(String serviceLogger) {
        Enumeration tmpLoggers = LogManager.getCurrentLoggers();
        if (tmpLoggers != null) {
            while (tmpLoggers.hasMoreElements()) {
                LogTypedLoggerLegacy aLogger;
                Object o = tmpLoggers.nextElement();
                if (!(o instanceof LogTypedLoggerLegacy) || (aLogger = (LogTypedLoggerLegacy)((Object)o)).getName().toLowerCase().indexOf("request") <= 0 || !aLogger.getName().startsWith("Audit." + serviceLogger) && !aLogger.getName().startsWith("Audit.RTUsage." + serviceLogger) && !aLogger.getName().startsWith("Audit.Admin." + serviceLogger) && !aLogger.getName().startsWith("Audit.Other." + serviceLogger)) continue;
                String tmpLev = LogIPFConfigure.getServiceLevel(serviceLogger).toLowerCase();
                if (tmpLev.compareTo("trace") == 0) {
                    LogIPFLog.debug("LogIPFConfiguration::updateRequestLoggers() - Set level to FATAL for Logger " + aLogger.getName());
                    aLogger.setLevel(Level.FATAL);
                    continue;
                }
                LogIPFLog.debug("LogIPFConfiguration::updateRequestLoggers() - Set level to " + tmpLev + " for Logger " + aLogger.getName());
                aLogger.setLevel(LogIPFConfigure.convertIPFBeLevelToLog4jLevel(tmpLev));
            }
        }
    }

    protected static String getServiceName(String componentName) {
        String servName = (String)m_compServiceMap.get(componentName.toUpperCase());
        if (null == servName) {
            return "";
        }
        return servName;
    }

    protected static String getServiceLevel(String serviceName) {
        String levelStrTmp = "";
        if (null == serviceName || serviceName.length() == 0) {
            return levelStrTmp;
        }
        String levelStr = "Minimal";
        int indexOfServSep = serviceName.indexOf(59);
        if (-1 == indexOfServSep) {
            levelStr = (String)m_serviceLevelMap.get(serviceName);
        } else {
            Level curLog4jLevel;
            StringBuffer serviceBuf = new StringBuffer(serviceName);
            Level log4jLevel = Level.OFF;
            while (-1 != indexOfServSep) {
                levelStrTmp = (String)m_serviceLevelMap.get(serviceBuf.substring(0, indexOfServSep));
                curLog4jLevel = LogIPFConfigure.convertIPFBeLevelToLog4jLevel(levelStr);
                if (curLog4jLevel.isGreaterOrEqual((Priority)log4jLevel)) {
                    log4jLevel = curLog4jLevel;
                    levelStr = levelStrTmp;
                }
                serviceBuf = serviceBuf.delete(0, indexOfServSep + 1);
                indexOfServSep = serviceBuf.toString().indexOf(59);
            }
            curLog4jLevel = LogIPFConfigure.convertIPFBeLevelToLog4jLevel((String)m_serviceLevelMap.get(serviceBuf.toString()));
            if (curLog4jLevel.isGreaterOrEqual((Priority)log4jLevel)) {
                log4jLevel = curLog4jLevel;
                levelStr = levelStrTmp;
            }
        }
        return levelStr;
    }

    private static void updateServiceLoggers() {
        Set services = m_serviceLevelMap.keySet();
        Iterator servIter = services.iterator();
        Object tmpAuditLog = null;
        String serviceLogger = "";
        while (servIter.hasNext()) {
            serviceLogger = (String)servIter.next();
            LogIPFConfigure.updateLoggers(serviceLogger, LogIPFConfigure.convertIPFBeLevelToLog4jLevel((String)m_serviceLevelMap.get(serviceLogger)));
            LogIPFConfigure.updateRequestLoggers(serviceLogger);
        }
        Set components = m_compServiceMap.keySet();
        Iterator compIter = components.iterator();
        StringBuffer sharedComp = new StringBuffer(16);
        while (compIter.hasNext()) {
            int aIndex;
            String compStr = (String)compIter.next();
            sharedComp.delete(0, sharedComp.length());
            sharedComp.append(m_compServiceMap.get(compStr));
            if (-1 == sharedComp.toString().indexOf(59)) continue;
            Level aLev = Level.OFF;
            while (sharedComp.length() > 0 && -1 != (aIndex = sharedComp.toString().indexOf(59))) {
                String aStrLev = (String)m_serviceLevelMap.get(sharedComp.substring(0, aIndex));
                if (aLev.isGreaterOrEqual((Priority)LogIPFConfigure.convertIPFBeLevelToLog4jLevel(aStrLev))) {
                    aLev = LogIPFConfigure.convertIPFBeLevelToLog4jLevel(aStrLev);
                }
                sharedComp.delete(0, aIndex + 1);
            }
            LogIPFConfigure.updateLoggers(compStr, aLev);
        }
    }

    private static void mergeDocs(org.dom4j.Element startupJavaRoot, org.dom4j.Element compRoot) {
        if (compRoot == null) {
            LogIPFLog.debug("LogIPFConfigure:mergeDocs -- the compRoot is null, return.");
            return;
        }
        List javaProc = compRoot.elements("process");
        if (javaProc != null) {
            for (int i = 0; i < javaProc.size(); ++i) {
                String procId;
                org.dom4j.Element javaNode = (org.dom4j.Element)javaProc.get(i);
                if (javaNode == null || javaNode.attribute("id") == null || (procId = javaNode.attribute("id").getStringValue()) == null || procId.compareToIgnoreCase("java") != 0) continue;
                List services = javaNode.elements("service");
                if (services == null) break;
                for (int j = 0; j < services.size(); ++j) {
                    org.dom4j.Element servNode = (org.dom4j.Element)services.get(j);
                    if (servNode == null) continue;
                    servNode.detach();
                    startupJavaRoot.add(servNode);
                }
                break;
            }
        }
    }

    private static void mergeStartup(String pathConfig, org.dom4j.Element startupJavaRoot) throws Exception {
        if (startupJavaRoot == null) {
            LogIPFLog.debug("LogIPFConfigure:mergeStartup - the base startup java process node is null. Skip the merge.");
            return;
        }
        File configDir = new File(pathConfig);
        if (!configDir.exists()) {
            LogIPFLog.debug("LogIPFConfigure:mergeStartup - The configuration path 'configuration/logging' doesn't exist. Skip the merging part.");
            return;
        }
        ArrayList<File> startupFiles = LogIPFUtils.getXmlFiles(configDir);
        for (int i = 0; i < startupFiles.size(); ++i) {
            File sStartuptFile = startupFiles.get(i);
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read(sStartuptFile.getCanonicalPath());
                org.dom4j.Element compRootElement = doc.getRootElement();
                LogIPFConfigure.mergeDocs(startupJavaRoot, compRootElement);
                continue;
            }
            catch (Exception e) {
                LogIPFLog.warn("LogIPFConfigure:mergeStartup - The extension ipfstartup doc (" + sStartuptFile.getCanonicalPath() + " ) failed to load, continue to next file.", e);
            }
        }
    }

    private static void doStartup(String filename, String pathConfig) throws Exception {
        try {
            org.dom4j.Element javaProcRoot;
            SAXReader reader = new SAXReader();
            Document doc = reader.read(filename);
            org.dom4j.Element rootElement = doc.getRootElement();
            if (rootElement != null) {
                List javaProc = rootElement.elements("process");
                javaProcRoot = null;
                if (javaProc != null) {
                    for (int i = 0; i < javaProc.size(); ++i) {
                        String procId;
                        org.dom4j.Element javaNode = (org.dom4j.Element)javaProc.get(i);
                        if (javaNode == null || javaNode.attribute("id") == null || (procId = javaNode.attribute("id").getStringValue()) == null || procId.compareToIgnoreCase("java") != 0) continue;
                        javaProcRoot = javaNode;
                        break;
                    }
                }
            } else {
                LogIPFLog.error("LogIPFConfigure:doStartup - The file " + filename + " is not a valid xml file.");
                throw new CCLConfigurationException(9);
            }
            LogIPFConfigure.mergeStartup(pathConfig, javaProcRoot);
            LogIPFConfigure.parseIPFStartup(javaProcRoot);
        }
        catch (IOException e) {
            LogIPFLog.error("LogIPFConfiguration::doStartup() - Could not open [" + filename + "].", e);
            throw e;
        }
        catch (Exception e) {
            LogIPFLog.error("LogIPFConfiguration::doStartup() - exception: ", e);
            throw e;
        }
    }

    private static void parseIPFStartup(org.dom4j.Element javaProcRootElement) throws Exception {
        if (javaProcRootElement != null) {
            LogIPFLog.debug("LogIPFConfigure:parseIPFStartup - parse the java process node into m_compServiceMap. ");
            List services = javaProcRootElement.elements("service");
            int length = services.size();
            for (int loop = 0; loop < length; ++loop) {
                org.dom4j.Element serviceNode = (org.dom4j.Element)services.get(loop);
                if (serviceNode == null) continue;
                String serviceName = serviceNode.attribute("id").getStringValue();
                m_serviceLevelMap.put(serviceName, "Minimal");
                List compList = serviceNode.elements("component");
                int noOfComp = compList.size();
                for (int loop1 = 0; loop1 < noOfComp; ++loop1) {
                    org.dom4j.Element compNode = (org.dom4j.Element)compList.get(loop1);
                    if (compNode == null) continue;
                    String compName = compNode.attribute("id").getStringValue();
                    if (m_compServiceMap.containsKey(compName)) {
                        String oldValue = (String)m_compServiceMap.get(compName);
                        m_compServiceMap.remove(compName);
                        m_compServiceMap.put(compName, oldValue + ";" + serviceName);
                        continue;
                    }
                    m_compServiceMap.put(compName, serviceName);
                }
            }
        } else {
            LogIPFLog.debug("LogIPFConfigure:parseIPFStartup - the java proc node is null, put the default values into m_compServiceMap. ");
            m_compServiceMap.put("ASV", "as");
            m_compServiceMap.put("JSM", "as;ds;js;ms;ems");
            m_compServiceMap.put("DLS", "ds");
            m_compServiceMap.put("JS", "js");
            m_compServiceMap.put("MS", "ms");
            m_compServiceMap.put("EMS", "ems");
            m_compServiceMap.put("XTS", "ps");
            m_compServiceMap.put("VIEWER", "ps");
            m_compServiceMap.put("VALIDATOR", "ps");
            m_compServiceMap.put("BUX", "ps");
            m_compServiceMap.put("LOGSV", "ls");
            m_compServiceMap.put("CM", "cms");
            m_compServiceMap.put("JCAM", "cms");
            m_compServiceMap.put("CAM", "cms");
            m_compServiceMap.put("JCAMCRYPTO", "cms");
            m_compServiceMap.put("AAA", "cms");
            m_compServiceMap.put("RSPECUPGRADE", "cms");
            m_compServiceMap.put("DISP", "dispatcher");
            m_compServiceMap.put("dispatcher", "dispatcher");
            m_compServiceMap.put("CAF", "dispatcher");
            m_compServiceMap.put("MTE", "mms");
            m_compServiceMap.put("CMM", "mms");
            m_compServiceMap.put("MMPDFS", "mms");
            m_compServiceMap.put("DIS", "dis");
            m_compServiceMap.put("CCS", "rds");
            m_compServiceMap.put("IDS", "ids");
            m_compServiceMap.put("CSN", "ids;ius;iss");
            m_compServiceMap.put("IUS", "ius");
            m_compServiceMap.put("ISS", "iss");
            m_compServiceMap.put("MOB", "mbs");
            m_compServiceMap.put("DMS", "dms");
            m_compServiceMap.put("MIS", "mis");
            m_compServiceMap.put("MIGDEPLOY", "mis");
            m_compServiceMap.put("MIGRSVP", "mis");
            m_compServiceMap.put("MDSRV", "mds");
            m_compServiceMap.put("PDS", "pds");
            m_compServiceMap.put("PPS", "pps");
            m_compServiceMap.put("HTS", "hts");
            m_compServiceMap.put("ANS", "ans");
            m_serviceLevelMap.put("as", "Minimal");
            m_serviceLevelMap.put("cms", "Minimal");
            m_serviceLevelMap.put("dispatcher", "Minimal");
            m_serviceLevelMap.put("ds", "Minimal");
            m_serviceLevelMap.put("ems", "Minimal");
            m_serviceLevelMap.put("js", "Minimal");
            m_serviceLevelMap.put("ms", "Minimal");
            m_serviceLevelMap.put("mms", "Minimal");
            m_serviceLevelMap.put("dis", "Minimal");
            m_serviceLevelMap.put("ps", "Minimal");
            m_serviceLevelMap.put("rds", "Minimal");
            m_serviceLevelMap.put("ids", "Minimal");
            m_serviceLevelMap.put("ius", "Minimal");
            m_serviceLevelMap.put("iss", "Minimal");
            m_serviceLevelMap.put("mbs", "Minimal");
            m_serviceLevelMap.put("dms", "Minimal");
            m_serviceLevelMap.put("mis", "Minimal");
            m_serviceLevelMap.put("mds", "Minimal");
            m_serviceLevelMap.put("pds", "Minimal");
            m_serviceLevelMap.put("pps", "Minimal");
            m_serviceLevelMap.put("hts", "Minimal");
            m_serviceLevelMap.put("ans", "Minimal");
            m_serviceLevelMap.put("qs", "Minimal");
        }
    }

    static {
        m_nativeQuery = false;
        firstRuntimeInit = true;
        m_firstRuntimeInit = true;
        IPFPropRead = new Properties();
        DispatcherID = 0;
        m_dbInitializationStatus = "";
        m_dbURL = "";
        m_dbErrMessage = "";
        m_serverFileAppenderExists = false;
        m_serverDBAppenderExists = false;
        m_serverDBAppenderDefined = false;
        m_serverRemoteAppenderExists = false;
        m_serverZosConsoleAppenderExists = false;
        m_serverNTAppenderExists = false;
        m_serverSyslogAppenderExists = false;
        m_numberOfServerAppenders = 0;
        m_compServiceMap = Collections.synchronizedMap(new HashMap());
        m_serviceLevelMap = Collections.synchronizedMap(new HashMap());
        try {
            ICCLConfiguration myConf = CCLConfigurationFactory.createConfiguration();
            myConf.init();
            String dispURLStr = null;
            String feedbackPortStr = null;
            try {
                dispURLStr = myConf.getValue("internalDispatcher", false);
                URL dispURL = new URL(dispURLStr);
                m_dispatcherPort = dispURL.getPort();
                if (m_dispatcherPort == -1) {
                    m_dispatcherPort = 0;
                }
                if (null != (feedbackPortStr = myConf.getValue("feedbackPort", false)) && feedbackPortStr.length() != 0) {
                    m_logFeedbackPort = Integer.parseInt(feedbackPortStr);
                }
            }
            catch (CCLConfigurationException e) {
                LogIPFLog.error("LogIPFConfigure initialization  - Failed to read Dispatcher URL ", e);
            }
            catch (MalformedURLException e) {
                m_dispatcherPort = 9300;
            }
            LogIPFConfigure.doStartup(myConf.resolveEffectivePath("../configuration/ipfstartup.xml"), myConf.resolveEffectivePath("../configuration/logging"));
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogIPFConfigure initialization - ICCLConfiguration.init() call failed", e);
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFConfigure initialization - Unknown error during initialization", e);
        }
        try {
            ResourceBundle resBund = ResourceBundle.getBundle("com.cognos.indications.IPFInternal", new Locale("ov", "CA"));
            Enumeration<String> parmNames = resBund.getKeys();
            while (parmNames.hasMoreElements()) {
                String parmName = parmNames.nextElement();
                String parmValue = resBund.getString(parmName);
                if (parmName == null || parmName.length() < 1) continue;
                IPFPropRead.remove(parmName);
                if (parmValue == null) {
                    IPFPropRead.setProperty(parmName, "");
                    continue;
                }
                IPFPropRead.setProperty(parmName, parmValue);
            }
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFConfigure initialization - Unable to load resource bundle com.cognos.indications.IPFInternal(IPFInternal.properties). ", e);
        }
        try {
            System.loadLibrary("LogIPFConfigure");
            DispatcherID = LogIPFConfigure.getDispatcherPID();
        }
        catch (SecurityException e) {
            LogIPFLog.warn("LogIPFConfigure initialization - SecurityException when loading library - Java PID left 0", e);
        }
        catch (UnsatisfiedLinkError e) {
            LogIPFLog.error("LogIPFConfigure initialization - UnsatisfiedLinkError (" + e.getMessage() + ") Java PID left 0", e);
        }
    }
}

