/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.CCLResolveInetAddress;
import com.cognos.cclcfgapi.CCLStartupConfiguration;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.IPFConfigNotifyAcceptor;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogConfigurationObservable;
import com.cognos.indications.LogFileWatchdog;
import com.cognos.indications.LogFileWatcher;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogLocalUDPAppender;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLoggerLegacy;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.DOMConfigurator;

public class LogIPFControl {
    protected static byte[] m_ipaddr;
    protected static String m_ipaddrStr;
    protected static short m_tzOffset;
    private static SigningSession m_CAMSigningSession;
    private static boolean m_bIsForIPFTest;
    private static boolean m_bIsInitUsingConfigFile;
    private static final char[] hex_chars;
    public static final short ERR_LOG_INIT = 0;
    public static final short ERR_LOGSERVER_CRYPTO = 1;
    public static final short ERR_LOGSERVER_SOCKET = 2;
    public static final short ERR_LOGSERVER_INIT = 3;
    public static final short ERR_LOGSERVER_CONFIGURE = 4;
    public static final short ERR_LOGSERVER_GENERIC = 5;
    public static final short ERR_LOGSERVER_DB_CREATION = 6;
    static String[] m_errMsgString;
    protected static long counterRef;
    protected static boolean m_isConfigurationDone;
    protected static Object logService;
    protected static LogFileWatchdog m_clientdogThread;
    protected static ArrayList<Thread> m_listWatchThreads;
    protected static LogConfigurationObservable m_configObservable;

    private static String hexify(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(hex_chars[b & 0xF]).append(hex_chars[(b & 0xF0) >> 4]);
        }
        return sb.toString();
    }

    public static void setForIPFTesting() {
        m_bIsForIPFTest = true;
    }

    public static void setPropForIPFTesting(String ipstr, int procID) {
        m_bIsForIPFTest = true;
        m_ipaddrStr = ipstr;
        LogIPFConfigure.DispatcherID = procID;
    }

    public static boolean isInitUsingConfigFile() {
        return m_bIsInitUsingConfigFile;
    }

    public static synchronized boolean initialize(String configFilename) {
        LogIPFLog.debug("LogIPFControl::initialize(configFilename) - begin. config file name: " + configFilename);
        boolean result = true;
        if (counterRef > 0L) {
            LogIPFLog.debug("LogIPFControl::initialize(configFilename) - counterRef > 0, IPF has been initialized, return true.");
            ++counterRef;
            return result;
        }
        if (!LogIPFControl.initCAMCrypto()) {
            LogIPFLog.warn("LogIPFControl::initialize() - initCAMCrypto() failed, return false.");
            return false;
        }
        try {
            String fileName = null;
            ICCLConfiguration myConf = CCLConfigurationFactory.createConfiguration();
            try {
                myConf.init();
                fileName = myConf.resolveEffectivePath(configFilename);
            }
            catch (CCLConfigurationException e) {
                LogIPFLog.warn("LogIPFControl::initialize(configFilename) - ICCLConfiguration.init() call failed with ", e);
                fileName = configFilename;
            }
            LogIPFLog.debug("LogIPFControl::initialize(configFilename) - resolved file name: " + fileName);
            File file = new File(fileName);
            if (file.exists()) {
                DOMConfigurator.configure((String)fileName);
                ++counterRef;
                Logger tmpLog = LogManager.exists((String)"Audit");
                if (null != tmpLog) {
                    tmpLog.setAdditivity(false);
                }
                if (null != (tmpLog = LogManager.exists((String)"Perf"))) {
                    tmpLog.setAdditivity(false);
                }
                if (null != (tmpLog = LogManager.exists((String)"Trace"))) {
                    tmpLog.setAdditivity(false);
                }
                LogIPFControl.getStrings();
                m_bIsInitUsingConfigFile = true;
            } else {
                result = false;
            }
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFControl::initialize(configFilename) - Exception ", e);
            result = false;
        }
        LogIPFLog.debug("LogIPFControl::initialize(configFilename) - end");
        return result;
    }

    public static boolean start() {
        LogIPFLog.debug("LogIPFControl::start() - calling LogIPFControl.initialize().");
        return LogIPFControl.initialize();
    }

    private static synchronized void startWatchThreads() {
        LogIPFLog.debug("LogIPFControl::startWatchThreads().");
        for (Thread th : m_listWatchThreads) {
            if (th == null) continue;
            th.setDaemon(true);
            th.start();
        }
    }

    private static synchronized void stopWatchThreads() {
        LogIPFLog.debug("LogIPFControl::stopWatchThreads().");
        for (Thread th : m_listWatchThreads) {
            if (th == null) continue;
            th.interrupt();
            try {
                th.join();
            }
            catch (InterruptedException e) {
                LogIPFLog.debug("LogIPFControl::stopWatchThreads() - file watch thread interrupted during join.", e);
            }
            LogIPFLog.debug("LogIPFControl::stopWatchThreads() - " + th.getClass());
        }
    }

    public static synchronized boolean initialize() {
        LogIPFLog.debug("LogIPFControl::initialize() - begin.");
        boolean result = true;
        if (counterRef > 0L) {
            LogIPFLog.debug("LogIPFControl::initialize() - counterRef > 0, IPF has been initialized, return true.");
            ++counterRef;
            return result;
        }
        LogIPFControl.getStrings();
        if (!LogIPFControl.initCAMCrypto()) {
            LogIPFLog.warn("LogIPFControl::initialize() - initCAMCrypto() failed, return false.");
            return false;
        }
        try {
            m_configObservable = new LogConfigurationObservable();
            ICCLConfiguration aConf = CCLConfigurationFactory.createConfiguration();
            aConf.init();
            String ipfclientconfigfileName = aConf.resolveEffectivePath("../configuration/DoNotUseipfclientconfig.xml");
            String log4j2configfilePath = aConf.resolveEffectivePath("../configuration/data/logging");
            m_listWatchThreads.add(new LogFileWatchdog(ipfclientconfigfileName));
            m_listWatchThreads.add(new LogFileWatcher(log4j2configfilePath, new IPFConfigNotifyAcceptor()));
            LogIPFControl.startWatchThreads();
            if (new File(ipfclientconfigfileName).exists()) {
                LogIPFLog.debug("LogIPFControl::initialize() - ipfclientconfigfile exist, return true.");
                ++counterRef;
                return result;
            }
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFControl::initialize() - Unknown error during initialize:", e);
        }
        try {
            LogIPFConfigure.clientIniBering(null);
            ++counterRef;
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFControl::initialize() -  exception while calling LogIPFConfigure.clientIniBering(null)", e);
            result = false;
        }
        LogIPFLog.debug("LogIPFControl::initialize() - end.");
        return result;
    }

    public static Object getInProcessServer() {
        return logService;
    }

    public static synchronized void setInProcessServer(Object server) {
        logService = server;
    }

    public static synchronized boolean configure(ICCLConfiguration cclConfig) {
        LogIPFLog.debug("LogIPFControl::configure(cclConfig) - begin.");
        boolean result = true;
        if (LogFileWatchdog.m_ipfConfigFileExists || LogIPFControl.isInitUsingConfigFile()) {
            LogIPFLog.debug("LogIPFControl::configure(cclConfig) - ipfConfigFileExists, or IPF is initialized by an specified config file, return true.");
            return result;
        }
        if (counterRef == 0L) {
            LogIPFLog.warn("LogIPFControl::configure(cclConfig) - not initialized yet, call LogIPFControl.initialize first. return false");
            return false;
        }
        if (cclConfig == null) {
            LogIPFLog.debug("LogIPFControl::configure(cclConfig) - ICCLConfiguration is null, return false");
            return false;
        }
        if (!m_isConfigurationDone) {
            LogIPFControl.shutdownLogger("Audit", LogAuditIndication.class);
            LogIPFControl.shutdownLogger("Perf", LogPerfIndication.class);
            LogIPFControl.shutdownLogger("Trace", LogTraceIndication.class);
            m_isConfigurationDone = true;
        }
        try {
            LogIPFConfigure.clientIniBering(cclConfig);
        }
        catch (Exception e) {
            LogIPFLog.warn("LogIPFControl::configure(cclConfig) - exception while calling LogIPFConfigure.clientIniBering(cclConfig):", e);
            result = false;
        }
        LogIPFLog.debug("LogIPFControl::configure(cclConfig) - end.");
        return result;
    }

    public static void terminate() {
        LogIPFLog.debug("LogIPFControl::terminate() - calling LogIPFControl.stop().");
        LogIPFControl.stop();
    }

    public static synchronized void stop() {
        LogIPFLog.debug("LogIPFControl::stop() - begin.");
        if (counterRef > 0L && --counterRef == 0L) {
            LogIPFLog.debug("LogIPFControl::stop() - (--counterRef == 0), stop watch dog thread and shutdown loggers.");
            LogIPFControl.stopWatchThreads();
            Enumeration loggerBag = LogManager.getCurrentLoggers();
            if (loggerBag != null) {
                while (loggerBag.hasMoreElements()) {
                    Object o = loggerBag.nextElement();
                    if (!(o instanceof LogTypedLoggerLegacy)) continue;
                    LogTypedLoggerLegacy aLogger = (LogTypedLoggerLegacy)((Object)o);
                    String loggerName = aLogger.getName();
                    LogIPFLog.debug("turn off logger named: " + loggerName);
                    if (!loggerName.startsWith("Audit") && !loggerName.startsWith("Perf") && !loggerName.startsWith("Trace")) continue;
                    aLogger.setLevel(Level.OFF);
                }
            }
            LogIPFControl.shutdownLogger("Audit", LogAuditIndication.class);
            LogIPFControl.shutdownLogger("Perf", LogPerfIndication.class);
            LogIPFControl.shutdownLogger("Trace", LogTraceIndication.class);
            m_isConfigurationDone = false;
        }
        LogIPFLog.debug("LogIPFControl::stop() - end.");
    }

    public static void getStrings() {
        Locale here;
        ICCLConfiguration myConf = CCLConfigurationFactory.createConfiguration();
        try {
            myConf.init();
            String localeString = myConf.getValue("serverLocale", false);
            if (localeString.length() != 0) {
                StringTokenizer st = new StringTokenizer(localeString, "_-", false);
                String languageLoc = st.nextToken();
                if (st.hasMoreTokens()) {
                    String countryLoc = st.nextToken();
                    here = new Locale(languageLoc, countryLoc);
                } else {
                    here = new Locale(languageLoc, "");
                }
            } else {
                here = Locale.getDefault();
            }
        }
        catch (CCLConfigurationException e) {
            here = Locale.getDefault();
        }
        try {
            ResourceBundle textvals = ResourceBundle.getBundle("Log", here);
            LogIPFControl.m_errMsgString[0] = textvals.getString("err0");
            LogIPFControl.m_errMsgString[1] = textvals.getString("err1");
            LogIPFControl.m_errMsgString[2] = textvals.getString("err2");
            LogIPFControl.m_errMsgString[3] = textvals.getString("err3");
            LogIPFControl.m_errMsgString[4] = textvals.getString("err4");
            LogIPFControl.m_errMsgString[5] = textvals.getString("err5");
            LogIPFControl.m_errMsgString[6] = textvals.getString("err6");
        }
        catch (MissingResourceException e) {
            LogIPFLog.debug("LogIPFControl::getStrings() - Log_" + here.getLanguage() + ".properties missing.");
        }
    }

    private static void shutdownLogger(String loggerName, Class base) {
        LogIPFLog.debug("LogIPFControl::shutdownLogger() - Logger name: " + loggerName);
        Logger aLogger = LogManager.exists((String)loggerName);
        if (null == aLogger) {
            LogIPFLog.debug("LogIPFControl::shutdownLogger() - Logger (" + loggerName + ") does not exist");
            return;
        }
        Enumeration enum1 = aLogger.getAllAppenders();
        if (enum1 != null) {
            while (enum1.hasMoreElements()) {
                Appender a = (Appender)enum1.nextElement();
                if (!(a instanceof AppenderAttachable)) continue;
                a.close();
            }
        }
        aLogger.removeAllAppenders();
    }

    public static String getErrMsg(short errCode) {
        if (errCode < 0 || errCode > 6) {
            return null;
        }
        return m_errMsgString[errCode];
    }

    public static void addConfigObserver(Observer o) {
        if (m_configObservable != null) {
            m_configObservable.addObserver(o);
        }
    }

    protected static void notifyConfigObservers() {
        if (m_configObservable != null) {
            m_configObservable.setChanged();
            m_configObservable.notifyObservers();
        }
    }

    public static void openFeedbackLoop() {
        Logger aLogger = LogManager.exists((String)"server.Audit");
        if (null == aLogger) {
            LogIPFLog.warn("LogIPFControl::openFeedbackLoop() - Logger 'server.Audit'  doesn't exist, return");
            return;
        }
        LogLocalUDPAppender newApp = new LogLocalUDPAppender(LogIPFConfigure.getFeedbackPort());
        newApp.setName("FeedbackAppender");
        newApp.setThreshold((Priority)Level.FATAL);
        aLogger.addAppender((Appender)newApp);
        newApp.activateOptions();
        LogIPFLog.debug("LogIPFControl::openFeedbackLoop() - succeed");
    }

    public static void closeFeedbackLoop() {
        Logger aLogger = LogManager.exists((String)"server.Audit");
        if (null == aLogger) {
            LogIPFLog.warn("LogIPFControl::closeFeedbackLoop() - failed to find the 'server.Audit' logger, return");
            return;
        }
        Appender feedbackAppender = null;
        Enumeration enum1 = aLogger.getAllAppenders();
        if (enum1 != null) {
            while (enum1.hasMoreElements()) {
                Appender a = (Appender)enum1.nextElement();
                if (a.getName().compareToIgnoreCase("FeedbackAppender") != 0) continue;
                feedbackAppender = a;
            }
        }
        if (null != feedbackAppender) {
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            feedbackAppender.close();
            aLogger.removeAppender(feedbackAppender);
        }
        LogIPFLog.debug("LogIPFControl::closeFeedbackLoop() - succeed.");
    }

    private static synchronized boolean initCAMCrypto() {
        LogIPFLog.debug("LogIPFControl::initCAMCrypto() - begin.");
        if (m_bIsForIPFTest) {
            LogIPFLog.debug("LogIPFControl::initCAMCrypto() - This is just for IPF testing, no need to initialize CAMCrypto stuff, return true.");
            return true;
        }
        if (m_CAMSigningSession == null) {
            LoggerRepository repository = LogManager.getLoggerRepository();
            if (repository == null) {
                LogIPFLog.error("LogIPFControl::initCAMCrypto() -- LoggerRepository is null, couldn't init CAMCrypto.");
                return false;
            }
            Level curRepLevel = repository.getThreshold();
            boolean result = false;
            try {
                repository.setThreshold(Level.OFF);
                CAMFactory cf = new CAMFactory();
                cf.initialize("<initializeDocument><serviceID>IPF</serviceID></initializeDocument>".getBytes());
                m_CAMSigningSession = cf.createSigningSession();
                repository.setThreshold(curRepLevel);
                if (m_CAMSigningSession == null) {
                    LogIPFLog.error("LogIPFControl::initCAMCrypto() - Cannot create CAM signing session, m_CAMSigningSession is null.");
                    result = false;
                } else {
                    LogIPFLog.debug("LogIPFControl::initCAMCrypto() - succeed.");
                    result = true;
                }
            }
            catch (Exception e) {
                repository.setThreshold(curRepLevel);
                LogIPFLog.error("LogIPFControl::initCAMCrypto() - Cannot create CAM signing session.", e);
                m_CAMSigningSession = null;
                result = false;
            }
            return result;
        }
        return true;
    }

    public static String generateSessionID(String passportId, boolean[] flags) throws Exception {
        if (passportId == null || passportId.length() == 0) {
            return LogIPFControl.addFlagToSessionID(passportId, flags);
        }
        String sessionID = "";
        if (m_CAMSigningSession != null) {
            try {
                byte[] hashObj = m_CAMSigningSession.hash(passportId.getBytes("UTF-8"));
                if (hashObj != null) {
                    sessionID = LogIPFControl.hexify(hashObj);
                }
                LogIPFLog.warn("LogIPFControl::generateSessionID -- m_CAMSigningSession.hash() return null. ");
            }
            catch (Exception e) {
                LogIPFLog.error("LogIPFControl::generateSessionID -- Could not hash the session id, throw the exception. ", e);
                throw e;
            }
        } else if (m_bIsForIPFTest) {
            LogIPFLog.debug("LogIPFControl::generateSessionId -- m_CAMSigningSession == null and this is just for testing, we don't need to hash the passport id for real, just use as it is.");
            byte[] hashObj = passportId.getBytes();
            sessionID = LogIPFControl.hexify(hashObj);
        } else {
            String msg = "LogIPFControl::generateSessionID -- the CAM signing session is null, could not hash the session id.";
            LogIPFLog.error(msg);
            throw new Exception(msg);
        }
        return LogIPFControl.addFlagToSessionID(sessionID, flags);
    }

    public static String addFlagToSessionID(String sessionId, boolean[] flags) {
        String enableDyeTrace = "1";
        if (flags != null && flags.length > 0 && !flags[0]) {
            enableDyeTrace = "0";
        }
        return "f:" + enableDyeTrace + ":" + sessionId;
    }

    public static short getTimeZoneOffset() {
        Calendar cal = Calendar.getInstance();
        m_tzOffset = (short)((cal.get(15) + cal.get(16)) / 60000);
        return m_tzOffset;
    }

    static {
        m_CAMSigningSession = null;
        m_bIsForIPFTest = false;
        m_bIsInitUsingConfigFile = false;
        InetAddress addr = null;
        StringBuffer buffer = new StringBuffer();
        CCLStartupConfiguration startupConfig = new CCLStartupConfiguration();
        int result = startupConfig.getValue("externalDispatcher", false, buffer);
        String dispatcherValue = buffer.toString();
        try {
            URI uri = new URI(dispatcherValue);
            String domain = uri.getHost();
            InetAddress dispatcherAddr = InetAddress.getByName(domain);
            if (domain != null && dispatcherAddr != null && domain.equals(dispatcherAddr.getHostAddress())) {
                addr = dispatcherAddr;
            }
        }
        catch (URISyntaxException e) {
            LogIPFLog.error("LogIPFControl Dispatcher domain is not valid format.");
        }
        catch (UnknownHostException e) {
            LogIPFLog.error("LogIPFControl couldn't find host name network interface");
        }
        if (addr == null) {
            try {
                addr = CCLResolveInetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                LogIPFLog.error("LogIPFControl couldn't find host name network interface");
                addr = CCLResolveInetAddress.getLoopbackAddress();
            }
        }
        if (addr != null) {
            m_ipaddr = addr.getAddress();
            m_ipaddrStr = addr.getHostAddress();
            if (m_ipaddrStr.indexOf(58) != -1) {
                m_ipaddrStr = "[" + m_ipaddrStr + "]";
            }
        } else {
            LogIPFLog.error("LogIPFControl couldn't find local loopback network interface");
        }
        Calendar cal = Calendar.getInstance();
        m_tzOffset = (short)((cal.get(15) + cal.get(16)) / 60000);
        hex_chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        m_errMsgString = new String[7];
        counterRef = 0L;
        m_isConfigurationDone = false;
        logService = null;
        m_clientdogThread = null;
        m_listWatchThreads = new ArrayList();
        m_configObservable = null;
    }
}

