/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.indications.ILogAuditAccessIndication;
import com.cognos.indications.ILogAuditIndication;
import com.cognos.indications.ILogPerfIndication;
import com.cognos.indications.ILogTraceIndication;
import com.cognos.indications.ILogValueTraceIndication;
import com.cognos.indications.LogIPFAuditAccessPatternParser;
import com.cognos.indications.LogIPFAuditPatternParser;
import com.cognos.indications.LogIPFPerfPatternParser;
import com.cognos.indications.LogIPFTracePatternParser;
import com.cognos.indications.LogIPFValueTracePatternParser;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class LogIPFIndLayout
extends PatternLayout {
    public static final String DEFAULT_IPF_CONVERSION_PATTERN = "%LDA\n";
    private StringBuffer sbuf = new StringBuffer(256);
    private String auditPattern;
    private PatternConverter auditHead;
    private String auditAccessPattern;
    private PatternConverter auditAccessHead;
    private String perfPattern;
    private PatternConverter perfHead;
    private String tracePattern;
    private PatternConverter traceHead;
    private String valueTracePattern;
    private PatternConverter valueTraceHead;

    public LogIPFIndLayout() {
        this(DEFAULT_IPF_CONVERSION_PATTERN);
    }

    public LogIPFIndLayout(String pattern) {
        super(pattern);
    }

    public void setAuditConversionPattern(String conversionPattern) {
        this.auditPattern = conversionPattern;
        this.auditHead = this.createAuditPatternParser(conversionPattern).parse();
    }

    public void setAuditAccessConversionPattern(String conversionPattern) {
        this.auditAccessPattern = conversionPattern;
        this.auditAccessHead = this.createAuditAccessPatternParser(conversionPattern).parse();
    }

    public void setPerfConversionPattern(String conversionPattern) {
        this.perfPattern = conversionPattern;
        this.perfHead = this.createPerfPatternParser(conversionPattern).parse();
    }

    public void setTraceConversionPattern(String conversionPattern) {
        this.tracePattern = conversionPattern;
        this.traceHead = this.createTracePatternParser(conversionPattern).parse();
    }

    public void setValueTraceConversionPattern(String conversionPattern) {
        this.valueTracePattern = conversionPattern;
        this.valueTraceHead = this.createValueTracePatternParser(conversionPattern).parse();
    }

    protected PatternParser createAuditPatternParser(String pattern) {
        return new LogIPFAuditPatternParser(pattern);
    }

    protected PatternParser createAuditAccessPatternParser(String pattern) {
        return new LogIPFAuditAccessPatternParser(pattern);
    }

    protected PatternParser createPerfPatternParser(String pattern) {
        return new LogIPFPerfPatternParser(pattern);
    }

    protected PatternParser createTracePatternParser(String pattern) {
        return new LogIPFTracePatternParser(pattern);
    }

    protected PatternParser createValueTracePatternParser(String pattern) {
        return new LogIPFValueTracePatternParser(pattern);
    }

    public String format(LoggingEvent event) {
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        PatternConverter c = null;
        Object o = event.getMessage();
        if (o instanceof ILogPerfIndication) {
            c = this.perfHead;
        }
        if (o instanceof ILogAuditIndication) {
            c = this.auditHead;
        }
        if (o instanceof ILogAuditAccessIndication) {
            c = this.auditAccessHead;
        }
        if (o instanceof ILogTraceIndication) {
            c = this.traceHead;
        }
        if (o instanceof ILogValueTraceIndication) {
            c = this.valueTraceHead;
        }
        while (c != null) {
            c.format(this.sbuf, event);
            c = c.next;
        }
        return this.sbuf.toString();
    }
}

