/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.indications.LogIPFUtils;
import java.io.File;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LogIPFLog {
    private static Logger m_ipfLogger = null;

    private static synchronized void initialize() {
        if (null == m_ipfLogger) {
            try {
                String fileName = CCLConfigurationFactory.getInstance().resolveEffectivePath("../configuration/ipfinternalconfig.xml");
                File file = new File(fileName);
                if (file.exists()) {
                    Document w3cDoc = LogIPFUtils.loadIPFConfigFile(file);
                    if (w3cDoc == null) {
                        m_ipfLogger = null;
                        return;
                    }
                    LogIPFUtils.updateDocWithResolvedPath(w3cDoc);
                    DOMConfigurator.configure((Element)w3cDoc.getDocumentElement());
                    m_ipfLogger = LogManager.exists((String)"CognosIPF.LogLogJava");
                    if (null != m_ipfLogger) {
                        m_ipfLogger.setAdditivity(false);
                    }
                }
            }
            catch (Exception e) {
                m_ipfLogger = null;
                e.printStackTrace();
            }
        }
    }

    public static void error(String msg) {
        if (null == m_ipfLogger) {
            LogIPFLog.initialize();
        }
        if (null != m_ipfLogger && m_ipfLogger.isEnabledFor((Priority)Level.ERROR)) {
            m_ipfLogger.log((Priority)Level.ERROR, (Object)msg);
        }
    }

    public static void error(String msg, Throwable e) {
        if (null == m_ipfLogger) {
            LogIPFLog.initialize();
        }
        if (null != m_ipfLogger && m_ipfLogger.isEnabledFor((Priority)Level.ERROR)) {
            m_ipfLogger.log((Priority)Level.ERROR, (Object)msg, e);
        }
    }

    public static void warn(String msg) {
        if (null == m_ipfLogger) {
            LogIPFLog.initialize();
        }
        if (null != m_ipfLogger && m_ipfLogger.isEnabledFor((Priority)Level.WARN)) {
            m_ipfLogger.log((Priority)Level.WARN, (Object)msg);
        }
    }

    public static void warn(String msg, Throwable e) {
        if (null == m_ipfLogger) {
            LogIPFLog.initialize();
        }
        if (null != m_ipfLogger && m_ipfLogger.isEnabledFor((Priority)Level.WARN)) {
            m_ipfLogger.log((Priority)Level.WARN, (Object)msg, e);
        }
    }

    public static void debug(String msg) {
        if (null == m_ipfLogger) {
            LogIPFLog.initialize();
        }
        if (null != m_ipfLogger && m_ipfLogger.isDebugEnabled()) {
            m_ipfLogger.log((Priority)Level.DEBUG, (Object)msg);
        }
    }

    public static void debug(String msg, Throwable e) {
        if (null == m_ipfLogger) {
            LogIPFLog.initialize();
        }
        if (null != m_ipfLogger && m_ipfLogger.isDebugEnabled()) {
            m_ipfLogger.log((Priority)Level.DEBUG, (Object)msg, e);
        }
    }
}

