/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public class LogIPFPatternConverter
extends PatternConverter {
    int position;
    public static final String IPF_COL_DELIMITER = "\t";
    public static final String IPF_IPADDR = "IPA";
    public static final int IPF_IPADDR_POS = 0;
    public static final String IPF_PORT = "PRT";
    public static final int IPF_PORT_POS = 1;
    public static final String IPF_PROCID = "PID";
    public static final int IPF_PROCID_POS = 2;
    public static final String IPF_TIMESTAMP = "TST";
    public static final int IPF_TIMESTAMP_POS = 3;
    public static final String IPF_TZ = "TZN";
    public static final int IPF_TZ_POS = 4;
    public static final String IPF_SESSIONID = "SID";
    public static final int IPF_SESSIONID_POS = 5;
    public static final String IPF_REQUESTID = "RID";
    public static final int IPF_REQUESTID_POS = 6;
    public static final String IPF_SUBREQID = "SUD";
    public static final int IPF_SUBREQID_POS = 7;
    public static final String IPF_STEPID = "STD";
    public static final int IPF_STEPID_POS = 8;
    public static final String IPF_THREADID = "TID";
    public static final int IPF_THREADID_POS = 9;
    public static final String IPF_COMPID = "CID";
    public static final int IPF_COMPID_POS = 10;
    public static final String IPF_BUILDNUM = "BNM";
    public static final int IPF_BUILDNUM_POS = 11;
    public static final String IPF_LEVEL = "LVL";
    public static final int IPF_LEVEL_POS = 12;
    public static final String IPF_LOGGER = "LOG";
    public static final int IPF_LOGGER_POS = 13;
    public static final String IPF_OPERATION = "OPP";
    public static final int IPF_OPERATION_POS = 14;
    public static final String IPF_LOGDATA = "LDA";
    public static final String IPF_OBJECTTYPE = "OBT";
    public static final String IPF_STATUS = "STA";

    LogIPFPatternConverter(int position) {
        this.position = position;
    }

    public String convert(LoggingEvent event) {
        String indicationMsg = event.getRenderedMessage();
        if (indicationMsg == null) {
            return null;
        }
        switch (this.position) {
            case 0: {
                int stopIndex = indicationMsg.indexOf(":");
                return indicationMsg.substring(0, stopIndex - 1);
            }
            case 1: {
                int startIndex = indicationMsg.indexOf(":");
                int stopIndex = indicationMsg.indexOf(9);
                return indicationMsg.substring(startIndex + 1, stopIndex - 1);
            }
        }
        int ii = -1;
        String tok = null;
        for (int tokPos = 1; tokPos < this.position && ii < indicationMsg.length(); ++tokPos) {
            ii = indicationMsg.indexOf(9, ii + 1);
        }
        if (ii >= 0) {
            tok = indicationMsg.substring(ii + 1, indicationMsg.indexOf(9, ii + 1));
        }
        return tok;
    }
}

