/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.indications.ILogIndication;
import com.cognos.indications.LogIndication;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.apache.log4j.or.ObjectRenderer;

public class LogIndicationRenderer
implements ObjectRenderer {
    private static SimpleDateFormat m_formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public String doRender(Object o) {
        if (o instanceof ILogIndication) {
            ILogIndication ind = (ILogIndication)o;
            String ipaddr = ind.getIPAddrStr();
            String sessId = ind.getRenderedSessionID();
            int sessLen = sessId.length();
            int strBufLength = 100 + sessLen + ind.getRequestID().length() + ind.getSubRequestID().length() + ind.getStepID().length() + ind.getThreadID().length() + ind.getComponentID().length() + ind.getLoggerName().length();
            StringBuffer msg = new StringBuffer(strBufLength);
            msg.append(ipaddr);
            msg.append(":").append(ind.getPort());
            msg.append('\t').append(ind.getProcID());
            msg.append('\t').append(m_formatter.format(new Date(ind.getTime())));
            short tz = ind.getTimeZoneOffset();
            if (tz >= 0) {
                msg.append('\t').append("+");
            } else {
                msg.append('\t');
            }
            int _hour = (tz - tz % 60) / 60;
            int _min = tz % 60;
            msg.append(_hour);
            if (_min != 0) {
                if (_min < 0) {
                    _min = -1 * _min;
                }
                msg.append(":").append(_min);
            }
            msg.append('\t').append(sessId);
            msg.append('\t').append(ind.getRequestID());
            msg.append('\t').append(ind.getSubRequestID());
            msg.append('\t').append(ind.getStepID());
            msg.append('\t').append(ind.getThreadID());
            msg.append('\t').append(ind.getComponentID());
            msg.append('\t').append(ind.getBuildNumber());
            msg.append('\t').append(LogIndication.toInteger(ind.getLevel()));
            msg.append('\t').append(ind.getLoggerName());
            return msg.toString();
        }
        return "";
    }

    protected static String escapeSeparators(String text) {
        if (text == null) {
            return new String(" ");
        }
        LinkedList<Integer> seplist = new LinkedList<Integer>();
        int offset = text.indexOf(9, 0);
        while (offset != -1) {
            seplist.add(new Integer(offset));
            ++offset;
            offset = text.indexOf(9, offset);
        }
        StringBuffer sb = new StringBuffer(text);
        while (seplist.size() > 0) {
            Integer loc = (Integer)seplist.removeLast();
            sb.insert((int)loc, '\t');
        }
        return new String(sb);
    }
}

