/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.indications.ILogAuditAccessIndication;
import com.cognos.indications.ILogIndication;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogIndication;
import com.cognos.indications.dbstore.LogDBConnection;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.jdbc.JDBCAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class LogJDBCAppender
extends JDBCAppender {
    private PreparedStatement stmtInsAction;
    private PreparedStatement stmtInsNativeQuery;
    private PreparedStatement stmtInsOracleNativeQuery;
    private PreparedStatement stmtInsParameter;
    private PreparedStatement stmtInsOracleParameter;
    private PreparedStatement stmtInsRunJob;
    private PreparedStatement stmtInsRunJobStep;
    private PreparedStatement stmtInsRunReport;
    private PreparedStatement stmtInsEditQuery;
    private PreparedStatement stmtInsUserLogon;
    private PreparedStatement stmtInsViewReport;
    private PreparedStatement stmtInsAgentBuild;
    private PreparedStatement stmtInsAgentRun;
    private PreparedStatement stmtInsThresholdViolations;
    private PreparedStatement stmtInsMigration;
    private PreparedStatement stmtInsPowerPlay;
    private PreparedStatement stmtInsPOWERPLAYDimUsage;
    private PreparedStatement stmtInsPOWERPLAYLevelUsage;
    private PreparedStatement stmtInsPOWERPLAYMeasureUsage;
    private PreparedStatement stmtInsHumanTaskService;
    private PreparedStatement stmtInsOracleHumanTaskService;
    private PreparedStatement stmtInsHumanTaskServiceDetails;
    private PreparedStatement stmtInsOracleHumanTaskServiceDetails;
    private PreparedStatement stmtInsAnnotationService;
    private PreparedStatement stmtInsMobileService;
    private PreparedStatement stmtInsRunWorkspace;
    private PreparedStatement stmtInsRunWorkspaceWidget;
    private PreparedStatement stmtSelRunJob;
    private PreparedStatement stmtSelRunJobStep;
    private PreparedStatement stmtSelRunJobWoStepId;
    private PreparedStatement stmtSelRunJobStepWoStepId;
    private PreparedStatement stmtSelNativeQuery;
    private PreparedStatement stmtSelNativeQueryWoStepId;
    private PreparedStatement stmtSelHumanTaskService;
    private PreparedStatement stmtSelHumanTaskServiceDetails;
    private PreparedStatement stmtSelMobileService;
    private PreparedStatement stmtUpdRunJob;
    private PreparedStatement stmtUpdRunJobWoStepId;
    private PreparedStatement stmtUpdRunJobStep;
    private PreparedStatement stmtUpdRunJobStepWoStepId;
    private PreparedStatement stmtUpdRunJobMultiple;
    private PreparedStatement stmtUpdRunJobWoStepIdMultiple;
    private PreparedStatement stmtUpdRunJobStepMultiple;
    private PreparedStatement stmtUpdRunJobStepWoStepIdMultiple;
    private PreparedStatement stmtUpdMobileService;
    private PreparedStatement stmtUpdMobileServiceMultiple;
    private HashMap<String, PreparedStatement> m_mapStmtSelRunReport = new HashMap();
    private HashMap<String, PreparedStatement> m_mapStmtSelEditQuery = new HashMap();
    private HashMap<String, PreparedStatement> m_mapStmtSelPowerPlay = new HashMap();
    private HashMap<String, PreparedStatement> m_mapStmtSelParameter = new HashMap();
    private HashMap<String, PreparedStatement> m_mapStmtUpdRunReport = new HashMap();
    private HashMap<String, PreparedStatement> m_mapStmtUpdEditQuery = new HashMap();
    private HashMap<String, PreparedStatement> m_mapStmtUpdPowerPlay = new HashMap();
    private HashMap<String, PreparedStatement> m_mapStmtUpdRunReportMultiple = new HashMap();
    private HashMap<String, PreparedStatement> m_mapStmtUpdEditQueryMultiple = new HashMap();
    private Connection m_conn = null;
    private static final String emptyRequestID = "empty ReqID";
    private static final String m_emptyString = "";
    private LogDBConnection m_logConnection = null;
    private int databaseType;
    private String m_databaseDriver;
    private Class OracleResultSetClass = null;
    private Method getCLOBMethod = null;
    private Class OracleClobClass = null;
    private Method getCharacterOutputStreamMethod = null;
    private static final int ERROR_MESSAGE_MAX_LENGTH = 2000;
    private static final int TARGET_PATH_MAX_LENGTH = 1024;
    private HashMap<String, HashMap<String, Integer>> m_mapTableColumnSize = new HashMap();
    private boolean isNameInLowerCase = false;

    public void activateOptions() {
        this.m_logConnection = new LogDBConnection();
        this.m_logConnection.setURL(this.databaseURL);
        this.m_logConnection.setUser(LogIPFConfigure.getDBUser());
        this.m_logConnection.setPassword(this.databasePassword);
        this.m_logConnection.setType(this.databaseType);
        this.m_logConnection.setDriver(this.m_databaseDriver);
    }

    public void close() {
        try {
            this.m_logConnection.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void append(LoggingEvent event) {
        if (((ILogIndication)event.getMessage()).getGroup() != 1) {
            return;
        }
        if (null == this.m_conn) {
            this.initialize();
        }
        try {
            super.append(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setIsNameInLowerCase() {
        this.isNameInLowerCase = this.getDBType() == 8;
    }

    private String getNameInProperCase(String name) {
        if (this.isNameInLowerCase && name != null) {
            return name.toLowerCase();
        }
        return name;
    }

    protected void initColumnSize(Connection conn, HashMap<String, HashMap<String, Integer>> tableColMap) {
        if (conn == null || tableColMap == null) {
            return;
        }
        try {
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet columnRS = meta.getColumns(null, null, this.getNameInProperCase("COGIPF") + "_%", "%");
            while (columnRS.next()) {
                String dbColumnName;
                String dbTableName = columnRS.getString(3);
                if (dbTableName == null || dbTableName.length() <= 0) continue;
                HashMap<String, Integer> colSizeMap = tableColMap.get(dbTableName.toUpperCase());
                if (colSizeMap == null) {
                    colSizeMap = new HashMap();
                    tableColMap.put(dbTableName.toUpperCase(), colSizeMap);
                }
                if ((dbColumnName = columnRS.getString(4)) == null || dbColumnName.length() <= 0) continue;
                int colSize = columnRS.getInt(7);
                colSizeMap.put(dbColumnName.toUpperCase(), colSize);
                LogIPFLog.debug("LogJDBCAppender::initColumnSize() - tableName: '" + dbTableName + "', columnName: '" + dbColumnName + "', columnSize: '" + String.valueOf(colSize) + "'.");
            }
        }
        catch (SQLException e) {
            LogIPFLog.error("LogJDBCAppender::initColumnSize() - Could not get the database metadata.", e);
        }
    }

    protected HashMap<String, HashMap<String, Integer>> getColumnSizeMapForTesting() {
        return this.m_mapTableColumnSize;
    }

    private void initColumnSize() {
        this.initColumnSize(this.m_conn, this.m_mapTableColumnSize);
    }

    private int getColumnSize(String tableName, String colName) {
        try {
            HashMap<String, Integer> testmap = this.m_mapTableColumnSize.get(tableName);
            int colLen = testmap.get(colName);
            if (colLen <= 0) {
                return -1;
            }
            return colLen;
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::getColumnSize() - Could not get column size for table '" + tableName + "', column '" + colName + "', ", e);
            return -1;
        }
    }

    private void initStmtForOracle(String headerNames) throws SQLException {
        this.stmtInsOracleNativeQuery = this.m_conn.prepareStatement("INSERT INTO COGIPF_NATIVEQUERY (" + headerNames + " COGIPF_REQUESTSTRING)" + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, EMPTY_CLOB())");
        this.stmtInsOracleParameter = this.m_conn.prepareStatement("INSERT INTO COGIPF_PARAMETER (COGIPF_LOCALTIMESTAMP, COGIPF_SESSIONID, COGIPF_REQUESTID, COGIPF_SUBREQUESTID, COGIPF_STEPID, COGIPF_OPERATION, COGIPF_TARGET_TYPE, COGIPF_PARAMETER_NAME, COGIPF_PARAMETER_VALUE, COGIPF_PARAMETER_VALUE_BLOB) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, EMPTY_CLOB())");
        this.stmtInsOracleHumanTaskService = this.m_conn.prepareStatement("INSERT INTO COGIPF_HUMANTASKSERVICE (COGIPF_HOST_IPADDR, COGIPF_HOST_PORT, COGIPF_PROC_ID, COGIPF_LOCALTIMESTAMP, COGIPF_TIMEZONE_OFFSET, COGIPF_SESSIONID, COGIPF_REQUESTID, COGIPF_STEPID, COGIPF_SUBREQUESTID, COGIPF_THREADID, COGIPF_BUILDNUMBER, COGIPF_OPERATION, COGIPF_TARGET_TYPE, COGIPF_TARGET_PATH, COGIPF_STATUS, COGIPF_LOGENTRYID, COGIPF_TASKID, COGIPF_TRANSACTION_TYPE, COGIPF_USER, COGIPF_TASK_PRIORITY, COGIPF_TASK_STATUS, COGIPF_TASK_ACTIVATION_TIME, COGIPF_TASK_EXPIRATION_TIME, COGIPF_TASK_TIMEZONEID, COGIPF_TASK_ACTUAL_OWNER, COGIPF_TASK_INITIATOR, COGIPF_TASK_CLASS_NAME,  COGIPF_TASK_CLASS_OPERATION, COGIPF_TASK_COMMENT, COGIPF_TASK_NAME, COGIPF_TASK_SUBJECT, COGIPF_TASK_DESCRIPTION) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, EMPTY_CLOB(), EMPTY_CLOB(), EMPTY_CLOB())");
        this.stmtInsOracleHumanTaskServiceDetails = this.m_conn.prepareStatement("INSERT INTO COGIPF_HUMANTASKSERVICE_DETAIL (COGIPF_HOST_IPADDR, COGIPF_HOST_PORT, COGIPF_SESSIONID, COGIPF_REQUESTID, COGIPF_STEPID, COGIPF_SUBREQUESTID, COGIPF_TASKID, COGIPF_LOGENTRYID, COGIPF_HUMANROLE_USER,COGIPF_HUMANROLE_ROLE, COGIPF_SUBSCRIPTION_OPERATION,  COGIPF_SUBSCRIPTION_EVENT, COGIPF_SUBSCRIPTION_USER, COGIPF_TASK_MESSAGE_TYPE, COGIPF_DETAIL_ID, COGIPF_TASK_MESSAGE, COGIPF_NOTIFICATION_DETAILS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, EMPTY_CLOB(), EMPTY_CLOB())");
    }

    private void initialize() {
        LogIPFLog.debug("LogJDBCAppender::initialize() - JDBC appender initial setup");
        if (this.m_conn == null) {
            LogIPFLog.debug("LogJDBCAppender::initialize() - m_conn == null, get connection first: " + this.databaseURL);
            try {
                this.m_conn = this.getConnection();
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::initialize() - JSQLException when get db connection:", e);
            }
        }
        if (this.m_conn != null) {
            try {
                LogIPFLog.debug("LogJDBCAppender::initialize() - m_conn is NOT null.");
                LogIPFLog.debug("LogJDBCAppender::initialize() - Retrieve the column size from audit db tables.");
                this.initColumnSize();
                LogIPFLog.debug("LogJDBCAppender::initialize() - Prepare the SQL statements");
                String headerNames = "COGIPF_HOST_IPADDR, COGIPF_HOST_PORT, COGIPF_PROC_ID, COGIPF_LOCALTIMESTAMP, COGIPF_TIMEZONE_OFFSET, COGIPF_SESSIONID, COGIPF_REQUESTID, COGIPF_STEPID, COGIPF_SUBREQUESTID, COGIPF_THREADID, COGIPF_COMPONENTID, COGIPF_BUILDNUMBER, COGIPF_LOG_LEVEL,";
                this.stmtInsAction = this.m_conn.prepareStatement("INSERT INTO COGIPF_ACTION (" + headerNames + " COGIPF_OPERATION, COGIPF_TARGET_TYPE, COGIPF_TARGET_PATH, COGIPF_STATUS, COGIPF_ERRORDETAILS)" + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsNativeQuery = this.m_conn.prepareStatement("INSERT INTO COGIPF_NATIVEQUERY (" + headerNames + " COGIPF_REQUESTSTRING)" + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsParameter = this.m_conn.prepareStatement("INSERT INTO COGIPF_PARAMETER (COGIPF_LOCALTIMESTAMP, COGIPF_SESSIONID, COGIPF_REQUESTID, COGIPF_SUBREQUESTID, COGIPF_STEPID, COGIPF_OPERATION, COGIPF_TARGET_TYPE, COGIPF_PARAMETER_NAME, COGIPF_PARAMETER_VALUE, COGIPF_PARAMETER_VALUE_BLOB) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsRunJob = this.m_conn.prepareStatement("INSERT INTO COGIPF_RUNJOB (" + headerNames + " COGIPF_JOBPATH, COGIPF_RUNTIME, COGIPF_TARGET_TYPE, COGIPF_STATUS, COGIPF_ERRORDETAILS)" + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsRunJobStep = this.m_conn.prepareStatement("INSERT INTO COGIPF_RUNJOBSTEP (" + headerNames + " COGIPF_JOBSTEPPATH, COGIPF_RUNTIME, COGIPF_TARGET_TYPE, COGIPF_STATUS, COGIPF_ERRORDETAILS)" + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsRunReport = this.m_conn.prepareStatement("INSERT INTO COGIPF_RUNREPORT (" + headerNames + " COGIPF_TARGET_TYPE, COGIPF_REPORTPATH, COGIPF_STATUS, COGIPF_ERRORDETAILS, COGIPF_RUNTIME, COGIPF_REPORTNAME, COGIPF_PACKAGE, COGIPF_MODEL)" + " VALUES " + "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsEditQuery = this.m_conn.prepareStatement("INSERT INTO COGIPF_EDITQUERY (" + headerNames + " COGIPF_TARGET_TYPE, COGIPF_QUERYPATH, COGIPF_STATUS, COGIPF_ERRORDETAILS, COGIPF_RUNTIME, COGIPF_QUERYNAME, COGIPF_PACKAGE, COGIPF_MODEL)" + " VALUES " + "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsUserLogon = this.m_conn.prepareStatement("INSERT INTO COGIPF_USERLOGON (" + headerNames + " COGIPF_LOGON_OPERATION, COGIPF_USERNAME, COGIPF_USERID, COGIPF_NAMESPACE, COGIPF_STATUS, COGIPF_ERRORDETAILS, COGIPF_REMOTE_IPADDR, COGIPF_CAMID, COGIPF_TENANTID)" + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsViewReport = this.m_conn.prepareStatement("INSERT INTO COGIPF_VIEWREPORT (" + headerNames + " COGIPF_TARGET_TYPE, COGIPF_REPORTPATH, COGIPF_STATUS, COGIPF_ERRORDETAILS, COGIPF_REPORTNAME, COGIPF_PACKAGE, COGIPF_MODEL," + " COGIPF_REPORTFORMAT)" + " VALUES " + "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsAgentBuild = this.m_conn.prepareStatement("INSERT INTO COGIPF_AGENTBUILD (" + headerNames + " COGIPF_OPERATION, COGIPF_TARGET_TYPE, COGIPF_TARGET_PATH, COGIPF_TARGET_NAME, COGIPF_STATUS, COGIPF_ERRORDETAILS, COGIPF_AGENT_PATH, COGIPF_SCHEDULETIME, COGIPF_USER," + " COGIPF_EMAIL)" + " VALUES " + "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsAgentRun = this.m_conn.prepareStatement("INSERT INTO COGIPF_AGENTRUN (" + headerNames + " COGIPF_OPERATION, COGIPF_TARGET_TYPE, COGIPF_TARGET_PATH, COGIPF_TARGET_NAME, COGIPF_STATUS, COGIPF_ERRORDETAILS, COGIPF_AGENT_PATH, COGIPF_SCHEDULETIME, COGIPF_USER," + " COGIPF_EMAIL, COGIPF_MESSAGEID)" + " VALUES " + "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsThresholdViolations = this.m_conn.prepareStatement("INSERT INTO COGIPF_THRESHOLD_VIOLATIONS (COGIPF_HOST_IPADDR, COGIPF_HOST_PORT, COGIPF_PROC_ID, COGIPF_LOCALTIMESTAMP, COGIPF_TIMEZONE_OFFSET, COGIPF_COMPONENTID, COGIPF_BUILDNUMBER, COGIPF_LOG_LEVEL, COGIPF_OPERATION, COGIPF_TARGET_TYPE, COGIPF_TARGET_NAME, COGIPF_TARGET_PATH, COGIPF_RESOURCE_TYPE, COGIPF_RESOURCE_PATH, COGIPF_METRIC_NAME, COGIPF_METRIC_VALUE, COGIPF_METRIC_HEALTH, COGIPF_LOWER_AVG_THRSHLD, COGIPF_LOWER_AVG_THRSHLD_EXCL, COGIPF_LOWER_POOR_THRSHLD, COGIPF_LOWER_POOR_THRSHLD_EXCL, COGIPF_UPPER_AVG_THRSHLD, COGIPF_UPPER_AVG_THRSHLD_EXCL, COGIPF_UPPER_POOR_THRSHLD, COGIPF_UPPER_POOR_THRSHLD_EXCL) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsMigration = this.m_conn.prepareStatement("INSERT INTO COGIPF_MIGRATION (" + headerNames + " COGIPF_OPERATION, COGIPF_TARGET_TYPE, COGIPF_TARGET_PATH, COGIPF_TARGET_NAME, COGIPF_STATUS, COGIPF_DETAILS, COGIPF_PACKAGE, COGIPF_MIGRATION_TASK, COGIPF_MSGNUM, COGIPF_SOURCE_TYPE, COGIPF_SOURCE_PATH, COGIPF_SOURCE_NAME)" + " VALUES " + "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsPowerPlay = this.m_conn.prepareStatement("INSERT INTO COGIPF_POWERPLAY (" + headerNames + " COGIPF_TARGET_TYPE, COGIPF_REPORTPATH, COGIPF_STATUS, COGIPF_RUNTIME, COGIPF_REPORTNAME, COGIPF_PACKAGE, COGIPF_DATASOURCE, COGIPF_DATASOURCE_CONNECTION, COGIPF_CUBEPATH, COGIPF_OPERATION, COGIPF_MESSAGE, COGIPF_REQUEST_TYPE, COGIPF_SUB_COMPONENTID)" + " VALUES " + "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsPOWERPLAYLevelUsage = this.m_conn.prepareStatement("INSERT INTO COGIPF_POWERPLAY_LEVEL_USAGE (COGIPF_SESSIONID, COGIPF_REQUESTID, COGIPF_DIM_CODE, COGIPF_LEVEL_CODE, COGIPF_LEVEL_NAME, COGIPF_LEVEL_COUNT) VALUES (?, ?, ?, ?, ?, ?)");
                this.stmtInsPOWERPLAYDimUsage = this.m_conn.prepareStatement("INSERT INTO COGIPF_POWERPLAY_DIM_USAGE (COGIPF_SESSIONID, COGIPF_REQUESTID, COGIPF_DIM_CODE, COGIPF_DIM_NAME, COGIPF_DIM_COUNT) VALUES (?, ?, ?, ?, ?)");
                this.stmtInsPOWERPLAYMeasureUsage = this.m_conn.prepareStatement("INSERT INTO COGIPF_POWERPLAY_MEASURE_USAGE (COGIPF_SESSIONID, COGIPF_REQUESTID, COGIPF_MEASURE_CODE, COGIPF_MEASURE_NAME, COGIPF_MEASURE_COUNT) VALUES (?, ?, ?, ?, ?)");
                this.stmtInsHumanTaskService = this.m_conn.prepareStatement("INSERT INTO COGIPF_HUMANTASKSERVICE (COGIPF_HOST_IPADDR, COGIPF_HOST_PORT, COGIPF_PROC_ID, COGIPF_LOCALTIMESTAMP, COGIPF_TIMEZONE_OFFSET, COGIPF_SESSIONID, COGIPF_REQUESTID, COGIPF_STEPID, COGIPF_SUBREQUESTID, COGIPF_THREADID, COGIPF_BUILDNUMBER, COGIPF_OPERATION, COGIPF_TARGET_TYPE, COGIPF_TARGET_PATH, COGIPF_STATUS, COGIPF_LOGENTRYID, COGIPF_TASKID, COGIPF_TRANSACTION_TYPE, COGIPF_USER, COGIPF_TASK_PRIORITY, COGIPF_TASK_STATUS, COGIPF_TASK_ACTIVATION_TIME, COGIPF_TASK_EXPIRATION_TIME, COGIPF_TASK_NAME, COGIPF_TASK_SUBJECT, COGIPF_TASK_DESCRIPTION, COGIPF_TASK_TIMEZONEID, COGIPF_TASK_ACTUAL_OWNER, COGIPF_TASK_INITIATOR, COGIPF_TASK_CLASS_NAME, COGIPF_TASK_CLASS_OPERATION, COGIPF_TASK_COMMENT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsHumanTaskServiceDetails = this.m_conn.prepareStatement("INSERT INTO COGIPF_HUMANTASKSERVICE_DETAIL (COGIPF_HOST_IPADDR, COGIPF_HOST_PORT, COGIPF_SESSIONID, COGIPF_REQUESTID, COGIPF_STEPID, COGIPF_SUBREQUESTID, COGIPF_TASKID, COGIPF_LOGENTRYID, COGIPF_NOTIFICATION_DETAILS, COGIPF_HUMANROLE_USER, COGIPF_HUMANROLE_ROLE, COGIPF_SUBSCRIPTION_OPERATION, COGIPF_SUBSCRIPTION_EVENT, COGIPF_SUBSCRIPTION_USER, COGIPF_TASK_MESSAGE, COGIPF_TASK_MESSAGE_TYPE, COGIPF_DETAIL_ID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsAnnotationService = this.m_conn.prepareStatement("INSERT INTO COGIPF_ANNOTATIONSERVICE (" + headerNames + " COGIPF_OPERATION, COGIPF_TARGET_TYPE, COGIPF_TARGET_PATH, COGIPF_ANNOTATION_ID, COGIPF_USER, COGIPF_PARENT_ID, COGIPF_CREATION_TIME, COGIPF_UPDATE_TIME)" + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsMobileService = this.m_conn.prepareStatement("INSERT INTO COGIPF_MOBILESERVICE (" + headerNames + " COGIPF_REPORT_TYPE, COGIPF_REPORT_PATH, COGIPF_STATUS, COGIPF_ERRORDETAILS,\tCOGIPF_EVENT_TYPE, COGIPF_REPORT_NAME, COGIPF_STORE_ID, COGIPF_DEVICE_ID, COGIPF_CLIENT_CATEGORY, COGIPF_USER_AGENT, COGIPF_USER_NAME, COGIPF_USER_UID) " + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsRunWorkspace = this.m_conn.prepareStatement("INSERT INTO COGIPF_RUNWORKSPACE (" + headerNames + " COGIPF_WORKSPACENAME, COGIPF_SEARCHPATH, COGIPF_STOREID)" + " VALUES " + "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.stmtInsRunWorkspaceWidget = this.m_conn.prepareStatement("INSERT INTO COGIPF_RUNWORKSPACE_WIDGET (" + headerNames + " COGIPF_DEFAULTTITLE, COGIPF_CUSTOMIZEDTITLE, COGIPF_SOURCENAME, COGIPF_WIDGETTYPE, COGIPF_SEARCHPATH, COGIPF_ORGREPSEARCHPATH, COGIPF_STOREID)" + " VALUES " + "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                if (this.isDBOracle()) {
                    this.initStmtForOracle(headerNames);
                }
                this.stmtSelRunJob = this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_RUNJOB", false, true));
                this.stmtSelRunJobWoStepId = this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_RUNJOB", false, false));
                this.stmtSelRunJobStep = this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_RUNJOBSTEP", false, true));
                this.stmtSelRunJobStepWoStepId = this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_RUNJOBSTEP", false, false));
                this.m_mapStmtSelRunReport.put("SubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_RUNREPORT", true, true)));
                this.m_mapStmtSelRunReport.put("SubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_RUNREPORT", true, false)));
                this.m_mapStmtSelRunReport.put("NoSubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_RUNREPORT", false, true)));
                this.m_mapStmtSelRunReport.put("NoSubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_RUNREPORT", false, false)));
                this.m_mapStmtSelEditQuery.put("SubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_EDITQUERY", true, true)));
                this.m_mapStmtSelEditQuery.put("SubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_EDITQUERY", true, false)));
                this.m_mapStmtSelEditQuery.put("NoSubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_EDITQUERY", false, true)));
                this.m_mapStmtSelEditQuery.put("NoSubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementSelect("COGIPF_EDITQUERY", false, false)));
                this.m_mapStmtSelPowerPlay.put("SubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementSelectPP(true, true)));
                this.m_mapStmtSelPowerPlay.put("SubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementSelectPP(true, false)));
                this.m_mapStmtSelPowerPlay.put("NoSubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementSelectPP(false, true)));
                this.m_mapStmtSelPowerPlay.put("NoSubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementSelectPP(false, false)));
                this.m_mapStmtSelParameter.put("SubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementSelectParameter(true, true)));
                this.m_mapStmtSelParameter.put("SubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementSelectParameter(true, false)));
                this.m_mapStmtSelParameter.put("NoSubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementSelectParameter(false, true)));
                this.m_mapStmtSelParameter.put("NoSubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementSelectParameter(false, false)));
                this.stmtSelNativeQuery = this.isDBOracle() ? this.m_conn.prepareStatement("SELECT COGIPF_REQUESTSTRING FROM COGIPF_NATIVEQUERY WHERE (COGIPF_REQUESTID = ? AND COGIPF_STEPID = ?) FOR UPDATE") : this.m_conn.prepareStatement("SELECT COGIPF_REQUESTSTRING FROM COGIPF_NATIVEQUERY WHERE (COGIPF_REQUESTID = ? AND COGIPF_STEPID = ?)");
                this.stmtSelNativeQueryWoStepId = this.isDBOracle() ? this.m_conn.prepareStatement("SELECT COGIPF_REQUESTSTRING FROM COGIPF_NATIVEQUERY WHERE (COGIPF_REQUESTID = ?) FOR UPDATE") : this.m_conn.prepareStatement("SELECT COGIPF_REQUESTSTRING FROM COGIPF_NATIVEQUERY WHERE (COGIPF_REQUESTID = ?)");
                this.stmtSelHumanTaskService = this.m_conn.prepareStatement("SELECT COGIPF_TASK_NAME, COGIPF_TASK_SUBJECT, COGIPF_TASK_DESCRIPTION FROM COGIPF_HUMANTASKSERVICE WHERE (COGIPF_HOST_IPADDR = ? AND COGIPF_HOST_PORT = ? AND COGIPF_REQUESTID = ? AND COGIPF_STEPID = ? AND COGIPF_SUBREQUESTID = ? AND COGIPF_TASKID = ? AND COGIPF_LOGENTRYID = ?)");
                this.stmtSelHumanTaskServiceDetails = this.m_conn.prepareStatement("SELECT COGIPF_NOTIFICATION_DETAILS, COGIPF_TASK_MESSAGE FROM COGIPF_HUMANTASKSERVICE_DETAIL WHERE (COGIPF_HOST_IPADDR = ? AND COGIPF_HOST_PORT = ? AND COGIPF_REQUESTID = ? AND COGIPF_STEPID = ? AND COGIPF_SUBREQUESTID = ? AND COGIPF_TASKID = ? AND COGIPF_LOGENTRYID = ? AND COGIPF_DETAIL_ID = ?)");
                this.stmtSelMobileService = this.m_conn.prepareStatement("SELECT * FROM COGIPF_MOBILESERVICE WHERE COGIPF_REQUESTID = ? AND COGIPF_USER_UID = ?");
                this.stmtUpdRunJob = this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNJOB", false, false, true));
                this.stmtUpdRunJobWoStepId = this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNJOB", false, false, false));
                this.stmtUpdRunJobStep = this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNJOBSTEP", false, false, true));
                this.stmtUpdRunJobStepWoStepId = this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNJOBSTEP", false, false, false));
                this.stmtUpdMobileService = this.m_conn.prepareStatement(this.genSQLStatementUpdateMobile("COGIPF_MOBILESERVICE", false));
                this.stmtUpdMobileServiceMultiple = this.m_conn.prepareStatement(this.genSQLStatementUpdateMobile("COGIPF_MOBILESERVICE", true));
                this.m_mapStmtUpdRunReport.put("SubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNREPORT", false, true, true)));
                this.m_mapStmtUpdRunReport.put("SubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNREPORT", false, true, false)));
                this.m_mapStmtUpdRunReport.put("NoSubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNREPORT", false, false, true)));
                this.m_mapStmtUpdRunReport.put("NoSubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNREPORT", false, false, false)));
                this.m_mapStmtUpdEditQuery.put("SubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_EDITQUERY", false, true, true)));
                this.m_mapStmtUpdEditQuery.put("SubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_EDITQUERY", false, true, false)));
                this.m_mapStmtUpdEditQuery.put("NoSubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_EDITQUERY", false, false, true)));
                this.m_mapStmtUpdEditQuery.put("NoSubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_EDITQUERY", false, false, false)));
                this.m_mapStmtUpdPowerPlay.put("SubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementUpdatePP(true, true)));
                this.m_mapStmtUpdPowerPlay.put("SubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementUpdatePP(true, false)));
                this.m_mapStmtUpdPowerPlay.put("NoSubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementUpdatePP(false, true)));
                this.m_mapStmtUpdPowerPlay.put("NoSubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementUpdatePP(false, false)));
                this.stmtUpdRunJobMultiple = this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNJOB", true, false, true));
                this.stmtUpdRunJobWoStepIdMultiple = this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNJOB", true, false, false));
                this.stmtUpdRunJobStepMultiple = this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNJOBSTEP", true, false, true));
                this.stmtUpdRunJobStepWoStepIdMultiple = this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNJOBSTEP", true, false, false));
                this.m_mapStmtUpdRunReportMultiple.put("SubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNREPORT", true, true, true)));
                this.m_mapStmtUpdRunReportMultiple.put("SubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNREPORT", true, true, false)));
                this.m_mapStmtUpdRunReportMultiple.put("NoSubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNREPORT", true, false, true)));
                this.m_mapStmtUpdRunReportMultiple.put("NoSubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_RUNREPORT", true, false, false)));
                this.m_mapStmtUpdEditQueryMultiple.put("SubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_EDITQUERY", true, true, true)));
                this.m_mapStmtUpdEditQueryMultiple.put("SubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_EDITQUERY", true, true, false)));
                this.m_mapStmtUpdEditQueryMultiple.put("NoSubReqId-StepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_EDITQUERY", true, false, true)));
                this.m_mapStmtUpdEditQueryMultiple.put("NoSubReqId-NoStepId", this.m_conn.prepareStatement(this.genSQLStatementUpdate("COGIPF_EDITQUERY", true, false, false)));
                try {
                    if (this.isDBOracle()) {
                        this.OracleResultSetClass = Class.forName("oracle.jdbc.OracleResultSet");
                        if (this.OracleResultSetClass != null) {
                            this.getCLOBMethod = this.OracleResultSetClass.getMethod("getCLOB", String.class);
                        }
                        this.OracleClobClass = Class.forName("oracle.sql.CLOB");
                        if (this.OracleClobClass != null) {
                            this.getCharacterOutputStreamMethod = this.OracleClobClass.getMethod("getCharacterOutputStream", null);
                        }
                    }
                }
                catch (Exception e) {
                    LogIPFLog.error("LogJDBCAppender::initialize() - Exception when load getCLOB method for ORACLE thin.", e);
                }
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::initialize() - SQLWarning: ", e);
                return;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::initialize() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure", e);
                return;
            }
        }
        LogIPFLog.debug("LogJDBCAppender::initialize() - JDBC appender initial setup succeed.");
    }

    private String genSQLStatementUpdate(String tableName, boolean isMultiple, boolean withSubReqid, boolean withStepid) {
        String setClause = isMultiple ? ", COGIPF_LOCALTIMESTAMP = ?, COGIPF_STATUS = ?, COGIPF_ERRORDETAILS = ?" : m_emptyString;
        String whereClause1 = withSubReqid ? " AND COGIPF_SUBREQUESTID = ?" : m_emptyString;
        String whereClause2 = withStepid ? " AND COGIPF_STEPID = ?" : m_emptyString;
        return "UPDATE " + tableName + " SET COGIPF_RUNTIME = ?" + setClause + " WHERE (COGIPF_REQUESTID = ?" + whereClause1 + whereClause2 + ")";
    }

    private String genSQLStatementUpdatePP(boolean withSubReqid, boolean withStepid) {
        String whereClause1 = withSubReqid ? " AND COGIPF_SUBREQUESTID = ?" : m_emptyString;
        String whereClause2 = withStepid ? " AND COGIPF_STEPID = ?" : m_emptyString;
        return "UPDATE COGIPF_POWERPLAY SET COGIPF_LOCALTIMESTAMP = ?, COGIPF_TARGET_TYPE = ?, COGIPF_REPORTPATH = ?, COGIPF_STATUS = ?, COGIPF_RUNTIME = ?, COGIPF_REPORTNAME = ?, COGIPF_PACKAGE = ?, COGIPF_DATASOURCE = ?, COGIPF_DATASOURCE_CONNECTION = ?, COGIPF_OPERATION = ?, COGIPF_MESSAGE = ?, COGIPF_REQUEST_TYPE  = ?, COGIPF_SUB_COMPONENTID = ? WHERE (COGIPF_REQUESTID = ?" + whereClause1 + whereClause2 + ")";
    }

    private String genSQLStatementUpdateMobile(String tableName, boolean isMultiple) {
        String setClause = isMultiple ? ", COGIPF_LOCALTIMESTAMP = ?, COGIPF_STATUS = ?, COGIPF_ERRORDETAILS = ?" : m_emptyString;
        return "UPDATE " + tableName + " SET COGIPF_RUNTIME = ?" + setClause + " WHERE (COGIPF_REQUESTID = ? AND COGIPF_USER_UID = ?)";
    }

    private String genSQLStatementSelect(String tableName, boolean withSubReqid, boolean withStepid) {
        String whereClause1 = withSubReqid ? " AND COGIPF_SUBREQUESTID = ?" : m_emptyString;
        String whereClause2 = withStepid ? " AND COGIPF_STEPID = ?" : m_emptyString;
        return "SELECT COGIPF_LOCALTIMESTAMP, COGIPF_STATUS, COGIPF_RUNTIME FROM " + tableName + " WHERE (COGIPF_REQUESTID = ?" + whereClause1 + whereClause2 + ")";
    }

    private String genSQLStatementSelectParameter(boolean withSubReqid, boolean withStepid) {
        String whereClause1 = withSubReqid ? " AND COGIPF_SUBREQUESTID = ?" : m_emptyString;
        String whereClause2 = withStepid ? " AND COGIPF_STEPID = ?" : m_emptyString;
        return "SELECT COGIPF_PARAMETER_VALUE_BLOB FROM COGIPF_PARAMETER WHERE (COGIPF_REQUESTID = ? AND COGIPF_PARAMETER_NAME = ?" + whereClause1 + whereClause2 + ")";
    }

    private String genSQLStatementSelectPP(boolean withSubReqid, boolean withStepid) {
        String whereClause1 = withSubReqid ? " AND COGIPF_SUBREQUESTID = ?" : m_emptyString;
        String whereClause2 = withStepid ? " AND COGIPF_STEPID = ?" : m_emptyString;
        return "SELECT * FROM COGIPF_POWERPLAY WHERE (COGIPF_REQUESTID = ?" + whereClause1 + whereClause2 + ")";
    }

    private String getErrorMessage(LogAuditAccessIndication aind, int colLen) {
        int colSize = colLen;
        if (colLen <= 0) {
            colSize = 2000;
            LogIPFLog.debug("LogJDBCAppender::getErrorMessage() - Set colSize to ERROR_MESSAGE_MAX_LENGTH: 2000");
        }
        String result = this.processColumnValue(aind.getErrorMessage(), colSize);
        LogIPFLog.debug("LogJDBCAppender::getErrorMessage() - processColumnValue() return: '" + result + "'.");
        return result;
    }

    private String getObjectPath(LogAuditAccessIndication aind, int colLen) {
        int colSize = colLen;
        if (colLen <= 0) {
            colSize = 1024;
        }
        return this.processColumnValue(aind.getObjectPath(), colSize);
    }

    private String processColumnValue(String colVal, int colLen, boolean bTruncRight) {
        if (colVal == null) {
            return m_emptyString;
        }
        String resVal = colVal;
        try {
            byte[] resValBytes = resVal.getBytes("UTF-8");
            if (resValBytes.length > colLen) {
                LogIPFLog.debug("LogJDBCAppender::processColumnValue() - value exceed column size in bytes. Expected column size: '" + String.valueOf(colLen) + ", Value: '" + resVal + "', Bytes: '" + resValBytes.length + "'.");
                int exceedBytes = resValBytes.length - colLen;
                resVal = exceedBytes < resVal.length() ? (bTruncRight ? resVal.substring(0, resVal.length() - exceedBytes) : resVal.substring(exceedBytes, resVal.length())) : this.truncateMultibyteString(resVal, colLen, bTruncRight);
                LogIPFLog.debug("LogJDBCAppender::processColumnValue() - Value after truncation: '" + resVal + "'.");
            }
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::processColumnValue() - can't get bytes. " + e);
        }
        return resVal;
    }

    private String processColumnValue(String colVal, int colLen) {
        return this.processColumnValue(colVal, colLen, true);
    }

    private String truncateMultibyteString(String colVal, int colLen, boolean bTruncRight) {
        if (colVal != null && colVal.length() > 0) {
            int resLen = colVal.length() / 2;
            String resVal = m_emptyString;
            resVal = bTruncRight ? colVal.substring(0, resLen) : colVal.substring(resLen, colVal.length());
            try {
                byte[] resValBytes = resVal.getBytes("UTF-8");
                if (resValBytes.length > colLen) {
                    LogIPFLog.debug("LogJDBCAppender::truncateMultibyteString() - the value still need truncate: '" + resVal + "'.");
                    return this.truncateMultibyteString(resVal, colLen, bTruncRight);
                }
                LogIPFLog.debug("LogJDBCAppender::truncateMultibyteString() - Value after truncate in half: '" + resVal + "'.");
                return resVal;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::truncateMultibyteString() - can't get bytes. " + e);
                return resVal;
            }
        }
        return m_emptyString;
    }

    public String truncateStringTest(String colVal, int colLen, boolean bTruncRight) {
        return this.processColumnValue(colVal, colLen, bTruncRight);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized String getLogStatement(LoggingEvent p0) {
        HashMap<String, String> logDataMap;
        String[] crackURLTmp;
        if (this.m_conn == null) {
            return null;
        }
        LogAuditIndication ind = (LogAuditIndication)p0.getMessage();
        int level = ind.getLevel();
        String operation = ind.getOperation();
        String tmpReqID = ind.getRequestID();
        if (null == tmpReqID) {
            ind.setRequestID(m_emptyString);
        }
        if (level == 50000) {
            if (!operation.equalsIgnoreCase("ThresholdViolation")) return null;
            if (!(ind instanceof ILogAuditAccessIndication)) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - A ThresholdViolation audit indication is logged on level 1 but it is NOT a LogAuditAccessIndication, drop it from DB. The logger is " + ind.getLoggerName());
                return null;
            }
            LogAuditAccessIndication aind = (LogAuditAccessIndication)ind;
            String object = aind.getObjectType();
            if (!object.equalsIgnoreCase("Threshold_Manager")) {
                return null;
            }
            try {
                this.stmtInsThresholdViolations.setString(1, ind.getIPAddrStr());
                this.stmtInsThresholdViolations.setInt(2, ind.getPort());
                this.stmtInsThresholdViolations.setInt(3, ind.getProcID());
                this.stmtInsThresholdViolations.setTimestamp(4, new Timestamp(ind.getTime()));
                this.stmtInsThresholdViolations.setShort(5, (short)(ind.getTimeZoneOffset() / 60));
                String tmpStr = ind.getComponentID();
                if (tmpStr.length() > 8) {
                    this.stmtInsThresholdViolations.setString(6, tmpStr.substring(0, 8));
                } else {
                    this.stmtInsThresholdViolations.setString(6, tmpStr);
                }
                this.stmtInsThresholdViolations.setInt(7, ind.getBuildNumber());
                this.stmtInsThresholdViolations.setInt(8, LogAuditIndication.toInteger(ind.getLevel()));
                this.stmtInsThresholdViolations.setString(9, operation);
                this.stmtInsThresholdViolations.setString(10, object);
                String[] crackURLTmp2 = this.crackURL(aind.getObjectPath());
                this.stmtInsThresholdViolations.setString(11, crackURLTmp2[1]);
                this.stmtInsThresholdViolations.setString(12, this.processColumnValue(crackURLTmp2[0], this.getColumnSize("COGIPF_THRESHOLD_VIOLATIONS", "COGIPF_TARGET_PATH")));
                HashMap<String, String> logDataMap2 = this.parseLogData(aind.getLogData());
                this.stmtInsThresholdViolations.setString(13, this.searchXML(logDataMap2, "ResourceType"));
                this.stmtInsThresholdViolations.setString(14, this.processColumnValue(this.searchXML(logDataMap2, "ResourcePath"), this.getColumnSize("COGIPF_THRESHOLD_VIOLATIONS", "COGIPF_RESOURCE_PATH")));
                this.stmtInsThresholdViolations.setString(15, this.searchXML(logDataMap2, "MetricName"));
                this.stmtInsThresholdViolations.setString(16, this.searchXML(logDataMap2, "MetricValue"));
                this.stmtInsThresholdViolations.setString(17, this.searchXML(logDataMap2, "MetricHealth"));
                this.stmtInsThresholdViolations.setString(18, this.searchXML(logDataMap2, "LowerSideAverageThreshold"));
                String sExcl = this.searchXML(logDataMap2, "LowerSideAverageThresholdExclusive");
                Boolean bExcl = new Boolean(sExcl);
                this.stmtInsThresholdViolations.setBoolean(19, bExcl);
                this.stmtInsThresholdViolations.setString(20, this.searchXML(logDataMap2, "LowerSidePoorThreshold"));
                sExcl = this.searchXML(logDataMap2, "LowerSidePoorThresholdExclusive");
                bExcl = new Boolean(sExcl);
                this.stmtInsThresholdViolations.setBoolean(21, bExcl);
                this.stmtInsThresholdViolations.setString(22, this.searchXML(logDataMap2, "UpperSideAverageThreshold"));
                sExcl = this.searchXML(logDataMap2, "UpperSideAverageThresholdExclusive");
                bExcl = new Boolean(sExcl);
                this.stmtInsThresholdViolations.setBoolean(23, bExcl);
                this.stmtInsThresholdViolations.setString(24, this.searchXML(logDataMap2, "UpperSidePoorThreshold"));
                sExcl = this.searchXML(logDataMap2, "UpperSidePoorThresholdExclusive");
                bExcl = new Boolean(sExcl);
                this.stmtInsThresholdViolations.setBoolean(25, bExcl);
                this.stmtInsThresholdViolations.execute();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_THRESHOLD_VIOLATIONS", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_THRESHOLD_VIOLATIONS ", e);
            }
            return null;
        }
        if (level == 40000) {
            if (!operation.equalsIgnoreCase("Logon") && !operation.equalsIgnoreCase("Trusted Credential") && !operation.equalsIgnoreCase("Logoff") && !operation.equalsIgnoreCase("SelectTenants") && !operation.equalsIgnoreCase("LogonExpired") && !operation.equalsIgnoreCase("ForcedLogoff")) return null;
            if (!(ind instanceof ILogAuditAccessIndication)) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - A " + operation + "audit indication is logged on level 2 but it is NOT a LogAuditAccessIndication, drop it from DB. The logger is " + ind.getLoggerName());
                return null;
            }
            if (null == ind.getRequestID() || ind.getRequestID().equals(m_emptyString)) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Request ID is missing in this " + operation + " audit indication (Level 2). The logger is " + ind.getLoggerName());
            }
            LogAuditAccessIndication aind = (LogAuditAccessIndication)ind;
            try {
                HashMap<String, String> logDataMap3 = this.parseLogData(aind.getLogData());
                this.stuffHeader(this.stmtInsUserLogon, ind);
                this.stmtInsUserLogon.setString(14, operation);
                this.stmtInsUserLogon.setString(15, this.searchXML(logDataMap3, "display name"));
                this.stmtInsUserLogon.setString(16, this.searchXML(logDataMap3, "username"));
                this.stmtInsUserLogon.setString(17, this.searchXML(logDataMap3, "namespace"));
                this.stmtInsUserLogon.setString(18, aind.getStatus());
                this.stmtInsUserLogon.setString(19, this.getErrorMessage(aind, this.getColumnSize("COGIPF_USERLOGON", "COGIPF_ERRORDETAILS")));
                this.stmtInsUserLogon.setString(20, this.searchXML(logDataMap3, "REMOTE_ADDR"));
                this.stmtInsUserLogon.setString(21, this.searchXML(logDataMap3, "CAMID"));
                this.stmtInsUserLogon.setString(22, this.searchXML(logDataMap3, "TENANTID"));
                this.stmtInsUserLogon.execute();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_USERLOGON", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_USERLOGON ", e);
            }
            return null;
        }
        if (level == 20000 && ind.getComponentID() != null && ind.getComponentID().equalsIgnoreCase("PPS")) {
            LogAuditAccessIndication aind;
            if (!LogAuditAccessIndication.class.isInstance(ind) || !(aind = (LogAuditAccessIndication)ind).getObjectType().equalsIgnoreCase("Powerplay8CubeData")) return null;
            String logdata = aind.getLogData();
            if (this.m_conn == null || null == logdata || logdata.length() <= 0) return null;
            try {
                this.m_conn.setAutoCommit(false);
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_POWERPLAY tables,calling m_conn.setAutoCommit(false) ", e);
                return null;
            }
            try {
                this.insertPowerPlayUsageTables(aind);
                this.m_conn.commit();
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_POWERPLAY tables " + logdata, e);
                try {
                    this.m_conn.rollback();
                }
                catch (Exception e1) {
                    LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while rollback connection", e1);
                }
            }
            try {
                this.m_conn.setAutoCommit(true);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_POWERPLAY tables, calling m_conn.setAutoCommit(true) ", e);
            }
            return null;
        }
        if (level == 10000 || level == 20000 && ind.getComponentID() != null && ind.getComponentID().equalsIgnoreCase("XQE")) {
            if (!ind.getOperation().equalsIgnoreCase("NativeQuery")) return null;
            if (null == ind.getRequestID() || ind.getRequestID().equals(m_emptyString)) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Request ID is missing in this NATIVEQUERY audit indication (Level 5). The logger is " + ind.getLoggerName());
            }
            String logData = ind.getLogData();
            if (this.m_conn == null) return null;
            try {
                this.m_conn.setAutoCommit(false);
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_NATIVEQUERY ", e);
                return null;
            }
            try {
                if (this.isDBOracle()) {
                    this.stuffHeader(this.stmtInsOracleNativeQuery, ind);
                    this.stmtInsOracleNativeQuery.execute();
                    ResultSet nativeQueryResult = null;
                    String stepId = ind.getStepID();
                    if (null == stepId || 0 == stepId.length()) {
                        this.stmtSelNativeQueryWoStepId.setString(1, ind.getRequestID());
                        nativeQueryResult = this.stmtSelNativeQueryWoStepId.executeQuery();
                    } else {
                        this.stmtSelNativeQuery.setString(1, ind.getRequestID());
                        this.stmtSelNativeQuery.setString(2, ind.getStepID());
                        nativeQueryResult = this.stmtSelNativeQuery.executeQuery();
                    }
                    while (nativeQueryResult.next()) {
                        this.bindOracleCLOBToResultSet(logData, nativeQueryResult, "COGIPF_REQUESTSTRING");
                    }
                } else {
                    this.stmtInsNativeQuery.clearParameters();
                    this.stuffHeader(this.stmtInsNativeQuery, ind);
                    this.bindCLOBData(this.stmtInsNativeQuery, 14, logData);
                    this.stmtInsNativeQuery.execute();
                }
                this.m_conn.commit();
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_NATIVEQUERY " + logData, e);
                try {
                    this.m_conn.rollback();
                }
                catch (Exception e1) {
                    LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while rollback connection", e1);
                }
            }
            try {
                this.m_conn.setAutoCommit(true);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_NATIVEQUERY ", e);
            }
            return null;
        }
        if (level != 30000) return null;
        ResultSet runRepResult = null;
        ResultSet editQueryResult = null;
        ResultSet runJobResult = null;
        ResultSet runJobStepResult = null;
        if (!(ind instanceof ILogAuditAccessIndication)) {
            LogIPFLog.error("LogJDBCAppender::getLogStatement() - A audit indication is logged on level 3 but it is NOT a LogAuditAccessIndication, drop it from DB. The logger is " + ind.getLoggerName());
            return null;
        }
        LogAuditAccessIndication aind = (LogAuditAccessIndication)ind;
        String object = aind.getObjectType();
        if (null == aind.getRequestID() || aind.getRequestID().equals(m_emptyString)) {
            LogIPFLog.error("LogJDBCAppender::getLogStatement() - Request ID is missing in this '" + operation + " " + object + "' audit indication (Level 3). The logger is '" + ind.getLoggerName() + "'");
        }
        if (!object.startsWith("Workspace")) {
            String plogdata = aind.getLogData();
            if (this.m_conn != null && null != plogdata && plogdata.length() > 0) {
                try {
                    this.m_conn.setAutoCommit(false);
                }
                catch (Exception e) {
                    LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_PARAMETER tables,calling m_conn.setAutoCommit(false) ", e);
                    return null;
                }
                try {
                    this.putParameters(aind);
                    this.m_conn.commit();
                }
                catch (Exception e) {
                    LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_PARAMETER table." + plogdata, e);
                    try {
                        this.m_conn.rollback();
                    }
                    catch (Exception e1) {
                        LogIPFLog.error("LogJDBCAppender::getLogStatement() - inserting into COGIPF_PARAMETER - Exception while rollback connection", e1);
                    }
                }
                try {
                    this.m_conn.setAutoCommit(true);
                }
                catch (Exception e) {
                    LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_PARAMETER tables, calling m_conn.setAutoCommit(true) ", e);
                }
            }
        }
        boolean nullStepID = false;
        if (null == aind.getStepID() || aind.getStepID().equals(m_emptyString)) {
            nullStepID = true;
        }
        if (operation.equalsIgnoreCase("Submit") && object.equalsIgnoreCase("JobDefinition")) {
            try {
                if (nullStepID) {
                    this.stmtSelRunJobWoStepId.setString(1, aind.getRequestID());
                    runJobResult = this.stmtSelRunJobWoStepId.executeQuery();
                } else {
                    this.stmtSelRunJob.setString(1, aind.getRequestID());
                    this.stmtSelRunJob.setString(2, aind.getStepID());
                    runJobResult = this.stmtSelRunJob.executeQuery();
                }
                int errorMsgLen = this.getColumnSize("COGIPF_RUNJOB", "COGIPF_ERRORDETAILS");
                if (runJobResult.next()) {
                    if (nullStepID) {
                        this.needToUpdateRuntime(runJobResult, aind, this.stmtUpdRunJobWoStepId, this.stmtUpdRunJobWoStepIdMultiple, false, false, errorMsgLen);
                        return null;
                    } else {
                        this.needToUpdateRuntime(runJobResult, aind, this.stmtUpdRunJob, this.stmtUpdRunJobMultiple, true, false, errorMsgLen);
                    }
                    return null;
                }
                runJobResult.close();
                runJobResult = null;
                this.stuffHeader(this.stmtInsRunJob, ind);
                this.stmtInsRunJob.setString(14, this.getObjectPath(aind, this.getColumnSize("COGIPF_RUNJOB", "COGIPF_JOBPATH")));
                this.stmtInsRunJob.setInt(15, 0);
                this.stmtInsRunJob.setString(16, aind.getObjectType());
                this.stmtInsRunJob.setString(17, aind.getStatus());
                this.stmtInsRunJob.setString(18, this.getErrorMessage(aind, errorMsgLen));
                this.stmtInsRunJob.executeUpdate();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_RUNJOB", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_RUNJOB ", e);
            }
            return null;
        }
        if (operation.equalsIgnoreCase("Submit") && object.equalsIgnoreCase("JobStepDefinition")) {
            try {
                if (nullStepID) {
                    this.stmtSelRunJobStepWoStepId.setString(1, aind.getRequestID());
                    runJobStepResult = this.stmtSelRunJobStepWoStepId.executeQuery();
                } else {
                    this.stmtSelRunJobStep.setString(1, aind.getRequestID());
                    this.stmtSelRunJobStep.setString(2, aind.getStepID());
                    runJobStepResult = this.stmtSelRunJobStep.executeQuery();
                }
                int errorMsgLen = this.getColumnSize("COGIPF_RUNJOBSTEP", "COGIPF_ERRORDETAILS");
                if (runJobStepResult.next()) {
                    if (nullStepID) {
                        this.needToUpdateRuntime(runJobStepResult, aind, this.stmtUpdRunJobStepWoStepId, this.stmtUpdRunJobStepWoStepIdMultiple, false, false, errorMsgLen);
                        return null;
                    } else {
                        this.needToUpdateRuntime(runJobStepResult, aind, this.stmtUpdRunJobStep, this.stmtUpdRunJobStepMultiple, true, false, errorMsgLen);
                    }
                    return null;
                }
                runJobStepResult.close();
                runJobStepResult = null;
                this.stuffHeader(this.stmtInsRunJobStep, ind);
                this.stmtInsRunJobStep.setString(14, this.getObjectPath(aind, this.getColumnSize("COGIPF_RUNJOBSTEP", "COGIPF_JOBSTEPPATH")));
                this.stmtInsRunJobStep.setInt(15, 0);
                this.stmtInsRunJobStep.setString(16, aind.getObjectType());
                this.stmtInsRunJobStep.setString(17, aind.getStatus());
                this.stmtInsRunJobStep.setString(18, this.getErrorMessage(aind, errorMsgLen));
                this.stmtInsRunJobStep.executeUpdate();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_RUNJOBSTEP", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_RUNJOBSTEP ", e);
            }
            return null;
        }
        if (operation.startsWith("Execute") && (object.startsWith("Report") || object.startsWith("ReportView") || object.startsWith("Query") && !object.startsWith("QueryFramework") || object.startsWith("Analysis") || object.startsWith("PowerplayReport") || object.startsWith("Exploration"))) {
            try {
                String entryId;
                PreparedStatement stmtSelRunReport;
                boolean nullSubReqID = false;
                if (null == aind.getSubRequestID() || aind.getSubRequestID().equals(m_emptyString)) {
                    nullSubReqID = true;
                }
                if ((stmtSelRunReport = this.m_mapStmtSelRunReport.get(entryId = (nullSubReqID ? "NoSubReqId" : "SubReqId") + "-" + (nullStepID ? "NoStepId" : "StepId"))) == null) {
                    LogIPFLog.error("LogJDBCAppender::getLogStatement() - couldn't find PreparedStatment m_mapStmtSelRunReport.get('" + entryId + "')");
                    return null;
                }
                stmtSelRunReport.setString(1, aind.getRequestID());
                if (!nullSubReqID) {
                    stmtSelRunReport.setString(2, aind.getSubRequestID());
                    if (!nullStepID) {
                        stmtSelRunReport.setString(3, aind.getStepID());
                    }
                } else if (!nullStepID) {
                    stmtSelRunReport.setString(2, aind.getStepID());
                }
                runRepResult = stmtSelRunReport.executeQuery();
                int errorMsgLen = this.getColumnSize("COGIPF_RUNREPORT", "COGIPF_ERRORDETAILS");
                if (runRepResult.next()) {
                    PreparedStatement stmtUpdRunReport = this.m_mapStmtUpdRunReport.get(entryId);
                    PreparedStatement stmtUpdRunReportMultiple = this.m_mapStmtUpdRunReportMultiple.get(entryId);
                    if (stmtUpdRunReport == null || stmtUpdRunReportMultiple == null) {
                        LogIPFLog.error("LogJDBCAppender::getLogStatement() - couldn't find PreparedStatment m_mapStmtUpdRunReport.get('" + entryId + "')");
                        return null;
                    }
                    this.needToUpdateRuntime(runRepResult, aind, stmtUpdRunReport, stmtUpdRunReportMultiple, !nullStepID, !nullSubReqID, errorMsgLen);
                    return null;
                }
                runRepResult.close();
                runRepResult = null;
                this.stuffHeader(this.stmtInsRunReport, ind);
                this.stmtInsRunReport.setString(14, aind.getObjectType());
                this.stmtInsRunReport.setString(15, this.getObjectPath(aind, this.getColumnSize("COGIPF_RUNREPORT", "COGIPF_REPORTPATH")));
                this.stmtInsRunReport.setString(16, aind.getStatus());
                this.stmtInsRunReport.setString(17, this.getErrorMessage(aind, errorMsgLen));
                this.stmtInsRunReport.setInt(18, 0);
                String[] crackURLTmp3 = this.crackURL(aind.getObjectPath());
                this.stmtInsRunReport.setString(19, crackURLTmp3[1]);
                HashMap<String, String> logDataMap4 = this.parseLogData(aind.getLogData());
                String modelName = this.searchXML(logDataMap4, "MODEL");
                String packageName = this.searchXML(logDataMap4, "PACKAGE");
                int thePackageColSize = this.getColumnSize("COGIPF_RUNREPORT", "COGIPF_PACKAGE");
                if (packageName != null && packageName.length() > 0) {
                    this.stmtInsRunReport.setString(20, this.processColumnValue(packageName, thePackageColSize, false));
                } else {
                    this.stmtInsRunReport.setString(20, this.processColumnValue(modelName, thePackageColSize, false));
                }
                this.stmtInsRunReport.setString(21, this.processColumnValue(modelName, this.getColumnSize("COGIPF_RUNREPORT", "COGIPF_MODEL"), false));
                this.stmtInsRunReport.executeUpdate();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_RUNREPORT", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_RUNREPORT ", e);
            }
            return null;
        }
        if (operation.startsWith("Execute") && object.startsWith("Workspace")) {
            this.getLogStatementForWorkspace(object, ind, aind);
            return null;
        }
        if ((operation.startsWith("EditQuery") || operation.startsWith("EditAnalysis")) && (object.startsWith("Query") || object.startsWith("Analysis"))) {
            try {
                String entryId;
                PreparedStatement stmtSelEditQuery;
                boolean nullSubReqID = false;
                if (null == aind.getSubRequestID() || aind.getSubRequestID().equals(m_emptyString)) {
                    nullSubReqID = true;
                }
                if ((stmtSelEditQuery = this.m_mapStmtSelEditQuery.get(entryId = (nullSubReqID ? "NoSubReqId" : "SubReqId") + "-" + (nullStepID ? "NoStepId" : "StepId"))) == null) {
                    LogIPFLog.error("LogJDBCAppender::getLogStatement() - couldn't find PreparedStatment m_mapStmtSelEditQuery.get('" + entryId + "')");
                    return null;
                }
                stmtSelEditQuery.setString(1, aind.getRequestID());
                if (!nullSubReqID) {
                    stmtSelEditQuery.setString(2, aind.getSubRequestID());
                    if (!nullStepID) {
                        stmtSelEditQuery.setString(3, aind.getStepID());
                    }
                } else if (!nullStepID) {
                    stmtSelEditQuery.setString(2, aind.getStepID());
                }
                editQueryResult = stmtSelEditQuery.executeQuery();
                int errorMsgLen = this.getColumnSize("COGIPF_EDITQUERY", "COGIPF_ERRORDETAILS");
                if (editQueryResult.next()) {
                    PreparedStatement stmtUpdEditQuery = this.m_mapStmtUpdEditQuery.get(entryId);
                    PreparedStatement stmtUpdEditQueryMultiple = this.m_mapStmtUpdEditQueryMultiple.get(entryId);
                    if (stmtUpdEditQuery == null || stmtUpdEditQueryMultiple == null) {
                        LogIPFLog.error("LogJDBCAppender::getLogStatement() - couldn't find PreparedStatment m_mapStmtUpdEditQuery.get('" + entryId + "')");
                        return null;
                    }
                    this.needToUpdateRuntime(editQueryResult, aind, stmtUpdEditQuery, stmtUpdEditQueryMultiple, !nullStepID, !nullSubReqID, errorMsgLen);
                    return null;
                }
                editQueryResult.close();
                editQueryResult = null;
                this.stuffHeader(this.stmtInsEditQuery, ind);
                this.stmtInsEditQuery.setString(14, aind.getObjectType());
                this.stmtInsEditQuery.setString(15, this.getObjectPath(aind, this.getColumnSize("COGIPF_EDITQUERY", "COGIPF_QUERYPATH")));
                this.stmtInsEditQuery.setString(16, aind.getStatus());
                this.stmtInsEditQuery.setString(17, this.getErrorMessage(aind, errorMsgLen));
                this.stmtInsEditQuery.setInt(18, 0);
                String[] crackURLTmp4 = this.crackURL(aind.getObjectPath());
                this.stmtInsEditQuery.setString(19, crackURLTmp4[1]);
                HashMap<String, String> logDataMap5 = this.parseLogData(aind.getLogData());
                String modelName = this.searchXML(logDataMap5, "MODEL");
                String packageName = this.searchXML(logDataMap5, "PACKAGE");
                int thePackageColSize = this.getColumnSize("COGIPF_EDITQUERY", "COGIPF_PACKAGE");
                if (packageName != null && packageName.length() > 0) {
                    this.stmtInsEditQuery.setString(20, this.processColumnValue(packageName, thePackageColSize, false));
                } else {
                    this.stmtInsEditQuery.setString(20, this.processColumnValue(modelName, thePackageColSize, false));
                }
                this.stmtInsEditQuery.setString(21, this.processColumnValue(modelName, this.getColumnSize("COGIPF_EDITQUERY", "COGIPF_MODEL"), false));
                this.stmtInsEditQuery.executeUpdate();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_EDITQUERY", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_EDITQUERY ", e);
            }
            return null;
        }
        if (operation.equalsIgnoreCase("View") && (object.equalsIgnoreCase("Report") || object.equalsIgnoreCase("ReportView") || object.equalsIgnoreCase("Query") || object.equalsIgnoreCase("Analysis") || object.equalsIgnoreCase("ARCHIVED_DOCUMENT"))) {
            try {
                this.stuffHeader(this.stmtInsViewReport, ind);
                this.stmtInsViewReport.setString(14, aind.getObjectType());
                this.stmtInsViewReport.setString(15, this.getObjectPath(aind, this.getColumnSize("COGIPF_VIEWREPORT", "COGIPF_REPORTPATH")));
                this.stmtInsViewReport.setString(16, aind.getStatus());
                this.stmtInsViewReport.setString(17, this.getErrorMessage(aind, this.getColumnSize("COGIPF_VIEWREPORT", "COGIPF_ERRORDETAILS")));
                crackURLTmp = this.crackURL(aind.getObjectPath());
                this.stmtInsViewReport.setString(18, crackURLTmp[1]);
                HashMap<String, String> logDataMap6 = this.parseLogData(aind.getLogData());
                String modelName = this.searchXML(logDataMap6, "MODEL");
                String packageName = this.searchXML(logDataMap6, "PACKAGE");
                int thePackageColSize = this.getColumnSize("COGIPF_VIEWREPORT", "COGIPF_PACKAGE");
                if (packageName != null && packageName.length() > 0) {
                    this.stmtInsViewReport.setString(19, this.processColumnValue(packageName, thePackageColSize, false));
                } else {
                    this.stmtInsViewReport.setString(19, this.processColumnValue(modelName, thePackageColSize, false));
                }
                this.stmtInsViewReport.setString(20, this.processColumnValue(modelName, this.getColumnSize("COGIPF_VIEWREPORT", "COGIPF_MODEL"), false));
                this.stmtInsViewReport.setString(21, this.searchXML(logDataMap6, "REPORTFORMAT"));
                this.stmtInsViewReport.execute();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_VIEWREPORT", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_VIEWREPORT ", e);
            }
            return null;
        }
        if ((operation.equalsIgnoreCase("Create") || operation.equalsIgnoreCase("Delete") || operation.equalsIgnoreCase("Update")) && (object.equalsIgnoreCase("AgentDefinition") || object.equalsIgnoreCase("Memo") || object.equalsIgnoreCase("StoredProcedureTask") || object.equalsIgnoreCase("AgentDefinitionView") || object.equalsIgnoreCase("AgentTaskDefinition") || object.equalsIgnoreCase("HeadlineTask") || object.equalsIgnoreCase("WebServiceTask") || object.equalsIgnoreCase("ContentManagerService"))) {
            try {
                this.stuffHeader(this.stmtInsAgentBuild, ind);
                this.stmtInsAgentBuild.setString(14, aind.getOperation());
                this.stmtInsAgentBuild.setString(15, aind.getObjectType());
                crackURLTmp = this.crackURL(aind.getObjectPath());
                this.stmtInsAgentBuild.setString(16, this.processColumnValue(crackURLTmp[0], this.getColumnSize("COGIPF_AGENTBUILD", "COGIPF_TARGET_PATH")));
                this.stmtInsAgentBuild.setString(17, crackURLTmp[1]);
                this.stmtInsAgentBuild.setString(18, aind.getStatus());
                this.stmtInsAgentBuild.setString(19, this.getErrorMessage(aind, this.getColumnSize("COGIPF_AGENTBUILD", "COGIPF_ERRORDETAILS")));
                HashMap<String, String> logDataMap7 = this.parseLogData(aind.getLogData());
                this.stmtInsAgentBuild.setString(20, this.processColumnValue(this.searchXML(logDataMap7, "AGENTPATH"), this.getColumnSize("COGIPF_AGENTBUILD", "COGIPF_AGENT_PATH")));
                String sScheTime = this.searchXML(logDataMap7, "SCHEDULETIME");
                int iScheTime = 0;
                try {
                    iScheTime = Integer.valueOf(sScheTime);
                }
                catch (NumberFormatException nfe) {
                    iScheTime = 0;
                }
                this.stmtInsAgentBuild.setInt(21, iScheTime);
                this.stmtInsAgentBuild.setString(22, this.searchXML(logDataMap7, "USER"));
                int emailColumnSize = this.getColumnSize("COGIPF_AGENTBUILD", "COGIPF_EMAIL");
                if (emailColumnSize <= 0) {
                    emailColumnSize = 512;
                }
                this.stmtInsAgentBuild.setString(23, this.processColumnValue(this.searchXML(logDataMap7, "EMAIL"), emailColumnSize));
                this.stmtInsAgentBuild.execute();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_AGENTBUILD", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_AGENTBUILD ", e);
            }
            return null;
        }
        if ((operation.equalsIgnoreCase("Run") || operation.equalsIgnoreCase("RunAt") || operation.equalsIgnoreCase("Cancel") || operation.equalsIgnoreCase("Wait") || operation.equalsIgnoreCase("Release") || operation.equalsIgnoreCase("Background")) && (object.equalsIgnoreCase("AgentDefinition") || object.equalsIgnoreCase("Memo") || object.equalsIgnoreCase("StoredProcedureTask") || object.equalsIgnoreCase("AgentDefinitionView") || object.equalsIgnoreCase("AgentTaskDefinition") || object.equalsIgnoreCase("HeadlineTask") || object.equalsIgnoreCase("WebServiceTask") || object.equalsIgnoreCase("ContentManagerService"))) {
            try {
                this.stuffHeader(this.stmtInsAgentRun, ind);
                this.stmtInsAgentRun.setString(14, aind.getOperation());
                this.stmtInsAgentRun.setString(15, aind.getObjectType());
                crackURLTmp = this.crackURL(aind.getObjectPath());
                this.stmtInsAgentRun.setString(16, this.processColumnValue(crackURLTmp[0], this.getColumnSize("COGIPF_AGENTRUN", "COGIPF_TARGET_PATH")));
                this.stmtInsAgentRun.setString(17, crackURLTmp[1]);
                this.stmtInsAgentRun.setString(18, aind.getStatus());
                this.stmtInsAgentRun.setString(19, this.getErrorMessage(aind, this.getColumnSize("COGIPF_AGENTRUN", "COGIPF_ERRORDETAILS")));
                HashMap<String, String> logDataMap8 = this.parseLogData(aind.getLogData());
                this.stmtInsAgentRun.setString(20, this.processColumnValue(this.searchXML(logDataMap8, "AGENTPATH"), this.getColumnSize("COGIPF_AGENTRUN", "COGIPF_AGENT_PATH")));
                String sScheTime = this.searchXML(logDataMap8, "SCHEDULETIME");
                int iScheTime = 0;
                try {
                    iScheTime = Integer.valueOf(sScheTime);
                }
                catch (NumberFormatException nfe) {
                    iScheTime = 0;
                }
                this.stmtInsAgentRun.setInt(21, iScheTime);
                this.stmtInsAgentRun.setString(22, this.searchXML(logDataMap8, "USER"));
                int emailColumnSize = this.getColumnSize("COGIPF_AGENTRUN", "COGIPF_EMAIL");
                if (emailColumnSize <= 0) {
                    emailColumnSize = 512;
                }
                this.stmtInsAgentRun.setString(23, this.processColumnValue(this.searchXML(logDataMap8, "EMAIL"), emailColumnSize));
                this.stmtInsAgentRun.setString(24, this.searchXML(logDataMap8, "MESSAGEID"));
                this.stmtInsAgentRun.execute();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_AGENTRUN", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_AGENTRUN ", e);
            }
            return null;
        }
        if (operation.equalsIgnoreCase("MigrationAdd") || operation.equalsIgnoreCase("MigrationCreate") || operation.equalsIgnoreCase("MigrationValidate") || operation.equalsIgnoreCase("MigrationExecute") || operation.equalsIgnoreCase("MigrationUpdate") || operation.equalsIgnoreCase("MigrationQuery") || object.equalsIgnoreCase("MIS") || object.equalsIgnoreCase("MIGS7") || object.equalsIgnoreCase("MIGS7Service") || object.equalsIgnoreCase("MigrationTask")) {
            try {
                logDataMap = this.parseLogData(aind.getLogData());
                this.stuffHeader(this.stmtInsMigration, ind);
                this.stmtInsMigration.setString(14, aind.getOperation());
                this.stmtInsMigration.setString(15, aind.getObjectType());
                this.stmtInsMigration.setString(16, this.getObjectPath(aind, this.getColumnSize("COGIPF_MIGRATION", "COGIPF_TARGET_PATH")));
                this.stmtInsMigration.setString(17, this.searchXML(logDataMap, "TARGETNAME"));
                this.stmtInsMigration.setString(18, aind.getStatus());
                this.stmtInsMigration.setString(19, this.getErrorMessage(aind, this.getColumnSize("COGIPF_MIGRATION", "COGIPF_DETAILS")));
                String sPackage = this.searchXML(logDataMap, "PACKAGE");
                if (sPackage != null && sPackage.length() > 0) {
                    sPackage = this.processColumnValue(sPackage, this.getColumnSize("COGIPF_MIGRATION", "COGIPF_PACKAGE"), false);
                }
                this.stmtInsMigration.setString(20, sPackage);
                this.stmtInsMigration.setString(21, this.processColumnValue(this.searchXML(logDataMap, "MIGRATIONTASK"), this.getColumnSize("COGIPF_MIGRATION", "COGIPF_MIGRATION_TASK")));
                try {
                    int msgnum = Integer.parseInt(this.searchXML(logDataMap, "MSGNUM"));
                    this.stmtInsMigration.setInt(22, msgnum);
                }
                catch (Exception e) {
                    this.stmtInsMigration.setInt(22, 0);
                }
                this.stmtInsMigration.setString(23, this.searchXML(logDataMap, "SOURCETYPE"));
                this.stmtInsMigration.setString(24, this.processColumnValue(this.searchXML(logDataMap, "SOURCEPATH"), this.getColumnSize("COGIPF_MIGRATION", "COGIPF_SOURCE_PATH")));
                this.stmtInsMigration.setString(25, this.searchXML(logDataMap, "SOURCENAME"));
                this.stmtInsMigration.execute();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_MIGRATION", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_MIGRATION ", e);
            }
            return null;
        }
        if ((object.equalsIgnoreCase("Powerplay8Report") || object.equalsIgnoreCase("Powerplay8ReportView")) && ind.getComponentID() != null && ind.getComponentID().equalsIgnoreCase("PPS")) {
            try {
                String entryId;
                PreparedStatement stmtSelPowerPlay;
                boolean nullSubReqID = false;
                if (null == aind.getSubRequestID() || aind.getSubRequestID().equals(m_emptyString)) {
                    nullSubReqID = true;
                }
                if ((stmtSelPowerPlay = this.m_mapStmtSelPowerPlay.get(entryId = (nullSubReqID ? "NoSubReqId" : "SubReqId") + "-" + (nullStepID ? "NoStepId" : "StepId"))) == null) {
                    LogIPFLog.error("LogJDBCAppender::getLogStatement() - couldn't find PreparedStatment m_mapStmtSelPowerPlay.get('" + entryId + "')");
                    return null;
                }
                stmtSelPowerPlay.setString(1, aind.getRequestID());
                if (!nullSubReqID) {
                    stmtSelPowerPlay.setString(2, aind.getSubRequestID());
                    if (!nullStepID) {
                        stmtSelPowerPlay.setString(3, aind.getStepID());
                    }
                } else if (!nullStepID) {
                    stmtSelPowerPlay.setString(2, aind.getStepID());
                }
                if ((runRepResult = stmtSelPowerPlay.executeQuery()).next()) {
                    PreparedStatement stmtUpdPowerPlay = this.m_mapStmtUpdPowerPlay.get(entryId);
                    if (stmtUpdPowerPlay == null) {
                        LogIPFLog.error("LogJDBCAppender::getLogStatement() - couldn't find PreparedStatment m_mapStmtUpdPowerPlay.get('" + entryId + "')");
                        return null;
                    }
                    this.needToUpdateRuntimePP(runRepResult, aind, stmtUpdPowerPlay, !nullStepID, !nullSubReqID);
                    return null;
                }
                runRepResult.close();
                runRepResult = null;
                this.stuffHeader(this.stmtInsPowerPlay, ind);
                this.stmtInsPowerPlay.setString(14, aind.getObjectType());
                this.stmtInsPowerPlay.setString(15, this.getObjectPath(aind, this.getColumnSize("COGIPF_POWERPLAY", "COGIPF_REPORTPATH")));
                this.stmtInsPowerPlay.setString(16, aind.getStatus());
                this.stmtInsPowerPlay.setInt(17, 0);
                HashMap<String, String> logDataMap9 = this.parseLogData(aind.getLogData());
                this.stmtInsPowerPlay.setString(18, this.searchXML(logDataMap9, "REPORT_NAME"));
                String sPackage = this.searchXML(logDataMap9, "PACKAGE");
                if (sPackage != null && sPackage.length() > 0) {
                    sPackage = this.processColumnValue(sPackage, this.getColumnSize("COGIPF_POWERPLAY", "COGIPF_PACKAGE"), false);
                }
                this.stmtInsPowerPlay.setString(19, sPackage);
                this.stmtInsPowerPlay.setString(20, this.searchXML(logDataMap9, "DATASOURCE"));
                this.stmtInsPowerPlay.setString(21, this.searchXML(logDataMap9, "DATASOURCE_CONNECTION"));
                this.stmtInsPowerPlay.setString(22, this.processColumnValue(this.searchXML(logDataMap9, "CUBE_PATH"), this.getColumnSize("COGIPF_POWERPLAY", "COGIPF_CUBEPATH")));
                this.stmtInsPowerPlay.setString(23, aind.getOperation());
                this.stmtInsPowerPlay.setString(24, this.getErrorMessage(aind, this.getColumnSize("COGIPF_POWERPLAY", "COGIPF_MESSAGE")));
                try {
                    int reqType = Integer.parseInt(this.searchXML(logDataMap9, "REQUEST_TYPE"));
                    this.stmtInsPowerPlay.setInt(25, reqType);
                }
                catch (Exception e) {
                    this.stmtInsPowerPlay.setInt(25, 0);
                }
                this.stmtInsPowerPlay.setString(26, this.searchXML(logDataMap9, "SUB_COMPONENTID"));
                this.stmtInsPowerPlay.executeUpdate();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insertttt in COGIPF_POWERPLAY", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_POWERPLAY ", e);
            }
            return null;
        }
        if (object.equalsIgnoreCase("PowerplayService") && ind.getComponentID() != null && ind.getComponentID().equalsIgnoreCase("PPS")) {
            try {
                this.stuffHeader(this.stmtInsPowerPlay, ind);
                this.stmtInsPowerPlay.setString(14, aind.getObjectType());
                this.stmtInsPowerPlay.setString(15, this.getObjectPath(aind, this.getColumnSize("COGIPF_POWERPLAY", "COGIPF_REPORTPATH")));
                this.stmtInsPowerPlay.setString(16, aind.getStatus());
                this.stmtInsPowerPlay.setInt(17, 0);
                crackURLTmp = this.crackURL(aind.getObjectPath());
                this.stmtInsPowerPlay.setString(18, crackURLTmp[1]);
                HashMap<String, String> logDataMap10 = this.parseLogData(aind.getLogData());
                String sPackage = this.searchXML(logDataMap10, "PACKAGE");
                if (sPackage != null && sPackage.length() > 0) {
                    sPackage = this.processColumnValue(sPackage, this.getColumnSize("COGIPF_POWERPLAY", "COGIPF_PACKAGE"), false);
                }
                this.stmtInsPowerPlay.setString(19, sPackage);
                this.stmtInsPowerPlay.setString(20, this.searchXML(logDataMap10, "DATASOURCE"));
                this.stmtInsPowerPlay.setString(21, this.searchXML(logDataMap10, "DATASOURCE_CONNECTION"));
                this.stmtInsPowerPlay.setString(22, this.processColumnValue(this.searchXML(logDataMap10, "CUBE_PATH"), this.getColumnSize("COGIPF_POWERPLAY", "COGIPF_CUBEPATH")));
                this.stmtInsPowerPlay.setString(23, aind.getOperation());
                this.stmtInsPowerPlay.setString(24, this.getErrorMessage(aind, this.getColumnSize("COGIPF_POWERPLAY", "COGIPF_MESSAGE")));
                try {
                    int reqType = Integer.parseInt(this.searchXML(logDataMap10, "REQUEST_TYPE"));
                    this.stmtInsPowerPlay.setInt(25, reqType);
                }
                catch (Exception e) {
                    this.stmtInsPowerPlay.setInt(25, 0);
                }
                this.stmtInsPowerPlay.setString(26, this.searchXML(logDataMap10, "SUB_COMPONENTID"));
                this.stmtInsPowerPlay.executeUpdate();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_POWERPLAY", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_POWERPLAY ", e);
            }
            return null;
        }
        if (object.startsWith("HumanTaskServiceTask")) {
            String logdata = aind.getLogData();
            if (this.m_conn == null || null == logdata || logdata.length() <= 0) return null;
            try {
                this.m_conn.setAutoCommit(false);
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_HUMANTASKSERVICETASK tables,calling m_conn.setAutoCommit(false) ", e);
                return null;
            }
            try {
                this.populateHumanTaskServiceTables(aind);
                this.m_conn.commit();
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_HUMANTASKSERVICETASK tables " + logdata, e);
                try {
                    this.m_conn.rollback();
                }
                catch (Exception e1) {
                    LogIPFLog.error("LogJDBCAppender::getLogStatement() - inserting into COGIPF_HUMANTASKSERVICETASK - Exception while rollback connection", e1);
                }
            }
            try {
                this.m_conn.setAutoCommit(true);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_USERSERVICE tables, calling m_conn.setAutoCommit(true) ", e);
            }
            return null;
        }
        if (object.startsWith("Annotation")) {
            try {
                this.stuffHeader(this.stmtInsAnnotationService, ind);
                this.stmtInsAnnotationService.setString(14, aind.getOperation());
                this.stmtInsAnnotationService.setString(15, aind.getObjectType());
                this.stmtInsAnnotationService.setString(16, this.getObjectPath(aind, this.getColumnSize("COGIPF_ANNOTATIONSERVICE", "COGIPF_TARGET_PATH")));
                logDataMap = this.parseLogData(aind.getLogData());
                String sid = this.searchXML(logDataMap, "annotation_id");
                int aid = 0;
                try {
                    aid = Integer.parseInt(sid);
                }
                catch (Exception e) {
                    LogIPFLog.error("Exception when insert COGIPF_ANNOTATIONSERVICE - annotation_id " + sid + " is invalid. set it to 0. ", e);
                    aid = 0;
                }
                this.stmtInsAnnotationService.setInt(17, aid);
                this.stmtInsAnnotationService.setString(18, this.searchXML(logDataMap, "user"));
                this.stmtInsAnnotationService.setString(19, this.searchXML(logDataMap, "parent_id"));
                String createTime = this.searchXML(logDataMap, "creation_time");
                Timestamp ts = null;
                if (createTime.equalsIgnoreCase(m_emptyString)) {
                    this.stmtInsAnnotationService.setTimestamp(20, null);
                } else {
                    try {
                        ts = new Timestamp(Long.parseLong(createTime));
                    }
                    catch (Exception e) {
                        LogIPFLog.error("Exception when insert COGIPF_ANNOTATIONSERVICE - create time " + createTime + " is invalid. ", e);
                        ts = null;
                    }
                    this.stmtInsAnnotationService.setTimestamp(20, ts);
                }
                String updateTime = this.searchXML(logDataMap, "update_time");
                if (updateTime.equalsIgnoreCase(m_emptyString)) {
                    this.stmtInsAnnotationService.setTimestamp(21, null);
                } else {
                    ts = null;
                    try {
                        ts = new Timestamp(Long.parseLong(updateTime));
                    }
                    catch (Exception e) {
                        LogIPFLog.error("Exception when insert COGIPF_ANNOTATIONSERVICE - update time " + updateTime + " is invalid. set it to 0.", e);
                        ts = null;
                    }
                    this.stmtInsAnnotationService.setTimestamp(21, ts);
                }
                this.stmtInsAnnotationService.execute();
                return null;
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning while inserting into COGIPF_ANNOTATIONSERVICE: ", e);
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException while inserting into COGIPF_ANNOTATIONSERVICE: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_ANNOTATIONSERVICE", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_ANNOTATIONSERVICE ", e);
            }
            return null;
        }
        if (object.equals("Mobile")) {
            try {
                logDataMap = this.parseLogData(aind.getLogData());
                if (aind.getOperation().equals("Run") || aind.getOperation().equals("View") || aind.getOperation().equals("NextPage") || aind.getOperation().equals("DrillUpDown") || aind.getOperation().equals("DrillThrough")) {
                    String requestID = aind.getRequestID();
                    String userID = this.searchXML(logDataMap, "userID");
                    this.stmtSelMobileService.setString(1, requestID);
                    this.stmtSelMobileService.setString(2, userID);
                    ResultSet selectResults = this.stmtSelMobileService.executeQuery();
                    if (selectResults.next()) {
                        this.needToUpdateRuntimeMobile(selectResults, aind, this.stmtUpdMobileService, this.stmtUpdMobileServiceMultiple, this.getColumnSize("COGIPF_MOBILESERVICE", "COFIPF_ERRORDETAIL"), logDataMap);
                        return null;
                    }
                    this.stuffHeader(this.stmtInsMobileService, ind);
                    this.stuffMobileServiceCommonFields(this.stmtInsMobileService, aind, logDataMap);
                    if (aind.getOperation().equals("Run")) {
                        this.stmtInsMobileService.setString(18, "Interactive");
                    } else if (aind.getOperation().equals("View")) {
                        this.stmtInsMobileService.setString(18, "SavedOutput");
                    } else {
                        this.stmtInsMobileService.setString(18, aind.getOperation());
                    }
                    this.stmtInsMobileService.setString(24, this.processColumnValue(this.searchXML(logDataMap, "userName"), this.getColumnSize("COGIPF_MOBILESERVICE", "COGIPF_USER_NAME")));
                    this.stmtInsMobileService.setString(25, this.searchXML(logDataMap, "userID"));
                    this.stmtInsMobileService.execute();
                    return null;
                }
                if (aind.getOperation().equals("Logon") || aind.getOperation().equals("Logoff") || aind.getOperation().equals("LogonExpired")) {
                    this.stuffHeader(this.stmtInsMobileService, ind);
                    this.stuffMobileServiceCommonFields(this.stmtInsMobileService, aind, logDataMap);
                    this.stmtInsMobileService.setString(18, aind.getOperation());
                    this.stmtInsMobileService.setString(24, this.processColumnValue(this.searchXML(logDataMap, "userName"), this.getColumnSize("COGIPF_MOBILESERVICE", "COGIPF_USER_NAME")));
                    this.stmtInsMobileService.setString(25, this.searchXML(logDataMap, "userID"));
                    this.stmtInsMobileService.execute();
                    return null;
                }
                if (!aind.getOperation().equals("Deliver")) return null;
                this.stuffHeader(this.stmtInsMobileService, ind);
                this.stuffMobileServiceCommonFields(this.stmtInsMobileService, aind, logDataMap);
                this.stmtInsMobileService.setString(18, aind.getOperation());
                String userListString = this.searchXML(logDataMap, "forUsers");
                String userIDListString = this.searchXML(logDataMap, "forUserIDs");
                if (userListString == null || userListString.trim() == m_emptyString) return null;
                String[] userList = userListString.trim().split(" ");
                String[] userIDList = userIDListString.trim().split(" ");
                for (int i = 0; i < userList.length; ++i) {
                    this.stmtInsMobileService.setString(24, this.processColumnValue(userList[i], this.getColumnSize("COGIPF_MOBILESERVICE", "COGIPF_USER_NAME")));
                    this.stmtInsMobileService.setString(25, userIDList[i]);
                    this.stmtInsMobileService.execute();
                }
                return null;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_MOBILESERVICE", e);
                return null;
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception: ", e);
                return null;
            }
        }
        if (operation.equalsIgnoreCase("CollectParameter") || operation.equalsIgnoreCase("Validate") || operation.equalsIgnoreCase("GetParameter") || operation.equalsIgnoreCase("ReportQuery") || operation.equalsIgnoreCase("DrillThrough") || operation.equalsIgnoreCase("Execute") && (object.startsWith("MetaData") || object.startsWith("QueryFramework"))) return null;
        try {
            this.stuffHeader(this.stmtInsAction, ind);
            this.stmtInsAction.setString(14, aind.getOperation());
            this.stmtInsAction.setString(15, aind.getObjectType());
            this.stmtInsAction.setString(16, this.getObjectPath(aind, this.getColumnSize("COGIPF_ACTION", "COGIPF_TARGET_PATH")));
            this.stmtInsAction.setString(17, aind.getStatus());
            this.stmtInsAction.setString(18, this.getErrorMessage(aind, this.getColumnSize("COGIPF_ACTION", "COGIPF_ERRORDETAILS")));
            this.stmtInsAction.execute();
            return null;
        }
        catch (SQLWarning e) {
            LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLWarning: ", e);
            return null;
        }
        catch (SQLException e) {
            LogIPFLog.error("LogJDBCAppender::getLogStatement() - SQLException: ", e);
            this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_ACTION", e);
            return null;
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::getLogStatement() - Exception while inserting into COGIPF_ACTION ", e);
        }
        return null;
    }

    protected void getLogStatementForWorkspace(String objectType, LogAuditIndication ind, LogAuditAccessIndication aind) {
        String searchResult = null;
        if (objectType.startsWith("WorkspaceWidget")) {
            try {
                this.stuffHeader(this.stmtInsRunWorkspaceWidget, ind);
                HashMap<String, String> logDataMap = this.parseLogData(aind.getLogData());
                searchResult = this.searchXML(logDataMap, "DEFAULTTITLE");
                this.stmtInsRunWorkspaceWidget.setString(14, searchResult);
                searchResult = this.searchXML(logDataMap, "CUSTOMIZEDTITLE");
                this.stmtInsRunWorkspaceWidget.setString(15, searchResult);
                searchResult = this.searchXML(logDataMap, "SOURCENAME");
                this.stmtInsRunWorkspaceWidget.setString(16, searchResult);
                searchResult = this.searchXML(logDataMap, "WIDGETTYPE");
                this.stmtInsRunWorkspaceWidget.setString(17, searchResult);
                searchResult = this.searchXML(logDataMap, "SEARCHPATH");
                this.stmtInsRunWorkspaceWidget.setString(18, this.processColumnValue(searchResult, this.getColumnSize("COGIPF_RUNWORKSPACE_WIDGET", "COGIPF_SEARCHPATH")));
                searchResult = this.searchXML(logDataMap, "ORGREPSEARCHPATH");
                this.stmtInsRunWorkspaceWidget.setString(19, this.processColumnValue(searchResult, this.getColumnSize("COGIPF_RUNWORKSPACE_WIDGET", "COGIPF_ORGREPSEARCHPATH")));
                searchResult = this.searchXML(logDataMap, "STOREID");
                this.stmtInsRunWorkspaceWidget.setString(20, searchResult);
                this.stmtInsRunWorkspaceWidget.executeUpdate();
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatementForWorkspace() - SQLWarning: ", e);
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatementForWorkspace() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_WORKSPACE_WIDGET", e);
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatementForWorkspace() - Exception while inserting into COGIPF_WORKSPACE_WIDGET ", e);
            }
        } else {
            try {
                this.stuffHeader(this.stmtInsRunWorkspace, ind);
                HashMap<String, String> logDataMap = this.parseLogData(aind.getLogData());
                searchResult = this.searchXML(logDataMap, "WORKSPACENAME");
                this.stmtInsRunWorkspace.setString(14, searchResult);
                searchResult = this.searchXML(logDataMap, "SEARCHPATH");
                this.stmtInsRunWorkspace.setString(15, this.processColumnValue(searchResult, this.getColumnSize("COGIPF_RUNWORKSPACE", "COGIPF_SEARCHPATH")));
                searchResult = this.searchXML(logDataMap, "STOREID");
                this.stmtInsRunWorkspace.setString(16, searchResult);
                this.stmtInsRunWorkspace.executeUpdate();
            }
            catch (SQLWarning e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatementForWorkspace() - SQLWarning: ", e);
            }
            catch (SQLException e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatementForWorkspace() - SQLException: ", e);
                this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_RUNWORKSPACE", e);
            }
            catch (Exception e) {
                LogIPFLog.error("LogJDBCAppender::getLogStatementForWorkspace() - Exception while inserting into COGIPF_RUNWORKSPACE ", e);
            }
        }
    }

    protected void execute(String sql) throws SQLException {
    }

    private void stuffParamsHeader(PreparedStatement stmt, LogAuditAccessIndication ind) throws Exception {
        try {
            stmt.setTimestamp(1, new Timestamp(ind.getTime()));
            stmt.setString(2, ind.getRenderedSessionID());
            if (0 == ind.getRequestID().length()) {
                stmt.setString(3, emptyRequestID);
            } else {
                stmt.setString(3, ind.getRequestID());
            }
            stmt.setString(4, ind.getSubRequestID());
            stmt.setString(5, ind.getStepID());
            stmt.setString(6, ind.getOperation());
            stmt.setString(7, ind.getObjectType());
        }
        catch (SQLException e) {
            LogIPFLog.error("LogJDBCAppender::stuffParamsHeader() - SQLException", e);
            throw e;
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::stuffParamsHeader() - Exception", e);
            throw e;
        }
    }

    private void putParametersOracle(Iterator<Element> itemList, LogAuditAccessIndication ind) throws Exception {
        this.stuffParamsHeader(this.stmtInsOracleParameter, ind);
        while (itemList.hasNext()) {
            Element item = itemList.next();
            String pname = item.attributeValue("name");
            this.stmtInsOracleParameter.setString(8, pname);
            String ptype = item.attributeValue("type");
            if (ptype != null && ptype.equalsIgnoreCase("blob")) {
                String entryId;
                PreparedStatement stmtSelParameter;
                this.stmtInsOracleParameter.setString(9, m_emptyString);
                this.stmtInsOracleParameter.execute();
                ResultSet paramResult = null;
                boolean nullStepID = false;
                if (null == ind.getStepID() || ind.getStepID().equals(m_emptyString)) {
                    nullStepID = true;
                }
                boolean nullSubReqID = false;
                if (null == ind.getSubRequestID() || ind.getSubRequestID().equals(m_emptyString)) {
                    nullSubReqID = true;
                }
                if ((stmtSelParameter = this.m_mapStmtSelParameter.get(entryId = (nullSubReqID ? "NoSubReqId" : "SubReqId") + "-" + (nullStepID ? "NoStepId" : "StepId"))) == null) {
                    String errmsg = "LogJDBCAppender::putParametersOracle() - couldn't find PreparedStatment m_mapStmtSelParameter('" + entryId + "')";
                    LogIPFLog.error(errmsg);
                    throw new Exception(errmsg);
                }
                stmtSelParameter.setString(1, ind.getRequestID());
                stmtSelParameter.setString(2, pname);
                if (!nullSubReqID) {
                    stmtSelParameter.setString(3, ind.getSubRequestID());
                    if (!nullStepID) {
                        stmtSelParameter.setString(4, ind.getStepID());
                    }
                } else if (!nullStepID) {
                    stmtSelParameter.setString(3, ind.getStepID());
                }
                paramResult = stmtSelParameter.executeQuery();
                while (paramResult.next()) {
                    this.bindOracleCLOBToResultSet(item.getText(), paramResult, "COGIPF_PARAMETER_VALUE_BLOB");
                }
                continue;
            }
            this.stmtInsOracleParameter.setString(9, this.processColumnValue(item.getText(), this.getColumnSize("COGIPF_PARAMETER", "COGIPF_PARAMETER_VALUE")));
            this.stmtInsOracleParameter.execute();
        }
    }

    private void putParameters(LogAuditAccessIndication ind) throws Exception {
        StringReader stringInput = new StringReader(ind.getLogData());
        try {
            SAXReader xmlInput = new SAXReader();
            Document doc = xmlInput.read((Reader)stringInput);
            Element root = doc.getRootElement();
            Iterator itemList = root.elementIterator("item");
            if (this.isDBOracle()) {
                this.putParametersOracle(itemList, ind);
            } else {
                while (itemList.hasNext()) {
                    this.stmtInsParameter.clearParameters();
                    this.stuffParamsHeader(this.stmtInsParameter, ind);
                    Element item = (Element)itemList.next();
                    String pname = item.attributeValue("name");
                    this.stmtInsParameter.setString(8, pname);
                    String ptype = item.attributeValue("type");
                    if (ptype != null && ptype.equalsIgnoreCase("blob")) {
                        this.stmtInsParameter.setString(9, m_emptyString);
                        this.bindCLOBData(this.stmtInsParameter, 10, item.getText());
                        this.stmtInsParameter.execute();
                        continue;
                    }
                    this.stmtInsParameter.setString(9, this.processColumnValue(item.getText(), this.getColumnSize("COGIPF_PARAMETER", "COGIPF_PARAMETER_VALUE")));
                    this.bindCLOBData(this.stmtInsParameter, 10, m_emptyString);
                    this.stmtInsParameter.execute();
                }
            }
        }
        catch (DocumentException e) {
            Matcher match;
            String logData = ind.getLogData();
            String ablob = "blob";
            String cData = "<![CDATA[";
            String cDataEnd = "]]>";
            if (logData.endsWith("...") && (match = Pattern.compile(".*(blob).*", 2).matcher(logData)).matches()) {
                String blobMatched = match.group(1);
                String quotedBlob = "\"" + blobMatched;
                int indexOfBlob = logData.indexOf(blobMatched);
                int endOfElement = logData.indexOf(62, indexOfBlob);
                int startOfElement = logData.lastIndexOf(60, indexOfBlob);
                String elementText = logData.substring(startOfElement + 1, endOfElement - 1);
                String[] tokens = elementText.split("\\s");
                String pname = m_emptyString;
                boolean blobType = false;
                if (tokens[0].equalsIgnoreCase("item")) {
                    for (int i = 1; i < tokens.length; ++i) {
                        String[] attributeItems = tokens[i].split("=");
                        if (attributeItems[0].equalsIgnoreCase("name")) {
                            pname = attributeItems[1];
                        }
                        if (!attributeItems[0].equalsIgnoreCase("type") || !attributeItems[1].equalsIgnoreCase(quotedBlob)) continue;
                        blobType = true;
                    }
                    if (blobType && pname.equalsIgnoreCase("\"parameterValues\"")) {
                        this.stmtInsParameter.clearParameters();
                        this.stuffParamsHeader(this.stmtInsParameter, ind);
                        if (pname != null) {
                            this.stmtInsParameter.setString(8, pname.substring(1, pname.length() - 1));
                        }
                        this.stmtInsParameter.setString(9, m_emptyString);
                        String parameterValues = logData.substring(endOfElement + 1);
                        if (parameterValues.startsWith(cData)) {
                            String parameterValuesData = parameterValues.substring(cData.length());
                            int parameterValuesDataEnd = parameterValuesData.indexOf(cDataEnd);
                            if (parameterValuesDataEnd != -1) {
                                parameterValuesData = parameterValuesData.substring(0, parameterValuesDataEnd);
                            }
                            this.bindCLOBData(this.stmtInsParameter, 10, parameterValuesData);
                        } else {
                            this.bindCLOBData(this.stmtInsParameter, 10, parameterValues);
                        }
                        this.stmtInsParameter.execute();
                    }
                }
            }
        }
        catch (SQLWarning e) {
            LogIPFLog.error("LogJDBCAppender::putParameters() - SQLWarning: ", e);
            LogIPFLog.error("LogJDBCAppender::putParameters() - parameter xml: " + ind.getLogData());
            throw e;
        }
        catch (SQLException e) {
            LogIPFLog.error("LogJDBCAppender::putParameters() - SQLException: ", e);
            LogIPFLog.error("LogJDBCAppender::putParameters() - parameter xml: " + ind.getLogData());
            this.m_conn = this.m_logConnection.parseException("Failure to insert in COGIPF_PARAMETERS", e);
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::putParameters() - Exception  ", e);
            LogIPFLog.error("LogJDBCAppender::putParameters() - parameter xml: " + ind.getLogData());
            throw e;
        }
    }

    private String searchXML(HashMap<String, String> logDataMap, String key) throws Exception {
        if (null == logDataMap || key == null) {
            return m_emptyString;
        }
        String value = logDataMap.get(key.toUpperCase());
        if (value != null) {
            return value;
        }
        return m_emptyString;
    }

    private void insertPowerPlayUsageTables(LogAuditAccessIndication aind) throws Exception {
        String logdata = aind.getLogData();
        if (null == logdata || 0 == logdata.length()) {
            return;
        }
        String sessionID = aind.getRenderedSessionID();
        String requestID = aind.getRequestID();
        StringReader stringInput = new StringReader(logdata);
        try {
            SAXReader xmlInput = new SAXReader();
            Document doc = xmlInput.read((Reader)stringInput);
            Element root = doc.getRootElement();
            Iterator itemList = root.elementIterator("item");
            while (itemList.hasNext()) {
                Element dimUsageElem;
                Element blobElem;
                Element item = (Element)itemList.next();
                String name = item.attributeValue("name");
                String value = item.getText();
                if (name == null || name.length() <= 0) continue;
                if (name.equalsIgnoreCase("PPES_MEASURE_USAGE")) {
                    Element mUsageElem;
                    blobElem = item.element("blob");
                    if (blobElem == null || (mUsageElem = blobElem.element("PPES_MEASURE_USAGE")) == null) continue;
                    Iterator mUsageItemList = mUsageElem.elementIterator("PPES_MEASURE_ITEM");
                    while (mUsageItemList.hasNext()) {
                        Element mItem = (Element)mUsageItemList.next();
                        Element mCodeElem = mItem.element("PPES_MEASURE_CODE");
                        String mCode = m_emptyString;
                        if (mCodeElem != null) {
                            mCode = mCodeElem.getText();
                        }
                        Element mNameElem = mItem.element("PPES_MEASURE_NAME");
                        String mName = m_emptyString;
                        if (mNameElem != null) {
                            mName = mNameElem.getText();
                        }
                        Element mCountElem = mItem.element("PPES_MEASURE_COUNT");
                        String mCount = m_emptyString;
                        if (mCountElem != null) {
                            mCount = mCountElem.getText();
                        }
                        int iCount = 0;
                        try {
                            iCount = Integer.parseInt(mCount);
                        }
                        catch (Exception ee) {
                            iCount = -1;
                        }
                        this.stmtInsPOWERPLAYMeasureUsage.setString(1, sessionID);
                        this.stmtInsPOWERPLAYMeasureUsage.setString(2, requestID);
                        this.stmtInsPOWERPLAYMeasureUsage.setString(3, mCode);
                        this.stmtInsPOWERPLAYMeasureUsage.setString(4, mName);
                        this.stmtInsPOWERPLAYMeasureUsage.setInt(5, iCount);
                        this.stmtInsPOWERPLAYMeasureUsage.execute();
                    }
                    continue;
                }
                if (!name.equalsIgnoreCase("PPES_DIM_USAGE") || (blobElem = item.element("blob")) == null || (dimUsageElem = blobElem.element("PPES_DIM_USAGE")) == null) continue;
                Iterator dimUsageItemList = dimUsageElem.elementIterator("PPES_DIM_ITEM");
                while (dimUsageItemList.hasNext()) {
                    Element dimItem = (Element)dimUsageItemList.next();
                    Element dimCodeElem = dimItem.element("PPES_DIM_CODE");
                    String dimCode = m_emptyString;
                    if (dimCodeElem != null) {
                        dimCode = dimCodeElem.getText();
                    }
                    Element dimNameElem = dimItem.element("PPES_DIM_NAME");
                    String dimName = m_emptyString;
                    if (dimNameElem != null) {
                        dimName = dimNameElem.getText();
                    }
                    Element dimCountElem = dimItem.element("PPES_DIM_COUNT");
                    String dimCount = m_emptyString;
                    if (dimCountElem != null) {
                        dimCount = dimCountElem.getText();
                    }
                    int idimCount = 0;
                    try {
                        idimCount = Integer.parseInt(dimCount);
                    }
                    catch (Exception ee) {
                        idimCount = -1;
                    }
                    this.stmtInsPOWERPLAYDimUsage.setString(1, sessionID);
                    this.stmtInsPOWERPLAYDimUsage.setString(2, requestID);
                    this.stmtInsPOWERPLAYDimUsage.setString(3, dimCode);
                    this.stmtInsPOWERPLAYDimUsage.setString(4, dimName);
                    this.stmtInsPOWERPLAYDimUsage.setInt(5, idimCount);
                    this.stmtInsPOWERPLAYDimUsage.execute();
                    Element levelUsageElem = dimItem.element("PPES_LEVEL_USAGE");
                    if (levelUsageElem == null) continue;
                    Iterator levelItemList = levelUsageElem.elementIterator("PPES_LEVEL_ITEM");
                    while (levelItemList.hasNext()) {
                        Element levelItem = (Element)levelItemList.next();
                        Element levelCodeElem = levelItem.element("PPES_LEVEL_CODE");
                        String levelCode = m_emptyString;
                        if (levelCodeElem != null) {
                            levelCode = levelCodeElem.getText();
                        }
                        Element levelNameElem = levelItem.element("PPES_LEVEL_NAME");
                        String levelName = m_emptyString;
                        if (levelNameElem != null) {
                            levelName = levelNameElem.getText();
                        }
                        Element levelCountElem = levelItem.element("PPES_LEVEL_COUNT");
                        String levelCount = m_emptyString;
                        if (levelCountElem != null) {
                            levelCount = levelCountElem.getText();
                        }
                        int ilevelCount = 0;
                        try {
                            ilevelCount = Integer.parseInt(levelCount);
                        }
                        catch (Exception ee) {
                            ilevelCount = -1;
                        }
                        this.stmtInsPOWERPLAYLevelUsage.setString(1, sessionID);
                        this.stmtInsPOWERPLAYLevelUsage.setString(2, requestID);
                        this.stmtInsPOWERPLAYLevelUsage.setString(3, dimCode);
                        this.stmtInsPOWERPLAYLevelUsage.setString(4, levelCode);
                        this.stmtInsPOWERPLAYLevelUsage.setString(5, levelName);
                        this.stmtInsPOWERPLAYLevelUsage.setInt(6, ilevelCount);
                        this.stmtInsPOWERPLAYLevelUsage.execute();
                    }
                }
            }
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::insertPowerPlayUsageTables() - Exception: ", e);
            throw e;
        }
    }

    private void stuffHumanTaskServiceCommonFields(PreparedStatement insstmt, LogAuditAccessIndication aind) throws Exception {
        try {
            insstmt.setString(1, aind.getIPAddrStr());
            insstmt.setInt(2, aind.getPort());
            insstmt.setInt(3, aind.getProcID());
            insstmt.setTimestamp(4, new Timestamp(aind.getTime()));
            insstmt.setShort(5, (short)(aind.getTimeZoneOffset() / 60));
            insstmt.setString(6, aind.getRenderedSessionID());
            if (0 == aind.getRequestID().length()) {
                insstmt.setString(7, emptyRequestID);
            } else {
                insstmt.setString(7, aind.getRequestID());
            }
            insstmt.setString(8, aind.getStepID());
            insstmt.setString(9, aind.getSubRequestID());
            insstmt.setString(10, aind.getThreadID());
            insstmt.setInt(11, aind.getBuildNumber());
            insstmt.setString(12, aind.getOperation());
            insstmt.setString(13, aind.getObjectType());
            insstmt.setString(14, this.getObjectPath(aind, this.getColumnSize("COGIPF_HUMANTASKSERVICE", "COGIPF_TARGET_PATH")));
            insstmt.setString(15, aind.getStatus());
        }
        catch (SQLException e) {
            LogIPFLog.error("LogJDBCAppender::stuffHumanTaskServiceCommonFields() - set common fields for COGIPF_HUMANTASKSERVICE - SQLException", e);
            throw e;
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::stuffHumanTaskServiceCommonFields() - set common fields for COGIPF_HUMANTASKSERVICE  - Exception", e);
            throw e;
        }
    }

    private void stuffHumanTaskServiceDetailCommonFields(PreparedStatement insstmt, LogAuditAccessIndication aind) throws Exception {
        try {
            insstmt.setString(1, aind.getIPAddrStr());
            insstmt.setInt(2, aind.getPort());
            insstmt.setString(3, aind.getRenderedSessionID());
            if (0 == aind.getRequestID().length()) {
                insstmt.setString(4, emptyRequestID);
            } else {
                insstmt.setString(4, aind.getRequestID());
            }
            insstmt.setString(5, aind.getStepID());
            insstmt.setString(6, aind.getSubRequestID());
        }
        catch (SQLException e) {
            LogIPFLog.error("LogJDBCAppender::stuffHumanTaskServiceDetailCommonFields() - set common fields for COGIPF_HUMANTASKSERVICE_DETAIL - SQLException", e);
            throw e;
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::stuffHumanTaskServiceDetailCommonFields() - set common fields for COGIPF_HUMANTASKSERVICE_DETAIL  - Exception", e);
            throw e;
        }
    }

    private void stuffMobileServiceCommonFields(PreparedStatement statement, LogAuditAccessIndication aind, HashMap<String, String> logDataMap) throws Exception {
        try {
            statement.setString(14, this.searchXML(logDataMap, "reportType"));
            statement.setString(15, this.getObjectPath(aind, this.getColumnSize("COGIPF_MOBILESERVICE", "COGIPF_REPORT_PATH")));
            statement.setString(16, aind.getStatus());
            statement.setString(17, this.getErrorMessage(aind, this.getColumnSize("COGIPF_MOBILESERVICE", "COGIPF_ERROR_DETAIL")));
            statement.setString(19, this.searchXML(logDataMap, "reportName"));
            statement.setString(20, this.searchXML(logDataMap, "storeID"));
            statement.setString(21, this.searchXML(logDataMap, "deviceID"));
            statement.setString(22, this.searchXML(logDataMap, "clientType"));
            statement.setString(23, this.processColumnValue(this.searchXML(logDataMap, "userAgent"), this.getColumnSize("COGIPF_MOBILESERVICE", "COGIPF_USER_AGENT")));
        }
        catch (SQLException e) {
            LogIPFLog.error("LogJDBCAppender::stuffMobileServiceCommonFields() - set common fields for COGIPF_MOBILESERVICE - SQLException", e);
            throw e;
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::stuffMobileServiceCommonFields() - set common fields for COGIPF_MOBILESERVICE  - Exception", e);
            throw e;
        }
    }

    private void setNumericFields(PreparedStatement stmtIns, String propName, String propValue, int valueIdx, int propType) throws Exception {
        if (propValue.equalsIgnoreCase(m_emptyString)) {
            stmtIns.setNull(valueIdx, propType);
        } else {
            try {
                if (propType == 4) {
                    stmtIns.setInt(valueIdx, Integer.parseInt(propValue));
                } else if (propType == -5) {
                    stmtIns.setLong(valueIdx, Long.parseLong(propValue));
                }
            }
            catch (Exception e) {
                LogIPFLog.error("Exception when insert COGIPF_HUMANTASKSERVICE - " + propName + " " + propValue + " is invalid. ", e);
                stmtIns.setNull(valueIdx, propType);
            }
        }
    }

    private void populateHumanTaskServiceTables(LogAuditAccessIndication aind) throws Exception {
        String logdata = aind.getLogData();
        if (null == logdata || 0 == logdata.length()) {
            return;
        }
        LogIPFLog.debug("begin populateHumanTaskServiceTables - logdata=" + logdata);
        String tmStamp = Long.toString(System.currentTimeMillis());
        int logEntryNo = 0;
        int detailsSeqNo = 0;
        StringReader stringInput = new StringReader(logdata);
        try {
            SAXReader xmlInput = new SAXReader();
            Document doc = xmlInput.read((Reader)stringInput);
            Element root = doc.getRootElement();
            Iterator logEntryList = root.elementIterator("LogEntry");
            while (logEntryList.hasNext()) {
                Element subsChangeListElem;
                Element humanroleListElem;
                Element notificationListElem;
                Element logEntry = (Element)logEntryList.next();
                if (logEntry == null) continue;
                String logEntryId = tmStamp + Integer.toString(logEntryNo);
                ++logEntryNo;
                detailsSeqNo = 0;
                Element taskIdElem = logEntry.element("TaskId");
                String taskId = m_emptyString;
                if (taskIdElem != null) {
                    taskId = taskIdElem.getText();
                }
                Element TransactionTypeElem = logEntry.element("TransactionType");
                String TransactionType = m_emptyString;
                if (TransactionTypeElem != null) {
                    TransactionType = TransactionTypeElem.getText();
                }
                Element UserElem = logEntry.element("User");
                String User = m_emptyString;
                if (UserElem != null) {
                    User = UserElem.getText();
                }
                Element PriorityElem = logEntry.element("Priority");
                String Priority2 = m_emptyString;
                if (PriorityElem != null) {
                    Priority2 = PriorityElem.getText();
                }
                Element StatusElem = logEntry.element("Status");
                String Status = m_emptyString;
                if (StatusElem != null) {
                    Status = StatusElem.getText();
                }
                Element ActivationTimeElem = logEntry.element("ActivationTime");
                String ActivationTime = m_emptyString;
                if (ActivationTimeElem != null) {
                    ActivationTime = ActivationTimeElem.getText();
                }
                Element ExpirationTimeElem = logEntry.element("ExpirationTime");
                String ExpirationTime = m_emptyString;
                if (ExpirationTimeElem != null) {
                    ExpirationTime = ExpirationTimeElem.getText();
                }
                Element NameElem = logEntry.element("Name");
                String Name = m_emptyString;
                if (NameElem != null) {
                    Name = NameElem.getText();
                }
                Element SubjectElem = logEntry.element("Subject");
                String Subject = m_emptyString;
                if (SubjectElem != null) {
                    Subject = SubjectElem.getText();
                }
                Element DescriptionElem = logEntry.element("Description");
                String Description = m_emptyString;
                if (DescriptionElem != null) {
                    Description = DescriptionElem.getText();
                }
                Element TimezoneIdElem = logEntry.element("TimezoneId");
                String TimezoneId = m_emptyString;
                if (TimezoneIdElem != null) {
                    TimezoneId = TimezoneIdElem.getText();
                }
                Element ActualOwnerElem = logEntry.element("ActualOwner");
                String ActualOwner = m_emptyString;
                if (ActualOwnerElem != null) {
                    ActualOwner = ActualOwnerElem.getText();
                }
                Element InitiatorElem = logEntry.element("Initiator");
                String Initiator = m_emptyString;
                if (InitiatorElem != null) {
                    Initiator = InitiatorElem.getText();
                }
                Element ClassNameElem = logEntry.element("ClassName");
                String ClassName = m_emptyString;
                if (ClassNameElem != null) {
                    ClassName = ClassNameElem.getText();
                }
                Element ClassOperationElem = logEntry.element("ClassOperation");
                String ClassOperation = m_emptyString;
                if (ClassOperationElem != null) {
                    ClassOperation = ClassOperationElem.getText();
                }
                Element CommentElem = logEntry.element("Comment");
                String Comment2 = m_emptyString;
                if (CommentElem != null) {
                    Comment2 = CommentElem.getText();
                }
                Comment2 = this.processColumnValue(Comment2, this.getColumnSize("COGIPF_HUMANTASKSERVICE", "COGIPF_TASK_COMMENT"));
                if (this.isDBOracle()) {
                    this.stuffHumanTaskServiceCommonFields(this.stmtInsOracleHumanTaskService, aind);
                    this.stmtInsOracleHumanTaskService.setString(16, logEntryId);
                    this.stmtInsOracleHumanTaskService.setString(17, taskId);
                    this.stmtInsOracleHumanTaskService.setString(18, TransactionType);
                    this.stmtInsOracleHumanTaskService.setString(19, User);
                    this.setNumericFields(this.stmtInsOracleHumanTaskService, "Priority", Priority2, 20, 4);
                    this.stmtInsOracleHumanTaskService.setString(21, Status);
                    this.setNumericFields(this.stmtInsOracleHumanTaskService, "ActivationTime", ActivationTime, 22, -5);
                    this.setNumericFields(this.stmtInsOracleHumanTaskService, "ExpirationTime", ExpirationTime, 23, -5);
                    this.stmtInsOracleHumanTaskService.setString(24, TimezoneId);
                    this.stmtInsOracleHumanTaskService.setString(25, ActualOwner);
                    this.stmtInsOracleHumanTaskService.setString(26, Initiator);
                    this.stmtInsOracleHumanTaskService.setString(27, ClassName);
                    this.stmtInsOracleHumanTaskService.setString(28, ClassOperation);
                    this.stmtInsOracleHumanTaskService.setString(29, Comment2);
                    this.stmtInsOracleHumanTaskService.execute();
                    ResultSet humantTaskServiceResult = null;
                    this.stmtSelHumanTaskService.setString(1, aind.getIPAddrStr());
                    this.stmtSelHumanTaskService.setInt(2, aind.getPort());
                    this.stmtSelHumanTaskService.setString(3, aind.getRequestID());
                    this.stmtSelHumanTaskService.setString(4, aind.getStepID());
                    this.stmtSelHumanTaskService.setString(5, aind.getSubRequestID());
                    this.stmtSelHumanTaskService.setString(6, taskId);
                    this.stmtSelHumanTaskService.setString(7, logEntryId);
                    humantTaskServiceResult = this.stmtSelHumanTaskService.executeQuery();
                    while (humantTaskServiceResult.next()) {
                        this.bindOracleCLOBToResultSet(Name, humantTaskServiceResult, "COGIPF_TASK_NAME");
                        this.bindOracleCLOBToResultSet(Subject, humantTaskServiceResult, "COGIPF_TASK_SUBJECT");
                        this.bindOracleCLOBToResultSet(Description, humantTaskServiceResult, "COGIPF_TASK_DESCRIPTION");
                    }
                } else {
                    this.stmtInsHumanTaskService.clearParameters();
                    this.stuffHumanTaskServiceCommonFields(this.stmtInsHumanTaskService, aind);
                    this.stmtInsHumanTaskService.setString(16, logEntryId);
                    this.stmtInsHumanTaskService.setString(17, taskId);
                    this.stmtInsHumanTaskService.setString(18, TransactionType);
                    this.stmtInsHumanTaskService.setString(19, User);
                    this.setNumericFields(this.stmtInsHumanTaskService, "Priority", Priority2, 20, 4);
                    this.stmtInsHumanTaskService.setString(21, Status);
                    this.setNumericFields(this.stmtInsHumanTaskService, "ActivationTime", ActivationTime, 22, -5);
                    this.setNumericFields(this.stmtInsHumanTaskService, "ExpirationTime", ExpirationTime, 23, -5);
                    this.bindCLOBData(this.stmtInsHumanTaskService, 24, Name);
                    this.bindCLOBData(this.stmtInsHumanTaskService, 25, Subject);
                    this.bindCLOBData(this.stmtInsHumanTaskService, 26, Description);
                    this.stmtInsHumanTaskService.setString(27, TimezoneId);
                    this.stmtInsHumanTaskService.setString(28, ActualOwner);
                    this.stmtInsHumanTaskService.setString(29, Initiator);
                    this.stmtInsHumanTaskService.setString(30, ClassName);
                    this.stmtInsHumanTaskService.setString(31, ClassOperation);
                    this.stmtInsHumanTaskService.setString(32, Comment2);
                    this.stmtInsHumanTaskService.execute();
                }
                Element taskMsgListElem = logEntry.element("TaskMessageList");
                if (taskMsgListElem != null) {
                    Iterator taskMsgList = taskMsgListElem.elementIterator("TaskMessage");
                    while (taskMsgList.hasNext()) {
                        Element taskMsgItem = (Element)taskMsgList.next();
                        Element msgElem = taskMsgItem.element("Message");
                        String taskMsg = m_emptyString;
                        if (msgElem != null) {
                            taskMsg = msgElem.getText();
                        }
                        Element msgTypeElem = taskMsgItem.element("MessageType");
                        String msgType = m_emptyString;
                        if (msgTypeElem != null) {
                            msgType = msgTypeElem.getText();
                        }
                        ++detailsSeqNo;
                        if (this.isDBOracle()) {
                            this.stuffHumanTaskServiceDetailCommonFields(this.stmtInsOracleHumanTaskServiceDetails, aind);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(7, taskId);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(8, logEntryId);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(9, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(10, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(11, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setInt(12, 0);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(13, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(14, msgType);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(15, Integer.toString(detailsSeqNo));
                            this.stmtInsOracleHumanTaskServiceDetails.execute();
                            ResultSet humantTaskServiceDetailsResult = null;
                            this.stmtSelHumanTaskServiceDetails.setString(1, aind.getIPAddrStr());
                            this.stmtSelHumanTaskServiceDetails.setInt(2, aind.getPort());
                            this.stmtSelHumanTaskServiceDetails.setString(3, aind.getRequestID());
                            this.stmtSelHumanTaskServiceDetails.setString(4, aind.getStepID());
                            this.stmtSelHumanTaskServiceDetails.setString(5, aind.getSubRequestID());
                            this.stmtSelHumanTaskServiceDetails.setString(6, taskId);
                            this.stmtSelHumanTaskServiceDetails.setString(7, logEntryId);
                            this.stmtSelHumanTaskServiceDetails.setString(8, Integer.toString(detailsSeqNo));
                            humantTaskServiceDetailsResult = this.stmtSelHumanTaskServiceDetails.executeQuery();
                            while (humantTaskServiceDetailsResult.next()) {
                                this.bindOracleCLOBToResultSet(taskMsg, humantTaskServiceDetailsResult, "COGIPF_TASK_MESSAGE");
                            }
                            continue;
                        }
                        this.stmtInsHumanTaskServiceDetails.clearParameters();
                        this.stuffHumanTaskServiceDetailCommonFields(this.stmtInsHumanTaskServiceDetails, aind);
                        this.stmtInsHumanTaskServiceDetails.setString(7, taskId);
                        this.stmtInsHumanTaskServiceDetails.setString(8, logEntryId);
                        this.bindCLOBData(this.stmtInsHumanTaskServiceDetails, 9, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setString(10, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setString(11, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setString(12, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setInt(13, 0);
                        this.stmtInsHumanTaskServiceDetails.setString(14, m_emptyString);
                        this.bindCLOBData(this.stmtInsHumanTaskServiceDetails, 15, taskMsg);
                        this.stmtInsHumanTaskServiceDetails.setString(16, msgType);
                        this.stmtInsHumanTaskServiceDetails.setString(17, Integer.toString(detailsSeqNo));
                        this.stmtInsHumanTaskServiceDetails.execute();
                    }
                }
                if ((notificationListElem = logEntry.element("NotificationList")) != null) {
                    Iterator notificationList = notificationListElem.elementIterator("Notification");
                    while (notificationList.hasNext()) {
                        Element notificationItem = (Element)notificationList.next();
                        Element notifDetailsElem = notificationItem.element("NotificationDetails");
                        String nottifDetails = m_emptyString;
                        if (notifDetailsElem != null) {
                            nottifDetails = notifDetailsElem.getText();
                        }
                        ++detailsSeqNo;
                        if (this.isDBOracle()) {
                            this.stuffHumanTaskServiceDetailCommonFields(this.stmtInsOracleHumanTaskServiceDetails, aind);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(7, taskId);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(8, logEntryId);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(9, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(10, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(11, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setInt(12, 0);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(13, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(14, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(15, Integer.toString(detailsSeqNo));
                            this.stmtInsOracleHumanTaskServiceDetails.execute();
                            ResultSet humantTaskServiceDetailsResult = null;
                            this.stmtSelHumanTaskServiceDetails.setString(1, aind.getIPAddrStr());
                            this.stmtSelHumanTaskServiceDetails.setInt(2, aind.getPort());
                            this.stmtSelHumanTaskServiceDetails.setString(3, aind.getRequestID());
                            this.stmtSelHumanTaskServiceDetails.setString(4, aind.getStepID());
                            this.stmtSelHumanTaskServiceDetails.setString(5, aind.getSubRequestID());
                            this.stmtSelHumanTaskServiceDetails.setString(6, taskId);
                            this.stmtSelHumanTaskServiceDetails.setString(7, logEntryId);
                            this.stmtSelHumanTaskServiceDetails.setString(8, Integer.toString(detailsSeqNo));
                            humantTaskServiceDetailsResult = this.stmtSelHumanTaskServiceDetails.executeQuery();
                            while (humantTaskServiceDetailsResult.next()) {
                                this.bindOracleCLOBToResultSet(nottifDetails, humantTaskServiceDetailsResult, "COGIPF_NOTIFICATION_DETAILS");
                            }
                            continue;
                        }
                        this.stmtInsHumanTaskServiceDetails.clearParameters();
                        this.stuffHumanTaskServiceDetailCommonFields(this.stmtInsHumanTaskServiceDetails, aind);
                        this.stmtInsHumanTaskServiceDetails.setString(7, taskId);
                        this.stmtInsHumanTaskServiceDetails.setString(8, logEntryId);
                        this.bindCLOBData(this.stmtInsHumanTaskServiceDetails, 9, nottifDetails);
                        this.stmtInsHumanTaskServiceDetails.setString(10, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setString(11, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setString(12, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setInt(13, 0);
                        this.stmtInsHumanTaskServiceDetails.setString(14, m_emptyString);
                        this.bindCLOBData(this.stmtInsHumanTaskServiceDetails, 15, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setString(16, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setString(17, Integer.toString(detailsSeqNo));
                        this.stmtInsHumanTaskServiceDetails.execute();
                    }
                }
                if ((humanroleListElem = logEntry.element("HumanroleList")) != null) {
                    Iterator humanroleList = humanroleListElem.elementIterator("Humanrole");
                    while (humanroleList.hasNext()) {
                        Element humanroleItem = (Element)humanroleList.next();
                        Element userElem = humanroleItem.element("User");
                        String user = m_emptyString;
                        if (userElem != null) {
                            user = userElem.getText();
                        }
                        Element roleElem = humanroleItem.element("Role");
                        String role = m_emptyString;
                        if (roleElem != null) {
                            role = roleElem.getText();
                        }
                        ++detailsSeqNo;
                        if (this.isDBOracle()) {
                            this.stuffHumanTaskServiceDetailCommonFields(this.stmtInsOracleHumanTaskServiceDetails, aind);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(7, taskId);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(8, logEntryId);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(9, user);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(10, role);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(11, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setInt(12, 0);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(13, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(14, m_emptyString);
                            this.stmtInsOracleHumanTaskServiceDetails.setString(15, Integer.toString(detailsSeqNo));
                            this.stmtInsOracleHumanTaskServiceDetails.execute();
                            continue;
                        }
                        this.stmtInsHumanTaskServiceDetails.clearParameters();
                        this.stuffHumanTaskServiceDetailCommonFields(this.stmtInsHumanTaskServiceDetails, aind);
                        this.stmtInsHumanTaskServiceDetails.setString(7, taskId);
                        this.stmtInsHumanTaskServiceDetails.setString(8, logEntryId);
                        this.bindCLOBData(this.stmtInsHumanTaskServiceDetails, 9, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setString(10, user);
                        this.stmtInsHumanTaskServiceDetails.setString(11, role);
                        this.stmtInsHumanTaskServiceDetails.setString(12, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setInt(13, 0);
                        this.stmtInsHumanTaskServiceDetails.setString(14, m_emptyString);
                        this.bindCLOBData(this.stmtInsHumanTaskServiceDetails, 15, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setString(16, m_emptyString);
                        this.stmtInsHumanTaskServiceDetails.setString(17, Integer.toString(detailsSeqNo));
                        this.stmtInsHumanTaskServiceDetails.execute();
                    }
                }
                if ((subsChangeListElem = logEntry.element("SubscriptionChangeList")) == null) continue;
                Iterator subsChangeList = subsChangeListElem.elementIterator("SubscriptionChange");
                while (subsChangeList.hasNext()) {
                    Element subsChangeItem = (Element)subsChangeList.next();
                    Element opElem = subsChangeItem.element("Operation");
                    String operation = m_emptyString;
                    if (opElem != null) {
                        operation = opElem.getText();
                    }
                    Element userElem = subsChangeItem.element("User");
                    String user = m_emptyString;
                    if (userElem != null) {
                        user = userElem.getText();
                    }
                    Element eventElem = subsChangeItem.element("Event");
                    String strevent = m_emptyString;
                    if (eventElem != null) {
                        strevent = eventElem.getText();
                    }
                    int event = 0;
                    try {
                        event = Integer.parseInt(strevent);
                    }
                    catch (Exception e) {
                        event = 0;
                    }
                    ++detailsSeqNo;
                    if (this.isDBOracle()) {
                        this.stuffHumanTaskServiceDetailCommonFields(this.stmtInsOracleHumanTaskServiceDetails, aind);
                        this.stmtInsOracleHumanTaskServiceDetails.setString(7, taskId);
                        this.stmtInsOracleHumanTaskServiceDetails.setString(8, logEntryId);
                        this.stmtInsOracleHumanTaskServiceDetails.setString(9, m_emptyString);
                        this.stmtInsOracleHumanTaskServiceDetails.setString(10, m_emptyString);
                        this.stmtInsOracleHumanTaskServiceDetails.setString(11, operation);
                        this.stmtInsOracleHumanTaskServiceDetails.setInt(12, event);
                        this.stmtInsOracleHumanTaskServiceDetails.setString(13, user);
                        this.stmtInsOracleHumanTaskServiceDetails.setString(14, m_emptyString);
                        this.stmtInsOracleHumanTaskServiceDetails.setString(15, Integer.toString(detailsSeqNo));
                        this.stmtInsOracleHumanTaskServiceDetails.execute();
                        continue;
                    }
                    this.stmtInsHumanTaskServiceDetails.clearParameters();
                    this.stuffHumanTaskServiceDetailCommonFields(this.stmtInsHumanTaskServiceDetails, aind);
                    this.stmtInsHumanTaskServiceDetails.setString(7, taskId);
                    this.stmtInsHumanTaskServiceDetails.setString(8, logEntryId);
                    this.bindCLOBData(this.stmtInsHumanTaskServiceDetails, 9, m_emptyString);
                    this.stmtInsHumanTaskServiceDetails.setString(10, m_emptyString);
                    this.stmtInsHumanTaskServiceDetails.setString(11, m_emptyString);
                    this.stmtInsHumanTaskServiceDetails.setString(12, operation);
                    this.stmtInsHumanTaskServiceDetails.setInt(13, event);
                    this.stmtInsHumanTaskServiceDetails.setString(14, user);
                    this.bindCLOBData(this.stmtInsHumanTaskServiceDetails, 15, m_emptyString);
                    this.stmtInsHumanTaskServiceDetails.setString(16, m_emptyString);
                    this.stmtInsHumanTaskServiceDetails.setString(17, Integer.toString(detailsSeqNo));
                    this.stmtInsHumanTaskServiceDetails.execute();
                }
            }
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::populateHumanTaskServiceTables() - Exception: ", e);
            throw e;
        }
    }

    private HashMap<String, String> parseLogData(String XML) throws Exception {
        if (null == XML || 0 == XML.length()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> keyValuePair = new HashMap<String, String>();
        StringReader stringInput = new StringReader(XML);
        try {
            SAXReader xmlInput = new SAXReader();
            Document doc = xmlInput.read((Reader)stringInput);
            Element root = doc.getRootElement();
            Iterator itemList = root.elementIterator("item");
            while (itemList.hasNext()) {
                Element item = (Element)itemList.next();
                String name = item.attributeValue("name");
                String value = item.getText();
                if (name == null || name.length() <= 0) continue;
                keyValuePair.put(name.toUpperCase(), value != null ? value : m_emptyString);
            }
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::parseLogData() - Exception: ", e);
            throw e;
        }
        return keyValuePair;
    }

    private String searchURL(String urlStr, String searchKey) {
        if (null == urlStr) {
            return m_emptyString;
        }
        if (0 == urlStr.length()) {
            return m_emptyString;
        }
        StringTokenizer st = new StringTokenizer(urlStr, "/");
        while (st.hasMoreTokens()) {
            String tmpToken = st.nextToken();
            if (tmpToken == null) {
                return m_emptyString;
            }
            if (!searchKey.equalsIgnoreCase(tmpToken.substring(0, searchKey.length()))) continue;
            int equalPos = tmpToken.indexOf("=");
            if (-1 == equalPos) {
                return m_emptyString;
            }
            return tmpToken.substring(equalPos + 2, tmpToken.length() - 2);
        }
        return m_emptyString;
    }

    private String[] crackURL(String objectPath) {
        String[] result = null;
        result = new String[2];
        if (null == objectPath) {
            result[0] = m_emptyString;
            result[1] = m_emptyString;
            return result;
        }
        String nameKeyword1 = "']/";
        String nameKeyword2 = "\"]/";
        int pathNameSplitter1 = objectPath.lastIndexOf(nameKeyword1);
        int pathNameSplitter2 = objectPath.lastIndexOf(nameKeyword2);
        int pathNameSplitter = 0;
        int whichNameKeyword = 0;
        if (pathNameSplitter1 > pathNameSplitter2) {
            pathNameSplitter = pathNameSplitter1;
            whichNameKeyword = nameKeyword1.length();
        } else {
            pathNameSplitter = pathNameSplitter2;
            whichNameKeyword = nameKeyword2.length();
        }
        if (-1 == pathNameSplitter) {
            result[0] = m_emptyString;
            result[1] = objectPath;
            return result;
        }
        result[0] = objectPath.substring(0, pathNameSplitter + 2);
        result[1] = objectPath.substring(pathNameSplitter + whichNameKeyword);
        return result;
    }

    private void stuffHeader(PreparedStatement pstmt, LogIndication ind) throws Exception {
        try {
            pstmt.setString(1, ind.getIPAddrStr());
            pstmt.setInt(2, ind.getPort());
            pstmt.setInt(3, ind.getProcID());
            pstmt.setTimestamp(4, new Timestamp(ind.getTime()));
            pstmt.setShort(5, (short)(ind.getTimeZoneOffset() / 60));
            pstmt.setString(6, ind.getRenderedSessionID());
            if (0 == ind.getRequestID().length()) {
                pstmt.setString(7, emptyRequestID);
            } else {
                pstmt.setString(7, ind.getRequestID());
            }
            pstmt.setString(8, ind.getStepID());
            pstmt.setString(9, ind.getSubRequestID());
            pstmt.setString(10, ind.getThreadID());
            String tmpStr = ind.getComponentID();
            if (tmpStr.length() > 8) {
                pstmt.setString(11, tmpStr.substring(0, 8));
            } else {
                pstmt.setString(11, tmpStr);
            }
            pstmt.setInt(12, ind.getBuildNumber());
            pstmt.setInt(13, LogIndication.toInteger(ind.getLevel()));
        }
        catch (SQLException e) {
            LogIPFLog.error("LogJDBCAppender::searchXML() - SQLException", e);
            throw e;
        }
        catch (Exception e) {
            LogIPFLog.error("LogJDBCAppender::searchXML() - Exception", e);
            throw e;
        }
    }

    protected Connection getConnection() throws SQLException {
        this.m_conn = this.m_logConnection.getConnection();
        return this.m_conn;
    }

    protected Connection getConnectionForTest() throws SQLException {
        this.m_logConnection.setIgnoreLogs(true);
        return this.m_logConnection.getConnection();
    }

    protected void closeConnection(Connection con) {
        try {
            this.m_logConnection.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDBType(int dbType) {
        this.databaseType = dbType;
        this.setIsNameInLowerCase();
    }

    public int getDBType() {
        return this.databaseType;
    }

    public void setDriver(String driverClass) {
        this.m_databaseDriver = driverClass;
        super.setDriver(driverClass);
    }

    private void bindCLOBData(PreparedStatement stmt, int bindIndex, String value) throws SQLException {
        if (value == null || value.length() == 0) {
            stmt.setNull(bindIndex, 12);
        } else {
            if (this.isDBOracle()) {
                return;
            }
            if (value.length() > 5000) {
                stmt.setCharacterStream(bindIndex, (Reader)new StringReader(value), value.length());
            } else {
                stmt.setObject(bindIndex, (Object)value, 12);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int bindOracleCLOBToResultSet(String value, ResultSet rs, String colName) throws SQLException {
        if (rs == null || value == null || value.length() == 0) {
            return -1;
        }
        if (this.OracleResultSetClass == null || this.OracleClobClass == null || this.getCLOBMethod == null || this.getCharacterOutputStreamMethod == null) {
            return -1;
        }
        Writer outStream = null;
        try {
            Object clob = null;
            clob = this.getCLOBMethod.invoke((Object)rs, colName);
            if (clob != null) {
                outStream = (Writer)this.getCharacterOutputStreamMethod.invoke(clob, null);
                for (int pos = 0; pos < value.length(); pos += 10240) {
                    outStream.write(value, pos, Math.min(value.length() - pos, 10240));
                }
            } else {
                LogIPFLog.error("LogJDBCAppender::bindOracleCLOBToResultSet() - NULL CLOB");
            }
        }
        catch (Exception ex) {
            LogIPFLog.error("LogJDBCAppender::bindOracleCLOBToResultSet() - Exception:", ex);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception ex) {
                    LogIPFLog.debug("LogJDBCAppender::bindOracleCLOBToResultSet() - Exception when close outstream:", ex);
                }
            }
        }
        return 1;
    }

    private void needToUpdateRuntime(ResultSet aResultSet, LogAuditAccessIndication auditInd, PreparedStatement stmtUpd, PreparedStatement stmtUpdMultiple, boolean hasStepID, boolean hasSubReqID, int errMsgMaxLen) throws Exception {
        Timestamp dbTimestamp = aResultSet.getTimestamp("COGIPF_LOCALTIMESTAMP");
        String dbJobStatus = aResultSet.getString("COGIPF_STATUS");
        String dbJobRuntimeStr = aResultSet.getString("COGIPF_RUNTIME");
        long dbJobRuntime = dbJobRuntimeStr == null ? 0L : Long.parseLong(dbJobRuntimeStr);
        aResultSet.close();
        aResultSet = null;
        long dbTime = dbTimestamp.getTime() + (long)(dbTimestamp.getNanos() / 1000000);
        long runtime = StrictMath.abs(auditInd.getTime() - dbTime);
        String action = this.getUpdateActionString(auditInd, dbJobStatus, dbJobRuntime, dbTime, runtime);
        if (action.equals("update")) {
            stmtUpd.setInt(1, new Long(runtime).intValue());
            stmtUpd.setString(2, auditInd.getRequestID());
            if (hasSubReqID) {
                stmtUpd.setString(3, auditInd.getSubRequestID());
                if (hasStepID) {
                    stmtUpd.setString(4, auditInd.getStepID());
                }
            } else if (hasStepID) {
                stmtUpd.setString(3, auditInd.getStepID());
            }
            stmtUpd.executeUpdate();
        } else if (action.equals("updateMultiple")) {
            stmtUpdMultiple.setInt(1, new Long(runtime).intValue());
            stmtUpdMultiple.setTimestamp(2, new Timestamp(auditInd.getTime()));
            stmtUpdMultiple.setString(3, auditInd.getStatus());
            stmtUpdMultiple.setString(4, this.getErrorMessage(auditInd, errMsgMaxLen));
            stmtUpdMultiple.setString(5, auditInd.getRequestID());
            if (hasSubReqID) {
                stmtUpdMultiple.setString(6, auditInd.getSubRequestID());
                if (hasStepID) {
                    stmtUpdMultiple.setString(7, auditInd.getStepID());
                }
            } else if (hasStepID) {
                stmtUpdMultiple.setString(6, auditInd.getStepID());
            }
            stmtUpdMultiple.executeUpdate();
        }
    }

    private String getUpdateActionString(LogAuditAccessIndication auditInd, String dbJobStatus, long dbJobRuntime, long dbTime, long runtime) {
        String action = m_emptyString;
        if (null != dbJobStatus && (dbJobStatus.compareToIgnoreCase("Failure") == 0 || dbJobStatus.compareToIgnoreCase("Success") == 0)) {
            if (runtime > dbJobRuntime) {
                action = "update";
            }
        } else {
            action = auditInd.getStatus().length() > 0 ? "updateMultiple" : (dbTime < auditInd.getTime() ? "update" : "updateMultiple");
        }
        return action;
    }

    private void needToUpdateRuntimePP(ResultSet aResultSet, LogAuditAccessIndication auditInd, PreparedStatement stmtUpd, boolean hasStepID, boolean hasSubReqID) throws Exception {
        String sMsg;
        String sOperation;
        String sDataSrcConn;
        String sPackage;
        HashMap<String, String> logDataMap;
        String sReportName;
        String sStatus;
        String sObjPath;
        String sObjType;
        Timestamp dbTimestamp = aResultSet.getTimestamp("COGIPF_LOCALTIMESTAMP");
        String dbReportPath = aResultSet.getString("COGIPF_REPORTPATH");
        String dbObjType = aResultSet.getString("COGIPF_TARGET_TYPE");
        String dbStatus = aResultSet.getString("COGIPF_STATUS");
        String dbRuntimeStr = aResultSet.getString("COGIPF_RUNTIME");
        String dbReportName = aResultSet.getString("COGIPF_REPORTNAME");
        String dbPackage = aResultSet.getString("COGIPF_PACKAGE");
        String dbDataSrc = aResultSet.getString("COGIPF_DATASOURCE");
        String dbDataSrcConn = aResultSet.getString("COGIPF_DATASOURCE_CONNECTION");
        String dbOperation = aResultSet.getString("COGIPF_OPERATION");
        String dbMsg = aResultSet.getString("COGIPF_MESSAGE");
        int dbReqType = aResultSet.getInt("COGIPF_REQUEST_TYPE");
        String dbSubCompId = aResultSet.getString("COGIPF_SUB_COMPONENTID");
        long dbRuntime = dbRuntimeStr == null ? 0L : Long.parseLong(dbRuntimeStr);
        aResultSet.close();
        aResultSet = null;
        long dbTime = dbTimestamp.getTime() + (long)(dbTimestamp.getNanos() / 1000000);
        long runtime = StrictMath.abs(auditInd.getTime() - dbTime);
        Timestamp timeStamp = dbTimestamp;
        if (null != dbStatus && (dbStatus.compareToIgnoreCase("Failure") == 0 || dbStatus.compareToIgnoreCase("Success") == 0)) {
            timeStamp = new Timestamp(auditInd.getTime());
            if (runtime < dbRuntime) {
                runtime = dbRuntime;
            }
        } else if (auditInd.getStatus().length() > 0) {
            timeStamp = new Timestamp(auditInd.getTime());
        } else if (dbTime > auditInd.getTime()) {
            timeStamp = new Timestamp(auditInd.getTime());
        }
        if ((sObjType = auditInd.getObjectType()) == null || sObjType.length() == 0) {
            sObjType = dbObjType;
        }
        if ((sObjPath = this.getObjectPath(auditInd, this.getColumnSize("COGIPF_POWERPLAY", "COGIPF_REPORTPATH"))) == null || sObjPath.length() == 0) {
            sObjPath = dbReportPath;
        }
        if ((sStatus = auditInd.getStatus()) == null || sStatus.length() == 0) {
            sStatus = dbStatus;
        }
        if ((sReportName = this.searchXML(logDataMap = this.parseLogData(auditInd.getLogData()), "REPORT_NAME")) == null || sReportName.length() == 0) {
            sReportName = dbReportName;
        }
        if ((sPackage = this.searchXML(logDataMap, "PACKAGE")) == null || sPackage.length() == 0) {
            sPackage = dbPackage;
        }
        sPackage = this.processColumnValue(sPackage, this.getColumnSize("COGIPF_POWERPLAY", "COGIPF_PACKAGE"), false);
        String sDataSrc = this.searchXML(logDataMap, "DATASOURCE");
        if (sDataSrc == null || sDataSrc.length() == 0) {
            sDataSrc = dbDataSrc;
        }
        if ((sDataSrcConn = this.searchXML(logDataMap, "DATASOURCE_CONNECTION")) == null || sDataSrcConn.length() == 0) {
            sDataSrcConn = dbDataSrcConn;
        }
        if ((sOperation = auditInd.getOperation()) == null || sOperation.length() == 0) {
            sOperation = dbOperation;
        }
        if ((sMsg = this.getErrorMessage(auditInd, this.getColumnSize("COGIPF_POWERPLAY", "COGIPF_MESSAGE"))) == null || sMsg.length() == 0) {
            sMsg = dbMsg;
        }
        int reqType = 0;
        try {
            reqType = Integer.parseInt(this.searchXML(logDataMap, "REQUEST_TYPE"));
            if (reqType < 0) {
                reqType = dbReqType;
            }
        }
        catch (Exception e) {
            reqType = dbReqType;
        }
        String sSubCompId = this.searchXML(logDataMap, "SUB_COMPONENTID");
        if (sSubCompId == null || sSubCompId.length() == 0) {
            sSubCompId = dbSubCompId;
        }
        stmtUpd.setTimestamp(1, timeStamp);
        stmtUpd.setString(2, sObjType);
        stmtUpd.setString(3, sObjPath);
        stmtUpd.setString(4, sStatus);
        stmtUpd.setInt(5, new Long(runtime).intValue());
        stmtUpd.setString(6, sReportName);
        stmtUpd.setString(7, sPackage);
        stmtUpd.setString(8, sDataSrc);
        stmtUpd.setString(9, sDataSrcConn);
        stmtUpd.setString(10, sOperation);
        stmtUpd.setString(11, sMsg);
        stmtUpd.setInt(12, reqType);
        stmtUpd.setString(13, sSubCompId);
        stmtUpd.setString(14, auditInd.getRequestID());
        if (hasSubReqID) {
            stmtUpd.setString(15, auditInd.getSubRequestID());
            if (hasStepID) {
                stmtUpd.setString(16, auditInd.getStepID());
            }
        } else if (hasStepID) {
            stmtUpd.setString(15, auditInd.getStepID());
        }
        stmtUpd.executeUpdate();
    }

    private void needToUpdateRuntimeMobile(ResultSet aResultSet, LogAuditAccessIndication auditInd, PreparedStatement stmtUpd, PreparedStatement stmtUpdMultiple, int errMsgMaxLen, HashMap<String, String> logData) throws Exception {
        Timestamp dbTimestamp = aResultSet.getTimestamp("COGIPF_LOCALTIMESTAMP");
        String dbJobStatus = aResultSet.getString("COGIPF_STATUS");
        String dbJobRuntimeStr = aResultSet.getString("COGIPF_RUNTIME");
        long dbJobRuntime = dbJobRuntimeStr == null ? 0L : Long.parseLong(dbJobRuntimeStr);
        aResultSet.close();
        aResultSet = null;
        long dbTime = dbTimestamp.getTime() + (long)(dbTimestamp.getNanos() / 1000000);
        long runtime = StrictMath.abs(auditInd.getTime() - dbTime);
        String action = this.getUpdateActionString(auditInd, dbJobStatus, dbJobRuntime, dbTime, runtime);
        if (action.equals("update")) {
            stmtUpd.setInt(1, new Long(runtime).intValue());
            stmtUpd.setString(2, auditInd.getRequestID());
            stmtUpd.setString(3, this.searchXML(logData, "userID"));
            stmtUpd.executeUpdate();
        } else if (action.equals("updateMultiple")) {
            stmtUpdMultiple.setInt(1, new Long(runtime).intValue());
            stmtUpdMultiple.setTimestamp(2, new Timestamp(auditInd.getTime()));
            stmtUpdMultiple.setString(3, auditInd.getStatus());
            stmtUpdMultiple.setString(4, this.getErrorMessage(auditInd, errMsgMaxLen));
            stmtUpdMultiple.setString(5, auditInd.getRequestID());
            stmtUpdMultiple.setString(6, this.searchXML(logData, "userID"));
            stmtUpdMultiple.executeUpdate();
        }
    }

    private boolean isDBOracle() {
        return this.databaseURL.startsWith("jdbc:oracle:thin:");
    }
}

