/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.cclcfgapi.CCLResolveInetAddress;
import com.cognos.indications.ILogAuditIndication;
import com.cognos.indications.ILogIndication;
import com.cognos.indications.ILogPerfIndication;
import com.cognos.indications.ILogTraceIndication;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogIPFLog;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class LogLocalUDPAppender
extends AppenderSkeleton {
    public static final String PORT_OPTION = "Port";
    static final int DEFAULT_PORT = LogIPFConfigure.getServerPort();
    private static final int IPF_MAX_UDP_BUFFER = 65536;
    private boolean m_firstTimeAppend = true;
    private boolean m_useInProcessCalls = true;
    InetAddress address;
    DatagramSocket ds;
    DatagramPacket dp;
    int port = DEFAULT_PORT;
    ByteArrayOutputStream bos = new ByteArrayOutputStream(64000);
    int counter = 0;
    private Object inProcessServer = null;
    private Method inProcessServerLogMethod = null;
    private boolean inProcessServerSet = false;

    private void directAppend(LoggingEvent event) {
        try {
            this.bos.reset();
            ObjectOutputStream oos = new ObjectOutputStream(this.bos);
            oos.writeUTF(event.getLoggerName());
            oos.writeObject(event.getMessage());
            this.inProcessServerLogMethod.invoke(this.inProcessServer, new Object[]{this.bos.toByteArray()});
            oos.close();
        }
        catch (Exception e) {
            LogIPFLog.warn("Detected problem with connection: ", e);
        }
    }

    private void socketAppend(LoggingEvent event) {
        if (this.address == null) {
            LogIPFLog.error("LogLocalUDPAppender::socketAppend() - No host is set for LogLocalUDPAppender -- cannot log");
            return;
        }
        try {
            this.bos.reset();
            ObjectOutputStream oos = new ObjectOutputStream(this.bos);
            oos.writeUTF(event.getLoggerName());
            ILogIndication ind = (ILogIndication)event.getMessage();
            oos.writeObject(ind);
            oos.reset();
            if (this.bos.size() > 65536) {
                LogIPFLog.debug("LogLocalUDPAppender::socketAppend() - Stream buffer size exceeds the size:" + this.bos.size() + ". Maximum allowed is: " + 65536 + ". The data will be truncated.");
                if (ind instanceof ILogAuditIndication) {
                    ILogAuditIndication indAudit = (ILogAuditIndication)ind;
                    indAudit.setLogData(this.truncateLongLogMessage(this.bos.size(), indAudit.getLogData()));
                } else if (ind instanceof ILogPerfIndication) {
                    ILogPerfIndication indPerf = (ILogPerfIndication)ind;
                    indPerf.setLogData(this.truncateLongLogMessage(this.bos.size(), indPerf.getLogData()));
                } else if (ind instanceof ILogTraceIndication) {
                    ILogTraceIndication indTrace = (ILogTraceIndication)ind;
                    indTrace.setMessage(this.truncateLongLogMessage(this.bos.size(), indTrace.getMessage()));
                }
                oos.close();
                this.bos.reset();
                oos = new ObjectOutputStream(this.bos);
                oos.writeUTF(event.getLoggerName());
                oos.writeObject(ind);
                oos.reset();
            }
            this.dp = new DatagramPacket(this.bos.toByteArray(), this.bos.size(), this.address, this.port);
            this.ds.send(this.dp);
            oos.close();
        }
        catch (Exception e) {
            LogIPFLog.warn("LogLocalUDPAppender::socketAppend() - Detected problem with connection: ", e);
        }
    }

    private String truncateLongLogMessage(int targetSize, String longStr) {
        String resultStr = "";
        int exceedingBytes = targetSize - 65536 + 8;
        if (exceedingBytes >= longStr.length()) {
            resultStr = "...";
        } else if (exceedingBytes > 0) {
            LogIPFLog.debug("LogLocalUDPAppender::truncateLongLogMessage() - Number of characters to be removed from LogData is: " + exceedingBytes);
            StringBuffer str = new StringBuffer(longStr.substring(0, longStr.length() - exceedingBytes));
            str.append("...");
            resultStr = str.toString();
        }
        return resultStr;
    }

    public LogLocalUDPAppender() {
        try {
            this.address = CCLResolveInetAddress.getLoopbackAddress();
            this.ds = new DatagramSocket(0, this.address);
        }
        catch (Exception e) {
            LogIPFLog.warn("LogLocalUDPAppender::LogLocalUDPAppender() - Exception when get ipaddress of localhost: ", e);
            this.address = null;
        }
        this.port = this.ds.getPort();
        this.m_firstTimeAppend = true;
        this.m_useInProcessCalls = true;
    }

    public LogLocalUDPAppender(int port) {
        try {
            this.address = CCLResolveInetAddress.getLoopbackAddress();
            this.ds = new DatagramSocket(port, this.address);
        }
        catch (Exception e) {
            LogIPFLog.warn("LogLocalUDPAppender::LogLocalUDPAppender(port) - Exception when get ipaddress of localhost: ", e);
            this.address = null;
        }
        this.port = port;
        this.m_firstTimeAppend = true;
        this.m_useInProcessCalls = true;
    }

    public void activateOptions() {
        if (this.closed) {
            this.closed = false;
        }
        if (this.m_firstTimeAppend) {
            if (this.getName().compareToIgnoreCase("FeedbackAppender") == 0) {
                this.m_useInProcessCalls = false;
            }
            this.m_firstTimeAppend = false;
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public void append(LoggingEvent event) {
        if (event == null) {
            return;
        }
        if (!this.m_useInProcessCalls) {
            this.socketAppend(event);
            return;
        }
        if (!this.inProcessServerSet) {
            this.inProcessServerSet = true;
            this.inProcessServer = LogIPFControl.getInProcessServer();
            if (this.inProcessServer != null) {
                try {
                    Class<?> inProcessServerClass = Class.forName("com.cognos.logserver.LogService");
                    if (inProcessServerClass != null) {
                        this.inProcessServerLogMethod = inProcessServerClass.getMethod("log", byte[].class);
                    } else {
                        this.inProcessServer = null;
                    }
                }
                catch (Exception e) {
                    this.inProcessServer = null;
                }
            }
        }
        if (this.inProcessServer != null) {
            this.directAppend(event);
        } else {
            this.socketAppend(event);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }
}

