/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogZosConsoleLanguageConverter;
import com.cognos.indications.LogZosConsoleMessageCode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class LogZosConsoleAbstractAppender
extends AppenderSkeleton {
    private static String cognosInstanceId = "COGNOS";
    private static String installationRoot = "UNKNOWN";
    private static String hostname = " UNKNOWN";
    private static final int COGNOSINSTANCEIDLEN = 7;
    private static final int CGCCODELEN = 8;
    private static final int CHAINLENGTH = 1;
    private static final int MAXCONSOLELENGTH = 70;
    private static final int MAXLINEBREAKS = 4;
    private String zosConsoleMessageFileLocation = "../configuration/zosConsoleMessages.xml";
    private Pattern regexPattern = null;
    private String regex = "[A-Z]{2,3}-[A-Z]{2,3}-[0-9]{4}";
    private HashMap zosConsoleMsgsHash = null;
    private int hashMapInitLoad = 100;
    private static final LogZosConsoleLanguageConverter languageConverter = new LogZosConsoleLanguageConverter();
    private static Thread threadBufferReader;
    private static final List buffer;
    private static boolean shuttingDown;
    private static final int MAX_BUFFER_SIZE = 100;
    private String serverLocale = "en";

    public LogZosConsoleAbstractAppender() {
        LogIPFLog.debug("LogZosConsoleAbstractAppender default constructor");
        this.init();
    }

    public LogZosConsoleAbstractAppender(Layout layout) {
        LogIPFLog.debug("LogZosConsoleAbstractAppender non default constructor");
        this.layout = layout;
        this.init();
    }

    private void init() {
        this.regexPattern = Pattern.compile(this.regex, 66);
        this.loadHashMap();
        this.serverLocale = this.getServerLocale();
        if (this.convertMsgToEnglish()) {
            LogIPFLog.debug("LogZosConsoleiAbstractAppender - building translated English messages ");
            boolean result = languageConverter.init(this.serverLocale, this.zosConsoleMsgsHash);
            if (!result) {
                this.serverLocale = "en";
            }
        }
        this.initInstanceId();
        this.writeInstanceIdToLog();
        threadBufferReader = new Thread(new ThreadBufferReader(this, buffer));
        threadBufferReader.start();
    }

    private void initInstanceId() {
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "unknown";
        }
        installationRoot = CCLConfigurationFactory.getInstance().resolveEffectivePath("..");
        String hashInput = hostname + installationRoot;
        int hashResult = Math.abs(hashInput.hashCode());
        cognosInstanceId = Integer.toString(hashResult, 36).toUpperCase();
    }

    private void writeInstanceIdToLog() {
        String logMsg = "CGC0038I " + cognosInstanceId + "  The Cognos installation on hostname " + hostname + " installed in directory " + installationRoot + " has been assigned the unique identifier " + cognosInstanceId + ". All log messages originating from this installation will contain this identifier.";
        this.addLogMsgToBuffer(logMsg);
    }

    private String getServerLocale() {
        String languageLoc;
        ICCLConfiguration myConf = CCLConfigurationFactory.createConfiguration();
        try {
            myConf.init();
            String localeString = myConf.getValue("serverLocale", false);
            if (localeString.length() != 0) {
                StringTokenizer st = new StringTokenizer(localeString, "_-", false);
                languageLoc = st.nextToken();
            } else {
                languageLoc = "en";
            }
        }
        catch (CCLConfigurationException e) {
            languageLoc = "en";
        }
        return languageLoc;
    }

    private boolean convertMsgToEnglish() {
        boolean result = true;
        if (this.serverLocale.equals("en")) {
            result = false;
        }
        return result;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void activateOptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LogIPFLog.debug("LogZosConsoleAbstractAppender close");
        List list = buffer;
        synchronized (list) {
            shuttingDown = true;
            buffer.notifyAll();
        }
        try {
            threadBufferReader.join();
        }
        catch (InterruptedException e) {
            LogIPFLog.warn("Interrupted exception on shutdown");
        }
    }

    public boolean isShuttingDown() {
        return shuttingDown;
    }

    private void loadHashMap() {
        LogIPFLog.debug("LogZosConsoleAbstractAppender.loadHashMap");
        try {
            this.zosConsoleMsgsHash = new HashMap(this.hashMapInitLoad);
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxFactory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                String zosCodeStr = "";
                String patternStr = "";
                boolean zosCode = false;
                boolean pattern = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("zosCode")) {
                        this.zosCode = true;
                    } else if (qName.equalsIgnoreCase("pattern")) {
                        this.pattern = true;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.zosCode) {
                        this.zosCodeStr = new String(ch, start, length);
                        this.zosCode = false;
                    } else if (this.pattern) {
                        this.patternStr = new String(ch, start, length);
                        this.pattern = false;
                        LogZosConsoleAbstractAppender.this.zosConsoleMsgsHash.put(this.patternStr, new LogZosConsoleMessageCode(this.zosCodeStr));
                    }
                }
            };
            saxParser.parse(CCLConfigurationFactory.getInstance().resolveEffectivePath(this.zosConsoleMessageFileLocation), handler);
        }
        catch (Exception e) {
            LogIPFLog.error("LogZosConsoleAbstractAppender:loadHashMap - Error occurred during parsing of zosConsoleMessages.xml", e);
        }
    }

    private boolean checkErrorCode(LoggingEvent event, LogZosConsoleCurrentMessageInfo currentMessageInfo) {
        try {
            Matcher m = this.regexPattern.matcher(currentMessageInfo.getMessage());
            while (m.find()) {
                String lookupPattern = m.group(0);
                if (!this.zosConsoleMsgsHash.containsKey(lookupPattern)) continue;
                currentMessageInfo.setLookupPattern(lookupPattern);
                currentMessageInfo.setChainIdx(m.start());
                return true;
            }
        }
        catch (RuntimeException e) {
            LogIPFLog.error("LogZosConsoleAbstractAppender.checkErrorCode exception");
        }
        return false;
    }

    private boolean checkIndication(LoggingEvent event, LogZosConsoleCurrentMessageInfo currentMessageInfo) {
        boolean result = false;
        try {
            String className = ((LogIndication)event.getMessage()).getClass().getName();
            if (className == null) {
                return false;
            }
            if (className.equals("com.cognos.indications.LogAuditIndication")) {
                currentMessageInfo.setMessage(((LogAuditIndication)event.getMessage()).getLogData());
                result = true;
            } else if (className.equals("com.cognos.indications.LogAuditAccessIndication")) {
                currentMessageInfo.setMessage(((LogAuditAccessIndication)event.getMessage()).getErrorMessage());
                if (currentMessageInfo.getMessage().equals("")) {
                    currentMessageInfo.setMessage(((LogAuditAccessIndication)event.getMessage()).getLogData());
                }
                result = true;
            }
        }
        catch (RuntimeException e) {
            LogIPFLog.error("LogZosConsoleAbstractAppender.checkIndication  exception");
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void append(LoggingEvent event) {
        try {
            if (!event.getLevel().equals((Object)Level.FATAL)) return;
            LogZosConsoleCurrentMessageInfo currentMessageInfo = new LogZosConsoleCurrentMessageInfo();
            if (!this.checkIndication(event, currentMessageInfo)) return;
            if (!this.checkErrorCode(event, currentMessageInfo)) {
                return;
            }
            String zosMsg = this.formatMessage(event, currentMessageInfo);
            this.addLogMsgToBuffer(zosMsg);
            return;
        }
        catch (RuntimeException e) {
            LogIPFLog.error("***** LogZosConsoleAbstractAppender exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLogMsgToBuffer(String zosMsg) {
        List list = buffer;
        synchronized (list) {
            boolean bufferWasEmpty;
            boolean bl = bufferWasEmpty = buffer.size() == 0;
            if (buffer.size() < 100) {
                buffer.add(zosMsg);
                if (bufferWasEmpty) {
                    buffer.notifyAll();
                }
            } else {
                LogIPFLog.error("Buffer Overflow. Message Not Written to Zos Console " + zosMsg);
            }
        }
    }

    abstract void writeToConsole(String var1);

    protected String formatMessage(LoggingEvent event, LogZosConsoleCurrentMessageInfo currentMessageInfo) {
        String result = "";
        try {
            String newMsg = "";
            String msgHdr = "";
            String message = currentMessageInfo.getMessage();
            String submsg = message.substring(currentMessageInfo.getChainIdx(), message.length());
            String lookupPattern = currentMessageInfo.getLookupPattern();
            LogZosConsoleMessageCode msgObject = (LogZosConsoleMessageCode)this.zosConsoleMsgsHash.get(lookupPattern);
            String cgcCode = msgObject.getCgcCode();
            boolean messageChain = false;
            Matcher m = this.regexPattern.matcher(submsg);
            int i = 0;
            while (m.find()) {
                if (i == 1) {
                    messageChain = true;
                    break;
                }
                ++i;
            }
            if (messageChain) {
                int matchIdx = m.start();
                newMsg = submsg.substring(0, matchIdx);
            } else {
                newMsg = submsg;
            }
            msgHdr = this.padding(cgcCode, 8) + " " + this.padding(cognosInstanceId, 7) + " ";
            if (this.convertMsgToEnglish()) {
                String englishMsg = languageConverter.getEnglishMsg(newMsg, lookupPattern);
                result = this.breakString(msgHdr + lookupPattern + " " + englishMsg, 4);
            } else {
                result = this.breakString(msgHdr + newMsg, 4);
            }
        }
        catch (RuntimeException e) {
            LogIPFLog.error("LogZosConsoleAbstractAppender.formatMessage exception");
        }
        return result;
    }

    private String padding(String str, int maxLen) {
        int diff = maxLen - str.length();
        String pad = "";
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                pad = pad + " ";
            }
            return str + pad;
        }
        return str;
    }

    private String breakString(String msg, int numBreaks) {
        if (msg.length() <= 70) {
            return msg;
        }
        String sub = msg.substring(0, 69);
        for (int i = sub.length() - 1; i >= 0; --i) {
            if (sub.charAt(i) != ' ' && sub.charAt(i) != '\t') continue;
            if (numBreaks == 1) {
                return sub.substring(0, i) + "...";
            }
            return sub.substring(0, i) + "\n" + this.breakString(msg.substring(i + 1), numBreaks - 1);
        }
        return msg;
    }

    static {
        buffer = new ArrayList();
        shuttingDown = false;
    }

    private class LogZosConsoleCurrentMessageInfo {
        private String lookupPattern = "";
        private String message = "";
        private int chainIdx = -1;

        private LogZosConsoleCurrentMessageInfo() {
        }

        public void setLookupPattern(String pattern) {
            this.lookupPattern = pattern;
        }

        public void setMessage(String newMessage) {
            this.message = newMessage;
        }

        public void setChainIdx(int index) {
            this.chainIdx = index;
        }

        public int getChainIdx() {
            return this.chainIdx;
        }

        public String getLookupPattern() {
            return this.lookupPattern;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private class ThreadBufferReader
    implements Runnable {
        private final List buffer;
        private boolean isRunning = true;
        private final LogZosConsoleAbstractAppender parent;

        public ThreadBufferReader(LogZosConsoleAbstractAppender parent, List buffer) {
            this.buffer = buffer;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogIPFLog.debug("LogZosConsoleAbstractAppender.ThreadBufferReader Starting");
            while (this.isRunning) {
                try {
                    List list = this.buffer;
                    synchronized (list) {
                        int bufferSize = this.buffer.size();
                        boolean bl = this.isRunning = !this.parent.isShuttingDown();
                        if (bufferSize == 0 && this.isRunning) {
                            this.buffer.wait();
                            bufferSize = this.buffer.size();
                            boolean bl2 = this.isRunning = !this.parent.isShuttingDown();
                        }
                        if (bufferSize > 0) {
                            String zosMsg = (String)this.buffer.remove(0);
                            LogZosConsoleAbstractAppender.this.writeToConsole(zosMsg);
                            this.buffer.notifyAll();
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LogIPFLog.warn("LogZosConsoleAbstractAppender.ThreadBufferReader Interrupted");
                }
                catch (RuntimeException e) {
                    Thread.currentThread().interrupt();
                    LogIPFLog.error("LogZosConsoleAbstractAppender.ThreadBufferReader RuntimeException. Exiting thread");
                    this.isRunning = false;
                }
            }
            LogIPFLog.debug("LogZosConsoleAbstractAppender.ThreadBufferReader Shutting Down");
        }
    }
}

