/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.indications.LogIPFLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LogZosConsoleLanguageConverter {
    HashMap m_englishMessageList = new HashMap();
    HashMap m_foreignMessageList = new HashMap();
    private boolean m_parsingEnglish = true;
    private String m_zosMsgCode = null;
    private String m_componentSubString = null;
    private String m_sectionSubString = null;
    private String m_errorCodeSubString = null;
    private static final String PARAM_UNAVAILABLE = "UNAVAILABLE";

    public boolean init(String language, HashMap zosConsoleMsgsHash) {
        boolean result = true;
        try {
            String effectivePath = CCLConfigurationFactory.getInstance().resolveEffectivePath("../msgsdk");
            File dir = new File(effectivePath);
            if (dir.isDirectory()) {
                File file;
                int i;
                String suffix = new String("_" + language + ".xml");
                MsgFileFilter filter = new MsgFileFilter(suffix);
                filter.accept(dir, suffix);
                File[] msgFiles = dir.listFiles(filter);
                if (msgFiles.length == 0) {
                    LogIPFLog.warn("LogZosConsoleLanguageConverter - no messsage files found with suffix" + suffix);
                    result = false;
                }
                this.m_parsingEnglish = false;
                for (i = 0; i < msgFiles.length; ++i) {
                    file = msgFiles[i];
                    this.parseXmlMsgFile("../msgsdk/" + file.getName(), zosConsoleMsgsHash);
                }
                this.m_parsingEnglish = true;
                suffix = new String("_en.xml");
                filter = new MsgFileFilter(suffix);
                filter.accept(dir, suffix);
                msgFiles = dir.listFiles(filter);
                if (msgFiles.length == 0) {
                    LogIPFLog.warn("LogZosConsoleLanguageConverter - no messsage files found with suffix" + suffix);
                    result = false;
                }
                for (i = 0; i < msgFiles.length; ++i) {
                    file = msgFiles[i];
                    this.parseXmlMsgFile("../msgsdk/" + file.getName(), zosConsoleMsgsHash);
                }
            } else {
                LogIPFLog.warn("LogZosConsoleLanguageConverter - could not open directory to get message files");
                result = false;
            }
        }
        catch (Throwable e) {
            LogIPFLog.warn("LogZosConsoleLanguageConverter - exception occurred. Conversion to English disabled");
            result = false;
        }
        if (!result) {
            this.m_englishMessageList.clear();
            this.m_foreignMessageList.clear();
        }
        return result;
    }

    private boolean parseXmlMsgFile(String filename, HashMap zosConsoleMsgsHash) {
        boolean found = false;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            File file = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(filename));
            FileInputStream inputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            InputSource inputSource = new InputSource(inputStreamReader);
            inputSource.setEncoding("UTF-8");
            Document document = builder.parse(inputStream);
            NodeList nodes_i = document.getDocumentElement().getChildNodes();
            Set keys = zosConsoleMsgsHash.keySet();
            for (String code : keys) {
                String[] parts = code.split("-");
                if (parts.length != 3) continue;
                this.m_componentSubString = parts[0];
                this.m_sectionSubString = parts[1];
                this.m_errorCodeSubString = parts[2];
                this.m_zosMsgCode = code;
                found = this.searchForComponentElement(nodes_i, this.m_componentSubString, 0);
            }
        }
        catch (SAXException e) {
            LogIPFLog.warn("LogZosConsoleLanguageConverter - SAXException when parsing" + filename);
        }
        catch (IOException e) {
            LogIPFLog.warn("LogZosConsoleLanguageConverter - IOException when parsing" + filename);
        }
        catch (ParserConfigurationException e1) {
            LogIPFLog.warn("LogZosConsoleLanguageConverter - ParserConfigurationException when parsing" + filename);
        }
        return found;
    }

    private void logErrorCase(String zosConsoleCode) {
        ChunkedErrorMessage message = (ChunkedErrorMessage)this.m_englishMessageList.get(zosConsoleCode);
        if (message != null) {
            StringBuffer msgBuffer = new StringBuffer();
            for (int j = 0; j < message.size(); ++j) {
                ErrorMessageChunk chunk = (ErrorMessageChunk)message.get(j);
                if (chunk instanceof ErrorMessageParam) {
                    msgBuffer.append(PARAM_UNAVAILABLE);
                    continue;
                }
                if (!(chunk instanceof ErrorMessageText)) continue;
                ErrorMessageText text = (ErrorMessageText)chunk;
                msgBuffer.append(text.subString);
            }
        }
    }

    public String getEnglishMsg(String logMsgText, String zosConsoleCode) {
        StringBuffer englishZosConsoleMsg = new StringBuffer();
        try {
            int i;
            ArrayList<ErrorMessageSubstitutedParam> paramListWithSubstitutedText = new ArrayList<ErrorMessageSubstitutedParam>();
            ChunkedErrorMessage message = (ChunkedErrorMessage)this.m_foreignMessageList.get(zosConsoleCode);
            if (message != null) {
                int currentPosition = 0;
                int currentParamStartPos = -1;
                int currentParamNumber = -1;
                for (i = 0; i < message.size(); ++i) {
                    ErrorMessageChunk chunk = (ErrorMessageChunk)message.get(i);
                    if (chunk instanceof ErrorMessageParam) {
                        ErrorMessageParam param = (ErrorMessageParam)chunk;
                        if (currentParamStartPos == -1) {
                            currentParamStartPos = currentPosition;
                        }
                        currentParamNumber = param.paramNumber;
                        continue;
                    }
                    if (!(chunk instanceof ErrorMessageText)) continue;
                    ErrorMessageText text = (ErrorMessageText)chunk;
                    int found = logMsgText.indexOf(text.subString, currentPosition);
                    if (found != -1) {
                        if (currentParamNumber != -1) {
                            String substitedParamText = logMsgText.substring(currentParamStartPos, found);
                            ErrorMessageSubstitutedParam temp = new ErrorMessageSubstitutedParam(currentParamNumber, substitedParamText);
                            paramListWithSubstitutedText.add(temp);
                            currentParamStartPos = -1;
                            currentParamNumber = -1;
                        }
                        currentPosition = found + text.subString.length();
                        continue;
                    }
                    LogIPFLog.warn("LogZosConsoleLanguageConverter No match in<" + logMsgText + "> for <" + text.subString + ">");
                }
            } else {
                LogIPFLog.warn("LogZosConsoleLanguageConverter.getEnglishMsg - no foreign message for" + zosConsoleCode);
            }
            message = (ChunkedErrorMessage)this.m_englishMessageList.get(zosConsoleCode);
            if (message != null) {
                for (i = 0; i < message.size(); ++i) {
                    ErrorMessageChunk chunk = (ErrorMessageChunk)message.get(i);
                    if (chunk instanceof ErrorMessageParam) {
                        ErrorMessageParam param = (ErrorMessageParam)chunk;
                        try {
                            boolean found = false;
                            for (int j = 0; j < paramListWithSubstitutedText.size(); ++j) {
                                ErrorMessageSubstitutedParam substitutedParam = (ErrorMessageSubstitutedParam)paramListWithSubstitutedText.get(j);
                                if (substitutedParam.paramNumber != param.paramNumber) continue;
                                englishZosConsoleMsg.append(substitutedParam.subString);
                                found = true;
                                break;
                            }
                            if (found) continue;
                            englishZosConsoleMsg.append(PARAM_UNAVAILABLE);
                            continue;
                        }
                        catch (IndexOutOfBoundsException e) {
                            LogIPFLog.warn("LogZosConsoleLanguageConverter  - array out of bounds exception in getEnglishMsg");
                            englishZosConsoleMsg = new StringBuffer("");
                            break;
                        }
                    }
                    if (!(chunk instanceof ErrorMessageText)) continue;
                    ErrorMessageText text = (ErrorMessageText)chunk;
                    englishZosConsoleMsg.append(text.subString);
                }
            } else {
                LogIPFLog.warn("LogZosConsoleLanguageConverter.getEnglishMsg - no english message for" + zosConsoleCode);
            }
            if (englishZosConsoleMsg.length() == 0) {
                return logMsgText;
            }
            return englishZosConsoleMsg.toString();
        }
        catch (Throwable e) {
            LogIPFLog.warn("LogZosConsoleLanguageConverter.getEnglishMsg - exception occurred. Conversion to English did not occur for this message " + logMsgText);
            return logMsgText;
        }
    }

    private boolean searchForComponentElement(NodeList list, String toMatch, int level) {
        boolean result = false;
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            Node node_i = list.item(i);
            if (node_i.getNodeType() == 1 && (element = (Element)node_i).getNodeName() == "component") {
                NodeList newList;
                String temp = element.getAttribute("name");
                if (element.getAttribute("name").equals(toMatch) && (result = this.searchForSectionElement(newList = node_i.getChildNodes(), this.m_sectionSubString, level++))) break;
            }
            if (!node_i.hasChildNodes()) continue;
            NodeList newList = node_i.getChildNodes();
            result = this.searchForComponentElement(newList, toMatch, level++);
        }
        return result;
    }

    private boolean searchForSectionElement(NodeList list, String toMatch, int level) {
        NodeList newList;
        Element element;
        Node node_i;
        boolean result = false;
        for (int i = 0; !(i >= list.getLength() || (node_i = list.item(i)).getNodeType() == 1 && (element = (Element)node_i).getNodeName() == "section" && element.getAttribute("name").equals(toMatch) && (result = this.searchForErrorCodeElement(newList = node_i.getChildNodes(), this.m_errorCodeSubString, level++))); ++i) {
            if (!node_i.hasChildNodes()) continue;
            NodeList newList2 = node_i.getChildNodes();
            result = this.searchForSectionElement(newList2, toMatch, level++);
        }
        return result;
    }

    private boolean searchForErrorCodeElement(NodeList list, String toMatch, int level) {
        boolean result = false;
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            Node node_i = list.item(i);
            if (node_i.getNodeType() == 1 && (element = (Element)node_i).getNodeName() == "string" && element.getAttribute("errorCode").equals(toMatch)) {
                if (element.hasChildNodes()) {
                    Node innerNode;
                    NodeList innerList = element.getChildNodes();
                    for (int h = 0; h < innerList.getLength() && (innerNode = innerList.item(h)).getNodeType() != 3; ++h) {
                    }
                }
                this.storeErrorMessage(element);
                result = true;
                if (result) break;
            }
            if (!node_i.hasChildNodes()) continue;
            NodeList newList = node_i.getChildNodes();
            result = this.searchForErrorCodeElement(newList, toMatch, level++);
        }
        return result;
    }

    private void storeErrorMessage(Element errorMessageElement) {
        if (errorMessageElement.hasChildNodes()) {
            ChunkedErrorMessage chunkedErrorMessage = new ChunkedErrorMessage();
            NodeList list = errorMessageElement.getChildNodes();
            int paramCount = 0;
            for (int i = 0; i < list.getLength(); ++i) {
                Node node_i = list.item(i);
                if (node_i.getNodeType() == 1) {
                    Element element = (Element)node_i;
                    if (element.getNodeName() != "param") continue;
                    int paramNum = -1;
                    try {
                        paramNum = element.getAttribute("name") != "" ? Integer.parseInt(element.getAttribute("name")) : (element.getAttribute("index") != "" ? Integer.parseInt(element.getAttribute("index")) : Integer.parseInt(element.getAttribute("index")));
                    }
                    catch (NumberFormatException e) {
                        paramNum = paramCount;
                    }
                    ++paramCount;
                    if (paramNum == -1) continue;
                    ErrorMessageParam chunk = new ErrorMessageParam(paramNum);
                    chunkedErrorMessage.add(chunk);
                    continue;
                }
                if (node_i.getNodeType() != 3) continue;
                ErrorMessageText chunk = new ErrorMessageText(node_i.getNodeValue());
                chunkedErrorMessage.add(chunk);
            }
            if (this.m_parsingEnglish) {
                this.m_englishMessageList.put(this.m_zosMsgCode, chunkedErrorMessage);
            } else {
                this.m_foreignMessageList.put(this.m_zosMsgCode, chunkedErrorMessage);
            }
        }
    }

    private class MsgFileFilter
    implements FilenameFilter {
        String m_suffix;

        @Override
        public boolean accept(File dir, String fileName) {
            boolean result = false;
            if (fileName.endsWith(this.m_suffix)) {
                result = true;
            }
            return result;
        }

        MsgFileFilter(String suffix) {
            this.m_suffix = suffix;
        }
    }

    private class ChunkedErrorMessage
    extends ArrayList {
        static final long serialVersionUID = 0L;

        private ChunkedErrorMessage() {
        }
    }

    private class ErrorMessageSubstitutedParam {
        public int paramNumber;
        public String subString;

        public ErrorMessageSubstitutedParam(int paramIndex, String text) {
            this.paramNumber = paramIndex;
            this.subString = text;
        }
    }

    private class ErrorMessageText
    extends ErrorMessageChunk {
        public String subString;

        public ErrorMessageText(String text) {
            this.subString = text;
        }
    }

    private class ErrorMessageParam
    extends ErrorMessageChunk {
        public int paramNumber;

        public ErrorMessageParam(int paramIndex) {
            this.paramNumber = paramIndex;
        }
    }

    abstract class ErrorMessageChunk {
        ErrorMessageChunk() {
        }
    }
}

