/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications.dbstore;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogTypedLogger;
import com.cognos.indications.Version;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class LogDBConnection {
    private boolean m_logOnlyOnce = false;
    private String m_dbURL = "";
    private int m_dbType = 0;
    private String m_dbUser = "";
    private String m_dbPassword = "";
    protected Connection m_conn = null;
    private LogTypedLogger m_serverLogger = null;
    private boolean m_bIgnoreLogs = false;

    public void setIgnoreLogs(boolean bIgnore) {
        this.m_bIgnoreLogs = bIgnore;
    }

    public LogDBConnection() {
    }

    public LogDBConnection(boolean bIgnoreLogs) {
        this.m_bIgnoreLogs = bIgnoreLogs;
    }

    public void closeConnection() throws Exception {
        try {
            if (this.m_conn != null && !this.m_conn.isClosed()) {
                this.m_conn.close();
            }
        }
        catch (SQLException e) {
            LogIPFLog.error("LogDBConnection::closeConnection - Error closing connection ", e);
            throw e;
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.m_conn == null) {
            if (!DriverManager.getDrivers().hasMoreElements()) {
                this.setDriver("sun.jdbc.odbc.JdbcOdbcDriver");
            }
            try {
                this.m_conn = this.m_dbUser != null && this.m_dbUser.length() > 0 ? DriverManager.getConnection(this.m_dbURL, this.m_dbUser, this.m_dbPassword) : DriverManager.getConnection(this.m_dbURL);
                if (!this.m_bIgnoreLogs) {
                    this.logDBMessage("Success", null);
                    this.m_logOnlyOnce = false;
                }
            }
            catch (SQLException e) {
                if (!this.m_bIgnoreLogs && !this.m_logOnlyOnce) {
                    this.parseException("Failure", e);
                    this.m_logOnlyOnce = true;
                }
                LogIPFLog.error("LogDBConnection::getConnection - Error getting connection ", e);
                throw e;
            }
        }
        return this.m_conn;
    }

    public boolean isConnectionProblem(SQLException e) {
        String sqlState = e.getSQLState();
        if (sqlState == null) {
            if (this.m_dbType == 1 || this.m_dbType == 4 ? e.getErrorCode() == 17002 || e.getErrorCode() == 17008 : (this.m_dbType == 2 || this.m_dbType == 7 ? e.getErrorCode() == 0 : this.m_dbType == 6)) {
                return true;
            }
        } else {
            if (sqlState.startsWith("08")) {
                return true;
            }
            if (this.m_dbType == 1 || this.m_dbType == 4) {
                try {
                    int sqlStateValue = Integer.parseInt(sqlState);
                    if (sqlStateValue >= 60000 && sqlStateValue < 100000) {
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (this.m_dbType == 3) {
                if (sqlState.equals("40003")) {
                    return true;
                }
                if (sqlState.equals("S1000") && e.getMessage().indexOf("CLI0601E") >= 0) {
                    return true;
                }
                if (sqlState.equals("07003") && e.getErrorCode() == -518) {
                    return true;
                }
                if (sqlState.equals("26501") && e.getErrorCode() == -514) {
                    return true;
                }
            } else if (this.m_dbType == 6 && (sqlState.equals("04501") || sqlState.equals("XJ004") || sqlState.equals("XJ015") || sqlState.equals("XXXXX"))) {
                return true;
            }
        }
        return false;
    }

    public Connection parseException(String msg, SQLException ex) {
        if (this.isConnectionProblem(ex)) {
            this.m_conn = null;
        }
        if (msg.startsWith("Failure") && !msg.equalsIgnoreCase("Failure")) {
            this.logDBMessage("Failure", msg, ex);
        } else {
            this.logDBMessage(msg, ex);
        }
        return this.m_conn;
    }

    public void setDriver(String driverClass) {
        try {
            Class.forName(driverClass);
            LogIPFLog.debug("LogDBConnection::setDriver(): Loaded driver: " + driverClass);
        }
        catch (ClassNotFoundException e) {
            LogIPFLog.error("LogDBConnection: Failed to load driver " + driverClass, e);
            if (5 == this.m_dbType) {
                String driverString = LogIPFConfigure.IPFPropRead.getProperty("IPFDbDriverSybaseJDBC4");
                LogIPFLog.debug("LogDBConnection::setDriver(): Try to load driver: " + driverString);
                if (driverString != null && driverString.length() > 0) {
                    try {
                        Class.forName(driverString);
                        LogIPFLog.debug("LogDBConnection::setDriver(): Loaded driver: " + driverString);
                    }
                    catch (Exception e1) {
                        LogIPFLog.error("LogDBConnection: Failed to load driver " + driverString, e);
                    }
                }
            }
        }
        catch (Exception e) {
            LogIPFLog.error("LogDBConnection: Failed to load driver " + driverClass, e);
        }
    }

    private void logDBMessage(String status, Exception errEx) {
        this.logDBMessage(status, "", errEx);
    }

    private void logDBMessage(String status, String errMsg, Exception errEx) {
        if (null == this.m_serverLogger) {
            this.m_serverLogger = LogTypedLogger.getInstance("server.Audit.IPF", LogAuditAccessIndication.class);
        }
        if (null != this.m_serverLogger) {
            StringBuffer buffer = new StringBuffer(160);
            LogAuditAccessIndication dbStatusIndication = new LogAuditAccessIndication("LOGSV", Version.getMajorBuild());
            dbStatusIndication.setLevel(50000);
            dbStatusIndication.setOperation("Execute");
            dbStatusIndication.setObjectType("AuditDatabaseConnection");
            dbStatusIndication.setObjectPath(LogIPFConfigure.getDBURL());
            if (status.equalsIgnoreCase("Failure")) {
                dbStatusIndication.setErrorMessage(LogIPFControl.getErrMsg((short)5));
                buffer.append("<parameters><item name=\"DB URL\"><![CDATA[");
                buffer.append(LogIPFConfigure.getDBURL());
                buffer.append("]]></item>");
                buffer.append("<item name=\"DB SQL Exception\"><![CDATA[");
                if (errMsg.length() > 0) {
                    buffer.append(errMsg + ", ");
                }
                buffer.append(errEx.getMessage());
                buffer.append("]]></item></parameters>");
            } else {
                buffer.append("<parameters><item name=\"DB Connection\"><![CDATA[");
                buffer.append("Established");
                buffer.append("]]></item></parameters>");
            }
            dbStatusIndication.setStatus(status);
            dbStatusIndication.setLogData(buffer.toString());
            this.m_serverLogger.log(dbStatusIndication);
        }
    }

    public void setURL(String newURL) {
        this.m_dbURL = newURL;
    }

    public void setUser(String newUser) {
        this.m_dbUser = newUser;
    }

    public void setPassword(String newPassword) {
        this.m_dbPassword = newPassword;
    }

    public void setType(int newDB) {
        this.m_dbType = newDB;
    }

    public void checkDBConnParams() throws Exception {
        if (this.m_dbURL == null || this.m_dbURL.length() == 0) {
            throw new Exception("LogDBConnection::init() - URL not set");
        }
        if ((this.m_dbUser == null || this.m_dbUser.length() == 0) && this.m_dbType != 7 && this.m_dbType != 6) {
            throw new Exception("LogDBConnection::init() - User not set");
        }
        if (this.m_dbType == 0) {
            throw new Exception("LogDBConnection::init() - Database type not set");
        }
    }
}

