/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications.dbstore;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.LogTypedLogger;
import com.cognos.indications.dbstore.LogDBConnection;
import com.cognos.indications.dbstore.LogDbStoreExecutor;
import com.cognos.indications.dbstore.LogDbStoreScriptParameters;
import com.cognos.indications.dbstore.LogDbStoreUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class LogDbStoreFactory {
    private String m_dbURL = "";
    public static final int LogOracleDB = 1;
    public static final int LogMSSQLDB = 2;
    public static final int LogDb2DB = 3;
    public static final int LogOracleAdvancedDB = 4;
    public static final int LogSybaseDB = 5;
    public static final int LogDerbyDB = 6;
    public static final int LogMSSQLWinAuthDB = 7;
    public static final int LogInformixDB = 8;
    public static final String JDBC4DriverType = "JDBC4";
    private static final int LogDBStoreCreated = 1;
    private static final int LogDBStoreUpgraded = 2;
    private static final int LogDBStoreUndefined = 3;
    private static final String m_ipfSchemaFolder = "../configuration/schemas/logging/";
    private static final String DB_PARM_VERSION = "IPFStoreVersion";
    private static final String DB_VERSION = "102.006";
    private static final String SCRIPT_SQL_COMMENT = "--";
    private static LogDbStoreScriptParameters m_scriptParameters = new LogDbStoreScriptParameters();
    private int m_dbType = 0;
    private String m_dbTypeName = "";
    private int m_dbInitializationState = 3;
    private String m_dbStoreVersion = "";
    private boolean m_dbInited_ = false;
    protected Connection m_conn = null;
    protected LogDBConnection m_logConnection = new LogDBConnection(true);

    public static LogDbStoreScriptParameters getScriptParameters() {
        return m_scriptParameters;
    }

    public void setURL(String newURL) {
        this.m_logConnection.setURL(newURL);
    }

    public void setUser(String newUser) {
        this.m_logConnection.setUser(newUser);
    }

    public void setPassword(String newPassword) {
        this.m_logConnection.setPassword(newPassword);
    }

    public void setType(int newDB) {
        this.m_logConnection.setType(newDB);
        this.m_dbType = newDB;
    }

    protected void closeConnection() throws Exception {
        try {
            this.m_logConnection.closeConnection();
        }
        catch (SQLException e) {
            LogIPFLog.error("LogDbStoreFactory::closeConnection() - Error closing connection " + e.getMessage(), e);
            throw e;
        }
    }

    protected Connection getConnection() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = this.m_logConnection.getConnection();
        }
        return this.m_conn;
    }

    public synchronized void init() throws Exception {
        if (this.m_dbInited_) {
            return;
        }
        this.m_logConnection.checkDBConnParams();
        try {
            this.getConnection();
        }
        catch (Exception e) {
            LogIPFLog.error("LogDbStoreFactory::init() - Failed to connect to " + this.m_dbURL, e);
            throw e;
        }
        if (this.m_conn == null) {
            LogIPFLog.error("LogDbStoreFactory::init() - NULL DB connection");
            return;
        }
        this.getDBTypeName();
        LogDbStoreFactory.getScriptParameters().initialize();
        if (this.isDatabaseEmpty()) {
            this.initDatabase();
        } else if (this.databaseRequiresUpgrade()) {
            this.upgradeDatabase();
        }
        this.closeConnection();
        this.m_dbInited_ = true;
        LogIPFLog.debug("LogDbStoreFactory::init() - succeed.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getDBTypeName() throws Exception {
        if (this.m_dbType == 1 || this.m_dbType == 4) {
            this.m_dbTypeName = "oracle";
            return;
        } else if (this.m_dbType == 3) {
            if (this.m_conn == null) return;
            try {
                DatabaseMetaData dbInfo = this.m_conn.getMetaData();
                String dbTypeName = dbInfo.getDatabaseProductName();
                if (dbTypeName.length() == 0) {
                    if (!dbInfo.getDriverName().startsWith("IBM DB2")) return;
                    this.m_dbTypeName = "db2";
                    return;
                }
                if (dbTypeName.equalsIgnoreCase("DB2")) {
                    this.m_dbTypeName = "db2zOS";
                    return;
                }
                this.m_dbTypeName = "db2";
                return;
            }
            catch (SQLException e) {
                LogIPFLog.error("LogDbStoreFactory::getDBTypeName() - can not get meta data to figure out DB2 type (db2zOS or db2).", e);
                throw e;
            }
        } else {
            this.m_dbTypeName = this.m_dbType == 2 || this.m_dbType == 7 ? "mssql" : (this.m_dbType == 5 ? "sybase" : (this.m_dbType == 6 ? "derby" : (this.m_dbType == 8 ? "informix" : "")));
        }
    }

    private void initDatabase() throws Exception {
        this.executeCreateScript(this.m_conn, this.getInitScript());
        this.m_dbInitializationState = 1;
    }

    private File getInitScript() throws Exception {
        StringBuffer fileName = new StringBuffer(80);
        String folderName = this.m_dbTypeName.equalsIgnoreCase("mssql") ? "sqlserver" : this.m_dbTypeName;
        fileName.append(m_ipfSchemaFolder).append(folderName).append("/");
        fileName.append("LS_dbInit_");
        fileName.append(this.m_dbTypeName);
        fileName.append(".sql");
        String schemaCreateFileName = "";
        try {
            ICCLConfiguration tmpConf = CCLConfigurationFactory.createConfiguration();
            tmpConf.init();
            schemaCreateFileName = tmpConf.resolveEffectivePath(fileName.toString());
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogDbStoreFactory::getInitScript() - Failed to initialize  ICCLConfiguration", e);
            throw e;
        }
        File scriptFile = new File(schemaCreateFileName);
        if (scriptFile.exists()) {
            return scriptFile;
        }
        throw new Exception("LogDbStoreFactory::getInitScript() - Failed to retrieve " + schemaCreateFileName);
    }

    private void upgradeDatabase() throws Exception {
        LogIPFLog.debug("LogDbStoreFactory::upgradeDatabase() - LogServer database requires upgrade");
        File[] upgradeFiles = this.getUpgradeFiles();
        for (int i = 0; i < upgradeFiles.length && upgradeFiles[i] != null; ++i) {
            this.executeUpdateScript(this.m_conn, upgradeFiles[i], "com.cognos.indications.dbstore.LogDbStoreUpgrade");
        }
        boolean inTransaction = false;
        Statement stmt = null;
        try {
            stmt = this.m_conn.createStatement();
            this.m_conn.setAutoCommit(false);
            inTransaction = true;
            stmt.executeUpdate("delete from COGIPF_SYSPROPS where PROPNAME='IPFStoreVersion'");
            stmt.executeUpdate("insert into COGIPF_SYSPROPS (PROPNAME, PROPVALUE) values ('IPFStoreVersion', '102.006')");
            this.m_conn.commit();
            inTransaction = false;
            this.m_conn.setAutoCommit(true);
        }
        catch (SQLException ex) {
            LogIPFLog.warn("LogDbStoreFactory::upgradeDatabase() - SQLException", ex);
            try {
                if (inTransaction) {
                    this.m_conn.rollback();
                }
                this.m_conn.setAutoCommit(true);
            }
            catch (SQLException ex2) {
                LogIPFLog.warn("LogDbStoreFactory::upgradeDatabase() - SQLException", ex2);
            }
            throw ex;
        }
        finally {
            LogDbStoreUtil.safeCloseStatement(stmt);
        }
        this.m_dbInitializationState = 2;
    }

    public boolean databaseRequiresUpgrade() throws Exception {
        if (this.m_dbStoreVersion.equals(DB_VERSION)) {
            LogIPFLog.debug("LogDbStoreFactory::databaseRequiresUpgrade() - LogServer DB up-to-date [102.006]");
            return false;
        }
        if (Float.parseFloat(this.m_dbStoreVersion) > Float.parseFloat(DB_VERSION)) {
            throw new Exception("LogDbStoreFactory::databaseRequiresUpgrade() - CognosIPF.jar requires upgrade from version 102.006 to version " + this.m_dbStoreVersion + " or newer");
        }
        LogTypedLogger serverLogger = LogTypedLogger.getInstance("Audit", LogAuditAccessIndication.class);
        if (null != serverLogger) {
            StringBuffer buffer = new StringBuffer(160);
            buffer.append("<parameters><item name=\"OLD_VERSION\"><![CDATA[");
            buffer.append(this.m_dbStoreVersion);
            buffer.append("]]></item><item name=\"NEW_VERSION\"><![CDATA[");
            buffer.append(DB_VERSION);
            buffer.append("]]></item></parameters>");
            int buildNum = 0;
            try {
                Class<?> c = Class.forName("com.cognos.logserver.Version");
                Method m = c.getDeclaredMethod("getMajorBuild", null);
                buildNum = (Integer)m.invoke(c, null);
            }
            catch (Exception e) {
                LogIPFLog.debug("LogDbStoreFactory::databaseRequiresUpgrade() - Exception when get logerver build number", e);
            }
            LogAuditAccessIndication dbStatusIndication = new LogAuditAccessIndication("LOGSV", buildNum);
            dbStatusIndication.setLevel(50000);
            dbStatusIndication.setOperation("Upgrade");
            dbStatusIndication.setObjectType("Schema");
            dbStatusIndication.setObjectPath(this.m_dbURL);
            dbStatusIndication.setStatus("Success");
            dbStatusIndication.setLogData(buffer.toString());
            serverLogger.log(dbStatusIndication);
        }
        return true;
    }

    public boolean isDatabaseEmpty() throws Exception {
        return this.isDatabaseEmpty(this.m_conn);
    }

    public boolean isDatabaseEmpty(Connection conn) throws Exception {
        ResultSet rs = null;
        Statement selIpfObjects = null;
        try {
            selIpfObjects = conn.createStatement();
        }
        catch (SQLException ex) {
            LogIPFLog.warn("LogDbStoreFactory::isDatabaseEmpty() - SQLException when calling m_conn.createStatement():", ex);
            throw ex;
        }
        int numOfRetries = 5;
        try {
            rs = selIpfObjects.executeQuery("SELECT PROPVALUE FROM COGIPF_SYSPROPS");
            if (!rs.next()) {
                LogIPFLog.error("LogDbStoreFactory::isDatabaseEmpty() - Corrupted COGIPF_SYSPROPS table in the logging DB");
                throw new Exception("LogDbStoreFactory::isDatabaseEmpty() - Failed to read LogServer Database props");
            }
            LogIPFLog.debug("LogDbStoreFactory::isDatabaseEmpty() - Database exists");
            this.m_dbStoreVersion = rs.getString(1);
            LogIPFLog.debug("LogDbStoreFactory::isDatabaseEmpty() - Existing LogServer db version is: " + this.m_dbStoreVersion);
            return false;
        }
        catch (SQLException ex) {
            LogIPFLog.debug("LogDbStoreFactory::isDatabaseEmpty() - No such table: COGIPF_SYSPROPS ", ex);
            --numOfRetries;
            while (numOfRetries == 0) {
            }
            return true;
        }
    }

    private void executeCreateScript(Connection con, File scriptFile) throws Exception {
        if (!scriptFile.exists()) {
            LogIPFLog.debug("LogDbStoreFactory::executeCreateScript() - missing scripts");
            throw new Exception("LogDbStoreFactory::executeCreateScript() - Missing LogServer database creation scripts");
        }
        Statement stmt = null;
        boolean inTransaction = false;
        StringBuffer currentBatch = new StringBuffer(255);
        try {
            String currentLine;
            BufferedReader script = new BufferedReader(new InputStreamReader(new FileInputStream(scriptFile)));
            stmt = con.createStatement();
            con.setAutoCommit(false);
            inTransaction = true;
            while ((currentLine = script.readLine()) != null) {
                if (currentLine.trim().length() > 0) {
                    if (currentLine.indexOf(SCRIPT_SQL_COMMENT) == 0) continue;
                    currentLine = LogDbStoreFactory.getScriptParameters().replaceAllParameters(currentLine);
                    currentBatch.append(currentLine);
                    currentBatch.append("\n");
                    continue;
                }
                if (currentBatch.length() <= 0) continue;
                String currentCommand = currentBatch.toString();
                currentCommand = this.makeConformedSqlStatement(currentCommand);
                stmt.execute(currentCommand);
                currentBatch.setLength(0);
            }
            if (currentBatch.length() > 0) {
                stmt.execute(currentBatch.toString());
                currentBatch.setLength(0);
            }
            con.commit();
            inTransaction = false;
            con.setAutoCommit(true);
        }
        catch (Exception ex) {
            try {
                LogIPFLog.error("LogDbStoreFactory::executeCreateScript() -  exception executing " + currentBatch.toString(), ex);
                try {
                    if (inTransaction) {
                        con.rollback();
                    }
                    con.setAutoCommit(true);
                }
                catch (SQLException ex2) {
                    LogIPFLog.error("LogDbStoreFactory::executeCreateScript() -  exception executing con.rollback() ", ex2);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                LogDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
        }
        LogDbStoreUtil.safeCloseStatement(stmt);
    }

    private void executeUpdateScript(Connection con, File scriptFile, String codeBase) throws Exception {
        if (!scriptFile.exists()) {
            LogIPFLog.debug("LogDbStoreFactory::executeUpdateScript() -  execption: missing scripts");
            throw new Exception("LogDbStoreFactory::executeUpdateScript() -  Missing LogServer database creation scripts");
        }
        Statement stmt = null;
        StringBuffer currentBatch = new StringBuffer(255);
        try {
            String currentCommand;
            String currentLine;
            BufferedReader script = new BufferedReader(new InputStreamReader(new FileInputStream(scriptFile)));
            stmt = con.createStatement();
            while ((currentLine = script.readLine()) != null) {
                if (currentLine.trim().length() > 0) {
                    if (currentLine.indexOf(SCRIPT_SQL_COMMENT) == 0) continue;
                    currentLine = LogDbStoreFactory.getScriptParameters().replaceAllParameters(currentLine);
                    currentBatch.append(currentLine);
                    currentBatch.append("\n");
                    continue;
                }
                if (currentBatch.length() <= 0) continue;
                currentCommand = currentBatch.toString();
                if ((currentCommand = this.makeConformedSqlStatement(currentCommand)).charAt(0) == '!') {
                    this.executeScriptCommand(con, codeBase, currentCommand.substring(1));
                } else {
                    stmt.execute(currentCommand);
                }
                currentBatch.setLength(0);
            }
            if (currentBatch.length() > 0) {
                currentCommand = currentBatch.toString();
                if (currentCommand.charAt(0) == '!') {
                    this.executeScriptCommand(con, codeBase, currentCommand.substring(1));
                } else {
                    stmt.execute(currentBatch.toString());
                }
                currentBatch.setLength(0);
            }
        }
        catch (Exception ex) {
            try {
                LogIPFLog.error("LogDbStoreFactory::executeUpdateScript() -  exceprion while executing " + currentBatch.toString(), ex);
                throw ex;
            }
            catch (Throwable throwable) {
                LogDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
        }
        LogDbStoreUtil.safeCloseStatement(stmt);
    }

    private void executeScriptCommand(Connection con, String codeBase, String commandLine) throws Exception {
        String executorClassName = null;
        StringTokenizer toker = new StringTokenizer(commandLine);
        ArrayList<String> args = new ArrayList<String>();
        while (toker.hasMoreTokens()) {
            String token = toker.nextToken();
            if (executorClassName == null) {
                executorClassName = token;
                continue;
            }
            args.add(token);
        }
        Class<?> executorClass = Class.forName(codeBase + "$" + executorClassName);
        LogDbStoreExecutor exec = (LogDbStoreExecutor)executorClass.newInstance();
        exec.execute(con, args.toArray(new String[args.size()]));
    }

    private String makeConformedSqlStatement(String sqlCommandLine) {
        int currentLineSize;
        String theConformedSqlStatement = sqlCommandLine;
        if (this.m_dbType == 1 || this.m_dbType == 4) {
            int currentLineSize2 = theConformedSqlStatement.length();
            if (currentLineSize2 >= 2 && theConformedSqlStatement.charAt(currentLineSize2 - 1) == '\n' && (theConformedSqlStatement.charAt(currentLineSize2 - 2) == '/' || theConformedSqlStatement.charAt(currentLineSize2 - 2) == ';')) {
                theConformedSqlStatement = theConformedSqlStatement.substring(0, currentLineSize2 - 2);
            }
        } else if ((this.m_dbType == 6 || this.m_dbType == 3) && (currentLineSize = theConformedSqlStatement.length()) >= 2 && theConformedSqlStatement.charAt(currentLineSize - 1) == '\n' && theConformedSqlStatement.charAt(currentLineSize - 2) == ';') {
            theConformedSqlStatement = theConformedSqlStatement.substring(0, currentLineSize - 2);
        }
        return theConformedSqlStatement;
    }

    public void setDriver(String driverClass) {
        LogIPFLog.debug("LogDbStoreFactory::setDriver(): Try to load driver: " + driverClass);
        this.m_logConnection.setDriver(driverClass);
    }

    private File[] getUpgradeFiles() throws Exception {
        StringBuffer dbFilenameDir = new StringBuffer(80);
        String folderName = this.m_dbTypeName.equalsIgnoreCase("mssql") ? "sqlserver" : this.m_dbTypeName;
        dbFilenameDir.append(m_ipfSchemaFolder).append(folderName).append("/");
        String schemaFilesDirName = null;
        try {
            ICCLConfiguration tmpConf = CCLConfigurationFactory.createConfiguration();
            tmpConf.init();
            schemaFilesDirName = tmpConf.resolveEffectivePath(dbFilenameDir.toString());
        }
        catch (CCLConfigurationException e) {
            LogIPFLog.error("LogDbStoreFactory::getUpgradeFiles() - Failed to initialize  ICCLConfiguration", e);
            throw e;
        }
        File dbFileDir = new File(schemaFilesDirName);
        File[] allFiles = dbFileDir.listFiles();
        File[] upgradeFiles = new File[allFiles.length];
        LogIPFLog.error("LogDbStoreFactory::getUpgradeFiles() schema files location " + schemaFilesDirName);
        String prefix = "ls_dbupgrade" + this.versionToFileNameVersion(this.m_dbStoreVersion) + "-to-";
        String suffix = "_" + this.m_dbTypeName + ".sql";
        float endVersion = Float.parseFloat(DB_VERSION);
        LogIPFLog.error("LogDbStoreFactory::getUpgradeFiles() prefix " + prefix);
        LogIPFLog.error("LogDbStoreFactory::getUpgradeFiles() suffix " + suffix);
        int count = 0;
        boolean done = false;
        while (!done) {
            boolean reset = false;
            for (int i = 0; !reset && i < allFiles.length; ++i) {
                float version;
                String currentVersion;
                if (allFiles[i].getName().length() <= prefix.length() + suffix.length() || !allFiles[i].getName().toLowerCase().startsWith(prefix.toLowerCase()) || !allFiles[i].getName().toLowerCase().endsWith(suffix.toLowerCase()) || (currentVersion = this.versionFromFileNameVersion(allFiles[i].getName().substring(prefix.length(), allFiles[i].getName().length() - suffix.length()))) == null) continue;
                LogIPFLog.error("LogDbStoreFactory::getUpgradeFiles() currentVersion " + currentVersion);
                try {
                    version = Float.parseFloat(currentVersion);
                }
                catch (Exception ex) {
                    continue;
                }
                upgradeFiles[count++] = allFiles[i];
                reset = true;
                if (version == endVersion) {
                    done = true;
                }
                prefix = "ls_dbupgrade" + this.versionToFileNameVersion(currentVersion) + "-to-";
            }
            if (reset) continue;
            throw new Exception("LogDbStoreFactory::getUpgradeFiles() - No LS DB upgrade scripts");
        }
        return upgradeFiles;
    }

    private String versionToFileNameVersion(String version) throws Exception {
        int dotIndex = version.indexOf(46);
        if (dotIndex == -1) {
            throw new Exception("LogDbStoreFactory::versionToFileNameVersion() - Bad LogServer DB version: " + version);
        }
        return version.substring(0, dotIndex) + "_" + version.substring(dotIndex + 1);
    }

    private String versionFromFileNameVersion(String version) throws Exception {
        int dotIndex = version.indexOf(95);
        if (dotIndex == -1) {
            return null;
        }
        return version.substring(0, dotIndex) + "." + version.substring(dotIndex + 1);
    }

    public void testUpgrade() throws Exception {
        this.getDBTypeName();
        LogDbStoreFactory.getScriptParameters().initialize();
        this.upgradeDatabase();
        this.closeConnection();
    }
}

