/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge;

import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.data.providers.secbridge.WinImpersonate;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.utils.EncryptedObject;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.util.concurrent.Callable;

public final class ImpersonationTask<T>
implements Callable<T> {
    private final Callable<T> task;
    private final String domainName;
    private final String userName;
    private final EncryptedObject<String> encryptedPassword;
    private final int errorLocale;

    public ImpersonationTask(Callable<T> theTask, String theDomainName, String theUserName, EncryptedObject<String> theEncryptedPassword, int theErrorLocale) {
        this.task = theTask;
        this.domainName = theDomainName;
        this.userName = theUserName;
        this.encryptedPassword = theEncryptedPassword;
        this.errorLocale = theErrorLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        T result = null;
        long token = 0L;
        try {
            token = WinImpersonate.beginImpersonation(this.errorLocale, this.domainName, this.userName, this.encryptedPassword.decrypt());
        }
        catch (NativeException ex) {
            if (ex.getErrorStatus().getCategory() == ErrorStatus.Category.LOGON_FAILURE) {
                throw new MoserException(MoserError.MSR_WSB_NATIVE_LOGON_FAILURE, (Throwable)ex);
            }
            throw new MoserException(MoserError.MSR_WSB_CAM_COULD_NOT_IMPERSONATE, (Throwable)ex);
        }
        boolean success = false;
        try {
            result = this.task.call();
            success = true;
        }
        finally {
            try {
                WinImpersonate.revertImpersonation(this.errorLocale, token);
            }
            catch (NativeException ex) {
                if (success) {
                    throw new MoserException(MoserError.MSR_WSB_CAM_COULD_NOT_REVERT, (Throwable)ex);
                }
                LoggerAdapter.warn(this, "Error occurs when reverting Impersonation: " + ex.getMessage());
            }
        }
        return result;
    }
}

