/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge;

import com.cognos.xqe.data.providers.secbridge.CAMImpersonatorImpl;
import com.cognos.xqe.data.providers.secbridge.IImpersonator;
import com.cognos.xqe.data.providers.secbridge.WinImpersonatorImpl;
import com.ibm.bi.platform.moser.core.utils.EncryptedObject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImpersonatorFactory {
    private ImpersonatorFactory() {
    }

    public static IImpersonator createWinImpersonater(String domainName, String userName, String password, int errorLocale) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        return new WinImpersonatorImpl(executor, true, domainName, userName, new EncryptedObject<String>(password), errorLocale);
    }

    public static IImpersonator createWinImpersonater(String domainName, String userName, String password, int errorLocale, ExecutorService customExecutor) {
        return new WinImpersonatorImpl(customExecutor, false, domainName, userName, new EncryptedObject<String>(password), errorLocale);
    }

    public static IImpersonator createCAMImpersonater(String ssoDelegationHandle, int errorLocale) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        return new CAMImpersonatorImpl(executor, true, ssoDelegationHandle, errorLocale);
    }

    public static IImpersonator createCAMImpersonater(String ssoDelegationHandle, int errorLocale, ExecutorService customExecutor) {
        return new CAMImpersonatorImpl(customExecutor, false, ssoDelegationHandle, errorLocale);
    }
}

