/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge;

import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.cognos.aurora.core.util.SingletonHelper;

public final class SecBridge {
    private static final boolean WINDOWS_PLATFORM = System.getProperty("os.name").indexOf("Windows") >= 0;
    private static SingletonHelper<SecBridge> singletonHelper = new SingletonHelper<SecBridge>(){

        protected SecBridge newInstance() {
            return new SecBridge();
        }

        protected void initializeImpl(SecBridge theInstance) {
            theInstance.initialize();
        }

        protected void releaseImpl(SecBridge theInstance) {
            theInstance.terminate();
        }
    };

    private SecBridge() {
    }

    public static SecBridge getInstance() {
        return (SecBridge)singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    private void initialize() {
        if (WINDOWS_PLATFORM) {
            LoggerAdapter.info(this, "Loading SecBridge DLL.");
            try {
                System.loadLibrary("SecBridge");
            }
            catch (Throwable ex) {
                LoggerAdapter.error((Object)this, "Unexpected exception caught from System.loadLibrary(): ", ex);
                throw new MoserException(MoserError.MSR_WSB_BRIDGE_INIT_ERROR);
            }
        } else {
            LoggerAdapter.error(this, "Non-windows plaform, windows security bridge DLL not loaded.");
            throw new MoserException(MoserError.MSR_WSB_UNSUPPORTED_PLATFORM);
        }
        try {
            LoggerAdapter.info(this, "Initializing JNI for SecBridge.");
            SecBridge.cInitialize();
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            LoggerAdapter.error(this, "An error was returned from SecBridge.cInitialize: " + status.toString());
            throw new MoserException(MoserError.MSR_WSB_BRIDGE_INIT_ERROR, (Throwable)ex);
        }
        catch (Throwable ex) {
            LoggerAdapter.error((Object)this, "Unexpected exception caught in SecBridge.cInitialize: ", ex);
            throw new MoserException(MoserError.MSR_WSB_BRIDGE_INIT_ERROR);
        }
    }

    private void terminate() {
        try {
            SecBridge.cTerminate();
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            LoggerAdapter.error(this, "An error was returned from SecBridge.cTerminate: " + status.getMessage());
            throw new MoserException(MoserError.MSR_WSB_BRIDGE_TERM_ERROR, (Throwable)ex);
        }
        catch (Throwable ex) {
            LoggerAdapter.error((Object)this, "Unexpected exception caught in SecBridge.cTerminate: ", ex);
            throw new MoserException(MoserError.MSR_WSB_BRIDGE_TERM_ERROR);
        }
    }

    String getCurrentUserName(int errMsgLocale) throws NativeException {
        return SecBridge.cGetCurrentUserName(errMsgLocale);
    }

    boolean canCurrentUserImpersonate(int errMsgLocale) throws NativeException {
        return SecBridge.cCanCurrentUserImpersonate(errMsgLocale);
    }

    long beginWinImpersonation(int errMsgLocale, String domain, String user, String password) throws NativeException {
        return SecBridge.cBeginImpersonation(errMsgLocale, domain, user, password);
    }

    void revertWinImpersonation(int errMsgLocale, long token) throws NativeException {
        SecBridge.cRevertImpersonation(errMsgLocale, token);
    }

    String impCAMUsrNegotiate(int errMsgLocale, String sSecurityBlob, String cryptoHandle) throws NativeException {
        return SecBridge.cCAMImpUsrNegotiate(errMsgLocale, sSecurityBlob, cryptoHandle);
    }

    void beginCAMImpersonation(int errMsgLocale, String ssoDelegationHandle) throws NativeException {
        SecBridge.cCAMBeginImpersonation(errMsgLocale, ssoDelegationHandle);
    }

    void revertCAMImpersonation(int errMsgLocale, String ssoDelegationHandle) throws NativeException {
        SecBridge.cCAMRevertImpersonation(errMsgLocale, ssoDelegationHandle);
    }

    void releaseCAMHandle(int errMsgLocale, String ssoDelegationHandle) throws NativeException {
        SecBridge.cCAMReleaseHandle(errMsgLocale, ssoDelegationHandle);
    }

    private static native void cInitialize() throws NativeException;

    private static native void cTerminate() throws NativeException;

    private static native String cGetCurrentUserName(int var0) throws NativeException;

    private static native boolean cCanCurrentUserImpersonate(int var0) throws NativeException;

    private static native long cBeginImpersonation(int var0, String var1, String var2, String var3) throws NativeException;

    private static native void cRevertImpersonation(int var0, long var1) throws NativeException;

    private static native String cCAMImpUsrNegotiate(int var0, String var1, String var2) throws NativeException;

    private static native void cCAMBeginImpersonation(int var0, String var1) throws NativeException;

    private static native void cCAMRevertImpersonation(int var0, String var1) throws NativeException;

    private static native void cCAMReleaseHandle(int var0, String var1) throws NativeException;
}

