/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.cm;

import com.ibm.bi.platform.moser.core.cm.kerberos.JCAMImpersonator;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.AdminService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.soap.services.CamException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class AdminDatabaseService {
    public static final String ERROR = "error";
    private static final String NOT_FOUND = "' not found.";
    private static final String CM_SEARCH_PATH_TEMPLATE = "CAMID(\":\")/dataSource[@name='NAME'] | personalDataSourceSignon('NAME') | CAMID(\":\")/rolapDataSource[@name='NAME' and permission('read')] | CAMID(\":\")/rolapVirtualDataSource[@name='NAME' and permission('read')]";
    private static final Pattern PATTERN = Pattern.compile("NAME");
    private static final String[] DATASOURCE_FIELDS = new String[]{"defaultName", "credentials", "id"};
    public static final List<String> DATASOURCE_FIELDS_LIST = Arrays.asList(DATASOURCE_FIELDS);
    private static final String[] CONNECTION_FIELDS = new String[]{"id", "defaultName", "disabled", "ancestors", "connectionString", "openConnectionCommands", "openSessionCommands", "closeSessionCommands", "closeConnectionCommands", "apiToken"};
    private static final String[] CONNECTION_FIELDS_STEALTH = new String[]{"id", "defaultName"};
    private static final String[] SIGNON_FIELDS = new String[]{"defaultName", "disabled", "credentials"};
    private final RequestEnvironment runtime;

    public AdminDatabaseService(RequestEnvironment runtime) {
        this.runtime = runtime;
    }

    public JSONObject buildDatasource(String datasource) {
        JSONObject ds = this.getDatasource(datasource);
        if (AdminDatabaseService.isErrorResponse(ds)) {
            LoggerAdapter.error(this, "CM data source '" + datasource + NOT_FOUND);
            return null;
        }
        JSONArray connections = this.getConnections((String)ds.get((Object)"id"));
        for (Object o : connections) {
            JSONObject connection = (JSONObject)o;
            if (AdminDatabaseService.isErrorResponse(connection)) {
                LoggerAdapter.error(this, "Connection for data source '" + datasource + NOT_FOUND);
            }
            JSONArray signons = this.getSignons((String)ds.get((Object)"id"), (String)connection.get((Object)"id"));
            connection.put((Object)AdminService.AdminSubResource.SIGNONS.toString(), (Object)signons);
        }
        ds.put((Object)"connections", (Object)connections);
        return ds;
    }

    public static String buildSearchPath(String name) {
        return PATTERN.matcher(CM_SEARCH_PATH_TEMPLATE).replaceAll(name);
    }

    public JSONArray getDatasources() {
        RESTClientResponse resp = this.runtime.getAdminService().get(AdminService.AdminResource.DATASOURCES, null, null, null, null, null, DATASOURCE_FIELDS);
        return AdminDatabaseService.constructResponse(resp);
    }

    public JSONObject getDatasourceConnection(String datasource, String connection) {
        JSONObject ds = this.getDatasource(datasource);
        if (AdminDatabaseService.isErrorResponse(ds)) {
            LoggerAdapter.error(this, "CM data source '" + datasource + NOT_FOUND);
            return null;
        }
        JSONArray connections = this.getConnections((String)ds.get((Object)"id"), CONNECTION_FIELDS_STEALTH);
        for (Object o : connections) {
            String name;
            JSONObject c = (JSONObject)o;
            if (AdminDatabaseService.isErrorResponse(c)) {
                LoggerAdapter.error(this, "Connection for data source '" + datasource + NOT_FOUND);
            }
            if (!connection.equals(name = (String)c.get((Object)"defaultName"))) continue;
            return c;
        }
        return (JSONObject)connections.get(0);
    }

    private JSONObject getDatasource(String datasource) {
        JSONArray dataSources = this.getDatasources();
        for (Object o : dataSources) {
            JSONObject ds = (JSONObject)o;
            String dataSourceName = (String)ds.get((Object)"defaultName");
            if (!(dataSourceName == null ? AdminDatabaseService.isErrorResponse(ds) : datasource.equals(dataSourceName))) continue;
            return ds;
        }
        return null;
    }

    private JSONArray getConnections(String datasourceID, String[] fields) {
        RESTClientResponse resp = this.runtime.getAdminService().get(AdminService.AdminResource.DATASOURCES, datasourceID, AdminService.AdminSubResource.CONNECTIONS, null, null, null, fields);
        return AdminDatabaseService.constructResponse(resp);
    }

    private JSONArray getConnections(String datasourceID) {
        return this.getConnections(datasourceID, CONNECTION_FIELDS);
    }

    private JSONArray getSignons(String datasourceID, String connectionID) {
        RESTClientResponse resp = this.runtime.getAdminService().get(AdminService.AdminResource.DATASOURCES, datasourceID, AdminService.AdminSubResource.CONNECTIONS, connectionID, AdminService.AdminSubResource.SIGNONS, null, SIGNON_FIELDS);
        return AdminDatabaseService.constructResponse(resp);
    }

    private static JSONArray constructResponse(RESTClientResponse resp) {
        if (resp.getResponseCode() == 200) {
            JSONArtifact jObj = resp.getJSONArtifactResponse();
            if (jObj instanceof JSONObject) {
                Object result = ((JSONObject)jObj).get((Object)"data");
                if (result != null) {
                    return (JSONArray)result;
                }
            } else if (jObj instanceof JSONArray) {
                return (JSONArray)jObj;
            }
        }
        JSONArray response = null;
        List<Exception> exceptions = resp.getExceptions();
        if (exceptions != null && !exceptions.isEmpty()) {
            response = AdminDatabaseService.constructErrorResponse(exceptions.get(0));
        }
        return response;
    }

    private static JSONArray constructErrorResponse(Exception e) {
        JSONObject err = new JSONObject();
        err.put((Object)ERROR, (Object)e.getMessage());
        JSONArray response = new JSONArray();
        response.add((Object)err);
        return response;
    }

    private static boolean isErrorResponse(JSONObject obj) {
        return obj == null || obj.containsKey((Object)ERROR);
    }

    public JSONObject getPersonalDSSignon(String dsName) {
        try {
            List<JSONObject> results = this.runtime.getModuleStorageCM().getCMObjectViaSoapBridge(AdminDatabaseService.buildSearchPath(dsName), DATASOURCE_FIELDS_LIST, null);
            for (JSONObject jObj : results) {
                if (!"dataSourceSignon".equals(jObj.get((Object)"type"))) continue;
                return jObj;
            }
        }
        catch (CamException e) {
            LoggerAdapter.error((Object)this, "Unexpected CamException received when querying for personal ds signon: " + e.getLocalizedMessage(), e);
        }
        return null;
    }

    public JCAMImpersonator.DelegatedCredential getDelegatedCredentials(String databaseName) {
        return this.runtime.getCryptoDancer().getDelegatedCredentials(databaseName);
    }

    public String getCryptoHandleForIntegratedSecurity(String databaseName, Locale productLocale) {
        return this.runtime.getCryptoDancer().getCryptoHandleForIntegratedSecurity(databaseName, productLocale);
    }
}

