/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.cm;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import com.ibm.bi.platform.moser.core.cm.Signon;
import com.ibm.bi.platform.moser.core.utils.EncryptedObject;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ApiTokenSignon {
    public static final String ENCRYPTED_VALUE = "encryptedValue";
    private static final String AUTHKEY = "authKey";
    private static final String SECRETKEY = "secretKey";
    private EncryptedObject<String> mAuthKey = null;
    private EncryptedObject<String> mSecretKey = null;

    public ApiTokenSignon(String apiTokenCredentials) {
        try {
            Document document = DocumentHelper.parseText((String)apiTokenCredentials);
            Element root = document.getRootElement();
            Element encryptedValuElem = root.element(ENCRYPTED_VALUE);
            if (encryptedValuElem != null) {
                Element secretKeyElem;
                String decryptedApiToken = ApiTokenSignon.decrypt(encryptedValuElem.getText());
                document = DocumentHelper.parseText((String)decryptedApiToken);
                root = document.getRootElement();
                Element authKeyElem = root.element(AUTHKEY);
                if (authKeyElem != null) {
                    this.mAuthKey = new EncryptedObject<String>(authKeyElem.getText());
                }
                if ((secretKeyElem = root.element(SECRETKEY)) != null) {
                    this.mSecretKey = new EncryptedObject<String>(secretKeyElem.getText());
                }
            }
        }
        catch (UnsupportedEncodingException | DocumentException e) {
            LoggerAdapter.error(Signon.class, "Unexpected decrypted value: " + e.getMessage(), e);
        }
    }

    public boolean isDefined() {
        return this.mAuthKey != null || this.mSecretKey != null;
    }

    public EncryptedObject<String> getAuthKey() {
        return this.mAuthKey;
    }

    public EncryptedObject<String> getSecretKey() {
        return this.mSecretKey;
    }

    private static String decrypt(String encryptedApiToken) throws UnsupportedEncodingException {
        String decryptedText = null;
        try {
            byte[] source = Base64.getDecoder().decode(encryptedApiToken);
            byte[] result = JCAMCrypto.createEncryptingSession().decryptData(source);
            decryptedText = new String(result, "UTF-8");
        }
        catch (CAMCryptoException e) {
            LoggerAdapter.error(ApiTokenSignon.class, "Failed decrypt: " + e.getMessage(), e);
        }
        return decryptedText;
    }
}

