/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.cm;

import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.IMacroExpander;
import com.ibm.bi.platform.moser.core.provider.MetadataProviderFactory;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.wkc.core.utils.WKCUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="connection", propOrder={"name"})
public class Connection {
    protected static final String JDBC_COLON = "jdbc:";
    protected static final String STR_COLON = ":";
    protected static final String STR_SEMICOLON = ";";
    protected static final String TRANSFORM_UID_MARKER = "@transformuid";
    protected static final String IBMCOGNOS_PREFIX = "ibmcognos.";
    private String name;
    @XmlTransient
    private String id;
    @XmlTransient
    private String url;
    @XmlTransient
    private String driver;
    @XmlTransient
    private Properties properties = new Properties();
    @XmlTransient
    private JSONArray ancestors;
    @XmlTransient
    private String connectionString;
    @XmlTransient
    private String interfacetType;
    @XmlTransient
    private ConnectionType connectionType = ConnectionType.INVALID;
    @XmlTransient
    private String vendorType;
    @XmlTransient
    private String apiToken;
    private IMacroExpander macroExpander = null;
    private boolean transformUID;
    private static final CaseInsensitiveMap IGNORE_PARAMS;

    public Connection() {
    }

    public Connection(IMacroExpander macroExpander) {
        this.macroExpander = macroExpander;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getId() {
        return this.id;
    }

    public JSONArray getAncestors() {
        return this.ancestors;
    }

    public String getURL() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getInterfaceType() {
        return this.interfacetType;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public String getVendorType() {
        return this.vendorType;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public void initializeConnectionString(String connStr) {
        if (StringUtils.isEmpty((CharSequence)connStr)) {
            return;
        }
        this.connectionString = connStr;
        this.interfacetType = MetadataProviderFactory.getInterfaceTypeFromConnectionString(this.connectionString);
        String driverSplitter = ";DRIVER_NAME=";
        boolean bExternal = WKCUtil.isExternalCatalog(this.interfacetType);
        String[] tokens = null;
        tokens = !bExternal ? this.connectionString.split(";DRIVER_NAME=") : WKCUtil.split(this.connectionString, ";DRIVER_NAME=");
        int start = tokens[0].indexOf(JDBC_COLON);
        if (start >= 0 && tokens.length > 1) {
            String str;
            int ed;
            this.url = this.macroExpander != null ? this.macroExpander.expand(tokens[0].substring(start)) : tokens[0].substring(start);
            String[] parts = tokens[1].split(STR_SEMICOLON);
            this.driver = parts[0];
            if (parts.length >= 2) {
                for (int i = 1; i < parts.length; ++i) {
                    String[] params = parts[i].split("=");
                    this.setTransformUID(params);
                    if (params.length <= 1 || Connection.shouldIgnoreParams(params)) continue;
                    this.properties.setProperty(params[0], params[1]);
                }
            }
            if ((ed = (str = this.url.substring(JDBC_COLON.length())).indexOf(STR_COLON)) != -1) {
                this.vendorType = str.substring(0, ed);
            }
            if (this.name == null) {
                LoggerAdapter.error(this, "Unknown connection: " + this.connectionString);
                this.connectionType = ConnectionType.INVALID;
            } else {
                this.connectionType = ConnectionType.JDBC;
            }
        } else {
            String[] parts;
            for (String part : parts = this.connectionString.split(STR_SEMICOLON)) {
                String[] params = part.split("=");
                this.setTransformUID(params);
                if (params.length <= 1 || IGNORE_PARAMS.containsKey((Object)params[0].toLowerCase())) continue;
                this.properties.setProperty(params[0], params[1]);
            }
            this.connectionType = ConnectionType.NON_JDBC;
        }
    }

    private void setTransformUID(String[] params) {
        if (params == null || params.length == 0) {
            return;
        }
        if (params[0].toLowerCase().equals(TRANSFORM_UID_MARKER)) {
            this.transformUID = params.length > 1 ? params[1].toLowerCase().equals("true") : true;
        }
    }

    public boolean getTransformUID() {
        return this.transformUID;
    }

    public ConnectionType initialize(JSONObject src) {
        this.name = (String)src.get((Object)"defaultName");
        this.id = (String)src.get((Object)"id");
        this.ancestors = (JSONArray)src.get((Object)"ancestors");
        this.initializeConnectionString((String)src.get((Object)"connectionString"));
        if (this.connectionType != ConnectionType.JDBC) {
            return this.connectionType;
        }
        if (this.connectionString.contains("ibmcognos.authentication=java_krb5")) {
            this.properties.setProperty("ibmcognos.authentication", "java_krb5");
        }
        if (this.connectionString.contains("integratedSecurity=true")) {
            this.properties.setProperty("integratedSecurity", "true");
        }
        if (MetadataProviderFactory.isDB2TrustedContext(this.connectionString)) {
            this.properties.setProperty("trustedContext", "true");
        }
        this.addCommandBlocksToProperties(src);
        this.apiToken = (String)src.get((Object)"apiToken");
        return ConnectionType.JDBC;
    }

    private static boolean shouldIgnoreParams(String[] params) {
        return IGNORE_PARAMS.containsKey((Object)params[0].toLowerCase()) || params[0].toLowerCase().startsWith(IBMCOGNOS_PREFIX);
    }

    private void addCommandBlocksToProperties(JSONObject connection) {
        this.addCommandBlock("openSessionCommands", connection);
        this.addCommandBlock("openConnectionCommands", connection);
        this.addCommandBlock("closeSessionCommands", connection);
        this.addCommandBlock("closeConnectionCommands", connection);
    }

    private void addCommandBlock(String cmdBlockId, JSONObject connection) {
        JSONObject cmdBlock;
        String cmdBlockValue = (String)connection.get((Object)cmdBlockId);
        if (cmdBlockValue != null && (cmdBlock = MoserUtil.convertCmdBlockToJSONObject(cmdBlockValue)) != null) {
            this.properties.put(cmdBlockId, cmdBlock);
        }
    }

    public static boolean isJDBC(JSONObject src) {
        String connString = (String)src.get((Object)"connectionString");
        String driverSplitter = ";DRIVER_NAME=";
        String[] tokens = connString.split(";DRIVER_NAME=");
        if (tokens == null || tokens.length <= 0) {
            return false;
        }
        int start = tokens[0].indexOf(JDBC_COLON);
        return start > 0;
    }

    static {
        String[] values;
        IGNORE_PARAMS = new CaseInsensitiveMap();
        for (String s : values = new String[]{"@localsort", "level", TRANSFORM_UID_MARKER}) {
            IGNORE_PARAMS.put((Object)s, (Object)Boolean.TRUE);
        }
    }

    @XmlTransient
    public static enum ConnectionType {
        INVALID,
        NON_JDBC,
        JDBC;

    }
}

