/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.cm;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.exceptions.generic.ConnectionFaultException;
import com.ibm.bi.platform.moser.common.exceptions.metadata.EmptyOrInaccessibleSchemaException;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.provider.ProviderProperties;
import com.ibm.bi.platform.moser.common.provider.metadata.IMetadataProvider;
import com.ibm.bi.platform.moser.common.utils.MoserConnectionSpec;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.api.json.JSONApiError;
import com.ibm.bi.platform.moser.core.api.json.JSONApiResponse;
import com.ibm.bi.platform.moser.core.api.json.datasource.ModulesResponse;
import com.ibm.bi.platform.moser.core.api.json.datasource.SchemasData;
import com.ibm.bi.platform.moser.core.api.json.datasource.SchemasResponse;
import com.ibm.bi.platform.moser.core.api.json.datasource.TablesBody;
import com.ibm.bi.platform.moser.core.api.json.datasource.TablesResponse;
import com.ibm.bi.platform.moser.core.cm.AdminDatabaseService;
import com.ibm.bi.platform.moser.core.cm.ApiTokenSignon;
import com.ibm.bi.platform.moser.core.cm.Connection;
import com.ibm.bi.platform.moser.core.cm.ImportManager;
import com.ibm.bi.platform.moser.core.cm.OIDCSignon;
import com.ibm.bi.platform.moser.core.cm.Signon;
import com.ibm.bi.platform.moser.core.cm.UserProfile;
import com.ibm.bi.platform.moser.core.cm.kerberos.JCAMImpersonator;
import com.ibm.bi.platform.moser.core.ma.AmbiguousConnectionException;
import com.ibm.bi.platform.moser.core.ma.AmbiguousSignonException;
import com.ibm.bi.platform.moser.core.ma.LogonFailureException;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserMacroExpander;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserSSOIntegratedSecurityConnection;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.kerberos.MoserKerberosJMDConnection;
import com.ibm.bi.platform.moser.core.provider.MetadataProviderFactory;
import com.ibm.bi.platform.moser.core.provider.jdbc.JDBCProviderProperties;
import com.ibm.bi.platform.moser.core.provider.jdbc.metadata.MoserJDBCImporter;
import com.ibm.bi.platform.moser.core.rest.service.AdminService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.wkc.core.provider.jdbc.metadata.JDBCWKCMetadataProvider;
import com.ibm.cognos.jdbc.adaptor.sqlexception.SQLCognosInvalidLogonException;
import com.ibm.cognos.jmd.exception.JMDConnectionException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="databases")
public class DBDescriptor {
    private String databaseName;
    private Signon signon;
    private Connection connection;
    private JDBCProviderProperties connectionInformation;
    private ArrayList<String> multipleConnections;
    private String connectionName = null;
    private RequestEnvironment runtime;
    private String signonName = null;
    private MoserConnectionSpec connectionSpec;
    private Map<String, String> vendor;
    private static final String BACKSLASH = "\\";
    private static final String ATCHAR = "@";
    public static final String STRING_USER = "user";
    public static final String STRING_SYSTEM = "system";
    private static final String STRING_DISABLED = "disabled";
    private static final String SEP = ".";

    public DBDescriptor(String ds, String connection, String signon, Map<String, String> ven, RequestEnvironment runtime) {
        this.databaseName = ds.trim();
        this.connectionName = connection;
        this.signonName = signon;
        this.vendor = ven;
        this.runtime = runtime;
        this.connectionSpec = new MoserConnectionSpec(ds, connection, signon);
    }

    public DBDescriptor(String ds, RequestEnvironment runtime) {
        this.databaseName = ds.trim();
        this.runtime = runtime;
    }

    public STATUS init() {
        STATUS status = STATUS.OK;
        AdminDatabaseService service = this.runtime.getAdminDatabaseService();
        JSONObject ds = service.buildDatasource(this.databaseName);
        if (ds == null) {
            return STATUS.ERROR_READING_CONNECTION_STRING;
        }
        JSONArray connections = (JSONArray)ds.get((Object)"connections");
        if (connections.isEmpty()) {
            return STATUS.NO_CONNECTION;
        }
        JSONObject jsonConnection = this.getConnection(connections);
        if (this.multipleConnections != null) {
            throw new AmbiguousConnectionException(this.databaseName, this.multipleConnections);
        }
        if (this.connection == null) {
            return STATUS.NO_CONNECTION;
        }
        JSONArray signons = (JSONArray)jsonConnection.get((Object)AdminService.AdminSubResource.SIGNONS.toString());
        if (STATUS.MULTIPLE_SIGNONS.equals((Object)this.processSignons(signons))) {
            return STATUS.MULTIPLE_SIGNONS;
        }
        Properties properties = this.connection.getProperties();
        this.runtime.setPassportProperty(properties);
        if (MoserKerberosJMDConnection.isKerberos(properties)) {
            LoggerAdapter.debug(this, "Kerberos detected");
            JCAMImpersonator.DelegatedCredential creds = service.getDelegatedCredentials(this.databaseName);
            if (creds != null) {
                properties.put("kerberosCredential", creds);
            } else if (signons.isEmpty()) {
                LoggerAdapter.debug(this, "No signons. Calling getPersonalDSSignon");
                this.signon = Signon.fromJSON(service.getPersonalDSSignon(this.databaseName));
            }
        } else if (MoserSSOIntegratedSecurityConnection.isIntegratedSecurity(properties)) {
            LoggerAdapter.debug(this, "SSO Integrated Security Detected.");
            String cryptoHandle = service.getCryptoHandleForIntegratedSecurity(this.databaseName, this.runtime.getProductLocale());
            if (cryptoHandle != null) {
                LoggerAdapter.debug(this, "Got a crypto handle.");
                properties.put("cryptoHandle", cryptoHandle);
                properties.put("productLocale", this.runtime.getProductLocale());
            } else if (signons.isEmpty()) {
                LoggerAdapter.debug(this, "No signons. Calling getPersonalDSSignon");
                this.signon = Signon.fromJSON(service.getPersonalDSSignon(this.databaseName));
            }
        } else {
            LoggerAdapter.debug(this, "Not a kerberos or integrated security connection");
            if (signons.isEmpty()) {
                this.signon = Signon.fromJSON(service.getPersonalDSSignon(this.databaseName));
            }
        }
        this.connectionInformation = new JDBCProviderProperties();
        if (this.connection.getURL() != null) {
            this.connectionInformation.setUrl(this.connection.getURL());
        }
        if (this.connection.getDriver() != null) {
            this.connectionInformation.setDriverClass(this.connection.getDriver());
        }
        if (this.connection.getProperties() != null) {
            this.connectionInformation.setProperties(this.connection.getProperties());
        }
        if (this.signon != null) {
            OIDCSignon oidcSignon;
            String userId = this.signon.getUser();
            if (userId != null) {
                if (this.connection.getTransformUID()) {
                    String[] parts;
                    if (userId.contains(BACKSLASH)) {
                        parts = userId.split("\\\\");
                        LoggerAdapter.debug(this, "Removed domain name from domain userId " + userId);
                        userId = parts[1];
                        this.signon.setUser(userId);
                    }
                    if (userId.contains(ATCHAR)) {
                        parts = userId.split(ATCHAR);
                        LoggerAdapter.debug(this, "Removed domain name from userId@domain " + userId);
                        userId = parts[0];
                        this.signon.setUser(userId);
                    }
                }
                properties.setProperty(STRING_USER, userId);
            }
            if (this.signon.getPassword() != null) {
                properties.setProperty("password", this.signon.getPassword());
            }
            if ((oidcSignon = this.signon.getOIDCSignon()) != null && oidcSignon.isDefined()) {
                properties.put("oidc.signon", oidcSignon);
            }
        }
        if (this.connectionSpec != null) {
            this.connectionInformation.setConnectionSpec(this.connectionSpec);
        }
        if (jsonConnection.get((Object)"apiToken") != null) {
            ApiTokenSignon apiTokenSignon = new ApiTokenSignon((String)jsonConnection.get((Object)"apiToken"));
            properties.put("apitoken.signon", apiTokenSignon);
        }
        return status;
    }

    private JSONObject getConnection(JSONArray connections) {
        JSONObject ret = new JSONObject();
        if (this.connectionName != null) {
            for (Object obj : connections) {
                Connection con;
                JSONObject jsonConnection = (JSONObject)obj;
                if (Boolean.TRUE.equals(jsonConnection.get((Object)STRING_DISABLED)) || !this.connectionName.equals(jsonConnection.get((Object)"defaultName")) || (con = this.newConnection()).initialize(jsonConnection) == Connection.ConnectionType.INVALID) continue;
                this.connection = con;
                return jsonConnection;
            }
        }
        boolean hasJDBConnection = DBDescriptor.getHasJDBCConnection(connections);
        for (Object obj : connections) {
            Connection con;
            Connection.ConnectionType connType;
            JSONObject jsonConnection = (JSONObject)obj;
            if (Boolean.TRUE.equals(jsonConnection.get((Object)STRING_DISABLED)) || (connType = (con = this.newConnection()).initialize(jsonConnection)) == Connection.ConnectionType.INVALID || hasJDBConnection && connType != Connection.ConnectionType.JDBC) continue;
            if (this.connection != null) {
                this.addMultipleConnections(con);
                continue;
            }
            ret = jsonConnection;
            this.connection = con;
            this.connectionName = (String)jsonConnection.get((Object)"defaultName");
        }
        return ret;
    }

    private Connection newConnection() {
        if (this.runtime != null) {
            return new Connection(new MoserMacroExpander(this.runtime));
        }
        return new Connection();
    }

    public static boolean getHasJDBCConnection(JSONArray connections) {
        for (Object obj : connections) {
            JSONObject jsonConnection = (JSONObject)obj;
            if (Boolean.TRUE.equals(jsonConnection.get((Object)STRING_DISABLED)) || !Connection.isJDBC(jsonConnection)) continue;
            return true;
        }
        return false;
    }

    public String getConnectionURL() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getURL();
    }

    private STATUS processSignons(JSONArray signons) {
        JSONObject currentSignon;
        if (this.signonName != null) {
            for (Object sign : signons) {
                currentSignon = (JSONObject)sign;
                if (Boolean.TRUE.equals(currentSignon.get((Object)STRING_DISABLED)) || !this.signonName.equals(currentSignon.get((Object)"defaultName"))) continue;
                this.signon = Signon.fromJSON(currentSignon);
                return STATUS.OK;
            }
        }
        for (Object sign : signons) {
            currentSignon = (JSONObject)sign;
            if (Boolean.TRUE.equals(currentSignon.get((Object)STRING_DISABLED))) continue;
            if (this.signon != null) {
                throw new AmbiguousSignonException(this.databaseName, this.connection.getName(), DBDescriptor.getSignonList(signons));
            }
            this.signon = Signon.fromJSON(currentSignon);
        }
        return STATUS.OK;
    }

    private static List<String> getSignonList(JSONArray signons) {
        ArrayList<String> signonList = new ArrayList<String>();
        for (Object sign : signons) {
            JSONObject currentSignon = (JSONObject)sign;
            if (Boolean.TRUE.equals(currentSignon.get((Object)STRING_DISABLED))) continue;
            JSONObject jSignon = (JSONObject)sign;
            String name = (String)jSignon.get((Object)"defaultName");
            signonList.add(name);
        }
        return signonList;
    }

    private void addMultipleConnections(Connection con) {
        if (this.multipleConnections == null) {
            this.multipleConnections = new ArrayList();
            this.multipleConnections.add(this.connection.getName());
        }
        this.multipleConnections.add(con.getName());
    }

    public TablesResponse getTables(String catalog, String schema, String table, TablesBody tablesBody) throws Exception {
        IMetadataProvider mdProvider = MetadataProviderFactory.create(this.databaseName, this.connection, this.connectionInformation, this.runtime);
        if (mdProvider instanceof JDBCWKCMetadataProvider) {
            return ((JDBCWKCMetadataProvider)mdProvider).getTablesResponse(this.databaseName, catalog, schema, table, tablesBody, this.vendor, this.connection, this.connectionInformation);
        }
        return this.getTables(catalog, schema, table, tablesBody, mdProvider);
    }

    public ModulesResponse getPhysicalModule(String catalog, String schema, String table, TablesBody tablesBody) throws Exception {
        IMetadataProvider mdProvider = MetadataProviderFactory.create(this.databaseName, this.connection, this.connectionInformation, this.runtime);
        if (mdProvider instanceof JDBCWKCMetadataProvider) {
            return ((JDBCWKCMetadataProvider)mdProvider).getPhysicalModuleResponse(this.databaseName, catalog, schema, table, tablesBody, this.vendor, this.connection, this.connectionInformation);
        }
        return this.getPhysicalModule(catalog, schema, table, tablesBody, mdProvider);
    }

    protected TablesResponse getTables(String catalog, String schema, String table, TablesBody tablesBody, IMetadataProvider mdProvider) throws Exception {
        if (this.connectionInformation != null) {
            this.connectionInformation.setCatalog(catalog);
            this.connectionInformation.setSchema(schema);
            this.connectionInformation.setTable(table);
            MoserJDBCImporter.setInOrExcludedTables(this.connectionInformation, tablesBody);
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        HashMap feedBack = new HashMap();
        List tables = mdProvider.getTables((ProviderProperties)this.connectionInformation, exceptions, feedBack);
        if (DBDescriptor.containsSignonException(exceptions)) {
            this.setupPromptedSignonException(exceptions);
            exceptions.clear();
            feedBack.clear();
            tables = mdProvider.getTables((ProviderProperties)this.connectionInformation, exceptions, feedBack);
            if (DBDescriptor.containsSignonException(exceptions)) {
                throw new LogonFailureException(this.connectionName, this.databaseName, 1);
            }
        }
        if (!exceptions.isEmpty() && tables.isEmpty()) {
            throw (Exception)exceptions.get(0);
        }
        TablesResponse resp = new TablesResponse(tables);
        if (this.connection != null) {
            resp.setMeta("connectionString", this.connection.getConnectionString());
        }
        DBDescriptor.addWarnings(resp, exceptions);
        return resp;
    }

    public static void addWarnings(JSONApiResponse resp, List<Exception> exceptions) {
        for (Exception e : exceptions) {
            JSONApiError warn = new JSONApiError();
            warn.setStatus("warning");
            warn.setTitle(e.getLocalizedMessage());
            resp.addWarnings(warn);
        }
    }

    protected ModulesResponse getPhysicalModule(String catalog, String schema, String table, TablesBody tablesBody, IMetadataProvider mdProvider) throws Exception {
        if (this.connectionInformation != null) {
            this.connectionInformation.setCatalog(catalog);
            this.connectionInformation.setSchema(schema);
            this.connectionInformation.setTable(table);
            MoserJDBCImporter.setInOrExcludedTables(this.connectionInformation, tablesBody);
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        HashMap<String, Object> feedBack = new HashMap<String, Object>();
        Module module = mdProvider.getPhysicalModule((ProviderProperties)this.connectionInformation, exceptions, feedBack);
        if (DBDescriptor.containsSignonException(exceptions)) {
            this.setupPromptedSignonException(exceptions);
            exceptions.clear();
            feedBack.clear();
            module = mdProvider.getPhysicalModule((ProviderProperties)this.connectionInformation, exceptions, feedBack);
            if (DBDescriptor.containsSignonException(exceptions)) {
                throw new LogonFailureException(this.connectionName, this.databaseName, 1);
            }
        }
        if (module == null) {
            if (!exceptions.isEmpty()) {
                throw (Exception)exceptions.get(0);
            }
            throw new EmptyOrInaccessibleSchemaException(MoserUtil.buildSchemaDefaultName(this.databaseName, catalog, schema));
        }
        module.setIdentifier("physicalmodule");
        module.setContainer(this.getContainer(catalog, schema));
        ModulesResponse resp = new ModulesResponse(null, module, DBDescriptor.getNumOfTablesFromFeedback(feedBack));
        if (this.connection != null) {
            resp.setMeta("connectionString", this.connection.getConnectionString());
        }
        DBDescriptor.addWarnings(resp, exceptions);
        return resp;
    }

    public static Map<String, Object> getNumOfTablesFromFeedback(Map<String, Object> feedBack) {
        if (feedBack == null) {
            return null;
        }
        Object v = feedBack.get("NumberOfTables");
        if (v == null) {
            return null;
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("NumberOfTables", v);
        return r;
    }

    protected String getContainer(String catalog, String schema) {
        return this.databaseName + SEP + this.connectionName + SEP + catalog + SEP + schema;
    }

    public static boolean isSignonError(Exception e) {
        return e instanceof JMDConnectionException && e.getCause() instanceof SQLCognosInvalidLogonException && ((SQLCognosInvalidLogonException)e.getCause()).getSubCode() == SQLCognosInvalidLogonException.SubCode.INVALID_CREDENTIALS;
    }

    protected SchemasResponse getSchemas(IMetadataProvider mdProvider) throws Exception {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Map catsAndSchemas = mdProvider.getCatalogsAndSchemas((ProviderProperties)this.connectionInformation, exceptions);
        if (DBDescriptor.containsSignonException(exceptions)) {
            this.setupPromptedSignonException(exceptions);
            exceptions.clear();
            catsAndSchemas = mdProvider.getCatalogsAndSchemas((ProviderProperties)this.connectionInformation, exceptions);
            if (DBDescriptor.containsSignonException(exceptions)) {
                throw new LogonFailureException(this.connectionName, this.databaseName, 1);
            }
        }
        if (!exceptions.isEmpty() && catsAndSchemas.isEmpty()) {
            throw (Exception)exceptions.get(0);
        }
        String urlDS = this.connection == null ? null : this.connection.getURL();
        SchemasResponse resp = new SchemasResponse();
        for (Map.Entry entry : catsAndSchemas.entrySet()) {
            String catalog = (String)entry.getKey();
            List schemas = (List)entry.getValue();
            for (String schema : schemas) {
                SchemasData item = new SchemasData();
                item.setCatalog(catalog);
                item.setSchema(schema);
                item.setId(MoserUtil.buildSchemaDefaultName(this.databaseName, catalog, schema));
                if (urlDS != null) {
                    item.setSchemaType(DBDescriptor.getSchemaType(urlDS, catalog, schema));
                }
                resp.addData(item);
            }
        }
        if (this.connection != null) {
            resp.setMeta("connectionString", this.connection.getConnectionString());
        }
        DBDescriptor.addWarnings(resp, exceptions);
        return resp;
    }

    public static String getSchemaType(String urlDS, String catalog, String schema) {
        if (ImportManager.isIgnored(urlDS, ImportManager.DBOTypesEnum.DBOTE_CATALOG, catalog) || ImportManager.isIgnored(urlDS, ImportManager.DBOTypesEnum.DBOTE_SCHEMA, schema)) {
            return STRING_SYSTEM;
        }
        return STRING_USER;
    }

    private static boolean containsSignonException(List<Exception> exceptions) {
        for (Exception e : exceptions) {
            if (!DBDescriptor.isSignonError(e)) continue;
            return true;
        }
        return false;
    }

    protected void setupPromptedSignonException(List<Exception> exceptions) throws Exception {
        if (!DBDescriptor.setPromptedSignon(this.runtime.getUserProfile(), this.databaseName, this.connectionName, this.connection.getProperties())) {
            throw new LogonFailureException(this.connectionName, this.databaseName, 1);
        }
    }

    public static boolean setPromptedSignon(UserProfile up, String databaseName, String connName, Properties properties) {
        String credentials = up.getCredentialsForDatasource(databaseName, connName);
        if (credentials == null) {
            return false;
        }
        Signon cmSignon = new Signon();
        try {
            credentials = cmSignon.decrypt(credentials);
        }
        catch (UnsupportedEncodingException ex) {
            LoggerAdapter.error(DBDescriptor.class, "Failed decrypt signon: " + ex.getLocalizedMessage(), ex);
            return false;
        }
        if (!cmSignon.parseCredentials(credentials)) {
            return false;
        }
        properties.setProperty(STRING_USER, cmSignon.getUser());
        properties.setProperty("password", cmSignon.getPassword());
        return true;
    }

    public String getStatusMessage(STATUS status, Locale locale) {
        MoserException e = this.getConnectionFaultException(status);
        return e == null ? "" : e.getLocalizedMessage(locale);
    }

    public MoserException getConnectionFaultException(STATUS status) {
        switch (status) {
            case ERROR_READING_CONNECTION_STRING: {
                return new ConnectionFaultException(MoserError.MSR_IE_DATASOURCE_CONNECTION, this.databaseName);
            }
            case NO_CONNECTION: {
                return new ConnectionFaultException(MoserError.MSR_IE_DATASOURCE_CONNECTION_UNDEFINED, this.databaseName);
            }
            case MULTIPLE_CONNECTIONS: {
                return new ConnectionFaultException(MoserError.DATASOURCE_MULTIPLE_CONNECTIONS, this.databaseName);
            }
            case MULTIPLE_SIGNONS: {
                return new ConnectionFaultException(MoserError.DATASOURCE_MULTIPLE_SIGNONS, this.connection.getName(), this.databaseName);
            }
        }
        return null;
    }

    public SchemasResponse getSchemas() throws Exception {
        IMetadataProvider mdProvider = MetadataProviderFactory.create(this.databaseName, this.connection, this.connectionInformation, this.runtime);
        if (mdProvider instanceof JDBCWKCMetadataProvider) {
            return ((JDBCWKCMetadataProvider)mdProvider).getSchemas(this.databaseName, this.connection, this.connectionInformation);
        }
        return this.getSchemas(mdProvider);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Signon getSignon() {
        return this.signon;
    }

    public ProviderProperties getProviderProperties() {
        return this.connectionInformation;
    }

    public static enum STATUS {
        OK,
        ERROR_READING_CONNECTION_STRING,
        NO_CONNECTION,
        MULTIPLE_CONNECTIONS,
        NON_JDBC_CONNECTION,
        NO_SIGNON,
        MULTIPLE_SIGNONS;

    }
}

