/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.cm;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;

public class HistoryDetailMoserService {
    private String status;
    private StatusInfo statusInfo = new StatusInfo();
    private Specification specification = new Specification();
    private String detail;
    private String detailTime;
    private Severity sev = Severity.DEF;

    public void setSpecification(String dataStatistics, String version, String importPrimaryForeignKey, int dataSamplingSize) {
        this.specification = new Specification(dataStatistics, version, importPrimaryForeignKey, dataSamplingSize);
    }

    public void addExcludedTables(String ... tableNames) {
        this.specification.addExcludedTables(tableNames);
    }

    public void setProgress(int minorCurrent, String majorStepInfo, String minorStepInfo, int majorMax, int majorCurrent, int minorMax) {
        this.statusInfo.createCurrentProgress(minorCurrent, majorStepInfo, minorStepInfo, majorMax, majorCurrent, minorMax);
    }

    public void updateProgress(int minorCurrent, String majorStepInfo, String minorStepInfo, int majorCurrent) {
        this.statusInfo.updateCurrentProgress(minorCurrent, majorStepInfo, minorStepInfo, majorCurrent);
    }

    public void addMessage(String severity, String message, String messageDetail) {
        this.statusInfo.addMessage(severity, message, messageDetail);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public JSONObject getStatusInfo() {
        JSONObject response = new JSONObject();
        if (this.statusInfo.getMessageList() != null) {
            response.put((Object)"statusInfo", (Object)this.statusInfo.getMessageList());
        }
        if (this.statusInfo.getCurrentProgress() != null) {
            response.put((Object)"statusInfo", (Object)this.statusInfo.getCurrentProgress());
        }
        return response;
    }

    public JSONObject getSpecification() {
        JSONObject response = new JSONObject();
        if (this.specification.getExcludedTables() != null) {
            response.put((Object)"excludedTables", (Object)this.specification.getExcludedTables());
        }
        if (this.specification.getDataStatistics() != null) {
            response.put((Object)"dataStatistics", (Object)this.specification.getDataStatistics());
        }
        response.put((Object)"version", (Object)this.specification.getVersion());
        if (this.specification.getImportPrimaryForeignKey() != null) {
            response.put((Object)"importPrimaryForeignKey", (Object)this.specification.getImportPrimaryForeignKey());
        }
        response.put((Object)"dataSamplingSize", (Object)Double.toString(this.specification.getDataSamplingSize()));
        return response;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getDetailTime() {
        return this.detailTime;
    }

    public void setDetailTime(String detailTime) {
        this.detailTime = detailTime;
    }

    public String getSev() {
        return this.sev.toString();
    }

    public void setSev(Severity sev) {
        this.sev = sev;
    }

    public JSONObject toJSONObject() {
        JSONObject response = new JSONObject();
        if (this.getStatus() != null) {
            response.put((Object)"status", (Object)this.getStatus());
        }
        if (this.statusInfo != null && this.statusInfo.getMessageList() != null) {
            response.put((Object)"statusInfo", (Object)this.statusInfo.toJSONObject());
        }
        if (this.specification.getExcludedTables() != null) {
            response.put((Object)"specification", (Object)this.specification.toJSONObject());
        }
        if (this.getDetail() != null) {
            response.put((Object)"detail", (Object)this.getDetail());
        }
        if (this.getDetailTime() != null) {
            response.put((Object)"detailTime", (Object)this.getDetailTime());
        }
        if (this.getSev() != null && !this.getSev().isEmpty()) {
            response.put((Object)"severity", (Object)this.getSev());
        }
        return response;
    }

    public static enum Severity {
        ERROR("ERROR"),
        WARNING("WARNING"),
        INFO("INFO"),
        DEF("");

        private final String sev;

        private Severity(String sev) {
            this.sev = sev;
        }

        public String toString() {
            return this.sev;
        }
    }

    private static class StatusInfo {
        private ArrayList<Message> messageList = new ArrayList();
        private Progress currentProgress;

        public void addMessage(String severity, String message, String messageDetail) {
            this.messageList.add(new Message(severity, message, messageDetail));
        }

        public void createCurrentProgress(int minorCurrent, String majorStepInfo, String minorStepInfo, int majorMax, int majorCurrent, int minorMax) {
            this.currentProgress = new Progress(minorCurrent, majorStepInfo, minorStepInfo, majorMax, majorCurrent, minorMax);
        }

        public void updateCurrentProgress(int minorCurrent, String majorStepInfo, String minorStepInfo, int majorCurrent) {
            if (minorCurrent > 0 && majorCurrent > 0) {
                this.currentProgress.setMajorCurrent(majorCurrent);
                this.currentProgress.setMinorCurrent(minorCurrent);
                this.currentProgress.setMajorStepInfo(majorStepInfo);
                this.currentProgress.setMinorStepInfo(minorStepInfo);
            }
        }

        public JSONArray getMessageList() {
            if (!this.messageList.isEmpty()) {
                JSONArray msgList = new JSONArray();
                for (Message m : this.messageList) {
                    msgList.add((Object)m.toJSONObject());
                }
                return msgList;
            }
            return null;
        }

        public JSONObject getCurrentProgress() {
            JSONObject response = new JSONObject();
            if (this.currentProgress != null) {
                response.put((Object)"progress", (Object)this.currentProgress.toJSONObject());
            }
            return response;
        }

        public JSONObject toJSONObject() {
            JSONObject response = new JSONObject();
            if (this.currentProgress != null) {
                response.put((Object)"progress", (Object)this.currentProgress.toJSONObject());
            }
            if (!this.messageList.isEmpty()) {
                JSONArray msgList = new JSONArray();
                for (Message m : this.messageList) {
                    msgList.add((Object)m.toJSONObject());
                }
                response.put((Object)"messages", (Object)msgList);
            }
            return response;
        }

        private static class Progress {
            private int minorCurrent;
            private String majorStepInfo;
            private int majorMax;
            private String minorStepInfo;
            private int majorCurrent;
            private int minorMax;

            public Progress(int minorCurrent, String majorStepInfo, String minorStepInfo, int majorMax, int majorCurrent, int minorMax) {
                this.majorCurrent = majorCurrent;
                this.minorCurrent = minorCurrent;
                this.majorStepInfo = majorStepInfo;
                this.minorStepInfo = minorStepInfo;
                this.majorMax = majorMax;
                this.minorMax = minorMax;
            }

            public void setMinorCurrent(int minorCurrent) {
                this.minorCurrent = minorCurrent;
            }

            public void setMajorStepInfo(String majorStepInfo) {
                this.majorStepInfo = majorStepInfo;
            }

            public void setMinorStepInfo(String minorStepInfo) {
                this.minorStepInfo = minorStepInfo;
            }

            public void setMajorCurrent(int majorCurrent) {
                this.majorCurrent = majorCurrent;
            }

            public int getMinorCurrent() {
                return this.minorCurrent;
            }

            public String getMajorStepInfo() {
                return this.majorStepInfo;
            }

            public int getMajorMax() {
                return this.majorMax;
            }

            public String getMinorStepInfo() {
                return this.minorStepInfo;
            }

            public int getMajorCurrent() {
                return this.majorCurrent;
            }

            public int getMinorMax() {
                return this.minorMax;
            }

            public JSONObject toJSONObject() {
                JSONObject response = new JSONObject();
                if (this.getMajorCurrent() != 0) {
                    response.put((Object)"majorCurrent", (Object)Integer.toString(this.getMajorCurrent()));
                }
                if (this.getMinorCurrent() != 0) {
                    response.put((Object)"minorCurrent", (Object)Integer.toString(this.getMinorCurrent()));
                }
                if (this.getMajorStepInfo() != null) {
                    response.put((Object)"majorStepInfo", (Object)this.getMajorStepInfo());
                }
                if (this.getMinorStepInfo() != null) {
                    response.put((Object)"minorStepInfo", (Object)this.getMinorStepInfo());
                }
                if (this.getMajorMax() != 0) {
                    response.put((Object)"majorMax", (Object)Integer.toString(this.getMajorMax()));
                }
                if (this.getMinorMax() != 0) {
                    response.put((Object)"minorMax", (Object)Integer.toString(this.getMinorMax()));
                }
                return response;
            }
        }

        private static class Message {
            private String severity;
            private String mes;
            private String messageDetail;

            public Message(String severity, String message, String messageDetail) {
                this.severity = severity;
                this.mes = message;
                this.messageDetail = messageDetail;
            }

            public String getMessage() {
                return this.mes;
            }

            public String getSeverity() {
                return this.severity;
            }

            public String getMessageDetail() {
                return this.messageDetail;
            }

            public JSONObject toJSONObject() {
                JSONObject response = new JSONObject();
                if (this.getMessage() != null) {
                    response.put((Object)"message", (Object)this.getMessage());
                }
                if (this.getSeverity() != null) {
                    response.put((Object)"severity", (Object)this.getSeverity());
                }
                if (this.getMessageDetail() != null) {
                    response.put((Object)"messageDetail", (Object)this.getMessageDetail());
                }
                return response;
            }
        }
    }

    public static class Specification {
        private String dataStatistics;
        private ArrayList<String> excludedTables;
        private String version = "1.0";
        private String importPrimaryForeignKey;
        private int dataSamplingSize = 0;

        public Specification(String dataStatistics, String version, String importPrimaryForeignKey, int dataSamplingSize) {
            this.dataStatistics = dataStatistics;
            this.excludedTables = new ArrayList();
            this.version = version;
            this.importPrimaryForeignKey = importPrimaryForeignKey;
            this.dataSamplingSize = dataSamplingSize;
        }

        public Specification() {
            this.excludedTables = new ArrayList();
        }

        public String getDataStatistics() {
            return this.dataStatistics;
        }

        public JSONArray getExcludedTables() {
            if (!this.excludedTables.isEmpty()) {
                JSONArray tblList = new JSONArray();
                for (String m : this.excludedTables) {
                    tblList.add((Object)m);
                }
                return tblList;
            }
            return null;
        }

        public void addExcludedTables(String ... tblNames) {
            if (tblNames != null) {
                for (String t : tblNames) {
                    this.excludedTables.add(t);
                }
            }
        }

        public String getVersion() {
            return this.version;
        }

        public String getImportPrimaryForeignKey() {
            return this.importPrimaryForeignKey;
        }

        public int getDataSamplingSize() {
            return this.dataSamplingSize;
        }

        public JSONObject toJSONObject() {
            JSONObject response = new JSONObject();
            if (this.dataStatistics != null) {
                response.put((Object)"dataStatistics", (Object)this.getDataStatistics());
            }
            response.put((Object)"version", (Object)this.getVersion());
            if (this.importPrimaryForeignKey != null) {
                response.put((Object)"importPrimaryForeignKey", (Object)this.getImportPrimaryForeignKey());
            }
            if (this.dataSamplingSize != 0) {
                response.put((Object)"dataSamplingSize", (Object)Integer.toString(this.getDataSamplingSize()));
            }
            if (!this.excludedTables.isEmpty()) {
                JSONArray exList = new JSONArray();
                for (String m : this.excludedTables) {
                    exList.add((Object)m);
                }
                response.put((Object)"excludedTables", (Object)exList);
            }
            return response;
        }
    }
}

