/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.cm;

import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;

public class ImportManager {
    public static final String HIDE_HIDDEN_COLUMN = "hideHiddenColumn";
    private static ArrayList<VendorImportRules> vendorImportRules = null;

    private static synchronized ArrayList<VendorImportRules> getAllRules() {
        if (vendorImportRules == null) {
            String path = MoserConfig.getInstance().getMoserConfigDirectory() + "/import.xml";
            File file = new File(path);
            if (file.exists()) {
                try {
                    XMLConfiguration config = new XMLConfiguration(path);
                    List rules = config.configurationsAt("importRule");
                    ImportManager.setRules(rules);
                }
                catch (ConfigurationException cex) {
                    LoggerAdapter.errorExceptionStack(ImportManager.class, cex);
                }
                if (vendorImportRules == null) {
                    vendorImportRules = new ArrayList();
                }
            } else {
                vendorImportRules = new ArrayList();
            }
        }
        return (ArrayList)vendorImportRules.clone();
    }

    public static boolean isIgnored(String vendor, DBOTypesEnum type, String object) {
        List<VendorImportRules> rules = ImportManager.selectVendorRules(vendor);
        for (VendorImportRules current : rules) {
            VendorImportRules.DBOPattern rule = current.findRule(type, object);
            if (rule == null) continue;
            LoggerAdapter.trace(ImportManager.class, "Data base object '" + object + "' is ignored for url '" + vendor + "' matched pattern: " + rule.getPattern());
            return true;
        }
        return false;
    }

    public static List<VendorImportRules> selectVendorRules(String vendor) {
        ArrayList<VendorImportRules> ret = new ArrayList<VendorImportRules>();
        for (VendorImportRules current : ImportManager.getAllRules()) {
            if (!current.match(vendor)) continue;
            ret.add(current);
        }
        return ret;
    }

    public static boolean getBooleanSetting(String vendor, String settingName, boolean defaultRet) {
        ArrayList<VendorImportRules> catalogs = ImportManager.getAllRules();
        for (VendorImportRules current : catalogs) {
            if (!current.match(vendor)) continue;
            return current.getBooleanSetting(settingName, defaultRet);
        }
        return defaultRet;
    }

    public static synchronized void setRules(List<HierarchicalConfiguration> rules) {
        if (vendorImportRules == null) {
            vendorImportRules = new ArrayList();
        } else {
            vendorImportRules.clear();
        }
        for (HierarchicalConfiguration sub : rules) {
            VendorImportRules current = new VendorImportRules(sub.getString("[@connection]"));
            current.addDataBaseObjects(DBOTypesEnum.DBOTE_CATALOG, sub.getList("skip.catalog"));
            current.addDataBaseObjects(DBOTypesEnum.DBOTE_SCHEMA, sub.getList("skip.schema"));
            current.addDataBaseObjects(DBOTypesEnum.DBOTE_TABLE, sub.getList("skip.table"));
            String hideHidden = sub.getString(HIDE_HIDDEN_COLUMN);
            if (hideHidden != null) {
                current.settings.put(HIDE_HIDDEN_COLUMN, Boolean.valueOf(hideHidden));
            }
            vendorImportRules.add(current);
        }
    }

    public static synchronized void reset() {
        vendorImportRules = null;
    }

    protected static class VendorImportRules {
        String vendor;
        ArrayList<DBOPattern> dboPatterns = new ArrayList();
        HashMap<String, Object> settings = new HashMap();

        public VendorImportRules(String pat) {
            this.vendor = pat;
        }

        public void addDataBaseObjects(DBOTypesEnum type, List<Object> patterns) {
            for (Object current : patterns) {
                this.dboPatterns.add(new DBOPattern(type, (String)current));
            }
        }

        public DBOPattern findRule(DBOTypesEnum type, String object) {
            for (DBOPattern current : this.dboPatterns) {
                if (!current.match(type, object)) continue;
                return current;
            }
            return null;
        }

        boolean match(String jdbcUrl) {
            return jdbcUrl.matches(this.vendor);
        }

        public String getPattern() {
            return this.vendor;
        }

        boolean getBooleanSetting(String settingName, boolean defaultRet) {
            Object o = this.settings.get(settingName);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return defaultRet;
        }

        protected static class DBOPattern {
            DBOTypesEnum type = DBOTypesEnum.DBOTE_UNKNOWN;
            String pattern = null;

            DBOPattern(DBOTypesEnum type, String pattern) {
                this.type = type;
                this.pattern = pattern;
            }

            public boolean match(DBOTypesEnum t, String objName) {
                if (t == this.type) {
                    if (objName == null) {
                        return this.pattern == null;
                    }
                    if (this.pattern == null) {
                        return false;
                    }
                    return objName.matches(this.pattern);
                }
                return false;
            }

            public String getDBOTypeString() {
                switch (this.type) {
                    case DBOTE_CATALOG: {
                        return "catalog";
                    }
                    case DBOTE_SCHEMA: {
                        return "schema";
                    }
                    case DBOTE_TABLE: {
                        return "table";
                    }
                }
                return null;
            }

            public String getPattern() {
                return this.getDBOTypeString() + ":" + this.pattern;
            }
        }
    }

    public static enum DBOTypesEnum {
        DBOTE_CATALOG,
        DBOTE_SCHEMA,
        DBOTE_TABLE,
        DBOTE_COLUMN,
        DBOTE_JOIN,
        DBOTE_INDEX,
        DBOTE_FOREIGNKEY,
        DBOTE_UNKNOWN;

    }
}

