/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.cm;

import com.ibm.bi.platform.moser.core.api.json.datasource.SchemasData;
import com.ibm.bi.platform.moser.core.api.json.datasource.SchemasResponse;
import com.ibm.bi.platform.moser.core.metadata.MetadataEngine;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.wkc.core.utils.WKCUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class SchemaDescriptor {
    public static final String ANY = "any";
    public static final String LOADED = "loaded";
    public static final String NOT_LOADED = "not_loaded";
    private static final String[] DEFAULT_FIELDS = new String[]{"schema", "statusInfo", "catalog", "schemaType", "defaultName", "defaultDescription", "status", "ancestors", "specification"};
    private final RequestEnvironment requestEnv;
    private final MetadataEngine engine;

    public SchemaDescriptor(RequestEnvironment requestEnv, MetadataEngine engine) {
        this.requestEnv = requestEnv;
        this.engine = engine;
    }

    public JSONArray getSchemas(String fields, String schemaStatus) {
        JSONArray schemas = this.getExistingSchemas(fields);
        if (LoggerAdapter.isDebugEnabled(this)) {
            LoggerAdapter.debug(this, "Existing schemas: " + schemas.toString());
        }
        JSONArray dbSchemas = this.getDBSchemas();
        JSONArray permitted = this.combineSchemas(schemas, dbSchemas, schemaStatus);
        if (LoggerAdapter.isDebugEnabled(this)) {
            LoggerAdapter.debug(this, "Schemas permitted to access: " + permitted.toString());
        }
        return permitted;
    }

    private JSONArray getExistingSchemas(String fields) {
        RESTClientResponse r;
        String dataSourceConnectionId = this.requestEnv.getStringParam("dataSourceConnectionId");
        if (StringUtils.isEmpty((CharSequence)dataSourceConnectionId)) {
            return new JSONArray();
        }
        ContentService cs = this.requestEnv.getContentService();
        if (fields == null) {
            r = cs.get(ContentService.ContentResource.OBJECTS, dataSourceConnectionId, ContentService.ContentSubResource.ITEMS, "dataSourceSchema", DEFAULT_FIELDS);
        } else {
            String f = fields.contains("defaultName") ? fields : fields + "," + "defaultName";
            f = f.contains("catalog") ? f : f + "," + "catalog";
            f = f.contains("schema") ? f : f + "," + "schema";
            r = cs.get(ContentService.ContentResource.OBJECTS, dataSourceConnectionId, ContentService.ContentSubResource.ITEMS, "dataSourceSchema", f);
        }
        return r.getResponseCode() == Response.Status.OK.getStatusCode() ? WKCUtil.trimSpecification((JSONArray)r.getJSONObjectResponse().get((Object)"data")) : new JSONArray();
    }

    private JSONArray getDBSchemas() {
        SchemasResponse resp = this.engine.getSchemas(new JSONObject());
        List<SchemasData> schemas = resp.getSchemas();
        String dataSourceName = this.requestEnv.getStringParam("dataSourceName");
        String dataSourceConnectionName = this.requestEnv.getStringParam("dataSourceConnectionName");
        JSONArray result = new JSONArray();
        for (SchemasData schema : schemas) {
            JSONObject entry = new JSONObject();
            entry.put((Object)"catalog", (Object)schema.getCatalog());
            entry.put((Object)"schema", (Object)schema.getSchema());
            entry.put((Object)"statusInfo", null);
            entry.put((Object)"schemaType", (Object)schema.getSchemaType());
            Object defaultName = schema.get("defaultName");
            if (defaultName == null) {
                entry.put((Object)"defaultName", (Object)MoserUtil.buildSchemaDefaultName(dataSourceName, schema.getCatalog(), schema.getSchema()));
            } else {
                entry.put((Object)"defaultName", defaultName);
            }
            entry.put((Object)"type", (Object)"dataSourceSchema");
            entry.put((Object)"status", (Object)NOT_LOADED);
            entry.put((Object)"defaultDescription", null);
            Object moserSchemaId = schema.get("moserSchemaId");
            if (moserSchemaId == null) {
                entry.put((Object)"id", (Object)(dataSourceName + ":" + dataSourceConnectionName + ":" + schema.getCatalog() + ":" + schema.getSchema()));
            } else {
                entry.put((Object)"id", moserSchemaId);
            }
            entry.put((Object)"ancestors", null);
            Object spec = schema.get("specification");
            if (spec != null) {
                entry.put((Object)"specification", spec);
            }
            result.add((Object)entry);
        }
        return result;
    }

    private JSONArray combineSchemas(JSONArray schemas, JSONArray dbSchemas, String schemaStatus) {
        String dataSourceName = this.requestEnv.getStringParam("dataSourceName");
        TreeMap<String, JSONObject> combinedMap = new TreeMap<String, JSONObject>();
        for (Object o : dbSchemas) {
            JSONObject schema2 = (JSONObject)o;
            String name = WKCUtil.buildSchemaName(dataSourceName, schema2);
            combinedMap.put(name, schema2);
        }
        boolean remove = NOT_LOADED.equals(schemaStatus);
        for (Object o : schemas) {
            JSONObject schema3 = (JSONObject)o;
            String name = WKCUtil.buildSchemaName(dataSourceName, schema3);
            if (!combinedMap.containsKey(name)) continue;
            if (remove) {
                combinedMap.remove(name);
                continue;
            }
            combinedMap.put(name, schema3);
        }
        JSONArray permitted = new JSONArray();
        permitted.addAll(combinedMap.values());
        if (ANY.equals(schemaStatus) || NOT_LOADED.equals(schemaStatus)) {
            return permitted;
        }
        return permitted.stream().filter(schema -> schemaStatus.equals(((JSONObject)schema).get((Object)"status"))).collect(Collectors.toCollection(JSONArray::new));
    }
}

