/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.cm;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import com.ibm.bi.platform.moser.core.cm.OIDCSignon;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.json.java.JSONObject;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class Signon {
    public static final String ENCRYPTED_VALUE = "encryptedValue";
    public static final String USER_NAME = "username";
    public static final String PASSWORD = "password";
    private String name;
    private String encryptedValue;
    private String user;
    private String pwd;
    private OIDCSignon mOIDCSignon;

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.pwd;
    }

    public boolean initialize(JSONObject src) {
        this.name = (String)src.get((Object)"defaultName");
        JSONObject credentialsEx = (JSONObject)src.get((Object)"credentialsEx");
        if (credentialsEx != null && credentialsEx.get((Object)"password_test") != null) {
            this.user = (String)credentialsEx.get((Object)USER_NAME);
            this.pwd = (String)credentialsEx.get((Object)"password_test");
            LoggerAdapter.debug(Signon.class, "Signon credentials are from responce.");
            return true;
        }
        this.encryptedValue = (String)src.get((Object)"credentials");
        if (this.encryptedValue != null) {
            try {
                Document document = DocumentHelper.parseText((String)this.encryptedValue);
                Element root = document.getRootElement();
                this.encryptedValue = root.selectSingleNode(ENCRYPTED_VALUE).getText();
            }
            catch (DocumentException e) {
                LoggerAdapter.error(Signon.class, "Bad response: " + e.getMessage(), e);
                this.encryptedValue = null;
            }
        }
        return this.name != null && this.encryptedValue != null;
    }

    public boolean parseCredentials(String decryptedValue) {
        try {
            Document document = DocumentHelper.parseText((String)decryptedValue);
            Element root = document.getRootElement();
            Node node = root.selectSingleNode(USER_NAME);
            this.user = node == null ? "" : node.getText();
            node = root.selectSingleNode(PASSWORD);
            this.pwd = node == null ? "" : node.getText();
            this.mOIDCSignon = new OIDCSignon(root);
        }
        catch (DocumentException e) {
            LoggerAdapter.error(Signon.class, "Unexpected decrypted value: " + e.getMessage(), e);
            return false;
        }
        return true;
    }

    public String decrypt(String strNeedToDecrypt) throws UnsupportedEncodingException {
        String decryptedText = "";
        try {
            byte[] source = Base64.getDecoder().decode(strNeedToDecrypt);
            byte[] result = JCAMCrypto.createEncryptingSession().decryptData(source);
            decryptedText = new String(result, "UTF-8");
        }
        catch (CAMCryptoException e) {
            LoggerAdapter.error(Signon.class, "Failed decrypt: " + e.getMessage(), e);
        }
        return decryptedText;
    }

    public boolean decryptObject() {
        String decryptedText;
        if (this.user != null && this.pwd != null) {
            return true;
        }
        if (this.encryptedValue == null) {
            return false;
        }
        try {
            decryptedText = this.decrypt(this.encryptedValue);
        }
        catch (Exception e) {
            LoggerAdapter.error(Signon.class, "Decrypt failed: " + this.encryptedValue + " with error " + e.getMessage(), e);
            return false;
        }
        return !decryptedText.isEmpty() && this.parseCredentials(decryptedText);
    }

    public String getName() {
        return this.name;
    }

    public OIDCSignon getOIDCSignon() {
        return this.mOIDCSignon;
    }

    public static Signon fromJSON(JSONObject jSignon) {
        if (jSignon == null) {
            return null;
        }
        Signon signon = new Signon();
        signon.initialize(jSignon);
        signon.decryptObject();
        return signon;
    }

    public void setUser(String userId) {
        this.user = userId;
    }
}

